(in-package :net-snmp-system)

(defpackage :org.net-snmp
  (:nicknames :snmp)
  (:use :cl :cffi)
  (:export
   ;; class
   snmp-session oid
   ;; method
   snmp-msg-get
   ;; constants
   +snmp-version-1+
   +snmp-version-2c+))

(in-package :org.net-snmp)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (define-foreign-library libssl
    (:unix (:or "libssl.so.0.9.8" "libssl.so"))
    (t (:default "libssl")))
  
  (define-foreign-library libsnmp
    (:unix (:or "libsnmp.so.15" "libsnmp.so"))
    (t (:default "libsnmp")))
  
  (use-foreign-library libssl)
  (use-foreign-library libsnmp))
