(in-package :org.net-snmp)

;;(defcvar ("usmHMACMD5AuthProtocol" *c-usm-hmac-md5-auth-protocol*) :pointer)

(eval-when (:compile-toplevel :load-toplevel)
  (defcfun ("init_snmp" c-snmp-init) :void (type :string)))

(eval-when (:load-toplevel :execute)
  (progn (c-snmp-init "snmpapp")
	 (format t "c-snmp-init called.~%")))

;;;
;;; Initializes the session structure.
;;; May perform one time minimal library initialization.
;;; No MIB file processing is done via this call.
;;;
(defcfun ("snmp_sess_init" c-snmp-session-init) :void (session :pointer))

;;;
;;; netsnmp_session *snmp_open(session)
;;; netsnmp_session *session;
;;;
;;; Sets up the session with the snmp_session information provided
;;; by the user.  Then opens and binds the necessary UDP port.
;;; A handle to the created session is returned (this is different than
;;; the pointer passed to snmp_open()).  On any error, NULL is returned
;;; and snmp_errno is set to the appropriate error code.
;;; 
(defcfun ("snmp_open" c-snmp-open) :pointer (session :pointer))

;;;
;;; int snmp_close(session)
;;; netsnmp_session *session;
;;;
;;; Close the input session.  Frees all data allocated for the session,
;;; dequeues any pending requests, and closes any sockets allocated for
;;; the session.  Returns 0 on error, 1 otherwise.
;;;
;;; snmp_close_sessions() does the same thing for all open sessions
;;;
(defcfun ("snmp_close" c-snmp-close) :int (session :pointer))
(defcfun ("snmp_close_sessions" c-snmp-close-sessions) :int)

(defcfun ("snmp_perror" c-snmp-perror) :void (prog-string :string))
(defcfun ("snmp_errstring" c-snmp-errstring) :string (errstat :int))
(defcfun ("snmp_sess_perror" c-snmp-session-perror) :void
  (prog-string :string) (ss :pointer))

(defcfun ("snmp_pdu_create" c-snmp-pdu-create) :pointer (command :int))
(defcfun ("snmp_free_pdu" c-snmp-pdu-free) :void (pdu :pointer))
(defcfun ("snmp_pdu_type" c-snmp-pdu-type) :string (type :int))

(defcfun ("read_objid" c-read-objid) :int
  (str :string)
  (oid :pointer)
  (size :pointer))

(defcfun ("get_node" c-get-node) :int
  (str :string)
  (oid :pointer)
  (size :pointer))

(defcfun ("snmp_add_null_var" c-snmp-add-null-var) :pointer
  (pdu :pointer)
  (oid :pointer)
  (size :ulong))

(defcfun ("snmp_synch_response" c-snmp-synch-response) :int
  (session :pointer)
  (pdu :pointer)
  (pdu* :pointer))

(defcfun ("print_variable" c-print-variable) :void
  (objid :pointer)
  (objidlen :ulong)
  (variable :pointer))

