

import org.armedbear.lisp.*;

/**
 * Utility functions to make it easy to interface between Java and Lisp.
 *
 * @author Blake McBride (blake@mcbride.name)
 */
public class ABCL {
    private static Interpreter interpreter;

    public static void init() {
        if (interpreter == null)
            interpreter = Interpreter.createInstance();
    }

    public static LispObject eval(String str) {
        init();
        return interpreter.eval(str);
    }

    public static Function findLispFunction(String packageName, String funName) {
        init();
        if (packageName == null  ||  packageName.isEmpty())
            packageName = "CL-USER";
        else
            packageName = packageName.toUpperCase();
        org.armedbear.lisp.Package lispPackage = Packages.findPackage(packageName);
        Symbol symbol = lispPackage.findAccessibleSymbol(funName.toUpperCase());
        Function fun = (Function) symbol.getSymbolFunction();
        return fun;
    }

    public static LispObject executeLispFunction(Function fun, Object ... args) {
        LispObject [] jargs;
        jargs = new LispObject[args.length];
        for (int i=0 ; i < args.length ; i++)
            jargs[i] = JavaObject.getInstance(args[i], true);
        return fun.execute(jargs);
    }

    public static LispObject executeLisp(String packageName, String funName, Object ... args) {
        Function fun = findLispFunction(packageName, funName);
        LispObject [] jargs;
        jargs = new LispObject[args.length];
        for (int i=0 ; i < args.length ; i++)
            jargs[i] = JavaObject.getInstance(args[i], true);
        return fun.execute(jargs);
    }

}
