
; Written by Blake McBride (blake@mcbride.name)


(defmacro defun-class-method (lfun cls-name meth-name &rest arg-types)
  (let ((arglist (mapcar (lambda (x) (gensym)) arg-types))
	(method (gensym))
	(cls (gensym)))
    `(let ((,method (jmethod ,cls-name ,meth-name ,@arg-types))
	   (,cls (jclass ,cls-name)))
       (defun ,lfun ,arglist
	 (jcall ,method ,cls ,@arglist)))))

(defmacro defun-instance-method (lfun cls-name meth-name &rest arg-types)
  (let ((arglist (mapcar (lambda (x) (gensym)) (cons nil arg-types)))
	(method (gensym)))
    `(let ((,method (jmethod ,cls-name ,meth-name ,@arg-types)))
       (defun ,lfun ,arglist
	 (jcall ,method ,@arglist)))))

(defmacro defun-constructor (lfun cls-name &rest arg-types)
  (let ((arglist (mapcar (lambda (x) (gensym)) arg-types))
	(method (gensym)))
    `(let ((,method (jconstructor ,cls-name ,@arg-types)))
       (defun ,lfun ,arglist
	 (jnew ,method ,@arglist)))))
