/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ByteArrayOutputStream
extends Stream {
    private final java.io.ByteArrayOutputStream byteArrayOutputStream;
    private static final Primitive MAKE_BYTE_ARRAY_OUTPUT_STREAM = new Primitive("%make-byte-array-output-stream", Lisp.PACKAGE_SYS, false, "&optional element-type"){

        public LispObject execute() {
            return new ByteArrayOutputStream();
        }

        public LispObject execute(LispObject arg) {
            return new ByteArrayOutputStream(arg);
        }
    };
    private static final Primitive GET_OUTPUT_STREAM_STRING = new Primitive("%get-output-stream-bytes", Lisp.PACKAGE_SYS, false, "byte-array-output-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof ByteArrayOutputStream) {
                return JavaObject.getInstance(((ByteArrayOutputStream)arg).getByteArray());
            }
            return Lisp.error(new TypeError(this, Symbol.STREAM));
        }
    };

    public ByteArrayOutputStream() {
        this(Lisp.UNSIGNED_BYTE_8);
    }

    private ByteArrayOutputStream(LispObject elementType) {
        this.elementType = elementType;
        this.byteArrayOutputStream = new java.io.ByteArrayOutputStream();
        this.initAsBinaryOutputStream(this.byteArrayOutputStream);
    }

    public LispObject typeOf() {
        return Symbol.STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.STREAM;
    }

    public LispObject typep(LispObject type) {
        return super.typep(type);
    }

    protected long _getFilePosition() {
        if (this.elementType == Lisp.NIL) {
            return 0L;
        }
        return this.byteArrayOutputStream.size();
    }

    public byte[] getByteArray() {
        if (this.elementType == Lisp.NIL) {
            return new byte[0];
        }
        return this.byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return this.unreadableString("BYTE-ARRAY-OUTPUT-STREAM");
    }
}

