/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public class CellError
extends LispError {
    protected CellError(LispClass cls) {
        super(cls);
    }

    public CellError(LispObject initArgs) {
        super(StandardClass.CELL_ERROR);
        this.initialize(initArgs);
    }

    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        LispObject name = Lisp.NIL;
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.NAME) {
                name = initArgs.car();
                break;
            }
            initArgs = initArgs.cdr();
        }
        this.setCellName(name);
    }

    public final LispObject getCellName() {
        return this.getInstanceSlotValue(Symbol.NAME);
    }

    protected final void setCellName(LispObject name) {
        this.setInstanceSlotValue(Symbol.NAME, name);
    }

    public LispObject typeOf() {
        return Symbol.CELL_ERROR;
    }

    public LispObject classOf() {
        return StandardClass.CELL_ERROR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.CELL_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.CELL_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public String writeToString() {
        if (Symbol.PRINT_ESCAPE.symbolValue() == Lisp.NIL) {
            return super.writeToString();
        }
        StringBuffer sb = new StringBuffer(this.typeOf().writeToString());
        sb.append(' ');
        sb.append(this.getCellName().writeToString());
        return this.unreadableString(sb.toString());
    }
}

