/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;

public final class Cons
extends LispObject {
    public LispObject car;
    public LispObject cdr;
    private static long count;

    public Cons(LispObject car, LispObject cdr) {
        this.car = car;
        this.cdr = cdr;
        ++count;
    }

    public Cons(LispObject car) {
        this.car = car;
        this.cdr = Lisp.NIL;
        ++count;
    }

    public Cons(String name, LispObject value) {
        this.car = new SimpleString(name);
        this.cdr = value != null ? value : Lisp.NULL_VALUE;
        ++count;
    }

    public LispObject typeOf() {
        return Symbol.CONS;
    }

    public LispObject classOf() {
        return BuiltInClass.CONS;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier instanceof Symbol) {
            if (typeSpecifier == Symbol.LIST) {
                return Lisp.T;
            }
            if (typeSpecifier == Symbol.CONS) {
                return Lisp.T;
            }
            if (typeSpecifier == Symbol.SEQUENCE) {
                return Lisp.T;
            }
            if (typeSpecifier == Lisp.T) {
                return Lisp.T;
            }
        } else if (typeSpecifier instanceof BuiltInClass) {
            if (typeSpecifier == BuiltInClass.LIST) {
                return Lisp.T;
            }
            if (typeSpecifier == BuiltInClass.CONS) {
                return Lisp.T;
            }
            if (typeSpecifier == BuiltInClass.SEQUENCE) {
                return Lisp.T;
            }
            if (typeSpecifier == BuiltInClass.CLASS_T) {
                return Lisp.T;
            }
        }
        return Lisp.NIL;
    }

    public final boolean constantp() {
        return this.car == Symbol.QUOTE && this.cdr instanceof Cons && ((Cons)this.cdr).cdr == Lisp.NIL;
    }

    public boolean atom() {
        return false;
    }

    public LispObject RPLACA(LispObject obj) {
        this.car = obj;
        return this;
    }

    public LispObject RPLACD(LispObject obj) {
        this.cdr = obj;
        return this;
    }

    public final LispObject cadr() {
        return this.cdr.car();
    }

    public final LispObject cddr() {
        return this.cdr.cdr();
    }

    public final LispObject caddr() {
        return this.cdr.cadr();
    }

    public LispObject nthcdr(int n) {
        if (n < 0) {
            return Lisp.type_error(Fixnum.getInstance(n), Lisp.list(Symbol.INTEGER, Fixnum.ZERO));
        }
        LispObject result = this;
        int i = n;
        while (i-- > 0 && (result = result.cdr()) != Lisp.NIL) {
        }
        return result;
    }

    public final int sxhash() {
        return Cons.computeHash(this, 4);
    }

    private static final int computeHash(LispObject obj, int depth) {
        if (obj instanceof Cons) {
            if (depth > 0) {
                int n1 = Cons.computeHash(((Cons)obj).car, depth - 1);
                int n2 = Cons.computeHash(((Cons)obj).cdr, depth - 1);
                return n1 ^ n2;
            }
            return 261835505;
        }
        return obj.sxhash();
    }

    public final int psxhash() {
        return Cons.computeEqualpHash(this, 4);
    }

    private static final int computeEqualpHash(LispObject obj, int depth) {
        if (obj instanceof Cons) {
            if (depth > 0) {
                int n1 = Cons.computeEqualpHash(((Cons)obj).car, depth - 1);
                int n2 = Cons.computeEqualpHash(((Cons)obj).cdr, depth - 1);
                return n1 ^ n2;
            }
            return 261835505;
        }
        return obj.psxhash();
    }

    public final boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Cons && this.car.equal(((Cons)obj).car) && this.cdr.equal(((Cons)obj).cdr);
    }

    public final boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Cons && this.car.equalp(((Cons)obj).car) && this.cdr.equalp(((Cons)obj).cdr);
    }

    public final int length() {
        int length = 1;
        LispObject obj = this.cdr;
        while (obj != Lisp.NIL) {
            ++length;
            if (obj instanceof Cons) {
                obj = ((Cons)obj).cdr;
                continue;
            }
            Lisp.type_error(obj, Symbol.LIST);
        }
        return length;
    }

    public LispObject NTH(int index) {
        if (index < 0) {
            Lisp.type_error(Fixnum.getInstance(index), Symbol.UNSIGNED_BYTE);
        }
        int i = 0;
        LispObject obj = this;
        while (i != index) {
            if ((obj = obj.cdr()) == Lisp.NIL) {
                return Lisp.NIL;
            }
            ++i;
        }
        return obj.car();
    }

    public LispObject NTH(LispObject arg) {
        if (!(arg instanceof Fixnum)) {
            if (arg instanceof Bignum) {
                if (arg.minusp()) {
                    return Lisp.type_error(arg, Symbol.UNSIGNED_BYTE);
                }
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.UNSIGNED_BYTE);
        }
        int index = ((Fixnum)arg).value;
        if (index < 0) {
            Lisp.type_error(arg, Symbol.UNSIGNED_BYTE);
        }
        int i = 0;
        LispObject obj = this;
        while (i != index) {
            if ((obj = obj.cdr()) == Lisp.NIL) {
                return Lisp.NIL;
            }
            ++i;
        }
        return obj.car();
    }

    public LispObject elt(int index) {
        if (index < 0) {
            Lisp.type_error(Fixnum.getInstance(index), Symbol.UNSIGNED_BYTE);
        }
        int i = 0;
        Cons cons = this;
        while (i != index) {
            LispObject conscdr = cons.cdr;
            if (!(conscdr instanceof Cons)) {
                if (conscdr == Lisp.NIL) {
                    Lisp.type_error(Fixnum.getInstance(index), Lisp.list(Symbol.INTEGER, Fixnum.ZERO, Fixnum.getInstance(this.length() - 1)));
                } else {
                    Lisp.type_error(conscdr, Symbol.LIST);
                }
                return Lisp.NIL;
            }
            cons = (Cons)conscdr;
            ++i;
        }
        return cons.car;
    }

    public LispObject reverse() {
        Cons cons = this;
        Cons result = new Cons(cons.car);
        while (cons.cdr instanceof Cons) {
            cons = (Cons)cons.cdr;
            result = new Cons(cons.car, (LispObject)result);
        }
        if (cons.cdr != Lisp.NIL) {
            return Lisp.type_error(cons.cdr, Symbol.LIST);
        }
        return result;
    }

    public final LispObject nreverse() {
        if (this.cdr instanceof Cons) {
            Cons cons = (Cons)this.cdr;
            if (cons.cdr instanceof Cons) {
                Cons cons1 = cons;
                LispObject list = Lisp.NIL;
                do {
                    Cons temp = (Cons)cons.cdr;
                    cons.cdr = list;
                    list = cons;
                    cons = temp;
                } while (cons.cdr instanceof Cons);
                if (cons.cdr != Lisp.NIL) {
                    return Lisp.type_error(cons.cdr, Symbol.LIST);
                }
                this.cdr = list;
                cons1.cdr = cons;
            } else if (cons.cdr != Lisp.NIL) {
                return Lisp.type_error(cons.cdr, Symbol.LIST);
            }
            LispObject temp = this.car;
            this.car = cons.car;
            cons.car = temp;
        } else if (this.cdr != Lisp.NIL) {
            return Lisp.type_error(this.cdr, Symbol.LIST);
        }
        return this;
    }

    public final boolean listp() {
        return true;
    }

    public final boolean endp() {
        return false;
    }

    public final LispObject[] copyToArray() {
        int length = this.length();
        LispObject[] array = new LispObject[length];
        LispObject rest = this;
        for (int i = 0; i < length; ++i) {
            array[i] = rest.car();
            rest = rest.cdr();
        }
        return array;
    }

    public LispObject execute() {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute();
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject arg) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(arg);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third, fourth);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third, fourth, fifth);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third, fourth, fifth, sixth);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third, fourth, fifth, sixth, seventh);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
        }
        return this.signalExecutionError();
    }

    public LispObject execute(LispObject[] args) {
        if (this.car == Symbol.LAMBDA) {
            Closure closure = new Closure((LispObject)this, new Environment());
            return closure.execute(args);
        }
        return this.signalExecutionError();
    }

    private final LispObject signalExecutionError() {
        return Lisp.type_error(this, Lisp.list(Symbol.OR, Symbol.FUNCTION, Symbol.SYMBOL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeToString() {
        LispThread thread = LispThread.currentThread();
        LispObject printLength = Symbol.PRINT_LENGTH.symbolValue(thread);
        int maxLength = printLength instanceof Fixnum ? ((Fixnum)printLength).value : Integer.MAX_VALUE;
        LispObject printLevel = Symbol.PRINT_LEVEL.symbolValue(thread);
        int maxLevel = printLevel instanceof Fixnum ? ((Fixnum)printLevel).value : Integer.MAX_VALUE;
        FastStringBuffer sb = new FastStringBuffer();
        if (this.car == Symbol.QUOTE && this.cdr instanceof Cons && this.cdr.cdr() == Lisp.NIL) {
            sb.append('\'');
            sb.append(this.cdr.car().writeToString());
            return sb.toString();
        }
        if (this.car == Symbol.FUNCTION && this.cdr instanceof Cons && this.cdr.cdr() == Lisp.NIL) {
            sb.append("#'");
            sb.append(this.cdr.car().writeToString());
            return sb.toString();
        }
        LispObject currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread);
        int currentLevel = Fixnum.getValue(currentPrintLevel);
        if (currentLevel < maxLevel) {
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Lisp._CURRENT_PRINT_LEVEL_, currentPrintLevel.incr());
            try {
                int count = 0;
                boolean truncated = false;
                sb.append('(');
                if (count < maxLength) {
                    LispObject p = this;
                    sb.append(p.car().writeToString());
                    ++count;
                    while ((p = p.cdr()) instanceof Cons) {
                        sb.append(' ');
                        if (count < maxLength) {
                            sb.append(p.car().writeToString());
                            ++count;
                            continue;
                        }
                        truncated = true;
                        break;
                    }
                    if (!truncated && p != Lisp.NIL) {
                        sb.append(" . ");
                        sb.append(p.writeToString());
                    }
                } else {
                    truncated = true;
                }
                if (truncated) {
                    sb.append("...");
                }
                sb.append(')');
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        } else {
            sb.append('#');
        }
        return sb.toString();
    }

    static long getCount() {
        return count;
    }

    static void setCount(long n) {
        count = n;
    }
}

