/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;

public final class EqHashTable
extends HashTable {
    private LispObject cachedKey;
    private int cachedIndex;
    private int mask;

    public EqHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        super(EqHashTable.calculateInitialCapacity(size), rehashSize, rehashThreshold);
        this.mask = this.buckets.length - 1;
    }

    public Symbol getTest() {
        return Symbol.EQ;
    }

    public LispObject get(LispObject key) {
        int index;
        if (key == this.cachedKey) {
            index = this.cachedIndex;
        } else {
            index = key.sxhash() & this.mask;
            this.cachedKey = key;
            this.cachedIndex = index;
        }
        HashTable.HashEntry e = this.buckets[index];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void put(LispObject key, LispObject value) {
        int index;
        if (key == this.cachedKey) {
            index = this.cachedIndex;
        } else {
            index = key.sxhash() & this.mask;
            this.cachedKey = key;
            this.cachedIndex = index;
        }
        HashTable.HashEntry e = this.buckets[index];
        while (e != null) {
            if (key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (++this.count > this.threshold) {
            this.rehash();
            index = key.sxhash() & this.mask;
            this.cachedKey = key;
            this.cachedIndex = index;
        }
        e = new HashTable.HashEntry(key, value);
        e.next = this.buckets[index];
        this.buckets[index] = e;
    }

    public LispObject remove(LispObject key) {
        int index;
        if (key == this.cachedKey) {
            index = this.cachedIndex;
        } else {
            index = key.sxhash() & this.mask;
            this.cachedKey = key;
            this.cachedIndex = index;
        }
        HashTable.HashEntry e = this.buckets[index];
        HashTable.HashEntry last2 = null;
        while (e != null) {
            if (key == e.key) {
                if (last2 == null) {
                    this.buckets[index] = e.next;
                } else {
                    last2.next = e.next;
                }
                --this.count;
                return e.value;
            }
            last2 = e;
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        this.cachedKey = null;
        HashTable.HashEntry[] oldBuckets = this.buckets;
        int newCapacity = this.buckets.length * 2;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.buckets = new HashTable.HashEntry[newCapacity];
        this.mask = this.buckets.length - 1;
        int i = oldBuckets.length;
        while (i-- > 0) {
            HashTable.HashEntry e = oldBuckets[i];
            while (e != null) {
                int index = e.key.sxhash() & this.mask;
                HashTable.HashEntry dest = this.buckets[index];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[index] = e;
                }
                HashTable.HashEntry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }
}

