/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;

public final class EqualpHashTable
extends HashTable {
    public EqualpHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        super(size, rehashSize, rehashThreshold);
    }

    public Symbol getTest() {
        return Symbol.EQUALP;
    }

    public LispObject get(LispObject key) {
        int index = key.psxhash() % this.buckets.length;
        HashTable.HashEntry e = this.buckets[index];
        while (e != null) {
            if (key.equalp(e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void put(LispObject key, LispObject value) {
        int index = key.psxhash() % this.buckets.length;
        HashTable.HashEntry e = this.buckets[index];
        while (e != null) {
            if (key.equalp(e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (++this.count > this.threshold) {
            this.rehash();
            index = key.psxhash() % this.buckets.length;
        }
        e = new HashTable.HashEntry(key, value);
        e.next = this.buckets[index];
        this.buckets[index] = e;
    }

    public LispObject remove(LispObject key) {
        int index = key.psxhash() % this.buckets.length;
        HashTable.HashEntry e = this.buckets[index];
        HashTable.HashEntry last2 = null;
        while (e != null) {
            if (key.equalp(e.key)) {
                if (last2 == null) {
                    this.buckets[index] = e.next;
                } else {
                    last2.next = e.next;
                }
                --this.count;
                return e.value;
            }
            last2 = e;
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        HashTable.HashEntry[] oldBuckets = this.buckets;
        int newCapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.buckets = new HashTable.HashEntry[newCapacity];
        int i = oldBuckets.length;
        while (i-- > 0) {
            HashTable.HashEntry e = oldBuckets[i];
            while (e != null) {
                int index = e.key.psxhash() % this.buckets.length;
                HashTable.HashEntry dest = this.buckets[index];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[index] = e;
                }
                HashTable.HashEntry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }
}

