/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.IOException;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class Extensions {
    public static final Symbol _ED_FUNCTIONS_ = Lisp.exportSpecial("*ED-FUNCTIONS*", Lisp.PACKAGE_EXT, Lisp.list(Lisp.intern("DEFAULT-ED-FUNCTION", Lisp.PACKAGE_SYS), new LispObject[0]));
    private static final SpecialOperator TRULY_THE = new SpecialOperator("truly-the", Lisp.PACKAGE_EXT, true, "type value"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return Lisp.eval(args.cadr(), env, LispThread.currentThread());
        }
    };
    private static final Primitive NEQ = new Primitive(Symbol.NEQ, "obj1 obj2"){

        public LispObject execute(LispObject first, LispObject second) {
            return first != second ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive MEMQ = new Primitive(Symbol.MEMQ, "item list"){

        public LispObject execute(LispObject item, LispObject list) {
            while (list instanceof Cons) {
                if (item == ((Cons)list).car) {
                    return list;
                }
                list = ((Cons)list).cdr;
            }
            if (list != Lisp.NIL) {
                Lisp.type_error(list, Symbol.LIST);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive MEMQL = new Primitive(Symbol.MEMQL, "item list"){

        public LispObject execute(LispObject item, LispObject list) {
            while (list instanceof Cons) {
                if (item.eql(((Cons)list).car)) {
                    return list;
                }
                list = ((Cons)list).cdr;
            }
            if (list != Lisp.NIL) {
                Lisp.type_error(list, Symbol.LIST);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive ADJOIN_EQL = new Primitive(Symbol.ADJOIN_EQL, "item list"){

        public LispObject execute(LispObject item, LispObject list) {
            return Lisp.memql(item, list) ? list : new Cons(item, list);
        }
    };
    private static final Primitive SPECIAL_VARIABLE_P = new Primitive("special-variable-p", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            return arg.isSpecialVariable() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive SOURCE = new Primitive("source", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            return Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
        }
    };
    private static final Primitive SOURCE_FILE_POSITION = new Primitive("source-file-position", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            LispObject obj = Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
            if (obj instanceof Cons) {
                return obj.cdr();
            }
            return Lisp.NIL;
        }
    };
    public static final Primitive SOURCE_PATHNAME = new Primitive("source-pathname", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            LispObject obj = Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
            if (obj instanceof Cons) {
                return obj.car();
            }
            return obj;
        }
    };
    private static final Primitive EXIT = new Primitive("exit", Lisp.PACKAGE_EXT, true, "&key status"){

        public LispObject execute() {
            Lisp.exit(0);
            return LispThread.currentThread().nothing();
        }

        public LispObject execute(LispObject first, LispObject second) {
            int status = 0;
            if (first == Keyword.STATUS && second instanceof Fixnum) {
                status = ((Fixnum)second).value;
            }
            Lisp.exit(status);
            return LispThread.currentThread().nothing();
        }
    };
    private static final Primitive QUIT = new Primitive("quit", Lisp.PACKAGE_EXT, true, "&key status"){

        public LispObject execute() {
            Lisp.exit(0);
            return LispThread.currentThread().nothing();
        }

        public LispObject execute(LispObject first, LispObject second) {
            int status = 0;
            if (first == Keyword.STATUS && second instanceof Fixnum) {
                status = ((Fixnum)second).value;
            }
            Lisp.exit(status);
            return LispThread.currentThread().nothing();
        }
    };
    private static final Primitive DUMP_JAVA_STACK = new Primitive("dump-java-stack", Lisp.PACKAGE_EXT, true){

        public LispObject execute() {
            Thread.dumpStack();
            return LispThread.currentThread().nothing();
        }
    };
    private static final Primitive MAKE_TEMP_FILE = new Primitive("make-temp-file", Lisp.PACKAGE_EXT, true, ""){

        public LispObject execute() {
            try {
                File file = File.createTempFile("abcl", null, null);
                if (file != null) {
                    return new Pathname(file.getPath());
                }
            }
            catch (IOException e) {
                Debug.trace(e);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive INTERRUPT_LISP = new Primitive("interrupt-lisp", Lisp.PACKAGE_EXT, true, ""){

        public LispObject execute() {
            Lisp.setInterrupted(true);
            return Lisp.T;
        }
    };
    private static final Primitive GETENV = new Primitive("getenv", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.type_error(arg, Symbol.STRING);
            }
            AbstractString string = (AbstractString)arg;
            String result = System.getenv(string.getStringValue());
            if (result != null) {
                return new SimpleString(result);
            }
            return Lisp.NIL;
        }
    };
}

