/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DispatchMacroFunction;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FaslReadtable;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.ReaderMacroFunction;
import org.armedbear.lisp.SimpleBitVector;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;

public final class FaslReader {
    public static final ReaderMacroFunction FASL_READ_COMMENT = new ReaderMacroFunction("fasl-read-comment", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            try {
                int n;
                do {
                    if ((n = stream._readChar()) >= 0) continue;
                    return null;
                } while (n != 10);
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
    };
    public static final ReaderMacroFunction FASL_READ_STRING = new ReaderMacroFunction("fasl-read-string", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char terminator) {
            FaslReadtable rt = FaslReadtable.getInstance();
            FastStringBuffer sb = new FastStringBuffer();
            try {
                while (true) {
                    int n;
                    if ((n = stream._readChar()) < 0) {
                        Lisp.error(new EndOfFile(stream));
                        return null;
                    }
                    char c = (char)n;
                    if (rt.getSyntaxType(c) == 4) {
                        n = stream._readChar();
                        if (n < 0) {
                            Lisp.error(new EndOfFile(stream));
                            return null;
                        }
                        sb.append((char)n);
                        continue;
                    }
                    if (Utilities.isPlatformWindows && c == '\r') {
                        n = stream._readChar();
                        if (n < 0) {
                            Lisp.error(new EndOfFile(stream));
                            return null;
                        }
                        if (n == 10) {
                            sb.append('\n');
                            continue;
                        }
                        stream._unreadChar(n);
                        sb.append('\r');
                        continue;
                    }
                    if (c == terminator) break;
                    sb.append(c);
                }
                return new SimpleString(sb);
            }
            catch (IOException e) {
                return new SimpleString(sb);
            }
        }
    };
    public static final ReaderMacroFunction FASL_READ_LIST = new ReaderMacroFunction("fasl-read-list", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            return stream.readList(false, true);
        }
    };
    public static final ReaderMacroFunction FASL_READ_RIGHT_PAREN = new ReaderMacroFunction("fasl-read-right-paren", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            return Lisp.error(new ReaderError("Unmatched right parenthesis.", stream));
        }
    };
    public static final ReaderMacroFunction FASL_READ_QUOTE = new ReaderMacroFunction("fasl-read-quote", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            return new Cons(Symbol.QUOTE, (LispObject)new Cons(stream.faslRead(true, Lisp.NIL, true, LispThread.currentThread())));
        }
    };
    public static final ReaderMacroFunction FASL_READ_DISPATCH_CHAR = new ReaderMacroFunction("fasl-read-dispatch-char", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char c) {
            return stream.readDispatchChar(c, true);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_LEFT_PAREN = new DispatchMacroFunction("fasl-sharp-left-paren", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            LispThread thread = LispThread.currentThread();
            LispObject list = stream.readList(true, true);
            if (Lisp._BACKQUOTE_COUNT_.symbolValue(thread).zerop()) {
                if (n >= 0) {
                    LispObject[] array = new LispObject[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = list.car();
                        if (list.cdr() == Lisp.NIL) continue;
                        list = list.cdr();
                    }
                    return new SimpleVector(array);
                }
                return new SimpleVector(list);
            }
            return new Cons(Lisp._BQ_VECTOR_FLAG_.symbolValue(thread), list);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_STAR = new DispatchMacroFunction("fasl-sharp-star", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char ignored, int n) {
            char c;
            LispThread thread = LispThread.currentThread();
            FaslReadtable rt = FaslReadtable.getInstance();
            boolean suppress = Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL;
            FastStringBuffer sb = new FastStringBuffer();
            try {
                int ch;
                while ((ch = stream._readChar()) >= 0) {
                    c = (char)ch;
                    if (c == '0' || c == '1') {
                        sb.append(c);
                        continue;
                    }
                    byte syntaxType = rt.getSyntaxType(c);
                    if (syntaxType == 1 || syntaxType == 2) {
                        stream._unreadChar(c);
                        break;
                    }
                    if (suppress) continue;
                    String name = LispCharacter.charToName(c);
                    if (name == null) {
                        name = "#\\" + c;
                    }
                    Lisp.error(new ReaderError("Illegal element for bit-vector: " + name, stream));
                }
            }
            catch (IOException e) {
                Lisp.error(new ReaderError("IO error: ", stream));
                return Lisp.NIL;
            }
            if (suppress) {
                return Lisp.NIL;
            }
            if (n >= 0) {
                int length = sb.length();
                if (length == 0 && n > 0) {
                    return Lisp.error(new ReaderError("No element specified for bit vector of length " + n + '.', stream));
                }
                if (n > length) {
                    c = sb.charAt(length - 1);
                    for (int i = length; i < n; ++i) {
                        sb.append(c);
                    }
                } else if (n < length) {
                    return Lisp.error(new ReaderError("Bit vector is longer than specified length: #" + n + '*' + sb.toString(), stream));
                }
            }
            return new SimpleBitVector(sb.toString());
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_DOT = new DispatchMacroFunction("fasl-sharp-dot", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            LispThread thread = LispThread.currentThread();
            if (Symbol.READ_EVAL.symbolValue(thread) == Lisp.NIL) {
                return Lisp.error(new ReaderError("Can't read #. when *READ-EVAL* is NIL.", stream));
            }
            return Lisp.eval(stream.faslRead(true, Lisp.NIL, true, thread), new Environment(), thread);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_COLON = new DispatchMacroFunction("fasl-sharp-colon", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            LispThread thread = LispThread.currentThread();
            Symbol symbol = (Symbol)stream.readSymbol(FaslReadtable.getInstance());
            LispObject pkg = Load._FASL_ANONYMOUS_PACKAGE_.symbolValue(thread);
            Debug.assertTrue(pkg != Lisp.NIL);
            symbol = ((Package)pkg).intern(symbol.getName());
            symbol.setPackage(Lisp.NIL);
            return symbol;
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_A = new DispatchMacroFunction("fasl-sharp-a", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadArray(n);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_B = new DispatchMacroFunction("fasl-sharp-b", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadRadix(2);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_C = new DispatchMacroFunction("fasl-sharp-c", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadComplex();
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_O = new DispatchMacroFunction("fasl-sharp-o", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadRadix(8);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_P = new DispatchMacroFunction("fasl-sharp-p", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadPathname();
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_R = new DispatchMacroFunction("fasl-sharp-r", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadRadix(n);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_S = new DispatchMacroFunction("fasl-sharp-s", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readStructure();
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_X = new DispatchMacroFunction("fasl-sharp-x", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.faslReadRadix(16);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_QUOTE = new DispatchMacroFunction("fasl-sharp-quote", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return new Cons(Symbol.FUNCTION, (LispObject)new Cons(stream.faslRead(true, Lisp.NIL, true, LispThread.currentThread())));
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_BACKSLASH = new DispatchMacroFunction("fasl-sharp-backslash", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readCharacterLiteral(FaslReadtable.getInstance(), LispThread.currentThread());
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_VERTICAL_BAR = new DispatchMacroFunction("sharp-vertical-bar", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            stream.skipBalancedComment();
            return null;
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_ILLEGAL = new DispatchMacroFunction("fasl-sharp-illegal", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            FastStringBuffer sb = new FastStringBuffer("Illegal # macro character: #\\");
            String s = LispCharacter.charToName(c);
            if (s != null) {
                sb.append(s);
            } else {
                sb.append(c);
            }
            return Lisp.error(new ReaderError(sb.toString(), stream));
        }
    };
}

