/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

public final class FastStringBuffer
implements Appendable,
CharSequence {
    private static final int SPARE_CAPACITY = 128;
    private final StringBuilder builder;

    public FastStringBuffer() {
        this(128);
    }

    public FastStringBuffer(String s) {
        this.builder = new StringBuilder(s);
    }

    public FastStringBuffer(char c) {
        this(String.valueOf(c));
    }

    public FastStringBuffer(int length) throws NegativeArraySizeException {
        this.builder = new StringBuilder(length);
    }

    public final int length() {
        return this.builder.length();
    }

    public final int capacity() {
        return this.builder.capacity();
    }

    public final char charAt(int index) {
        return this.builder.charAt(index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.builder.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public void setCharAt(int index, char c) {
        this.builder.setCharAt(index, c);
    }

    public void ensureCapacity(int minimumCapacity) {
        this.builder.ensureCapacity(minimumCapacity);
    }

    public FastStringBuffer append(String s) {
        this.builder.append(s);
        return this;
    }

    public FastStringBuffer append(char[] chars) {
        this.builder.append(chars);
        return this;
    }

    public FastStringBuffer append(char[] chars, int offset, int len) {
        this.builder.append(chars, offset, len);
        return this;
    }

    public FastStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public FastStringBuffer append(char c) {
        this.builder.append(c);
        return this;
    }

    public final FastStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public final FastStringBuffer append(long n) {
        return this.append(String.valueOf(n));
    }

    public void setLength(int newLength) throws IndexOutOfBoundsException {
        this.builder.setLength(newLength);
    }

    public FastStringBuffer reverse() {
        this.builder.reverse();
        return this;
    }

    public final String toString() {
        return this.builder.toString();
    }

    public final char[] toCharArray() {
        return this.toString().toCharArray();
    }

    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    public FastStringBuffer append(CharSequence seq) {
        this.builder.append(seq);
        return this;
    }

    public FastStringBuffer append(CharSequence seq, int start, int end) {
        this.builder.append(seq, start, end);
        return this;
    }
}

