/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.ComplexString;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class FillPointerOutputStream
extends Stream {
    private ComplexString string;
    private static final Primitive MAKE_FILL_POINTER_OUTPUT_STREAM = new Primitive("make-fill-pointer-output-stream", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            ComplexString string;
            if (arg instanceof ComplexString && (string = (ComplexString)arg).getFillPointer() >= 0) {
                return new FillPointerOutputStream(string);
            }
            return Lisp.type_error(arg, Lisp.list(Symbol.AND, Symbol.STRING, Lisp.list(Symbol.SATISFIES, Symbol.ARRAY_HAS_FILL_POINTER_P)));
        }
    };

    private FillPointerOutputStream(ComplexString string) {
        this.elementType = Symbol.CHARACTER;
        this.isOutputStream = true;
        this.isInputStream = false;
        this.isCharacterStream = true;
        this.isBinaryStream = false;
        this.string = string;
        this.setWriter(new Writer());
    }

    private class Writer
    extends java.io.Writer {
        private Writer() {
        }

        public void write(char[] cbuf, int off, int len) {
            int fp = FillPointerOutputStream.this.string.getFillPointer();
            if (fp >= 0) {
                int limit = Math.min(cbuf.length, off + len);
                FillPointerOutputStream.this.string.ensureCapacity(fp + limit);
                for (int i = off; i < limit; ++i) {
                    FillPointerOutputStream.this.string.setCharAt(fp, cbuf[i]);
                    ++fp;
                }
            }
            FillPointerOutputStream.this.string.setFillPointer(fp);
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

