/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public abstract class Function
extends Operator {
    private LispObject propertyList = Lisp.NIL;
    private int callCount;
    private int hotCount;

    protected Function() {
    }

    public Function(String name) {
        if (name != null) {
            Symbol symbol = Symbol.addFunction(name.toUpperCase(), this);
            if (Lisp.cold) {
                symbol.setBuiltInFunction(true);
            }
            this.setLambdaName(symbol);
        }
    }

    public Function(Symbol symbol, String arglist2) {
        symbol.setSymbolFunction(this);
        if (Lisp.cold) {
            symbol.setBuiltInFunction(true);
        }
        this.setLambdaName(symbol);
        this.setLambdaList(new SimpleString(arglist2));
    }

    public Function(Symbol symbol, String arglist2, String docstring) {
        symbol.setSymbolFunction(this);
        if (Lisp.cold) {
            symbol.setBuiltInFunction(true);
        }
        this.setLambdaName(symbol);
        this.setLambdaList(new SimpleString(arglist2));
        if (docstring != null) {
            symbol.setDocumentation(Symbol.FUNCTION, new SimpleString(docstring));
        }
    }

    public Function(String name, String arglist2) {
        this(name);
        this.setLambdaList(new SimpleString(arglist2));
    }

    public Function(String name, Package pkg) {
        this(name, pkg, false);
    }

    public Function(String name, Package pkg, boolean exported) {
        this(name, pkg, exported, null, null);
    }

    public Function(String name, Package pkg, boolean exported, String arglist2) {
        this(name, pkg, exported, arglist2, null);
    }

    public Function(String name, Package pkg, boolean exported, String arglist2, String docstring) {
        if (arglist2 instanceof String) {
            this.setLambdaList(new SimpleString(arglist2));
        }
        if (name != null) {
            Symbol symbol = exported ? pkg.internAndExport(name.toUpperCase()) : pkg.intern(name.toUpperCase());
            symbol.setSymbolFunction(this);
            if (Lisp.cold) {
                symbol.setBuiltInFunction(true);
            }
            this.setLambdaName(symbol);
            if (docstring != null) {
                symbol.setDocumentation(Symbol.FUNCTION, new SimpleString(docstring));
            }
        }
    }

    public Function(LispObject name) {
        this.setLambdaName(name);
    }

    public Function(LispObject name, LispObject lambdaList) {
        this.setLambdaName(name);
        this.setLambdaList(lambdaList);
    }

    public LispObject typeOf() {
        return Symbol.FUNCTION;
    }

    public LispObject classOf() {
        return BuiltInClass.FUNCTION;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.FUNCTION) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.COMPILED_FUNCTION) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.FUNCTION) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public final void setClassBytes(byte[] bytes) {
        this.propertyList = Lisp.putf(this.propertyList, Symbol.CLASS_BYTES, new JavaObject(bytes));
    }

    public LispObject execute() {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject arg) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public LispObject execute(LispObject[] args) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeToString() {
        LispObject name = this.getLambdaName();
        if (name != null && name != Lisp.NIL) {
            StringBuffer sb = new StringBuffer("#<FUNCTION ");
            sb.append(name.writeToString());
            sb.append(" {");
            sb.append(Integer.toHexString(System.identityHashCode(this)).toUpperCase());
            sb.append("}>");
            return sb.toString();
        }
        LispObject lambdaList = this.getLambdaList();
        if (lambdaList != null) {
            StringBuffer sb = new StringBuffer("#<FUNCTION ");
            sb.append("(LAMBDA ");
            if (lambdaList == Lisp.NIL) {
                sb.append("()");
            } else {
                LispThread thread = LispThread.currentThread();
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Symbol.PRINT_LENGTH, Fixnum.THREE);
                try {
                    sb.append(lambdaList.writeToString());
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
            }
            sb.append(")");
            sb.append(" {");
            sb.append(Integer.toHexString(System.identityHashCode(this)).toUpperCase());
            sb.append("}>");
            return sb.toString();
        }
        return this.unreadableString("FUNCTION");
    }

    public final void argCountError() {
        Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    public final int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public final void incrementCallCount() {
        ++this.callCount;
    }

    public final int getHotCount() {
        return this.hotCount;
    }

    public void setHotCount(int n) {
        this.hotCount = n;
    }

    public final void incrementHotCount() {
        ++this.hotCount;
    }
}

