/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public abstract class HashTable
extends LispObject {
    private static final int DEFAULT_SIZE = 16;
    protected static final float loadFactor = 0.75f;
    protected final LispObject rehashSize;
    protected final LispObject rehashThreshold;
    protected int threshold;
    protected HashEntry[] buckets;
    protected int count;

    protected HashTable() {
        this.rehashSize = new SingleFloat(1.5f);
        this.rehashThreshold = new SingleFloat(0.75f);
        this.buckets = new HashEntry[16];
        this.threshold = 12;
    }

    protected HashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        this.rehashSize = rehashSize;
        this.rehashThreshold = rehashThreshold;
        this.buckets = new HashEntry[size];
        this.threshold = (int)((float)size * 0.75f);
    }

    protected static int calculateInitialCapacity(int size) {
        int capacity;
        for (capacity = 1; capacity < size; capacity <<= 1) {
        }
        return capacity;
    }

    public final LispObject getRehashSize() {
        return this.rehashSize;
    }

    public final LispObject getRehashThreshold() {
        return this.rehashThreshold;
    }

    public int getSize() {
        return this.buckets.length;
    }

    public int getCount() {
        return this.count;
    }

    public abstract Symbol getTest();

    public LispObject typeOf() {
        return Symbol.HASH_TABLE;
    }

    public LispObject classOf() {
        return BuiltInClass.HASH_TABLE;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.HASH_TABLE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.HASH_TABLE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashTable) {
            HashTable ht = (HashTable)obj;
            if (this.count != ht.count) {
                return false;
            }
            if (this.getTest() != ht.getTest()) {
                return false;
            }
            for (LispObject entries = this.ENTRIES(); entries != Lisp.NIL; entries = entries.cdr()) {
                LispObject entry = entries.car();
                LispObject key = entry.car();
                LispObject value = entry.cdr();
                if (value.equalp(ht.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LispObject getParts() {
        LispObject parts = Lisp.NIL;
        for (int i = 0; i < this.buckets.length; ++i) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                parts = parts.push(new Cons("KEY [bucket " + i + "]", e.key));
                parts = parts.push(new Cons("VALUE", e.value));
                e = e.next;
            }
        }
        return parts.nreverse();
    }

    public synchronized void clear() {
        int i = this.buckets.length;
        while (i-- > 0) {
            this.buckets[i] = null;
        }
        this.count = 0;
    }

    public synchronized LispObject gethash(LispObject key) {
        LispObject presentp;
        LispObject value = this.get(key);
        if (value == null) {
            presentp = Lisp.NIL;
            value = presentp;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public synchronized LispObject gethash(LispObject key, LispObject defaultValue) {
        LispObject presentp;
        LispObject value = this.get(key);
        if (value == null) {
            value = defaultValue;
            presentp = Lisp.NIL;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public synchronized LispObject gethash1(LispObject key) {
        LispObject value = this.get(key);
        return value != null ? value : Lisp.NIL;
    }

    public synchronized LispObject puthash(LispObject key, LispObject newValue) {
        this.put(key, newValue);
        return newValue;
    }

    public synchronized LispObject remhash(LispObject key) {
        return this.remove(key) != null ? Lisp.T : Lisp.NIL;
    }

    public String writeToString() {
        if (Symbol.PRINT_READABLY.symbolValue(LispThread.currentThread()) != Lisp.NIL) {
            Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
            return null;
        }
        FastStringBuffer sb = new FastStringBuffer(this.getTest().writeToString());
        sb.append(' ');
        sb.append(Symbol.HASH_TABLE.writeToString());
        sb.append(' ');
        sb.append(this.count);
        if (this.count == 1) {
            sb.append(" entry");
        } else {
            sb.append(" entries");
        }
        sb.append(", ");
        sb.append(this.buckets.length);
        sb.append(" buckets");
        return this.unreadableString(sb.toString());
    }

    public abstract LispObject get(LispObject var1);

    public abstract void put(LispObject var1, LispObject var2);

    public abstract LispObject remove(LispObject var1);

    protected abstract void rehash();

    public LispObject ENTRIES() {
        LispObject list = Lisp.NIL;
        int i = this.buckets.length;
        while (i-- > 0) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                list = new Cons(new Cons(e.key, e.value), list);
                e = e.next;
            }
        }
        return list;
    }

    public LispObject MAPHASH(LispObject function) {
        int i = this.buckets.length;
        while (i-- > 0) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                function.execute(e.key, e.value);
                e = e.next;
            }
        }
        return Lisp.NIL;
    }

    public int psxhash() {
        long result = 2062775257L;
        result = Lisp.mix(result, this.count);
        result = Lisp.mix(result, this.getTest().sxhash());
        return (int)(result & Integer.MAX_VALUE);
    }

    protected static class HashEntry {
        LispObject key;
        LispObject value;
        HashEntry next;

        HashEntry(LispObject key, LispObject value) {
            this.key = key;
            this.value = value;
        }
    }
}

