/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.EqHashTable;
import org.armedbear.lisp.EqlHashTable;
import org.armedbear.lisp.EqualHashTable;
import org.armedbear.lisp.EqualpHashTable;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class HashTableFunctions {
    private static final LispObject FUNCTION_EQ = Symbol.EQ.getSymbolFunction();
    private static final LispObject FUNCTION_EQL = Symbol.EQL.getSymbolFunction();
    private static final LispObject FUNCTION_EQUAL = Symbol.EQUAL.getSymbolFunction();
    private static final LispObject FUNCTION_EQUALP = Symbol.EQUALP.getSymbolFunction();
    private static final Primitive _MAKE_HASH_TABLE = new Primitive("%make-hash-table", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject test, LispObject size, LispObject rehashSize, LispObject rehashThreshold) {
            int n = Fixnum.getValue(size);
            if (test == FUNCTION_EQL || test == Lisp.NIL) {
                return new EqlHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQ) {
                return new EqHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQUAL) {
                return new EqualHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQUALP) {
                return new EqualpHashTable(n, rehashSize, rehashThreshold);
            }
            return Lisp.error(new LispError("Unsupported test for MAKE-HASH-TABLE: " + test.writeToString()));
        }
    };
    private static final Primitive GETHASH = new Primitive(Symbol.GETHASH, "key hash-table &optional default"){

        public LispObject execute(LispObject key, LispObject ht) {
            return HashTableFunctions.checkHashTable(ht).gethash(key);
        }

        public LispObject execute(LispObject key, LispObject ht, LispObject defaultValue) {
            return HashTableFunctions.checkHashTable(ht).gethash(key, defaultValue);
        }
    };
    private static final Primitive GETHASH1 = new Primitive(Symbol.GETHASH1, "key hash-table"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject first, LispObject second) {
            HashTable ht;
            HashTable hashTable = ht = HashTableFunctions.checkHashTable(second);
            synchronized (hashTable) {
                LispObject value = ht.get(first);
                return value != null ? value : Lisp.NIL;
            }
        }
    };
    private static final Primitive PUTHASH = new Primitive(Symbol.PUTHASH, "key hash-table new-value &optional default"){

        public LispObject execute(LispObject key, LispObject ht, LispObject value) {
            return HashTableFunctions.checkHashTable(ht).puthash(key, value);
        }

        public LispObject execute(LispObject key, LispObject ht, LispObject ignored, LispObject value) {
            return HashTableFunctions.checkHashTable(ht).puthash(key, value);
        }
    };
    private static final Primitive REMHASH = new Primitive(Symbol.REMHASH, "key hash-table"){

        public LispObject execute(LispObject key, LispObject ht) {
            return HashTableFunctions.checkHashTable(ht).remhash(key);
        }
    };
    private static final Primitive CLRHASH = new Primitive(Symbol.CLRHASH, "hash-table"){

        public LispObject execute(LispObject ht) {
            HashTableFunctions.checkHashTable(ht).clear();
            return ht;
        }
    };
    private static final Primitive HASH_TABLE_COUNT = new Primitive(Symbol.HASH_TABLE_COUNT, "hash-table"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(HashTableFunctions.checkHashTable(arg).getCount());
        }
    };
    private static final Primitive SXHASH = new Primitive(Symbol.SXHASH, "object"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.sxhash());
        }
    };
    private static final Primitive PSXHASH = new Primitive("psxhash", Lisp.PACKAGE_SYS, true, "object"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.psxhash());
        }
    };
    private static final Primitive HASH_TABLE_P = new Primitive(Symbol.HASH_TABLE_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof HashTable ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive HASH_TABLE_ENTRIES = new Primitive("hash-table-entries", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            return HashTableFunctions.checkHashTable(arg).ENTRIES();
        }
    };
    private static final Primitive HASH_TABLE_TEST = new Primitive(Symbol.HASH_TABLE_TEST, "hash-table"){

        public LispObject execute(LispObject arg) {
            return HashTableFunctions.checkHashTable(arg).getTest();
        }
    };
    private static final Primitive HASH_TABLE_SIZE = new Primitive(Symbol.HASH_TABLE_SIZE, "hash-table"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(HashTableFunctions.checkHashTable(arg).getSize());
        }
    };
    private static final Primitive HASH_TABLE_REHASH_SIZE = new Primitive(Symbol.HASH_TABLE_REHASH_SIZE, "hash-table"){

        public LispObject execute(LispObject arg) {
            return HashTableFunctions.checkHashTable(arg).getRehashSize();
        }
    };
    private static final Primitive HASH_TABLE_REHASH_THRESHOLD = new Primitive(Symbol.HASH_TABLE_REHASH_THRESHOLD, "hash-table"){

        public LispObject execute(LispObject arg) {
            return HashTableFunctions.checkHashTable(arg).getRehashThreshold();
        }
    };
    private static final Primitive MAPHASH = new Primitive(Symbol.MAPHASH, "function hash-table"){

        public LispObject execute(LispObject first, LispObject second) {
            return HashTableFunctions.checkHashTable(second).MAPHASH(first);
        }
    };

    protected static HashTable checkHashTable(LispObject ht) {
        if (ht instanceof HashTable) {
            return (HashTable)ht;
        }
        Lisp.type_error(ht, Symbol.HASH_TABLE);
        return null;
    }
}

