/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Condition;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.Main;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StringInputStream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Version;

public final class Interpreter {
    public static Interpreter interpreter;
    private final boolean jlisp;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private static boolean noinit;
    private static boolean noinform;
    private static boolean topLevelInitialized;
    private static final Primitive _DEBUGGER_HOOK_FUNCTION;
    private static final String build;

    public static synchronized Interpreter getInstance() {
        return interpreter;
    }

    public static synchronized Interpreter createInstance() {
        if (interpreter != null) {
            return null;
        }
        interpreter = new Interpreter();
        Lisp._NOINFORM_.setSymbolValue(Lisp.T);
        Interpreter.initializeLisp();
        return interpreter;
    }

    public static synchronized Interpreter createDefaultInstance(String[] args) {
        if (interpreter != null) {
            return null;
        }
        interpreter = new Interpreter();
        if (args != null) {
            Interpreter.preprocessCommandLineArguments(args);
        }
        if (!noinform) {
            Stream out = Lisp.getStandardOutput();
            out._writeString(Interpreter.banner());
            out._finishOutput();
        }
        if (noinform) {
            Lisp._NOINFORM_.setSymbolValue(Lisp.T);
        } else {
            double uptime = (double)(System.currentTimeMillis() - Main.startTimeMillis) / 1000.0;
            Lisp.getStandardOutput()._writeString("Low-level initialization completed in " + uptime + " seconds.\n");
        }
        Interpreter.initializeLisp();
        Interpreter.initializeTopLevel();
        if (!noinit) {
            Interpreter.processInitializationFile();
        }
        if (args != null) {
            Interpreter.postprocessCommandLineArguments(args);
        }
        return interpreter;
    }

    public static synchronized Interpreter createJLispInstance(InputStream in, OutputStream out, String initialDirectory, String version) {
        if (interpreter != null) {
            return null;
        }
        interpreter = new Interpreter(in, out, initialDirectory);
        Stream stdout = Lisp.getStandardOutput();
        stdout._writeLine(version);
        stdout._writeString(Interpreter.banner());
        stdout._finishOutput();
        Interpreter.initializeJLisp();
        Interpreter.initializeTopLevel();
        Interpreter.processInitializationFile();
        return interpreter;
    }

    public static boolean initialized() {
        return interpreter != null;
    }

    private Interpreter() {
        this.jlisp = false;
        this.inputStream = null;
        this.outputStream = null;
    }

    private Interpreter(InputStream inputStream, OutputStream outputStream, String initialDirectory) {
        this.jlisp = true;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        Lisp.resetIO(new Stream(inputStream, (LispObject)Symbol.CHARACTER), new Stream(outputStream, (LispObject)Symbol.CHARACTER));
        if (!initialDirectory.endsWith(File.separator)) {
            initialDirectory = initialDirectory.concat(File.separator);
        }
        Symbol.DEFAULT_PATHNAME_DEFAULTS.setSymbolValue(new Pathname(initialDirectory));
    }

    public LispObject eval(String s) {
        return Lisp.eval(new StringInputStream(s).read(true, Lisp.NIL, false, LispThread.currentThread()));
    }

    public static synchronized void initializeLisp() {
        if (!Lisp.initialized) {
            Load.loadSystemFile("boot.lisp", false, false, false);
            Lisp.initialized = true;
        }
    }

    public static synchronized void initializeJLisp() {
        if (!Lisp.initialized) {
            Symbol.FEATURES.setSymbolValue(new Cons(Keyword.J, Symbol.FEATURES.getSymbolValue()));
            Load.loadSystemFile("boot.lisp", false, false, false);
            try {
                Class.forName("org.armedbear.j.LispAPI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Load.loadSystemFile("j.lisp");
            Lisp.initialized = true;
        }
    }

    private static synchronized void initializeTopLevel() {
        if (!topLevelInitialized) {
            Symbol TOP_LEVEL_LOOP = Lisp.intern("TOP-LEVEL-LOOP", Lisp.PACKAGE_TPL);
            LispObject tplFun = TOP_LEVEL_LOOP.getSymbolFunction();
            if (tplFun instanceof Autoload) {
                Autoload autoload = (Autoload)tplFun;
                autoload.load();
            }
            topLevelInitialized = true;
        }
    }

    private static synchronized void processInitializationFile() {
        try {
            String userHome = System.getProperty("user.home");
            File file = new File(userHome, ".abclrc");
            if (file.isFile()) {
                Load.load(file.getCanonicalPath());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void preprocessCommandLineArguments(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("--noinit")) {
                    noinit = true;
                    continue;
                }
                if (arg.equals("--noinform")) {
                    noinform = true;
                    continue;
                }
                if (arg.equals("--batch")) {
                    Lisp._BATCH_MODE_.setSymbolValue(Lisp.T);
                    continue;
                }
                if (arg.equals("--eval")) {
                    if (i + 1 < args.length) {
                        ++i;
                        continue;
                    }
                    System.err.println("No argument supplied to --eval");
                    System.exit(1);
                    continue;
                }
                if (!arg.equals("--load") && !arg.equals("--load-system-file")) continue;
                if (i + 1 < args.length) {
                    ++i;
                    continue;
                }
                System.err.println("No argument supplied to --load");
                System.exit(1);
            }
        }
    }

    private static void postprocessCommandLineArguments(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("--eval")) {
                    if (i + 1 < args.length) {
                        try {
                            Interpreter.evaluate(args[i + 1]);
                        }
                        catch (UnhandledCondition c) {
                            String separator = System.getProperty("line.separator");
                            FastStringBuffer sb = new FastStringBuffer();
                            sb.append(separator);
                            sb.append("Caught ");
                            sb.append(c.getCondition().typeOf().writeToString());
                            sb.append(" while processing --eval option \"" + args[i + 1] + "\":");
                            sb.append(separator);
                            sb.append("  ");
                            LispThread thread = LispThread.currentThread();
                            thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.NIL);
                            sb.append(c.getCondition().writeToString());
                            sb.append(separator);
                            System.err.print(sb.toString());
                            System.exit(2);
                        }
                        ++i;
                        continue;
                    }
                    System.err.println("No argument supplied to --eval");
                    System.exit(1);
                    continue;
                }
                if (!arg.equals("--load") && !arg.equals("--load-system-file")) continue;
                if (i + 1 < args.length) {
                    if (arg.equals("--load")) {
                        Load.load(new Pathname(args[i + 1]), args[i + 1], false, false, true);
                    } else {
                        Load.loadSystemFile(args[i + 1]);
                    }
                    ++i;
                    continue;
                }
                System.err.println("No argument supplied to --load");
                System.exit(1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block14: {
            thread = LispThread.currentThread();
            try {
                TOP_LEVEL_LOOP = Lisp.intern("TOP-LEVEL-LOOP", Lisp.PACKAGE_TPL);
                tplFun = TOP_LEVEL_LOOP.getSymbolFunction();
                if (tplFun instanceof Function) {
                    thread.execute(tplFun);
                    return;
                }
                out = Lisp.getStandardOutput();
                while (true) lbl-1000:
                // 4 sources

                {
                    try {
                        while (true) {
                            thread.resetStack();
                            thread.clearSpecialBindings();
                            out._writeString("* ");
                            out._finishOutput();
                            object = Lisp.getStandardInput().read(false, Lisp.EOF, false, thread);
                            if (object != Lisp.EOF) {
                                out.setCharPos(0);
                                Symbol.MINUS.setSymbolValue(object);
                                result = Lisp.eval(object, new Environment(), thread);
                                Debug.assertTrue(result != null);
                                Symbol.STAR_STAR_STAR.setSymbolValue(Symbol.STAR_STAR.getSymbolValue());
                                Symbol.STAR_STAR.setSymbolValue(Symbol.STAR.getSymbolValue());
                                Symbol.STAR.setSymbolValue(result);
                                Symbol.PLUS_PLUS_PLUS.setSymbolValue(Symbol.PLUS_PLUS.getSymbolValue());
                                Symbol.PLUS_PLUS.setSymbolValue(Symbol.PLUS.getSymbolValue());
                                Symbol.PLUS.setSymbolValue(Symbol.MINUS.getSymbolValue());
                                out = Lisp.getStandardOutput();
                                out.freshLine();
                                values = thread.getValues();
                                Symbol.SLASH_SLASH_SLASH.setSymbolValue(Symbol.SLASH_SLASH.getSymbolValue());
                                Symbol.SLASH_SLASH.setSymbolValue(Symbol.SLASH.getSymbolValue());
                                if (values != null) {
                                    slash = Lisp.NIL;
                                    i = values.length;
                                    while (i-- > 0) {
                                        slash = new Cons(values[i], slash);
                                    }
                                    Symbol.SLASH.setSymbolValue(slash);
                                    for (i = 0; i < values.length; ++i) {
                                        out._writeLine(values[i].writeToString());
                                    }
                                } else {
                                    Symbol.SLASH.setSymbolValue(new Cons(result));
                                    out._writeLine(result.writeToString());
                                }
                                out._finishOutput();
                                continue;
                            }
                            break block14;
                            break;
                        }
                    }
                    catch (StackOverflowError e) {
                        Lisp.getStandardInput().clearInput();
                        out._writeLine("Stack overflow");
                    }
                    catch (ControlTransfer c) {
                        Interpreter.reportError(c, thread);
                    }
                    catch (Throwable t) {
                        Lisp.getStandardInput().clearInput();
                        out.printStackTrace(t);
                        thread.printBacktrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ** GOTO lbl-1000
        }
    }

    private static void reportError(ControlTransfer c, LispThread thread) {
        Lisp.getStandardInput().clearInput();
        Stream out = Lisp.getStandardOutput();
        out.freshLine();
        Condition condition = (Condition)c.getCondition();
        out._writeLine("Error: unhandled condition: " + condition.writeToString());
        if (thread != null) {
            thread.printBacktrace();
        }
    }

    private static void reportError(UnhandledCondition c, LispThread thread) {
        Lisp.getStandardInput().clearInput();
        Stream out = Lisp.getStandardOutput();
        out.freshLine();
        Condition condition = (Condition)c.getCondition();
        out._writeLine("Error: unhandled condition: " + condition.writeToString());
        if (thread != null) {
            thread.printBacktrace();
        }
    }

    public void kill() {
        this.kill(0);
    }

    public void kill(int status) {
        if (this.jlisp) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                Debug.trace(e);
            }
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                Debug.trace(e);
            }
        } else {
            System.exit(status);
        }
    }

    public synchronized void dispose() {
        Debug.trace("Interpreter.dispose");
        Debug.assertTrue(interpreter == this);
        interpreter = null;
    }

    protected void finalize() throws Throwable {
        System.err.println("Interpreter.finalize");
    }

    public static final LispObject readFromString(String s) {
        return new StringInputStream(s).read(true, Lisp.NIL, false, LispThread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject evaluate(String s) {
        LispThread thread;
        StringInputStream stream;
        LispObject obj;
        if (!Lisp.initialized) {
            Interpreter.initializeJLisp();
        }
        if ((obj = (stream = new StringInputStream(s)).read(false, Lisp.EOF, false, thread = LispThread.currentThread())) == Lisp.EOF) {
            return Lisp.error(new EndOfFile(stream));
        }
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.DEBUGGER_HOOK, _DEBUGGER_HOOK_FUNCTION);
        try {
            LispObject lispObject = Lisp.eval(obj, new Environment(), thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    private static String banner() {
        String sep = System.getProperty("line.separator");
        FastStringBuffer sb = new FastStringBuffer("Armed Bear Common Lisp ");
        sb.append(Version.getVersion());
        if (build != null) {
            sb.append(" (built ");
            sb.append(build);
            sb.append(')');
        }
        sb.append(sep);
        sb.append("Java ");
        sb.append(System.getProperty("java.version"));
        sb.append(' ');
        sb.append(System.getProperty("java.vendor"));
        sb.append(sep);
        String vm = System.getProperty("java.vm.name");
        if (vm != null) {
            sb.append(vm);
            sb.append(sep);
        }
        return sb.toString();
    }

    static {
        noinit = false;
        noinform = false;
        _DEBUGGER_HOOK_FUNCTION = new Primitive("%debugger-hook-function", Lisp.PACKAGE_SYS, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LispObject execute(LispObject first, LispObject second) throws UnhandledCondition {
                Condition condition = (Condition)first;
                if (interpreter == null) {
                    LispThread thread = LispThread.currentThread();
                    SpecialBindingsMark mark = thread.markSpecialBindings();
                    thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.NIL);
                    try {
                        LispObject stream;
                        LispObject truename = Symbol.LOAD_TRUENAME.symbolValue(thread);
                        if (truename != Lisp.NIL && (stream = Lisp._LOAD_STREAM_.symbolValue(thread)) instanceof Stream) {
                            int lineNumber = ((Stream)stream).getLineNumber() + 1;
                            int offset = ((Stream)stream).getOffset();
                            Debug.trace("Error loading " + truename.writeToString() + " at line " + lineNumber + " (offset " + offset + ")");
                        }
                        Debug.trace("Encountered unhandled condition of type " + condition.typeOf().writeToString() + ':');
                        Debug.trace("  " + condition.writeToString());
                    }
                    catch (Throwable t) {
                    }
                    finally {
                        thread.resetSpecialBindings(mark);
                    }
                }
                throw new UnhandledCondition(condition);
            }
        };
        String s = null;
        InputStream in = Interpreter.class.getResourceAsStream("build");
        if (in != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                s = reader.readLine();
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        build = s;
    }

    public static final class UnhandledCondition
    extends Error {
        LispObject condition;

        UnhandledCondition(LispObject condition) {
            this.condition = condition;
        }

        public LispObject getCondition() {
            return this.condition;
        }
    }
}

