/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaException;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StorageCondition;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Java {
    private static final Map<Class, Symbol> registeredExceptions = new HashMap<Class, Symbol>();
    private static final LispClass java_exception = LispClass.findClass(Symbol.JAVA_EXCEPTION);
    private static final Primitive REGISTER_JAVA_EXCEPTION = new Primitive("register-java-exception", Lisp.PACKAGE_JAVA, true, "exception-name condition-symbol"){

        public LispObject execute(LispObject className, LispObject symbol) {
            if (symbol instanceof Symbol && Java.isJavaException(LispClass.findClass((Symbol)symbol))) {
                registeredExceptions.put(Java.classForName(className.getStringValue()), (Symbol)symbol);
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive UNREGISTER_JAVA_EXCEPTION = new Primitive("unregister-java-exception", Lisp.PACKAGE_JAVA, true, "exception-name"){

        public LispObject execute(LispObject className) {
            return registeredExceptions.remove(Java.classForName(className.getStringValue())) == null ? Lisp.NIL : Lisp.T;
        }
    };
    private static final Primitive JCLASS = new Primitive(Symbol.JCLASS, "name-or-class-ref", "Returns a reference to the Java class designated by NAME-OR-CLASS-REF."){

        public LispObject execute(LispObject arg) {
            return JavaObject.getInstance(Java.javaClass(arg));
        }
    };
    private static final Primitive JFIELD = new Primitive("jfield", Lisp.PACKAGE_JAVA, true, "class-ref-or-field field-or-instance &optional instance value"){

        public LispObject execute(LispObject[] args) {
            return Java.jfield(this, args, true);
        }
    };
    private static final Primitive JFIELD_RAW = new Primitive("jfield-raw", Lisp.PACKAGE_JAVA, true, "class-ref-or-field field-or-instance &optional instance value"){

        public LispObject execute(LispObject[] args) {
            return Java.jfield(this, args, false);
        }
    };
    private static final Primitive JCONSTRUCTOR = new Primitive("jconstructor", Lisp.PACKAGE_JAVA, true, "class-ref &rest parameter-class-refs"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            try {
                Class c = Java.javaClass(args[0]);
                int argCount = 0;
                if (args.length != 2 || !(args[1] instanceof Fixnum)) {
                    Class[] parameterTypes = new Class[args.length - 1];
                    for (int i = 1; i < args.length; ++i) {
                        parameterTypes[i - 1] = Java.javaClass(args[i]);
                    }
                    return JavaObject.getInstance(c.getConstructor(parameterTypes));
                }
                argCount = Fixnum.getValue(args[1]);
                Constructor<?>[] constructors = c.getConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    Constructor<?> constructor = constructors[i];
                    if (constructor.getParameterTypes().length != argCount) continue;
                    return JavaObject.getInstance(constructor);
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                Lisp.error(new LispError("no such constructor"));
            }
            catch (ControlTransfer e) {
                throw e;
            }
            catch (Throwable t) {
                Lisp.error(new LispError(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive JMETHOD = new Primitive("jmethod", Lisp.PACKAGE_JAVA, true, "class-ref name &rest parameter-class-refs"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Class c = Java.javaClass(args[0]);
            String methodName = args[1].getStringValue();
            try {
                int argCount = 0;
                if (args.length != 3 || !(args[2] instanceof Fixnum)) {
                    Class[] parameterTypes = new Class[args.length - 2];
                    for (int i = 2; i < args.length; ++i) {
                        parameterTypes[i - 2] = Java.javaClass(args[i]);
                    }
                    return JavaObject.getInstance(c.getMethod(methodName, parameterTypes));
                }
                argCount = ((Fixnum)args[2]).value;
                Method[] methods = c.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().equals(methodName) || method.getParameterTypes().length != argCount) continue;
                    return JavaObject.getInstance(method);
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                FastStringBuffer sb = new FastStringBuffer("No such method: ");
                sb.append(c.getName());
                sb.append('.');
                sb.append(methodName);
                sb.append('(');
                for (int i = 2; i < args.length; ++i) {
                    sb.append(args[i].writeToString());
                    if (i >= args.length - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
                Lisp.error(new LispError(sb.toString()));
            }
            catch (ControlTransfer e) {
                throw e;
            }
            catch (Throwable t) {
                Lisp.error(new LispError(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive JSTATIC = new Primitive("jstatic", Lisp.PACKAGE_JAVA, true, "method class &rest args"){

        public LispObject execute(LispObject[] args) {
            return Java.jstatic(this, args, true);
        }
    };
    private static final Primitive JSTATIC_RAW = new Primitive("jstatic-raw", Lisp.PACKAGE_JAVA, true, "method class &rest args"){

        public LispObject execute(LispObject[] args) {
            return Java.jstatic(this, args, false);
        }
    };
    private static final Primitive JNEW = new Primitive("jnew", Lisp.PACKAGE_JAVA, true, "constructor &rest args"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject classRef = args[0];
            try {
                Constructor constructor = classRef instanceof AbstractString ? Java.findConstructor(Java.javaClass(classRef), args) : (Constructor)JavaObject.getObject(classRef);
                Class<?>[] argTypes = constructor.getParameterTypes();
                Object[] initargs = new Object[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    LispObject arg = args[i];
                    initargs[i - 1] = arg == Lisp.NIL ? null : arg.javaInstance(argTypes[i - 1]);
                }
                return JavaObject.getInstance(constructor.newInstance(initargs));
            }
            catch (ControlTransfer c) {
                throw c;
            }
            catch (Throwable t) {
                Symbol condition;
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if ((condition = Java.getCondition(t.getClass())) == null) {
                    Lisp.error(new JavaException(t));
                } else {
                    Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
                }
                return Lisp.NIL;
            }
        }
    };
    private static final Primitive JNEW_ARRAY = new Primitive("jnew-array", Lisp.PACKAGE_JAVA, true, "element-type &rest dimensions"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            try {
                Class c = Java.javaClass(args[0]);
                int[] dimensions = new int[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    dimensions[i - 1] = (Integer)args[i].javaInstance();
                }
                return JavaObject.getInstance(Array.newInstance(c, dimensions));
            }
            catch (Throwable t) {
                Lisp.error(new JavaException(t));
                return Lisp.NIL;
            }
        }
    };
    private static final Primitive JARRAY_REF = new Primitive("jarray-ref", Lisp.PACKAGE_JAVA, true, "java-array &rest indices"){

        public LispObject execute(LispObject[] args) {
            return Java.jarray_ref(this, args, true);
        }
    };
    private static final Primitive JARRAY_REF_RAW = new Primitive("jarray-ref-raw", Lisp.PACKAGE_JAVA, true, "java-array &rest indices"){

        public LispObject execute(LispObject[] args) {
            return Java.jarray_ref(this, args, false);
        }
    };
    private static final Primitive JARRAY_SET = new Primitive("jarray-set", Lisp.PACKAGE_JAVA, true, "java-array new-value &rest indices"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 3) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            try {
                Object a = args[0].javaInstance();
                LispObject v = args[1];
                for (int i = 2; i < args.length - 1; ++i) {
                    a = Array.get(a, (Integer)args[i].javaInstance());
                }
                Array.set(a, (Integer)args[args.length - 1].javaInstance(), v.javaInstance());
                return v;
            }
            catch (Throwable t) {
                Symbol condition = Java.getCondition(t.getClass());
                if (condition == null) {
                    Lisp.error(new JavaException(t));
                } else {
                    Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
                }
                return Lisp.NIL;
            }
        }
    };
    private static final Primitive JCALL = new Primitive(Symbol.JCALL, "method-ref instance &rest args"){

        public LispObject execute(LispObject[] args) {
            return Java.jcall(this, args, true);
        }
    };
    private static final Primitive JCALL_RAW = new Primitive(Symbol.JCALL_RAW, "method-ref instance &rest args"){

        public LispObject execute(LispObject[] args) {
            return Java.jcall(this, args, false);
        }
    };
    private static final Primitive MAKE_IMMEDIATE_OBJECT = new Primitive("make-immediate-object", Lisp.PACKAGE_JAVA, true, "object &optional type"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject object = args[0];
            if (args.length > 1) {
                LispObject type = args[1];
                if (type == Keyword.BOOLEAN) {
                    if (object == Lisp.NIL) {
                        return JavaObject.getInstance(Boolean.FALSE);
                    }
                    return JavaObject.getInstance(Boolean.TRUE);
                }
                if (type == Keyword.REF) {
                    if (object == Lisp.NIL) {
                        return JavaObject.getInstance(null);
                    }
                    Lisp.error(new LispError("MAKE-IMMEDIATE-OBJECT: not implemented"));
                }
            }
            return JavaObject.getInstance(object.javaInstance());
        }
    };
    private static final Primitive JAVA_OBJECT_P = new Primitive("java-object-p", Lisp.PACKAGE_JAVA, true, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof JavaObject ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive JOBJECT_LISP_VALUE = new Primitive("jobject-lisp-value", Lisp.PACKAGE_JAVA, true, "java-object"){

        public LispObject execute(LispObject arg) {
            return JavaObject.getInstance(arg.javaInstance(), true);
        }
    };
    private static final Primitive JCOERCE = new Primitive("jcoerce", Lisp.PACKAGE_JAVA, true, "java-object intended-class"){

        public LispObject execute(LispObject javaObject, LispObject intendedClass) {
            Object o = javaObject.javaInstance();
            Class c = Java.javaClass(intendedClass);
            try {
                return JavaObject.getInstance(o, c);
            }
            catch (ClassCastException e) {
                return Lisp.error(new TypeError(javaObject, new SimpleString(c.getName())));
            }
        }
    };
    private static final Primitive JGET_PROPERTY_VALUE = new Primitive("%jget-property-value", Lisp.PACKAGE_JAVA, true, "java-object property-name"){

        public LispObject execute(LispObject javaObject, LispObject propertyName) {
            try {
                Object obj = javaObject.javaInstance();
                PropertyDescriptor pd = Java.getPropertyDescriptor(obj, propertyName);
                Object value = pd.getReadMethod().invoke(obj, new Object[0]);
                if (value instanceof LispObject) {
                    return (LispObject)value;
                }
                if (value != null) {
                    return JavaObject.getInstance(value, true);
                }
                return Lisp.NIL;
            }
            catch (Exception e) {
                return Lisp.error(new JavaException(e));
            }
        }
    };
    private static final Primitive JSET_PROPERTY_VALUE = new Primitive("%jset-property-value", Lisp.PACKAGE_JAVA, true, "java-object property-name value"){

        public LispObject execute(LispObject javaObject, LispObject propertyName, LispObject value) {
            Object obj = null;
            try {
                obj = javaObject.javaInstance();
                PropertyDescriptor pd = Java.getPropertyDescriptor(obj, propertyName);
                Object jValue = value instanceof JavaObject ? value.javaInstance() : (Boolean.TYPE.equals(pd.getPropertyType()) || Boolean.class.equals(pd.getPropertyType()) ? Boolean.valueOf(value != Lisp.NIL) : (value != Lisp.NIL ? value.javaInstance() : null));
                pd.getWriteMethod().invoke(obj, jValue);
                return value;
            }
            catch (Exception e) {
                return Lisp.error(new JavaException(e));
            }
        }
    };
    private static final Primitive JRUN_EXCEPTION_PROTECTED = new Primitive("jrun-exception-protected", Lisp.PACKAGE_JAVA, true, "closure"){

        public LispObject execute(LispObject closure) {
            Function fun = Lisp.checkFunction(closure);
            try {
                return LispThread.currentThread().execute(closure);
            }
            catch (OutOfMemoryError oom) {
                return Lisp.error(new StorageCondition("Out of memory."));
            }
            catch (StackOverflowError oos) {
                return Lisp.error(new StorageCondition("Stack overflow."));
            }
        }
    };

    private static boolean isJavaException(LispClass lc) {
        return lc.subclassp(java_exception);
    }

    private static Symbol getCondition(Class cl) {
        Class o = Java.classForName("java.lang.Object");
        for (Class c = cl; c != o; c = c.getSuperclass()) {
            Symbol object = registeredExceptions.get(c);
            if (object == null || !Java.isJavaException(LispClass.findClass(object))) continue;
            return object;
        }
        return null;
    }

    private static final LispObject jfield(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2 || args.length > 4) {
            Lisp.error(new WrongNumberOfArgumentsException(fun));
        }
        String fieldName = null;
        Object instance = null;
        try {
            Class<?> c;
            if (args[1] instanceof AbstractString) {
                fieldName = args[1].getStringValue();
                c = Java.javaClass(args[0]);
            } else {
                fieldName = args[0].getStringValue();
                instance = JavaObject.getObject(args[1]);
                c = instance.getClass();
            }
            Field f = c.getField(fieldName);
            Class<?> fieldType = f.getType();
            switch (args.length) {
                case 2: {
                    break;
                }
                case 3: {
                    if (instance == null) {
                        if (args[2] instanceof JavaObject) {
                            instance = JavaObject.getObject(args[2]);
                            break;
                        }
                        f.set(null, args[2].javaInstance(fieldType));
                        return args[2];
                    }
                    f.set(instance, args[2].javaInstance(fieldType));
                    return args[2];
                }
                case 4: {
                    if (args[2] != Lisp.NIL) {
                        instance = JavaObject.getObject(args[2]);
                    }
                    f.set(instance, args[3].javaInstance(fieldType));
                    return args[3];
                }
            }
            return JavaObject.getInstance(f.get(instance), translate, f.getType());
        }
        catch (NoSuchFieldException e) {
            Lisp.error(new LispError("no such field"));
        }
        catch (SecurityException e) {
            Lisp.error(new LispError("inaccessible field"));
        }
        catch (IllegalAccessException e) {
            Lisp.error(new LispError("illegal access"));
        }
        catch (IllegalArgumentException e) {
            Lisp.error(new LispError("illegal argument"));
        }
        catch (Throwable t) {
            Lisp.error(new LispError(Java.getMessage(t)));
        }
        return Lisp.NIL;
    }

    private static final LispObject jstatic(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException(fun));
        }
        try {
            Method m = null;
            LispObject methodRef = args[0];
            if (methodRef instanceof JavaObject) {
                Object obj = ((JavaObject)methodRef).getObject();
                if (obj instanceof Method) {
                    m = (Method)obj;
                }
            } else if (methodRef instanceof AbstractString) {
                Class c = Java.javaClass(args[1]);
                if (c != null) {
                    String methodName = methodRef.getStringValue();
                    Method[] methods = c.getMethods();
                    ArrayList<Method> staticMethods = new ArrayList<Method>();
                    int argCount = args.length - 2;
                    for (Method m1 : methods) {
                        if (!Modifier.isStatic(m1.getModifiers())) continue;
                        staticMethods.add(m1);
                    }
                    if (staticMethods.size() > 0) {
                        m = Java.findMethod(staticMethods.toArray(new Method[staticMethods.size()]), methodName, args);
                    }
                    if (m == null) {
                        Lisp.error(new LispError("no such method"));
                    }
                }
            } else {
                Lisp.error(new TypeError("wrong type: " + methodRef));
            }
            Object[] methodArgs = new Object[args.length - 2];
            Class<?>[] argTypes = m.getParameterTypes();
            for (int i = 2; i < args.length; ++i) {
                LispObject arg = args[i];
                methodArgs[i - 2] = arg == Lisp.NIL ? null : arg.javaInstance(argTypes[i - 2]);
            }
            Object result = m.invoke(null, methodArgs);
            return JavaObject.getInstance(result, translate, m.getReturnType());
        }
        catch (ControlTransfer c) {
            throw c;
        }
        catch (Throwable t) {
            Symbol condition;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if ((condition = Java.getCondition(t.getClass())) == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    private static final LispObject jarray_ref(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException(fun));
        }
        try {
            Object a = args[0].javaInstance();
            for (int i = 1; i < args.length - 1; ++i) {
                a = Array.get(a, (Integer)args[i].javaInstance());
            }
            return JavaObject.getInstance(Array.get(a, (Integer)args[args.length - 1].javaInstance()), translate);
        }
        catch (Throwable t) {
            Symbol condition = Java.getCondition(t.getClass());
            if (condition == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    private static LispObject jcall(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException(fun));
        }
        try {
            Class<?>[] argTypes;
            Method method;
            Object[] methodArgs;
            Object instance;
            LispObject methodArg = args[0];
            LispObject instanceArg = args[1];
            Class<?> intendedClass = null;
            if (instanceArg instanceof AbstractString) {
                instance = instanceArg.getStringValue();
            } else if (instanceArg instanceof JavaObject) {
                JavaObject jobj = (JavaObject)instanceArg;
                instance = jobj.getObject();
                intendedClass = jobj.getIntendedClass();
            } else {
                instance = instanceArg.javaInstance();
            }
            if (instance == null) {
                throw new NullPointerException();
            }
            if (methodArg instanceof AbstractString) {
                methodArgs = Java.translateMethodArguments(args, 2);
                String methodName = methodArg.getStringValue();
                if (intendedClass == null) {
                    intendedClass = instance.getClass();
                }
                method = Java.findMethod(intendedClass, methodName, methodArgs);
                Class<?> actualClass = null;
                if (method == null && intendedClass != (actualClass = instance.getClass()) && Modifier.isPublic(actualClass.getModifiers())) {
                    method = Java.findMethod(actualClass, methodName, methodArgs);
                }
                if (method == null) {
                    String classes = intendedClass.getName();
                    if (actualClass != null && actualClass != intendedClass) {
                        classes = classes + " or " + actualClass.getName();
                    }
                    throw new NoSuchMethodException("No applicable method named " + methodName + " found in " + classes);
                }
            } else {
                method = (Method)JavaObject.getObject(methodArg);
            }
            if ((argTypes = method.getParameterTypes()).length != args.length - 2) {
                return Lisp.error(new WrongNumberOfArgumentsException("Wrong number of arguments for " + method + ": expected " + argTypes.length + ", got " + (args.length - 2)));
            }
            methodArgs = new Object[argTypes.length];
            for (int i = 2; i < args.length; ++i) {
                LispObject arg = args[i];
                methodArgs[i - 2] = arg == Lisp.NIL ? null : arg.javaInstance(argTypes[i - 2]);
            }
            return JavaObject.getInstance(method.invoke(instance, methodArgs), translate, method.getReturnType());
        }
        catch (ControlTransfer t) {
            throw t;
        }
        catch (Throwable t) {
            Symbol condition;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if ((condition = Java.getCondition(t.getClass())) == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return null;
        }
    }

    private static Object[] translateMethodArguments(LispObject[] args) {
        return Java.translateMethodArguments(args, 0);
    }

    private static Object[] translateMethodArguments(LispObject[] args, int offs) {
        int argCount = args.length - offs;
        Object[] javaArgs = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            LispObject x = args[i + offs];
            javaArgs[i] = x == Lisp.NIL ? null : x.javaInstance();
        }
        return javaArgs;
    }

    private static Method findMethod(Method[] methods, String methodName, Object[] javaArgs) {
        int argCount = javaArgs.length;
        Method result = null;
        int i = methods.length;
        while (i-- > 0) {
            Class<?>[] methodTypes;
            Method method = methods[i];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != argCount || !Java.isApplicableMethod(methodTypes = method.getParameterTypes(), javaArgs) || result != null && !Java.isMoreSpecialized(methodTypes, result.getParameterTypes())) continue;
            result = method;
        }
        return result;
    }

    private static Method findMethod(Class<?> c, String methodName, Object[] javaArgs) {
        Method[] methods = c.getMethods();
        return Java.findMethod(methods, methodName, javaArgs);
    }

    private static Method findMethod(Class<?> c, String methodName, LispObject[] args) {
        Object[] javaArgs = Java.translateMethodArguments(args, 2);
        return Java.findMethod(c, methodName, javaArgs);
    }

    private static Method findMethod(Method[] methods, String methodName, LispObject[] args) {
        Object[] javaArgs = Java.translateMethodArguments(args, 2);
        return Java.findMethod(methods, methodName, javaArgs);
    }

    private static Constructor findConstructor(Class<?> c, LispObject[] args) throws NoSuchMethodException {
        int argCount = args.length - 1;
        Object[] javaArgs = Java.translateMethodArguments(args, 1);
        Constructor<?>[] ctors = c.getConstructors();
        Constructor<?> result = null;
        int i = ctors.length;
        while (i-- > 0) {
            Class<?>[] methodTypes;
            Constructor<?> ctor = ctors[i];
            if (ctor.getParameterTypes().length != argCount || !Java.isApplicableMethod(methodTypes = ctor.getParameterTypes(), javaArgs) || result != null && !Java.isMoreSpecialized(methodTypes, result.getParameterTypes())) continue;
            result = ctor;
        }
        if (result == null) {
            StringBuilder sb = new StringBuilder(c.getSimpleName());
            sb.append('(');
            boolean first = true;
            for (Object o : javaArgs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (o != null) {
                    sb.append(o.getClass().getName());
                    continue;
                }
                sb.append("<null>");
            }
            sb.append(')');
            throw new NoSuchMethodException(sb.toString());
        }
        return result;
    }

    private static boolean isApplicableMethod(Class<?>[] methodTypes, Object[] args) {
        for (int i = 0; i < methodTypes.length; ++i) {
            Class<?> x;
            Class<?> methodType = methodTypes[i];
            Object arg = args[i];
            if (!(methodType.isPrimitive() ? !(x = Java.getBoxedClass(methodType)).isInstance(arg) : arg != null && !methodType.isInstance(arg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isMoreSpecialized(Class<?>[] xtypes, Class<?>[] ytypes) {
        for (int i = 0; i < xtypes.length; ++i) {
            Class<?> ytype;
            Class<?> xtype = xtypes[i];
            if (xtype.isPrimitive()) {
                xtype = Java.getBoxedClass(xtype);
            }
            if ((ytype = ytypes[i]).isPrimitive()) {
                ytype = Java.getBoxedClass(ytype);
            }
            if (xtype.equals(ytype) || !ytype.isAssignableFrom(xtype)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> maybeBoxClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Java.getBoxedClass(clazz);
        }
        return clazz;
    }

    private static Class<?> getBoxedClass(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        return Void.class;
    }

    private static PropertyDescriptor getPropertyDescriptor(Object obj, LispObject propertyName) throws IntrospectionException {
        String prop = ((AbstractString)propertyName).getStringValue();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(prop)) continue;
            return pd;
        }
        Lisp.error(new LispError("Property " + prop + " not found in " + obj));
        return null;
    }

    private static Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, JavaClassLoader.getPersistentInstance());
            }
            catch (ClassNotFoundException ex) {
                Lisp.error(new LispError("Class not found: " + className));
                return null;
            }
        }
    }

    private static Class javaClass(LispObject obj) {
        if (obj instanceof AbstractString || obj instanceof Symbol) {
            String s = Lisp.javaString(obj);
            if (s.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (s.equals("byte")) {
                return Byte.TYPE;
            }
            if (s.equals("char")) {
                return Character.TYPE;
            }
            if (s.equals("short")) {
                return Short.TYPE;
            }
            if (s.equals("int")) {
                return Integer.TYPE;
            }
            if (s.equals("long")) {
                return Long.TYPE;
            }
            if (s.equals("float")) {
                return Float.TYPE;
            }
            if (s.equals("double")) {
                return Double.TYPE;
            }
            Class c = Java.classForName(s);
            if (c == null) {
                Lisp.error(new LispError(s + " does not designate a Java class."));
            }
            return c;
        }
        if (!(obj instanceof JavaObject)) {
            Lisp.type_error(obj, Lisp.list(Symbol.OR, Symbol.STRING, Symbol.JAVA_OBJECT));
            return null;
        }
        JavaObject javaObject = (JavaObject)obj;
        Object javaObjectgetObject = javaObject.getObject();
        if (javaObjectgetObject instanceof Class) {
            return (Class)javaObjectgetObject;
        }
        Lisp.error(new LispError(obj.writeToString() + " does not designate a Java class."));
        return null;
    }

    private static final String getMessage(Throwable t) {
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.getClass().getName();
        }
        return message;
    }
}

