/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends LispClass {
    private Class<?> javaClass;
    private static final Map<Class<?>, JavaClass> cache = new HashMap();
    private static final Primitive _FIND_JAVA_CLASS = new Primitive("%find-java-class", Lisp.PACKAGE_JAVA, false, "string"){

        public LispObject execute(LispObject arg) {
            try {
                return JavaClass.findJavaClass(Class.forName(arg.getStringValue()));
            }
            catch (ClassNotFoundException e) {
                return Lisp.error(new LispError("Cannot find Java class " + arg.getStringValue()));
            }
        }
    };

    private JavaClass(Class<?> javaClass) {
        super(new Symbol(javaClass.getCanonicalName()));
        this.javaClass = javaClass;
        this.setDirectSuperclass(BuiltInClass.JAVA_OBJECT);
    }

    private void initCPL() {
        LispObject cpl = Lisp.NIL;
        cpl = cpl.push(BuiltInClass.CLASS_T);
        cpl = cpl.push(BuiltInClass.JAVA_OBJECT);
        HashSet alreadySeen = new HashSet();
        Stack<JavaClass> stack = new Stack<JavaClass>();
        boolean stop = false;
        for (Class<?> theClass = this.javaClass; !stop && theClass != null; theClass = theClass.getSuperclass()) {
            stop = JavaClass.addClass(alreadySeen, stack, theClass);
            for (Class<?> c : theClass.getInterfaces()) {
                stop = JavaClass.addClass(alreadySeen, stack, c) && stop;
            }
        }
        while (!stack.isEmpty()) {
            cpl = cpl.push(stack.pop());
        }
        this.setCPL(cpl);
    }

    private static boolean addClass(Set<Class<?>> alreadySeen, Stack<JavaClass> stack, Class<?> theClass) {
        if (!alreadySeen.contains(theClass)) {
            alreadySeen.add(theClass);
            stack.push(JavaClass.findJavaClass(theClass));
            return false;
        }
        return true;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.JAVA_CLASS;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.JAVA_CLASS;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.JAVA_CLASS) {
            return Lisp.T;
        }
        if (type == StandardClass.JAVA_CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getDescription() {
        return new SimpleString(this.writeToString());
    }

    @Override
    public String writeToString() {
        FastStringBuffer sb = new FastStringBuffer("#<JAVA-CLASS ");
        sb.append(this.javaClass.getCanonicalName());
        sb.append('>');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass findJavaClass(Class<?> javaClass) {
        Map<Class<?>, JavaClass> map = cache;
        synchronized (map) {
            JavaClass c = cache.get(javaClass);
            if (c == null) {
                c = new JavaClass(javaClass);
                cache.put(javaClass, c);
                c.initCPL();
            }
            return c;
        }
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean subclassp(LispObject obj) {
        if (obj == BuiltInClass.CLASS_T) {
            return true;
        }
        if (obj == BuiltInClass.JAVA_OBJECT) {
            return true;
        }
        if (obj instanceof JavaClass) {
            return ((JavaClass)obj).getJavaClass().isAssignableFrom(this.javaClass);
        }
        return false;
    }
}

