/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassLoader
extends ClassLoader {
    private static JavaClassLoader persistentInstance;
    private static Set<String> packages;

    public JavaClassLoader() {
        super(JavaClassLoader.class.getClassLoader());
    }

    public static JavaClassLoader getPersistentInstance() {
        return JavaClassLoader.getPersistentInstance(null);
    }

    public static JavaClassLoader getPersistentInstance(String packageName) {
        if (persistentInstance == null) {
            persistentInstance = new JavaClassLoader();
        }
        JavaClassLoader.definePackage(packageName);
        return persistentInstance;
    }

    private static void definePackage(String packageName) {
        if (packageName != null && !packages.contains(packageName)) {
            persistentInstance.definePackage(packageName, "", "1.0", "", "", "1.0", "", null);
            packages.add(packageName);
        }
    }

    public Class<?> loadClassFromByteArray(byte[] classbytes) {
        return this.loadClassFromByteArray(null, classbytes);
    }

    public Class<?> loadClassFromByteArray(String className, byte[] classbytes) {
        try {
            Class<?> c;
            long length = classbytes.length;
            if (length < Integer.MAX_VALUE && (c = this.defineClass(className, classbytes, 0, (int)length)) != null) {
                this.resolveClass(c);
                return c;
            }
        }
        catch (LinkageError e) {
            throw e;
        }
        catch (Throwable t) {
            Debug.trace(t);
        }
        return null;
    }

    public Class<?> loadClassFromByteArray(String className, byte[] bytes, int offset, int length) {
        try {
            Class<?> c = this.defineClass(className, bytes, offset, length);
            if (c != null) {
                this.resolveClass(c);
                return c;
            }
        }
        catch (VerifyError e) {
            Lisp.error(new LispError("Class verification failed: " + e.getMessage()));
        }
        catch (Throwable t) {
            Debug.trace(t);
        }
        return null;
    }

    static {
        packages = Collections.synchronizedSet(new HashSet());
    }
}

