/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.EqHashTable;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SlotDefinition;
import org.armedbear.lisp.Symbol;

public final class Layout
extends LispObject {
    public final LispClass lispClass;
    public final EqHashTable slotTable;
    private final LispObject[] slotNames;
    private final LispObject sharedSlots;
    private boolean invalid;
    private static final Primitive MAKE_LAYOUT = new Primitive("make-layout", Lisp.PACKAGE_SYS, true, "class instance-slots class-slots"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return new Layout(Lisp.checkClass(first), Lisp.checkList(second), Lisp.checkList(third));
        }
    };
    private static final Primitive LAYOUT_CLASS = new Primitive("layout-class", Lisp.PACKAGE_SYS, true, "layout"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkLayout((LispObject)arg).lispClass;
        }
    };
    private static final Primitive LAYOUT_LENGTH = new Primitive("layout-length", Lisp.PACKAGE_SYS, true, "layout"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(Lisp.checkLayout(arg).slotNames.length);
        }
    };
    private static final Primitive LAYOUT_SLOT_INDEX = new Primitive("layout-slot-index", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            LispObject[] slotNames = Lisp.checkLayout(first).slotNames;
            int i = slotNames.length;
            while (i-- > 0) {
                if (slotNames[i] != second) continue;
                return Fixnum.getInstance(i);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive LAYOUT_SLOT_LOCATION = new Primitive("layout-slot-location", Lisp.PACKAGE_SYS, true, "layout slot-name"){

        public LispObject execute(LispObject first, LispObject second) {
            Layout layOutFirst = Lisp.checkLayout(first);
            LispObject[] slotNames = layOutFirst.slotNames;
            int limit = slotNames.length;
            for (int i = 0; i < limit; ++i) {
                if (slotNames[i] != second) continue;
                return Fixnum.getInstance(i);
            }
            for (LispObject rest = layOutFirst.sharedSlots; rest != Lisp.NIL; rest = rest.cdr()) {
                LispObject location = rest.car();
                if (location.car() != second) continue;
                return location;
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive _MAKE_INSTANCES_OBSOLETE = new Primitive("%make-instances-obsolete", Lisp.PACKAGE_SYS, true, "class"){

        public LispObject execute(LispObject arg) {
            LispClass lispClass = Lisp.checkClass(arg);
            Layout oldLayout = lispClass.getClassLayout();
            Layout newLayout = new Layout(oldLayout);
            lispClass.setClassLayout(newLayout);
            oldLayout.invalidate();
            return arg;
        }
    };

    public Layout(LispClass lispClass, LispObject instanceSlots, LispObject sharedSlots) {
        this.lispClass = lispClass;
        Debug.assertTrue(instanceSlots.listp());
        int length = instanceSlots.length();
        this.slotNames = new LispObject[length];
        int i = 0;
        while (instanceSlots != Lisp.NIL) {
            this.slotNames[i++] = instanceSlots.car();
            instanceSlots = instanceSlots.cdr();
        }
        Debug.assertTrue(i == length);
        this.sharedSlots = sharedSlots;
        this.slotTable = this.initializeSlotTable(this.slotNames);
    }

    public Layout(LispClass lispClass, LispObject[] instanceSlotNames, LispObject sharedSlots) {
        this.lispClass = lispClass;
        this.slotNames = instanceSlotNames;
        this.sharedSlots = sharedSlots;
        this.slotTable = this.initializeSlotTable(this.slotNames);
    }

    private Layout(Layout oldLayout) {
        this.lispClass = oldLayout.lispClass;
        this.slotNames = oldLayout.slotNames;
        this.sharedSlots = oldLayout.sharedSlots;
        this.slotTable = this.initializeSlotTable(this.slotNames);
    }

    private EqHashTable initializeSlotTable(LispObject[] slotNames) {
        EqHashTable ht = new EqHashTable(slotNames.length, Lisp.NIL, Lisp.NIL);
        int i = slotNames.length;
        while (i-- > 0) {
            ht.put(slotNames[i], Fixnum.getInstance(i));
        }
        return ht;
    }

    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("class", (LispObject)this.lispClass));
        for (int i = 0; i < this.slotNames.length; ++i) {
            result = result.push(new Cons("slot " + i, this.slotNames[i]));
        }
        result = result.push(new Cons("shared slots", this.sharedSlots));
        return result.nreverse();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public LispObject[] getSlotNames() {
        return this.slotNames;
    }

    public int getLength() {
        return this.slotNames.length;
    }

    public LispObject getSharedSlots() {
        return this.sharedSlots;
    }

    public String writeToString() {
        return this.unreadableString(Symbol.LAYOUT);
    }

    protected LispObject generateSlotDefinitions() {
        LispObject list = Lisp.NIL;
        int i = this.slotNames.length;
        while (i-- > 0) {
            list = list.push(new SlotDefinition(this.slotNames[i], Lisp.NIL));
        }
        return list;
    }

    public int getSlotIndex(LispObject slotName) {
        LispObject index = this.slotTable.get(slotName);
        if (index != null) {
            return ((Fixnum)index).value;
        }
        return -1;
    }

    public LispObject getSharedSlotLocation(LispObject slotName) {
        for (LispObject rest = this.sharedSlots; rest != Lisp.NIL; rest = rest.cdr()) {
            LispObject location = rest.car();
            if (location.car() != slotName) continue;
            return location;
        }
        return null;
    }
}

