/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.EqHashTable;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public abstract class LispClass
extends StandardObject {
    private static final EqHashTable map = new EqHashTable(256, Lisp.NIL, Lisp.NIL);
    private final int sxhash;
    protected Symbol symbol;
    private LispObject propertyList;
    private Layout classLayout;
    private LispObject directSuperclasses = Lisp.NIL;
    private LispObject directSubclasses = Lisp.NIL;
    public LispObject classPrecedenceList = Lisp.NIL;
    public LispObject directMethods = Lisp.NIL;
    public LispObject documentation = Lisp.NIL;
    private boolean finalized;
    private static final Primitive FIND_CLASS = new Primitive(Symbol.FIND_CLASS, "symbol &optional errorp environment"){

        public LispObject execute(LispObject arg) {
            return LispClass.findClass(arg, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispClass.findClass(first, second != Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return LispClass.findClass(first, second != Lisp.NIL);
        }
    };
    private static final Primitive _SET_FIND_CLASS = new Primitive("%set-find-class", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Symbol name = Lisp.checkSymbol(first);
            if (second == Lisp.NIL) {
                LispClass.removeClass(name);
                return second;
            }
            LispClass c = Lisp.checkClass(second);
            LispClass.addClass(name, c);
            return second;
        }
    };
    private static final Primitive SUBCLASSP = new Primitive(Symbol.SUBCLASSP, "class"){

        public LispObject execute(LispObject first, LispObject second) {
            LispClass c = Lisp.checkClass(first);
            return c.subclassp(second) ? Lisp.T : Lisp.NIL;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClass(Symbol symbol, LispClass c) {
        EqHashTable eqHashTable = map;
        synchronized (eqHashTable) {
            map.put(symbol, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClass(Symbol symbol) {
        EqHashTable eqHashTable = map;
        synchronized (eqHashTable) {
            map.remove(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispClass findClass(Symbol symbol) {
        EqHashTable eqHashTable = map;
        synchronized (eqHashTable) {
            return (LispClass)map.get(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject findClass(LispObject name, boolean errorp) {
        LispClass c;
        Symbol symbol = Lisp.checkSymbol(name);
        EqHashTable eqHashTable = map;
        synchronized (eqHashTable) {
            c = (LispClass)map.get(symbol);
        }
        if (c != null) {
            return c;
        }
        if (errorp) {
            FastStringBuffer sb = new FastStringBuffer("There is no class named ");
            sb.append(name.writeToString());
            sb.append('.');
            return Lisp.error(new LispError(sb.toString()));
        }
        return Lisp.NIL;
    }

    protected LispClass() {
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
    }

    protected LispClass(Symbol symbol) {
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
        this.symbol = symbol;
        this.directSuperclasses = Lisp.NIL;
    }

    protected LispClass(Symbol symbol, LispObject directSuperclasses) {
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
        this.symbol = symbol;
        this.directSuperclasses = directSuperclasses;
    }

    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("NAME", this.symbol != null ? this.symbol : Lisp.NIL));
        result = result.push(new Cons("LAYOUT", this.classLayout != null ? this.classLayout : Lisp.NIL));
        result = result.push(new Cons("DIRECT-SUPERCLASSES", this.directSuperclasses));
        result = result.push(new Cons("DIRECT-SUBCLASSES", this.directSubclasses));
        result = result.push(new Cons("CLASS-PRECEDENCE-LIST", this.classPrecedenceList));
        result = result.push(new Cons("DIRECT-METHODS", this.directMethods));
        result = result.push(new Cons("DOCUMENTATION", this.documentation));
        return result.nreverse();
    }

    public final int sxhash() {
        return this.sxhash;
    }

    public final Symbol getSymbol() {
        return this.symbol;
    }

    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public final Layout getClassLayout() {
        return this.classLayout;
    }

    public final void setClassLayout(Layout layout) {
        this.classLayout = layout;
    }

    public final int getLayoutLength() {
        if (this.layout == null) {
            return 0;
        }
        return this.layout.getLength();
    }

    public final LispObject getDirectSuperclasses() {
        return this.directSuperclasses;
    }

    public final void setDirectSuperclasses(LispObject directSuperclasses) {
        this.directSuperclasses = directSuperclasses;
    }

    public final boolean isFinalized() {
        return this.finalized;
    }

    public final void setFinalized(boolean b) {
        this.finalized = b;
    }

    public final void setDirectSuperclass(LispObject superclass) {
        this.directSuperclasses = new Cons(superclass);
    }

    public final LispObject getDirectSubclasses() {
        return this.directSubclasses;
    }

    public final void setDirectSubclasses(LispObject directSubclasses) {
        this.directSubclasses = directSubclasses;
    }

    public final LispObject getCPL() {
        return this.classPrecedenceList;
    }

    public final void setCPL(LispObject obj1) {
        if (obj1 instanceof Cons) {
            this.classPrecedenceList = obj1;
        } else {
            Debug.assertTrue(obj1 == this);
            this.classPrecedenceList = new Cons(obj1);
        }
    }

    public final void setCPL(LispObject obj1, LispObject obj2) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4, obj5);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4, obj5, obj6);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4, obj5, obj6, obj7);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7, LispObject obj8) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8);
    }

    public final void setCPL(LispObject obj1, LispObject obj2, LispObject obj3, LispObject obj4, LispObject obj5, LispObject obj6, LispObject obj7, LispObject obj8, LispObject obj9) {
        Debug.assertTrue(obj1 == this);
        this.classPrecedenceList = Lisp.list(obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8, obj9);
    }

    public String getName() {
        return this.symbol.getName();
    }

    public LispObject typeOf() {
        return Symbol.CLASS;
    }

    public LispObject classOf() {
        return StandardClass.CLASS;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.CLASS) {
            return Lisp.T;
        }
        if (type == StandardClass.CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean subclassp(LispObject obj) {
        LispObject cpl = this.classPrecedenceList;
        while (cpl != Lisp.NIL) {
            if (cpl.car() == obj) {
                return true;
            }
            cpl = ((Cons)cpl).cdr;
        }
        return false;
    }
}

