/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlError;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.IllegalMonitorState;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispStackFrame;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Primitives;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.StackFrame;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.ThreadDestroyed;
import org.armedbear.lisp.Throw;
import org.armedbear.lisp.UnboundVariable;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class LispThread
extends LispObject {
    private static boolean use_fast_calls = false;
    private static final ConcurrentHashMap<Thread, LispThread> map = new ConcurrentHashMap();
    private static ThreadLocal<LispThread> threads = new ThreadLocal<LispThread>(){

        @Override
        public LispThread initialValue() {
            Thread thisThread = Thread.currentThread();
            LispThread thread = (LispThread)map.get(thisThread);
            if (thread == null) {
                thread = new LispThread(thisThread);
                map.put(thisThread, thread);
            }
            return thread;
        }
    };
    private final Thread javaThread;
    private boolean destroyed;
    private final LispObject name;
    public LispObject[] _values;
    private boolean threadInterrupted;
    private LispObject pending = Lisp.NIL;
    static final int UNASSIGNED_SPECIAL_INDEX = 0;
    static final AtomicInteger lastSpecial = new AtomicInteger(0);
    final SpecialBinding[] specials = new SpecialBinding[4097];
    static final Symbol[] specialNames = new Symbol[4097];
    private SpecialBindingsMark savedSpecials = null;
    private LispObject catchTags = Lisp.NIL;
    private StackFrame stack = null;
    private static final Primitive MAKE_THREAD = new Primitive("make-thread", Lisp.PACKAGE_THREADS, true, "function &optional &key name"){

        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length == 0) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject name = Lisp.NIL;
            if (length > 1) {
                if ((length - 1) % 2 != 0) {
                    Lisp.error(new ProgramError("Odd number of keyword arguments."));
                }
                if (length > 3) {
                    Lisp.error(new WrongNumberOfArgumentsException(this));
                }
                if (args[1] == Keyword.NAME) {
                    name = args[2].STRING();
                } else {
                    Lisp.error(new ProgramError("Unrecognized keyword argument " + args[1].writeToString() + "."));
                }
            }
            return new LispThread(Lisp.checkFunction(args[0]), name);
        }
    };
    private static final Primitive THREADP = new Primitive("threadp", Lisp.PACKAGE_THREADS, true, "object", "Boolean predicate as whether OBJECT is a thread."){

        public LispObject execute(LispObject arg) {
            return arg instanceof LispThread ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive THREAD_ALIVE_P = new Primitive("thread-alive-p", Lisp.PACKAGE_THREADS, true, "thread", "Boolean predicate whether THREAD is alive."){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof LispThread)) {
                return Lisp.type_error(arg, Symbol.THREAD);
            }
            LispThread lispThread = (LispThread)arg;
            return lispThread.javaThread.isAlive() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive THREAD_NAME = new Primitive("thread-name", Lisp.PACKAGE_THREADS, true, "thread", "Return the name of THREAD if it has one."){

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispThread) {
                return ((LispThread)arg).name;
            }
            return Lisp.type_error(arg, Symbol.THREAD);
        }
    };
    private static final Primitive SLEEP = new Primitive("sleep", Lisp.PACKAGE_CL, true, "seconds", "Causes the invoking thread to sleep for SECONDS seconds.\nSECONDS may be a value between 0 1and 1."){

        public LispObject execute(LispObject arg) {
            try {
                Thread.sleep(LispThread.javaSleepInterval(arg));
            }
            catch (InterruptedException e) {
                LispThread.currentThread().processThreadInterrupts();
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive MAPCAR_THREADS = new Primitive("mapcar-threads", Lisp.PACKAGE_THREADS, true, "function", "Applies FUNCTION to all existing threads."){

        public LispObject execute(LispObject arg) {
            Function fun = Lisp.checkFunction(arg);
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                LispObject[] args = new LispObject[]{(LispThread)it.next()};
                result = new Cons(Lisp.funcall(fun, args, thread), result);
            }
            return result;
        }
    };
    private static final Primitive DESTROY_THREAD = new Primitive("destroy-thread", Lisp.PACKAGE_THREADS, true, "thread", "Mark THREAD as destroyed."){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof LispThread)) {
                return Lisp.type_error(arg, Symbol.THREAD);
            }
            LispThread thread = (LispThread)arg;
            thread.setDestroyed(true);
            return Lisp.T;
        }
    };
    private static final Primitive INTERRUPT_THREAD = new Primitive("interrupt-thread", Lisp.PACKAGE_THREADS, true, "thread function &rest args", "Interrupts THREAD and forces it to apply FUNCTION to ARGS.\nWhen the function returns, the thread's original computation continues. If  multiple interrupts are queued for a thread, they are all run, but the order is not guaranteed."){

        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            if (!(args[0] instanceof LispThread)) {
                return Lisp.type_error(args[0], Symbol.THREAD);
            }
            LispThread thread = (LispThread)args[0];
            LispObject fun = args[1];
            LispObject funArgs = Lisp.NIL;
            int i = args.length;
            while (i-- > 2) {
                funArgs = new Cons(args[i], funArgs);
            }
            thread.interrupt(fun, funArgs);
            return Lisp.T;
        }
    };
    private static final Primitive CURRENT_THREAD = new Primitive("current-thread", Lisp.PACKAGE_THREADS, true, "", "Returns a reference to invoking thread."){

        public LispObject execute() {
            return LispThread.currentThread();
        }
    };
    private static final Primitive BACKTRACE = new Primitive("backtrace", Lisp.PACKAGE_SYS, true, "", "Returns a backtrace of the invoking thread."){

        public LispObject execute(LispObject[] args) {
            if (args.length > 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            int limit = args.length > 0 ? Fixnum.getValue(args[0]) : 0;
            return LispThread.currentThread().backtrace(limit);
        }
    };
    private static final Primitive FRAME_TO_STRING = new Primitive("frame-to-string", Lisp.PACKAGE_SYS, true, "frame"){

        public LispObject execute(LispObject[] args) {
            if (args.length != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return Lisp.checkStackFrame(args[0]).toLispString();
        }
    };
    private static final Primitive FRAME_TO_LIST = new Primitive("frame-to-list", Lisp.PACKAGE_SYS, true, "frame"){

        public LispObject execute(LispObject[] args) {
            if (args.length != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            return Lisp.checkStackFrame(args[0]).toLispList();
        }
    };
    private static final Primitive USE_FAST_CALLS;
    private static final SpecialOperator SYNCHRONIZED_ON;
    private static final Primitive OBJECT_WAIT;
    private static final Primitive OBJECT_NOTIFY;
    private static final Primitive OBJECT_NOTIFY_ALL;

    public static final LispThread currentThread() {
        return threads.get();
    }

    private LispThread(Thread javaThread) {
        this.javaThread = javaThread;
        this.name = new SimpleString(javaThread.getName());
    }

    private LispThread(final Function fun, LispObject name) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Lisp.funcall(fun, new LispObject[0], LispThread.this);
                }
                catch (ThreadDestroyed ignored) {
                }
                catch (Throwable t) {
                    if (LispThread.this.isInterrupted()) {
                        LispThread.this.processThreadInterrupts();
                    }
                }
                finally {
                    map.remove(Thread.currentThread());
                }
            }
        };
        this.javaThread = new Thread(r);
        this.name = name;
        map.put(this.javaThread, this);
        if (name != Lisp.NIL) {
            this.javaThread.setName(name.getStringValue());
        }
        this.javaThread.setDaemon(true);
        this.javaThread.start();
    }

    public StackTraceElement[] getJavaStackTrace() {
        return this.javaThread.getStackTrace();
    }

    public LispObject typeOf() {
        return Symbol.THREAD;
    }

    public LispObject classOf() {
        return BuiltInClass.THREAD;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.THREAD) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.THREAD) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public final synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    private final synchronized boolean isInterrupted() {
        return this.threadInterrupted;
    }

    private final synchronized void setDestroyed(boolean b) {
        this.destroyed = b;
    }

    private final synchronized void interrupt(LispObject function, LispObject args) {
        this.pending = new Cons(args, this.pending);
        this.pending = new Cons(function, this.pending);
        this.threadInterrupted = true;
        this.javaThread.interrupt();
    }

    private final synchronized void processThreadInterrupts() {
        while (this.pending != Lisp.NIL) {
            LispObject function = this.pending.car();
            LispObject args = this.pending.cadr();
            this.pending = this.pending.cddr();
            Primitives.APPLY.execute(function, args);
        }
        this.threadInterrupted = false;
    }

    public final LispObject[] getValues() {
        return this._values;
    }

    public final LispObject[] getValues(LispObject result, int count) {
        if (this._values == null) {
            LispObject[] values = new LispObject[count];
            if (count > 0) {
                values[0] = result;
            }
            for (int i = 1; i < count; ++i) {
                values[i] = Lisp.NIL;
            }
            return values;
        }
        if (count <= this._values.length) {
            return this._values;
        }
        LispObject[] values = new LispObject[count];
        int i = this._values.length;
        while (i-- > 0) {
            values[i] = this._values[i];
        }
        for (i = this._values.length; i < count; ++i) {
            values[i] = Lisp.NIL;
        }
        return values;
    }

    public final LispObject[] accumulateValues(LispObject result, LispObject[] oldValues) {
        if (oldValues == null) {
            if (this._values != null) {
                return this._values;
            }
            LispObject[] values = new LispObject[]{result};
            return values;
        }
        if (this._values != null) {
            if (this._values.length == 0) {
                return oldValues;
            }
            int totalLength = oldValues.length + this._values.length;
            LispObject[] values = new LispObject[totalLength];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            System.arraycopy(this._values, 0, values, oldValues.length, this._values.length);
            return values;
        }
        int totalLength = oldValues.length + 1;
        LispObject[] values = new LispObject[totalLength];
        System.arraycopy(oldValues, 0, values, 0, oldValues.length);
        values[totalLength - 1] = result;
        return values;
    }

    public final LispObject setValues() {
        this._values = new LispObject[0];
        return Lisp.NIL;
    }

    public final LispObject setValues(LispObject value1) {
        this._values = null;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2) {
        this._values = new LispObject[2];
        this._values[0] = value1;
        this._values[1] = value2;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2, LispObject value3) {
        this._values = new LispObject[3];
        this._values[0] = value1;
        this._values[1] = value2;
        this._values[2] = value3;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2, LispObject value3, LispObject value4) {
        this._values = new LispObject[4];
        this._values[0] = value1;
        this._values[1] = value2;
        this._values[2] = value3;
        this._values[3] = value4;
        return value1;
    }

    public final LispObject setValues(LispObject[] values) {
        switch (values.length) {
            case 0: {
                this._values = values;
                return Lisp.NIL;
            }
            case 1: {
                this._values = null;
                return values[0];
            }
        }
        this._values = values;
        return values[0];
    }

    public final void clearValues() {
        this._values = null;
    }

    public final LispObject nothing() {
        this._values = new LispObject[0];
        return Lisp.NIL;
    }

    public final LispObject value(LispObject obj) {
        this._values = null;
        return obj;
    }

    public final SpecialBindingsMark markSpecialBindings() {
        return this.savedSpecials;
    }

    public final void resetSpecialBindings(SpecialBindingsMark mark) {
        SpecialBindingsMark c = this.savedSpecials;
        while (mark != c) {
            this.specials[c.idx] = c.binding;
            c = c.next;
        }
        this.savedSpecials = c;
    }

    final void clearSpecialBindings() {
        this.resetSpecialBindings(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void assignSpecialIndex(Symbol sym) {
        if (sym.specialIndex != 0) {
            return;
        }
        Symbol symbol = sym;
        synchronized (symbol) {
            if (sym.specialIndex == 0) {
                sym.specialIndex = lastSpecial.incrementAndGet();
                LispThread.specialNames[sym.specialIndex] = sym;
            }
        }
    }

    public final SpecialBinding bindSpecial(Symbol name, LispObject value) {
        LispThread.assignSpecialIndex(name);
        int idx = name.specialIndex;
        SpecialBinding binding = this.specials[idx];
        this.savedSpecials = new SpecialBindingsMark(idx, binding, this.savedSpecials);
        this.specials[idx] = new SpecialBinding(idx, value);
        return this.specials[idx];
    }

    public final SpecialBinding bindSpecialToCurrentValue(Symbol name) {
        LispThread.assignSpecialIndex(name);
        int idx = name.specialIndex;
        SpecialBinding binding = this.specials[idx];
        this.savedSpecials = new SpecialBindingsMark(idx, binding, this.savedSpecials);
        this.specials[idx] = new SpecialBinding(idx, binding == null ? name.getSymbolValue() : binding.value);
        return this.specials[idx];
    }

    public final LispObject lookupSpecial(Symbol name) {
        SpecialBinding binding = this.specials[name.specialIndex];
        return binding == null ? null : binding.value;
    }

    public final SpecialBinding getSpecialBinding(Symbol name) {
        return this.specials[name.specialIndex];
    }

    public final LispObject setSpecialVariable(Symbol name, LispObject value) {
        SpecialBinding binding = this.specials[name.specialIndex];
        if (binding != null) {
            binding.value = value;
            return binding.value;
        }
        name.setSymbolValue(value);
        return value;
    }

    public final LispObject pushSpecial(Symbol name, LispObject thing) {
        SpecialBinding binding = this.specials[name.specialIndex];
        if (binding != null) {
            binding.value = new Cons(thing, binding.value);
            return binding.value;
        }
        LispObject value = name.getSymbolValue();
        if (value != null) {
            Cons newValue = new Cons(thing, value);
            name.setSymbolValue(newValue);
            return newValue;
        }
        return Lisp.error(new UnboundVariable(name));
    }

    public final LispObject safeSymbolValue(Symbol name) {
        SpecialBinding binding = this.specials[name.specialIndex];
        if (binding != null) {
            return binding.value;
        }
        LispObject value = name.getSymbolValue();
        return value != null ? value : Lisp.NIL;
    }

    public final void rebindSpecial(Symbol name, LispObject value) {
        SpecialBinding binding = this.getSpecialBinding(name);
        binding.value = value;
    }

    public void pushCatchTag(LispObject tag) {
        this.catchTags = new Cons(tag, this.catchTags);
    }

    public void popCatchTag() {
        if (this.catchTags != Lisp.NIL) {
            this.catchTags = this.catchTags.cdr();
        } else {
            Debug.assertTrue(false);
        }
    }

    public void throwToTag(LispObject tag, LispObject result) {
        for (LispObject rest = this.catchTags; rest != Lisp.NIL; rest = rest.cdr()) {
            if (rest.car() != tag) continue;
            throw new Throw(tag, result, this);
        }
        Lisp.error(new ControlError("Attempt to throw to the nonexistent tag " + tag.writeToString() + "."));
    }

    @Deprecated
    public LispObject getStack() {
        return Lisp.NIL;
    }

    @Deprecated
    public void setStack(LispObject stack) {
    }

    public final void pushStackFrame(StackFrame frame) {
        frame.setNext(this.stack);
        this.stack = frame;
    }

    public final void popStackFrame() {
        if (this.stack != null) {
            this.stack = this.stack.getNext();
        }
    }

    public void resetStack() {
        this.stack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function) {
        if (use_fast_calls) {
            return function.execute();
        }
        this.pushStackFrame(new LispStackFrame(function));
        try {
            LispObject lispObject = function.execute();
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject arg) {
        if (use_fast_calls) {
            return function.execute(arg);
        }
        this.pushStackFrame(new LispStackFrame(function, arg));
        try {
            LispObject lispObject = function.execute(arg);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second) {
        if (use_fast_calls) {
            return function.execute(first, second);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second));
        try {
            LispObject lispObject = function.execute(first, second);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third) {
        if (use_fast_calls) {
            return function.execute(first, second, third);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third));
        try {
            LispObject lispObject = function.execute(first, second, third);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth) {
        if (use_fast_calls) {
            return function.execute(first, second, third, fourth);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third, fourth));
        try {
            LispObject lispObject = function.execute(first, second, third, fourth);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        if (use_fast_calls) {
            return function.execute(first, second, third, fourth, fifth);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third, fourth, fifth));
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        if (use_fast_calls) {
            return function.execute(first, second, third, fourth, fifth, sixth);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third, fourth, fifth, sixth));
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        if (use_fast_calls) {
            return function.execute(first, second, third, fourth, fifth, sixth, seventh);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third, fourth, fifth, sixth, seventh));
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth, seventh);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        if (use_fast_calls) {
            return function.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
        }
        this.pushStackFrame(new LispStackFrame(function, first, second, third, fourth, fifth, sixth, seventh, eighth));
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject[] args) {
        if (use_fast_calls) {
            return function.execute(args);
        }
        this.pushStackFrame(new LispStackFrame(function, args));
        try {
            LispObject lispObject = function.execute(args);
            return lispObject;
        }
        finally {
            this.popStackFrame();
        }
    }

    public void printBacktrace() {
        this.printBacktrace(0);
    }

    public void printBacktrace(int limit) {
        if (this.stack != null) {
            int count = 0;
            Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
            out._writeLine("Evaluation stack:");
            out._finishOutput();
            StackFrame s = this.stack;
            while (s != null) {
                out._writeString("  ");
                out._writeString(String.valueOf(count));
                out._writeString(": ");
                LispThread.pprint(s.toLispList(), out.getCharPos(), out);
                out.terpri();
                out._finishOutput();
                if (limit > 0 && ++count == limit) break;
                s = s.next;
            }
        }
    }

    public LispObject backtrace(int limit) {
        LispObject result = Lisp.NIL;
        if (this.stack != null) {
            int count = 0;
            for (StackFrame s = this.stack; s != null; s = s.getNext()) {
                result = result.push(s);
                if (limit > 0 && ++count == limit) break;
            }
        }
        return result.nreverse();
    }

    public void incrementCallCounts() {
        StackFrame s = this.stack;
        for (int i = 0; i < 8 && s != null; ++i) {
            if (!(s instanceof LispStackFrame)) continue;
            LispObject operator = ((LispStackFrame)s).getOperator();
            if (operator != null) {
                operator.incrementHotCount();
                operator.incrementCallCount();
            }
            s = s.getNext();
        }
        while (s != null) {
            LispObject operator;
            if (s instanceof LispStackFrame && (operator = ((LispStackFrame)s).getOperator()) != null) {
                operator.incrementCallCount();
            }
            s = s.getNext();
        }
    }

    private static void pprint(LispObject obj, int indentBy, Stream stream) {
        if (stream.getCharPos() == 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < indentBy; ++i) {
                sb.append(' ');
            }
            stream._writeString(sb.toString());
        }
        String raw = obj.writeToString();
        if (stream.getCharPos() + raw.length() < 80) {
            stream._writeString(raw);
            return;
        }
        if (obj instanceof Cons) {
            LispObject first;
            boolean newlineBefore = false;
            LispObject[] array = obj.copyToArray();
            if (array.length > 0 && (first = array[0]) == Symbol.LET) {
                newlineBefore = true;
            }
            int charPos = stream.getCharPos();
            if (newlineBefore && charPos != indentBy) {
                stream.terpri();
                charPos = stream.getCharPos();
            }
            if (charPos < indentBy) {
                StringBuffer sb = new StringBuffer();
                for (int i = charPos; i < indentBy; ++i) {
                    sb.append(' ');
                }
                stream._writeString(sb.toString());
            }
            stream.print('(');
            for (int i = 0; i < array.length; ++i) {
                LispThread.pprint(array[i], indentBy + 2, stream);
                if (i >= array.length - 1) continue;
                stream.print(' ');
            }
        } else {
            stream.terpri();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < indentBy; ++i) {
                sb.append(' ');
            }
            stream._writeString(sb.toString());
            stream._writeString(raw);
            return;
        }
        stream.print(')');
    }

    public String writeToString() {
        StringBuffer sb = new StringBuffer("THREAD");
        if (this.name != Lisp.NIL) {
            sb.append(" \"");
            sb.append(this.name.getStringValue());
            sb.append("\"");
        }
        return this.unreadableString(sb.toString());
    }

    public static final long javaSleepInterval(LispObject lispSleep) {
        double d = Lisp.checkDoubleFloat(lispSleep.multiplyBy(new DoubleFloat(1000.0))).getValue();
        if (d < 0.0) {
            Lisp.type_error(lispSleep, Lisp.list(Symbol.REAL, Fixnum.ZERO));
        }
        return d < 9.223372036854776E18 ? (long)d : Long.MAX_VALUE;
    }

    static {
        Lisp.PACKAGE_EXT.export(Lisp.intern("MAKE-THREAD", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("THREADP", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("THREAD-ALIVE-P", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("THREAD-NAME", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("MAPCAR-THREADS", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("DESTROY-THREAD", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("INTERRUPT-THREAD", Lisp.PACKAGE_THREADS));
        Lisp.PACKAGE_EXT.export(Lisp.intern("CURRENT-THREAD", Lisp.PACKAGE_THREADS));
        USE_FAST_CALLS = new Primitive("use-fast-calls", Lisp.PACKAGE_SYS, true){

            public LispObject execute(LispObject arg) {
                use_fast_calls = arg != Lisp.NIL;
                return use_fast_calls ? Lisp.T : Lisp.NIL;
            }
        };
        SYNCHRONIZED_ON = new SpecialOperator("synchronized-on", Lisp.PACKAGE_THREADS, true, "form &body body"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LispObject execute(LispObject args, Environment env) {
                if (args == Lisp.NIL) {
                    return Lisp.error(new WrongNumberOfArgumentsException(this));
                }
                LispThread thread = LispThread.currentThread();
                Object object = Lisp.eval(args.car(), env, thread).lockableInstance();
                synchronized (object) {
                    return Lisp.progn(args.cdr(), env, thread);
                }
            }
        };
        OBJECT_WAIT = new Primitive("object-wait", Lisp.PACKAGE_THREADS, true, "object &optional timeout"){

            public LispObject execute(LispObject object) {
                try {
                    object.lockableInstance().wait();
                }
                catch (InterruptedException e) {
                    LispThread.currentThread().processThreadInterrupts();
                }
                catch (IllegalMonitorStateException e) {
                    return Lisp.error(new IllegalMonitorState());
                }
                return Lisp.NIL;
            }

            public LispObject execute(LispObject object, LispObject timeout) {
                try {
                    object.lockableInstance().wait(LispThread.javaSleepInterval(timeout));
                }
                catch (InterruptedException e) {
                    LispThread.currentThread().processThreadInterrupts();
                }
                catch (IllegalMonitorStateException e) {
                    return Lisp.error(new IllegalMonitorState());
                }
                return Lisp.NIL;
            }
        };
        OBJECT_NOTIFY = new Primitive("object-notify", Lisp.PACKAGE_THREADS, true, "object"){

            public LispObject execute(LispObject object) {
                try {
                    object.lockableInstance().notify();
                }
                catch (IllegalMonitorStateException e) {
                    return Lisp.error(new IllegalMonitorState());
                }
                return Lisp.NIL;
            }
        };
        OBJECT_NOTIFY_ALL = new Primitive("object-notify-all", Lisp.PACKAGE_THREADS, true, "object"){

            public LispObject execute(LispObject object) {
                try {
                    object.lockableInstance().notifyAll();
                }
                catch (IllegalMonitorStateException e) {
                    return Lisp.error(new IllegalMonitorState());
                }
                return Lisp.NIL;
            }
        };
    }
}

