/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.armedbear.lisp.AutoloadedFunctionProxy;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Site;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.ZipCache;

public final class Load {
    private static final Symbol _FASL_VERSION_ = Lisp.exportConstant("*FASL-VERSION*", Lisp.PACKAGE_SYS, Fixnum.getInstance(35));
    private static final Symbol _FASL_EXTERNAL_FORMAT_ = Lisp.internConstant("*FASL-EXTERNAL-FORMAT*", Lisp.PACKAGE_SYS, new SimpleString("UTF-8"));
    public static final Symbol _FASL_ANONYMOUS_PACKAGE_ = Lisp.internSpecial("*FASL-ANONYMOUS-PACKAGE*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Primitive INIT_FASL = new Primitive("init-fasl", Lisp.PACKAGE_SYS, true, "&key version"){

        public LispObject execute(LispObject first, LispObject second) {
            if (first == Keyword.VERSION && second.eql(_FASL_VERSION_.getSymbolValue())) {
                LispThread thread = LispThread.currentThread();
                thread.bindSpecial(_FASL_ANONYMOUS_PACKAGE_, Lisp.NIL);
                thread.bindSpecial(Lisp._SOURCE_, Lisp.NIL);
                return Load.faslLoadStream(thread);
            }
            throw new FaslVersionMismatch(second);
        }
    };
    private static final Primitive _LOAD = new Primitive("%load", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist"){

        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.NIL);
        }
    };
    private static final Primitive _LOAD_RETURNING_LAST_RESULT = new Primitive("%load-returning-last-result", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist"){

        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.T);
        }
    };
    private static final Primitive LOAD_SYSTEM_FILE = new Primitive("load-system-file", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            LispThread thread = LispThread.currentThread();
            return Load.loadSystemFile(arg.getStringValue(), Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, false);
        }
    };

    public static final LispObject load(String filename) {
        LispThread thread = LispThread.currentThread();
        return Load.load(new Pathname(filename), filename, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, true);
    }

    private static final File findLoadableFile(String filename, String dir) {
        File file = new File(dir, filename);
        if (!file.isFile()) {
            String extension = Load.getExtension(filename);
            if (extension == null) {
                File lispFile = new File(dir, filename.concat(".lisp"));
                File abclFile = new File(dir, filename.concat(".abcl"));
                if (lispFile.isFile() && abclFile.isFile()) {
                    if (abclFile.lastModified() > lispFile.lastModified()) {
                        return abclFile;
                    }
                    return lispFile;
                }
                if (abclFile.isFile()) {
                    return abclFile;
                }
                if (lispFile.isFile()) {
                    return lispFile;
                }
            }
        } else {
            return file;
        }
        return null;
    }

    public static final LispObject load(Pathname pathname, String filename, boolean verbose, boolean print, boolean ifDoesNotExist) {
        return Load.load(pathname, filename, verbose, print, ifDoesNotExist, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject load(Pathname pathname, String filename, boolean verbose, boolean print, boolean ifDoesNotExist, boolean returnLastResult) {
        File file;
        String dir = null;
        if (!Utilities.isFilenameAbsolute(filename)) {
            dir = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()).getNamestring();
        }
        String zipFileName = null;
        String zipEntryName = null;
        if (filename.startsWith("jar:file:")) {
            String s = new String(filename);
            int index = (s = s.substring(9)).lastIndexOf(33);
            if (index >= 0) {
                zipFileName = s.substring(0, index);
                zipEntryName = s.substring(index + 1);
                if (zipEntryName.length() > 0 && zipEntryName.charAt(0) == '/') {
                    zipEntryName = zipEntryName.substring(1);
                }
                if (Utilities.isPlatformWindows && zipFileName.length() > 0 && zipFileName.charAt(0) == '/') {
                    zipFileName = zipFileName.substring(1);
                }
            }
        }
        if (null == (file = Load.findLoadableFile(filename, dir)) && null == zipFileName) {
            if (ifDoesNotExist) {
                return Lisp.error(new FileError("File not found: " + filename, pathname));
            }
            return Lisp.NIL;
        }
        if (Load.checkZipFile(file)) {
            if (".abcl".equals(Load.getExtension(file.getPath()))) {
                filename = file.getPath();
            }
            zipFileName = file.getPath();
            zipEntryName = file.getName();
        }
        String truename = filename;
        ZipFile zipfile = null;
        boolean packedFASL = false;
        InputStream in = null;
        if (zipFileName != null) {
            int i;
            int index;
            try {
                zipfile = ZipCache.getZip(zipFileName);
            }
            catch (IOException e) {
                return Lisp.error(new FileError("Zip file not found: " + filename, pathname));
            }
            ZipEntry entry = zipfile.getEntry(zipEntryName);
            if (null == entry) {
                index = zipEntryName.lastIndexOf(46);
                if (-1 == index) {
                    index = zipEntryName.length();
                }
                zipEntryName = zipEntryName.substring(0, index).concat("._");
                entry = zipfile.getEntry(zipEntryName);
            }
            if (null == entry) {
                index = zipEntryName.lastIndexOf(46);
                if (index == -1) {
                    index = zipEntryName.length();
                }
                if ((entry = zipfile.getEntry(zipEntryName = zipEntryName.substring(0, index).concat(".abcl"))) != null) {
                    packedFASL = true;
                }
            }
            if (null == entry) {
                i = zipEntryName.lastIndexOf(46);
                if (i == -1) {
                    i = zipEntryName.length();
                }
                if ((entry = zipfile.getEntry(zipEntryName = zipEntryName.substring(0, i).concat(".lisp"))) == null) {
                    return Lisp.error(new LispError("Failed to find " + zipEntryName + " in " + zipFileName + "."));
                }
            }
            if (null == entry) {
                return Lisp.error(new FileError("Can't find zip file entry " + zipEntryName, pathname));
            }
            if (".abcl".equals(Load.getExtension(zipEntryName))) {
                packedFASL = true;
            }
            if (packedFASL) {
                i = zipEntryName.lastIndexOf(46);
                int j = zipEntryName.lastIndexOf(47);
                if (j >= i) {
                    return Lisp.error(new LispError("Invalid zip entry name: " + zipEntryName));
                }
                String subZipEntryName = zipEntryName.substring(j + 1, i).concat("._");
                in = Utilities.getZippedZipEntryAsInputStream(zipfile, zipEntryName, subZipEntryName);
            } else {
                try {
                    in = zipfile.getInputStream(entry);
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        } else {
            try {
                in = new FileInputStream(file);
                truename = file.getCanonicalPath();
            }
            catch (FileNotFoundException e) {
                if (ifDoesNotExist) {
                    return Lisp.error(new FileError("File not found: " + filename, pathname));
                }
                return Lisp.NIL;
            }
            catch (IOException e) {
                return Lisp.error(new LispError(e.getMessage()));
            }
        }
        try {
            LispObject e = Load.loadFileFromStream(null, truename, new Stream(in, (LispObject)Symbol.CHARACTER), verbose, print, false, returnLastResult);
            return e;
        }
        catch (FaslVersionMismatch e) {
            FastStringBuffer sb = new FastStringBuffer("Incorrect fasl version: ");
            sb.append(truename);
            LispObject lispObject = Lisp.error(new SimpleError(sb.toString()));
            return lispObject;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
            if (zipfile != null) {
                try {
                    ZipCache.removeZip(zipfile.getName());
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        }
    }

    public static final LispObject loadSystemFile(String filename) {
        LispThread thread = LispThread.currentThread();
        return Load.loadSystemFile(filename, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject loadSystemFile(String filename, boolean auto) {
        LispThread thread = LispThread.currentThread();
        if (auto) {
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Symbol.CURRENT_READTABLE, Lisp.STANDARD_READTABLE.symbolValue(thread));
            thread.bindSpecial(Symbol._PACKAGE_, Lisp.PACKAGE_CL_USER);
            try {
                LispObject lispObject = Load.loadSystemFile(filename, Lisp._AUTOLOAD_VERBOSE_.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
        return Load.loadSystemFile(filename, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final LispObject loadSystemFile(String filename, boolean verbose, boolean print, boolean auto) {
        String s;
        int ARRAY_SIZE = 2;
        String[] candidates = new String[2];
        String extension = Load.getExtension(filename);
        if (extension == null) {
            candidates[0] = filename + '.' + "abcl";
            candidates[1] = filename.concat(".lisp");
        } else if (extension.equals(".abcl")) {
            candidates[0] = filename;
            candidates[1] = filename.substring(0, filename.length() - 5).concat(".lisp");
        } else {
            candidates[0] = filename;
        }
        InputStream in = null;
        Pathname pathname = null;
        String truename = null;
        for (int i = 0; i < 2 && (s = candidates[i]) != null; ++i) {
            ZipFile zipfile = null;
            String dir = Site.getLispHome();
            try {
                Object entry;
                if (dir != null) {
                    File file = new File(dir, s);
                    if (file.isFile()) {
                        String ext = Load.getExtension(s);
                        if (ext.equalsIgnoreCase(".abcl")) {
                            try {
                                zipfile = ZipCache.getZip(file.getPath());
                                String name = file.getName();
                                int index = name.lastIndexOf(46);
                                Debug.assertTrue(index >= 0);
                                name = name.substring(0, index).concat("._");
                                entry = zipfile.getEntry(name);
                                if (entry != null) {
                                    in = zipfile.getInputStream((ZipEntry)entry);
                                    truename = file.getCanonicalPath();
                                }
                            }
                            catch (ZipException e) {
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (in == null) {
                            try {
                                in = new FileInputStream(file);
                                truename = file.getCanonicalPath();
                            }
                            catch (IOException e) {
                                in = null;
                            }
                        }
                    }
                } else {
                    URL url = Lisp.class.getResource(s);
                    if (url != null) {
                        try {
                            in = url.openStream();
                            if ("jar".equals(url.getProtocol()) && url.getPath().startsWith("file:")) {
                                pathname = new Pathname(url);
                            }
                            truename = Load.getPath(url);
                        }
                        catch (IOException e) {
                            in = null;
                        }
                    }
                }
                if (in == null) continue;
                LispThread thread = LispThread.currentThread();
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Lisp._WARN_ON_REDEFINITION_, Lisp.NIL);
                LispObject e = Load.loadFileFromStream(pathname, truename, new Stream(in, (LispObject)Symbol.CHARACTER), verbose, print, auto);
                thread.resetSpecialBindings(mark);
                try {
                    in.close();
                }
                catch (IOException e2) {
                    entry = Lisp.error(new LispError(e2.getMessage()));
                    if (zipfile != null) {
                        try {
                            ZipCache.removeZip(zipfile.getName());
                        }
                        catch (IOException e3) {
                            return Lisp.error(new LispError(e3.getMessage()));
                        }
                    }
                    return entry;
                }
                return e;
                catch (FaslVersionMismatch e2) {
                    try {
                        FastStringBuffer sb = new FastStringBuffer("; Incorrect fasl version: ");
                        sb.append(truename);
                        System.err.println(sb.toString());
                        thread.resetSpecialBindings(mark);
                    }
                    catch (Throwable throwable) {
                        thread.resetSpecialBindings(mark);
                        try {
                            in.close();
                        }
                        catch (IOException e4) {
                            LispObject lispObject = Lisp.error(new LispError(e4.getMessage()));
                            if (zipfile != null) {
                                try {
                                    ZipCache.removeZip(zipfile.getName());
                                }
                                catch (IOException e5) {
                                    return Lisp.error(new LispError(e5.getMessage()));
                                }
                            }
                            return lispObject;
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                        continue;
                    }
                    catch (IOException e6) {
                        LispObject lispObject = Lisp.error(new LispError(e6.getMessage()));
                        if (zipfile != null) {
                            try {
                                ZipCache.removeZip(zipfile.getName());
                            }
                            catch (IOException e7) {
                                return Lisp.error(new LispError(e7.getMessage()));
                            }
                        }
                        return lispObject;
                    }
                }
            }
            finally {
                if (zipfile != null) {
                    try {
                        ZipCache.removeZip(zipfile.getName());
                    }
                    catch (IOException e) {
                        return Lisp.error(new LispError(e.getMessage()));
                    }
                }
            }
        }
        return Lisp.error(new LispError("File not found: " + filename));
    }

    private static final LispObject loadFileFromStream(LispObject pathname, String truename, Stream in, boolean verbose, boolean print, boolean auto) {
        return Load.loadFileFromStream(pathname, truename, in, verbose, print, auto, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadFileFromStream(LispObject pathname, String truename, Stream in, boolean verbose, boolean print, boolean auto, boolean returnLastResult) {
        long start = System.currentTimeMillis();
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecialToCurrentValue(Symbol.CURRENT_READTABLE);
        thread.bindSpecialToCurrentValue(Symbol._PACKAGE_);
        int loadDepth = Fixnum.getValue(Lisp._LOAD_DEPTH_.symbolValue(thread));
        thread.bindSpecial(Lisp._LOAD_DEPTH_, Fixnum.getInstance(++loadDepth));
        thread.bindSpecialToCurrentValue(Lisp._SPEED_);
        thread.bindSpecialToCurrentValue(Lisp._SPACE_);
        thread.bindSpecialToCurrentValue(Lisp._SAFETY_);
        thread.bindSpecialToCurrentValue(Lisp._DEBUG_);
        thread.bindSpecialToCurrentValue(Lisp._EXPLAIN_);
        String prefix = Load.getLoadVerbosePrefix(loadDepth);
        try {
            if (pathname == null && truename != null) {
                pathname = Pathname.parseNamestring(truename);
            }
            thread.bindSpecial(Symbol.LOAD_PATHNAME, pathname != null ? pathname : Lisp.NIL);
            thread.bindSpecial(Symbol.LOAD_TRUENAME, pathname != null ? pathname : Lisp.NIL);
            thread.bindSpecial(Lisp._SOURCE_, pathname != null ? pathname : Lisp.NIL);
            if (verbose) {
                Stream out = Lisp.getStandardOutput();
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloading " : " Loading ");
                out._writeString(truename != null ? truename : "stream");
                out._writeLine(" ...");
                out._finishOutput();
                LispObject result = Load.loadStream(in, print, thread, returnLastResult);
                long elapsed = System.currentTimeMillis() - start;
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloaded " : " Loaded ");
                out._writeString(truename != null ? truename : "stream");
                out._writeString(" (");
                out._writeString(String.valueOf((float)elapsed / 1000.0f));
                out._writeLine(" seconds)");
                out._finishOutput();
                LispObject lispObject = result;
                return lispObject;
            }
            LispObject lispObject = Load.loadStream(in, print, thread, returnLastResult);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public static String getLoadVerbosePrefix(int loadDepth) {
        FastStringBuffer sb = new FastStringBuffer(";");
        int i = loadDepth - 1;
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static final LispObject loadStream(Stream in, boolean print, LispThread thread) {
        return Load.loadStream(in, print, thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadStream(Stream in, boolean print, LispThread thread, boolean returnLastResult) {
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Lisp._LOAD_STREAM_, in);
        SpecialBinding sourcePositionBinding = thread.bindSpecial(Lisp._SOURCE_POSITION_, Fixnum.ZERO);
        try {
            LispObject lispObject;
            Environment env = new Environment();
            LispObject result = Lisp.NIL;
            while (true) {
                sourcePositionBinding.value = Fixnum.getInstance(in.getOffset());
                LispObject obj = in.read(false, Lisp.EOF, false, thread);
                if (obj == Lisp.EOF) break;
                result = Lisp.eval(obj, env, thread);
                if (!print) continue;
                Stream out = Lisp.checkCharacterOutputStream(Symbol.STANDARD_OUTPUT.symbolValue(thread));
                out._writeLine(result.writeToString());
                out._finishOutput();
            }
            if (returnLastResult) {
                lispObject = result;
                return lispObject;
            }
            lispObject = Lisp.T;
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject faslLoadStream(LispThread thread) {
        Stream in = (Stream)Lisp._LOAD_STREAM_.symbolValue(thread);
        Environment env = new Environment();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject result = Lisp.NIL;
        try {
            LispObject obj;
            thread.bindSpecial(_FASL_ANONYMOUS_PACKAGE_, new Package());
            thread.bindSpecial(Lisp.AUTOLOADING_CACHE, AutoloadedFunctionProxy.makePreloadingContext());
            in.setExternalFormat(_FASL_EXTERNAL_FORMAT_.symbolValue(thread));
            while ((obj = in.faslRead(false, Lisp.EOF, true, thread)) != Lisp.EOF) {
                result = Lisp.eval(obj, env, thread);
            }
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        return result;
    }

    private static final String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        if (index < filename.lastIndexOf(File.separatorChar)) {
            return null;
        }
        return filename.substring(index);
    }

    private static final String getPath(URL url) {
        if (url != null) {
            String path;
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                path = null;
            }
            if (path != null) {
                if (Utilities.isPlatformWindows && path.length() > 0 && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                return path;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean checkZipFile(File file) {
        boolean bl;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] bytes = new byte[4];
            int bytesRead = ((InputStream)in).read(bytes);
            bl = bytesRead == 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
            if (in == null) return bl;
        }
        catch (Throwable t) {
            try {
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            ((InputStream)in).close();
            return bl;
        }
        catch (IOException e) {
            // empty catch block
        }
        return bl;
    }

    private static final LispObject load(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist, LispObject returnLastResult) {
        if (filespec instanceof Stream && ((Stream)filespec).isOpen()) {
            LispObject pathname = filespec instanceof FileStream ? ((FileStream)filespec).getPathname() : Lisp.NIL;
            String truename = pathname instanceof Pathname ? ((Pathname)pathname).getNamestring() : null;
            return Load.loadFileFromStream(pathname, truename, (Stream)filespec, verbose != Lisp.NIL, print != Lisp.NIL, false, returnLastResult != Lisp.NIL);
        }
        Pathname pathname = Lisp.coerceToPathname(filespec);
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        return Load.load(pathname, pathname.getNamestring(), verbose != Lisp.NIL, print != Lisp.NIL, ifDoesNotExist != Lisp.NIL, returnLastResult != Lisp.NIL);
    }

    private static class FaslVersionMismatch
    extends Error {
        private final LispObject version;

        public FaslVersionMismatch(LispObject version) {
            this.version = version;
        }

        public LispObject getVersion() {
            return this.version;
        }
    }
}

