/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class Nil
extends Symbol {
    static final Nil NIL = new Nil(Lisp.PACKAGE_CL);

    public Nil(Package pkg) {
        super("NIL", pkg);
        pkg.addSymbol(this);
        this.initializeConstant(this);
    }

    public LispObject typeOf() {
        return Symbol.NULL;
    }

    public LispObject classOf() {
        return BuiltInClass.NULL;
    }

    public LispObject getDescription() {
        return new SimpleString("The symbol NIL");
    }

    public boolean getBooleanValue() {
        return false;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.NULL) {
            return T;
        }
        if (typeSpecifier == Symbol.LIST) {
            return T;
        }
        if (typeSpecifier == Symbol.SEQUENCE) {
            return T;
        }
        if (typeSpecifier == Symbol.SYMBOL) {
            return T;
        }
        if (typeSpecifier == Symbol.BOOLEAN) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.NULL) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.LIST) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.SEQUENCE) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.SYMBOL) {
            return T;
        }
        return super.typep(typeSpecifier);
    }

    public boolean constantp() {
        return true;
    }

    public final LispObject getSymbolValue() {
        return this;
    }

    public final LispObject cadr() {
        return this;
    }

    public final LispObject cddr() {
        return this;
    }

    public final LispObject caddr() {
        return this;
    }

    public LispObject nthcdr(int n) {
        if (n < 0) {
            return Lisp.type_error(Fixnum.getInstance(n), Lisp.list(Symbol.INTEGER, Fixnum.ZERO));
        }
        return this;
    }

    public int length() {
        return 0;
    }

    public LispObject NTH(int index) {
        if (index < 0) {
            Lisp.error(new TypeError(String.valueOf(index) + " is not of type UNSIGNED-BYTE."));
        }
        return NIL;
    }

    public LispObject NTH(LispObject arg) {
        if (!(arg instanceof Fixnum)) {
            if (arg instanceof Bignum) {
                if (arg.minusp()) {
                    return Lisp.error(new TypeError(arg, Symbol.UNSIGNED_BYTE));
                }
                return NIL;
            }
            return Lisp.error(new TypeError(arg, Symbol.UNSIGNED_BYTE));
        }
        int index = ((Fixnum)arg).value;
        if (index < 0) {
            Lisp.error(new TypeError(arg, Symbol.UNSIGNED_BYTE));
        }
        return NIL;
    }

    public LispObject elt(int index) {
        return Lisp.error(new TypeError("ELT: invalid index " + index + " for " + this + "."));
    }

    public LispObject reverse() {
        return this;
    }

    public LispObject nreverse() {
        return this;
    }

    public LispObject[] copyToArray() {
        return new LispObject[0];
    }

    public boolean listp() {
        return true;
    }

    public boolean endp() {
        return true;
    }

    public LispObject NOT() {
        return T;
    }

    public final LispObject getSymbolFunction() {
        return null;
    }

    public String toString() {
        if (Symbol.PRINT_READABLY.symbolValueNoThrow() != NIL) {
            return "|COMMON-LISP|::|NIL|";
        }
        return "NIL";
    }
}

