/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.SymbolHashTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Package
extends LispObject {
    private String name;
    private SimpleString lispName;
    private LispObject propertyList;
    private final SymbolHashTable internalSymbols = new SymbolHashTable(16);
    private final SymbolHashTable externalSymbols = new SymbolHashTable(16);
    private HashMap<String, Symbol> shadowingSymbols;
    private ArrayList<String> nicknames;
    private LispObject useList = null;
    private ArrayList<Package> usedByList = null;

    public Package() {
    }

    public Package(String name) {
        this.name = name;
        this.lispName = new SimpleString(name);
    }

    public Package(String name, int size) {
        this.name = name;
        this.lispName = new SimpleString(name);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.PACKAGE;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.PACKAGE;
    }

    @Override
    public LispObject getDescription() {
        if (this.name != null) {
            FastStringBuffer sb = new FastStringBuffer("The ");
            sb.append(this.name);
            sb.append(" package");
            return new SimpleString(sb);
        }
        return new SimpleString("PACKAGE");
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.PACKAGE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.PACKAGE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final String getName() {
        return this.name;
    }

    public final LispObject NAME() {
        return this.lispName != null ? this.lispName : Lisp.NIL;
    }

    @Override
    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    @Override
    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public final List getNicknames() {
        return this.nicknames;
    }

    public final synchronized boolean delete() {
        if (this.name != null) {
            Packages.deletePackage(this);
            List<Symbol> internals = this.internalSymbols.getSymbols();
            int i = internals.size();
            while (i-- > 0) {
                Symbol symbol = internals.get(i);
                if (symbol.getPackage() == this) {
                    symbol.setPackage(Lisp.NIL);
                }
                this.internalSymbols.remove(symbol);
            }
            List<Symbol> externals = this.externalSymbols.getSymbols();
            int i2 = externals.size();
            while (i2-- > 0) {
                Symbol symbol = externals.get(i2);
                if (symbol.getPackage() == this) {
                    symbol.setPackage(Lisp.NIL);
                }
                this.externalSymbols.remove(symbol);
            }
            this.name = null;
            this.lispName = null;
            this.nicknames = null;
            return true;
        }
        return false;
    }

    public final synchronized void rename(String newName, LispObject newNicks) {
        ArrayList<String> arrayList = null;
        while (newNicks != Lisp.NIL) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(Lisp.javaString(newNicks.car()));
            newNicks = newNicks.cdr();
        }
        Packages.deletePackage(this);
        this.name = newName;
        this.lispName = new SimpleString(newName);
        this.nicknames = arrayList;
        Packages.addPackage(this);
    }

    public synchronized Symbol findInternalSymbol(SimpleString name) {
        return this.internalSymbols.get(name);
    }

    public synchronized Symbol findExternalSymbol(SimpleString name) {
        return this.externalSymbols.get(name);
    }

    public synchronized Symbol findExternalSymbol(SimpleString name, int hash) {
        return this.externalSymbols.get(name, hash);
    }

    public synchronized Symbol findAccessibleSymbol(String name) {
        return this.findAccessibleSymbol(new SimpleString(name));
    }

    public synchronized Symbol findAccessibleSymbol(SimpleString name) {
        Symbol symbol = this.externalSymbols.get(name);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(name);
        if (symbol != null) {
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(name);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    public synchronized LispObject findSymbol(String name) {
        SimpleString s = new SimpleString(name);
        LispThread thread = LispThread.currentThread();
        Symbol symbol = this.externalSymbols.get(s);
        if (symbol != null) {
            return thread.setValues(symbol, Keyword.EXTERNAL);
        }
        symbol = this.internalSymbols.get(s);
        if (symbol != null) {
            return thread.setValues(symbol, Keyword.INTERNAL);
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s);
                if (symbol == null) continue;
                return thread.setValues(symbol, Keyword.INHERITED);
            }
        }
        return thread.setValues(Lisp.NIL, Lisp.NIL);
    }

    public synchronized void addSymbol(Symbol symbol) {
        Debug.assertTrue(symbol.getPackage() == this);
        Debug.assertTrue(symbol.getName().equals("NIL"));
        this.externalSymbols.put(symbol.name, symbol);
    }

    private synchronized Symbol addSymbol(SimpleString name, int hash) {
        Symbol symbol = new Symbol(name, hash, this);
        if (this == Lisp.PACKAGE_KEYWORD) {
            symbol.initializeConstant(symbol);
            this.externalSymbols.put(name, symbol);
        } else {
            this.internalSymbols.put(name, symbol);
        }
        return symbol;
    }

    public synchronized Symbol addInternalSymbol(String symbolName) {
        Symbol symbol = new Symbol(symbolName, this);
        this.internalSymbols.put(symbol);
        return symbol;
    }

    public synchronized Symbol addExternalSymbol(String symbolName) {
        Symbol symbol = new Symbol(symbolName, this);
        this.externalSymbols.put(symbol);
        return symbol;
    }

    public synchronized Symbol intern(String symbolName) {
        return this.intern(new SimpleString(symbolName));
    }

    public synchronized Symbol intern(SimpleString symbolName) {
        int hash = symbolName.sxhash();
        Symbol symbol = this.externalSymbols.get(symbolName, hash);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(symbolName, hash);
        if (symbol != null) {
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(symbolName, hash);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return this.addSymbol(symbolName, hash);
    }

    public synchronized Symbol intern(SimpleString s, LispThread thread) {
        int hash = s.sxhash();
        Symbol symbol = this.externalSymbols.get(s, hash);
        if (symbol != null) {
            return (Symbol)thread.setValues(symbol, Keyword.EXTERNAL);
        }
        symbol = this.internalSymbols.get(s, hash);
        if (symbol != null) {
            return (Symbol)thread.setValues(symbol, Keyword.INTERNAL);
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s, hash);
                if (symbol == null) continue;
                return (Symbol)thread.setValues(symbol, Keyword.INHERITED);
            }
        }
        return (Symbol)thread.setValues(this.addSymbol(s, hash), Lisp.NIL);
    }

    public synchronized Symbol internAndExport(String symbolName) {
        SimpleString s = new SimpleString(symbolName);
        int hash = s.sxhash();
        Symbol symbol = this.externalSymbols.get(s, hash);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(s, hash);
        if (symbol != null) {
            this.export(symbol);
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s, hash);
                if (symbol == null) continue;
                this.export(symbol);
                return symbol;
            }
        }
        symbol = new Symbol(s, hash, this);
        if (this == Lisp.PACKAGE_KEYWORD) {
            symbol.initializeConstant(symbol);
        }
        this.externalSymbols.put(s, symbol);
        return symbol;
    }

    public synchronized LispObject unintern(Symbol symbol) {
        String symbolName = symbol.getName();
        boolean shadow = this.shadowingSymbols != null && this.shadowingSymbols.get(symbolName) == symbol;
        if (shadow) {
            Symbol sym = null;
            if (this.useList instanceof Cons) {
                for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                    Package pkg = (Package)usedPackages.car();
                    Symbol s = pkg.findExternalSymbol(symbol.name);
                    if (s == null) continue;
                    if (sym == null) {
                        sym = s;
                        continue;
                    }
                    if (sym == s) continue;
                    FastStringBuffer sb = new FastStringBuffer("Uninterning the symbol ");
                    sb.append(symbol.getQualifiedName());
                    sb.append(" causes a name conflict between ");
                    sb.append(sym.getQualifiedName());
                    sb.append(" and ");
                    sb.append(s.getQualifiedName());
                    return Lisp.error(new PackageError(sb.toString()));
                }
            }
        }
        if (this.internalSymbols.get(symbol.name) == symbol) {
            this.internalSymbols.remove(symbol.name);
        } else if (this.externalSymbols.get(symbol.name) == symbol) {
            this.externalSymbols.remove(symbol.name);
        } else {
            return Lisp.NIL;
        }
        if (shadow) {
            Debug.assertTrue(this.shadowingSymbols != null);
            this.shadowingSymbols.remove(symbolName);
        }
        if (symbol.getPackage() == this) {
            symbol.setPackage(Lisp.NIL);
        }
        return Lisp.T;
    }

    public synchronized void importSymbol(Symbol symbol) {
        if (symbol.getPackage() == this) {
            return;
        }
        Symbol sym = this.findAccessibleSymbol(symbol.name);
        if (sym != null && sym != symbol) {
            FastStringBuffer sb = new FastStringBuffer("The symbol ");
            sb.append(sym.getQualifiedName());
            sb.append(" is already accessible in package ");
            sb.append(this.name);
            sb.append('.');
            Lisp.error(new PackageError(sb.toString()));
        }
        this.internalSymbols.put(symbol.name, symbol);
        if (symbol.getPackage() == Lisp.NIL) {
            symbol.setPackage(this);
        }
    }

    public synchronized void export(Symbol symbol) {
        String symbolName = symbol.getName();
        boolean added = false;
        if (symbol.getPackage() != this) {
            Symbol sym = this.findAccessibleSymbol(symbol.name);
            if (sym != symbol) {
                FastStringBuffer sb = new FastStringBuffer("The symbol ");
                sb.append(symbol.getQualifiedName());
                sb.append(" is not accessible in package ");
                sb.append(this.name);
                sb.append('.');
                Lisp.error(new PackageError(sb.toString()));
                return;
            }
            this.internalSymbols.put(symbol.name, symbol);
            added = true;
        }
        if (added || this.internalSymbols.get(symbol.name) == symbol) {
            if (this.usedByList != null) {
                for (Package pkg : this.usedByList) {
                    Symbol sym = pkg.findAccessibleSymbol(symbol.name);
                    if (sym == null || sym == symbol || pkg.shadowingSymbols != null && pkg.shadowingSymbols.get(symbolName) == sym) continue;
                    FastStringBuffer sb = new FastStringBuffer("The symbol ");
                    sb.append(sym.getQualifiedName());
                    sb.append(" is already accessible in package ");
                    sb.append(pkg.getName());
                    sb.append('.');
                    Lisp.error(new PackageError(sb.toString()));
                    return;
                }
            }
            this.internalSymbols.remove(symbol.name);
            this.externalSymbols.put(symbol.name, symbol);
            return;
        }
        if (this.externalSymbols.get(symbol.name) == symbol) {
            return;
        }
        FastStringBuffer sb = new FastStringBuffer("The symbol ");
        sb.append(symbol.getQualifiedName());
        sb.append(" is not accessible in package ");
        sb.append(this.name);
        sb.append('.');
        Lisp.error(new PackageError(sb.toString()));
    }

    public synchronized void unexport(Symbol symbol) {
        if (symbol.getPackage() == this) {
            if (this.externalSymbols.get(symbol.name) == symbol) {
                this.externalSymbols.remove(symbol.name);
                this.internalSymbols.put(symbol.name, symbol);
            }
        } else {
            if (this.useList instanceof Cons) {
                for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                    Package pkg = (Package)usedPackages.car();
                    if (pkg.findExternalSymbol(symbol.name) != symbol) continue;
                    return;
                }
            }
            FastStringBuffer sb = new FastStringBuffer("The symbol ");
            sb.append(symbol.getQualifiedName());
            sb.append(" is not accessible in package ");
            sb.append(this.name);
            Lisp.error(new PackageError(sb.toString()));
        }
    }

    public synchronized void shadow(String symbolName) {
        SimpleString s;
        Symbol symbol;
        if (this.shadowingSymbols == null) {
            this.shadowingSymbols = new HashMap();
        }
        if ((symbol = this.externalSymbols.get(s = new SimpleString(symbolName))) != null) {
            this.shadowingSymbols.put(symbolName, symbol);
            return;
        }
        symbol = this.internalSymbols.get(s);
        if (symbol != null) {
            this.shadowingSymbols.put(symbolName, symbol);
            return;
        }
        if (this.shadowingSymbols.get(symbolName) != null) {
            return;
        }
        symbol = new Symbol(s, this);
        this.internalSymbols.put(s, symbol);
        this.shadowingSymbols.put(symbolName, symbol);
    }

    public synchronized void shadowingImport(Symbol symbol) {
        LispObject where = Lisp.NIL;
        String symbolName = symbol.getName();
        Symbol sym = this.externalSymbols.get(symbol.name);
        if (sym != null) {
            where = Keyword.EXTERNAL;
        } else {
            sym = this.internalSymbols.get(symbol.name);
            if (sym != null) {
                where = Keyword.INTERNAL;
            } else if (this.useList instanceof Cons) {
                for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                    Package pkg = (Package)usedPackages.car();
                    sym = pkg.findExternalSymbol(symbol.name);
                    if (sym == null) continue;
                    where = Keyword.INHERITED;
                    break;
                }
            }
        }
        if (sym != null && (where == Keyword.INTERNAL || where == Keyword.EXTERNAL) && sym != symbol) {
            if (this.shadowingSymbols != null) {
                this.shadowingSymbols.remove(symbolName);
            }
            this.unintern(sym);
        }
        this.internalSymbols.put(symbol.name, symbol);
        if (this.shadowingSymbols == null) {
            this.shadowingSymbols = new HashMap();
        }
        Debug.assertTrue(this.shadowingSymbols.get(symbolName) == null);
        this.shadowingSymbols.put(symbolName, symbol);
    }

    public void usePackage(Package pkg) {
        if (this.useList == null) {
            this.useList = Lisp.NIL;
        }
        if (!Lisp.memq(pkg, this.useList)) {
            List symbols = pkg.getExternalSymbols();
            int i = symbols.size();
            while (i-- > 0) {
                Symbol symbol = (Symbol)symbols.get(i);
                Symbol existing = this.findAccessibleSymbol(symbol.name);
                if (existing == null || existing == symbol || this.shadowingSymbols != null && this.shadowingSymbols.get(symbol.getName()) != null) continue;
                Lisp.error(new PackageError("A symbol named " + symbol.getName() + " is already accessible in package " + this.name + "."));
                return;
            }
            this.useList = this.useList.push(pkg);
            if (pkg.usedByList != null) {
                Debug.assertTrue(!pkg.usedByList.contains(this));
            }
            if (pkg.usedByList == null) {
                pkg.usedByList = new ArrayList();
            }
            pkg.usedByList.add(this);
        }
    }

    public void unusePackage(Package pkg) {
        if (this.useList instanceof Cons && Lisp.memq(pkg, this.useList)) {
            LispObject newList = Lisp.NIL;
            while (this.useList != Lisp.NIL) {
                if (this.useList.car() != pkg) {
                    newList = newList.push(this.useList.car());
                }
                this.useList = this.useList.cdr();
            }
            this.useList = newList.nreverse();
            Debug.assertTrue(!Lisp.memq(pkg, this.useList));
            Debug.assertTrue(pkg.usedByList != null);
            Debug.assertTrue(pkg.usedByList.contains(this));
            pkg.usedByList.remove(this);
        }
    }

    public final void addNickname(String s) {
        Packages.addNickname(this, s);
        if (this.nicknames != null) {
            if (this.nicknames.contains(s)) {
                return;
            }
        } else {
            this.nicknames = new ArrayList();
        }
        this.nicknames.add(s);
    }

    public String getNickname() {
        if (this.nicknames != null && this.nicknames.size() > 0) {
            return this.nicknames.get(0);
        }
        return null;
    }

    public LispObject packageNicknames() {
        LispObject list = Lisp.NIL;
        if (this.nicknames != null) {
            int i = this.nicknames.size();
            while (i-- > 0) {
                String nickname = this.nicknames.get(i);
                list = new Cons(new SimpleString(nickname), list);
            }
        }
        return list;
    }

    public LispObject getUseList() {
        if (this.useList == null) {
            this.useList = Lisp.NIL;
        }
        return this.useList;
    }

    public boolean uses(LispObject pkg) {
        return this.useList instanceof Cons && Lisp.memq(pkg, this.useList);
    }

    public LispObject getUsedByList() {
        LispObject list = Lisp.NIL;
        if (this.usedByList != null) {
            for (Package pkg : this.usedByList) {
                list = new Cons(pkg, list);
            }
        }
        return list;
    }

    public LispObject getShadowingSymbols() {
        LispObject list = Lisp.NIL;
        if (this.shadowingSymbols != null) {
            for (Symbol symbol : this.shadowingSymbols.values()) {
                list = new Cons(symbol, list);
            }
        }
        return list;
    }

    public synchronized List getExternalSymbols() {
        return this.externalSymbols.getSymbols();
    }

    public synchronized List<Symbol> getAccessibleSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        list.addAll(this.internalSymbols.getSymbols());
        list.addAll(this.externalSymbols.getSymbols());
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                List<Symbol> symbols = pkg.externalSymbols.getSymbols();
                for (int i = 0; i < symbols.size(); ++i) {
                    Symbol symbol = symbols.get(i);
                    if (this.shadowingSymbols != null && this.shadowingSymbols.get(symbol.getName()) != null) continue;
                    list.add(symbol);
                }
            }
        }
        return list;
    }

    public synchronized LispObject PACKAGE_INTERNAL_SYMBOLS() {
        LispObject list = Lisp.NIL;
        List<Symbol> symbols = this.internalSymbols.getSymbols();
        int i = symbols.size();
        while (i-- > 0) {
            list = new Cons(symbols.get(i), list);
        }
        return list;
    }

    public synchronized LispObject PACKAGE_EXTERNAL_SYMBOLS() {
        LispObject list = Lisp.NIL;
        List<Symbol> symbols = this.externalSymbols.getSymbols();
        int i = symbols.size();
        while (i-- > 0) {
            list = new Cons(symbols.get(i), list);
        }
        return list;
    }

    public synchronized LispObject PACKAGE_INHERITED_SYMBOLS() {
        LispObject list = Lisp.NIL;
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                List externals = pkg.getExternalSymbols();
                int i = externals.size();
                while (i-- > 0) {
                    Symbol symbol = (Symbol)externals.get(i);
                    if (this.shadowingSymbols != null && this.shadowingSymbols.get(symbol.getName()) != null || this.externalSymbols.get(symbol.name) == symbol) continue;
                    list = new Cons(symbol, list);
                }
            }
        }
        return list;
    }

    public synchronized LispObject getSymbols() {
        LispObject list = Lisp.NIL;
        List<Symbol> internals = this.internalSymbols.getSymbols();
        int i = internals.size();
        while (i-- > 0) {
            list = new Cons(internals.get(i), list);
        }
        List<Symbol> externals = this.externalSymbols.getSymbols();
        int i2 = externals.size();
        while (i2-- > 0) {
            list = new Cons(externals.get(i2), list);
        }
        return list;
    }

    public synchronized Symbol[] symbols() {
        List<Symbol> internals = this.internalSymbols.getSymbols();
        List<Symbol> externals = this.externalSymbols.getSymbols();
        Symbol[] array = new Symbol[internals.size() + externals.size()];
        int i = 0;
        for (Symbol symbol : internals) {
            array[i++] = symbol;
        }
        for (Symbol symbol : externals) {
            array[i++] = symbol;
        }
        return array;
    }

    @Override
    public String writeToString() {
        if (Lisp._PRINT_FASL_.symbolValue() != Lisp.NIL && this.name != null) {
            FastStringBuffer sb = new FastStringBuffer("#.(FIND-PACKAGE \"");
            sb.append(this.name);
            sb.append("\")");
            return sb.toString();
        }
        if (this.name != null) {
            FastStringBuffer sb = new FastStringBuffer("#<PACKAGE \"");
            sb.append(this.name);
            sb.append("\">");
            return sb.toString();
        }
        return this.unreadableString("PACKAGE");
    }
}

