/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class PackageFunctions {
    private static final Primitive PACKAGEP = new Primitive("packagep", "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Package ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive PACKAGE_NAME = new Primitive("package-name", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).NAME();
        }
    };
    private static final Primitive PACKAGE_NICKNAMES = new Primitive("package-nicknames", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).packageNicknames();
        }
    };
    private static final Primitive PACKAGE_USE_LIST = new Primitive("package-use-list", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).getUseList();
        }
    };
    private static final Primitive PACKAGE_USED_BY_LIST = new Primitive("package-used-by-list", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).getUsedByList();
        }
    };
    private static final Primitive _IMPORT = new Primitive("%import", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject[] args) {
            LispObject symbols;
            Package pkg;
            if (args.length == 0 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package package_ = pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (symbols.listp()) {
                for (symbols = args[0]; symbols != Lisp.NIL; symbols = symbols.cdr()) {
                    pkg.importSymbol(Lisp.checkSymbol(symbols.car()));
                }
            } else {
                pkg.importSymbol(Lisp.checkSymbol(symbols));
            }
            return Lisp.T;
        }
    };
    private static final Primitive UNEXPORT = new Primitive("unexport", "symbols &optional package"){

        public LispObject execute(LispObject[] args) {
            LispObject symbols;
            Package pkg;
            if (args.length == 0 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package package_ = pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (symbols.listp()) {
                for (symbols = args[0]; symbols != Lisp.NIL; symbols = symbols.cdr()) {
                    pkg.unexport(Lisp.checkSymbol(symbols.car()));
                }
            } else {
                pkg.unexport(Lisp.checkSymbol(symbols));
            }
            return Lisp.T;
        }
    };
    private static final Primitive SHADOW = new Primitive("shadow", "symbol-names &optional package"){

        public LispObject execute(LispObject[] args) {
            LispObject symbols;
            Package pkg;
            if (args.length == 0 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package package_ = pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (symbols.listp()) {
                for (symbols = args[0]; symbols != Lisp.NIL; symbols = symbols.cdr()) {
                    pkg.shadow(Lisp.javaString(symbols.car()));
                }
            } else {
                pkg.shadow(Lisp.javaString(symbols));
            }
            return Lisp.T;
        }
    };
    private static final Primitive SHADOWING_IMPORT = new Primitive("shadowing-import", "symbols &optional package"){

        public LispObject execute(LispObject[] args) {
            LispObject symbols;
            Package pkg;
            if (args.length == 0 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package package_ = pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (symbols.listp()) {
                for (symbols = args[0]; symbols != Lisp.NIL; symbols = symbols.cdr()) {
                    pkg.shadowingImport(Lisp.checkSymbol(symbols.car()));
                }
            } else {
                pkg.shadowingImport(Lisp.checkSymbol(symbols));
            }
            return Lisp.T;
        }
    };
    private static final Primitive PACKAGE_SHADOWING_SYMBOLS = new Primitive("package-shadowing-symbols", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).getShadowingSymbols();
        }
    };
    private static final Primitive DELETE_PACKAGE = new Primitive("delete-package", "package"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).delete() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive USE_PACKAGE = new Primitive("unuse-package", "packages-to-unuse &optional package"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (args[0] instanceof Cons) {
                for (LispObject list = args[0]; list != Lisp.NIL; list = list.cdr()) {
                    pkg.unusePackage(Lisp.coerceToPackage(list.car()));
                }
            } else {
                pkg.unusePackage(Lisp.coerceToPackage(args[0]));
            }
            return Lisp.T;
        }
    };
    private static final Primitive RENAME_PACKAGE = new Primitive("rename-package", "package new-name &optional new-nicknames"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 2 || args.length > 3) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package pkg = Lisp.coerceToPackage(args[0]);
            String newName = Lisp.javaString(args[1]);
            LispObject nicknames = args.length == 3 ? Lisp.checkList(args[2]) : Lisp.NIL;
            pkg.rename(newName, nicknames);
            return pkg;
        }
    };
    private static final Primitive LIST_ALL_PACKAGES = new Primitive("list-all-packages", ""){

        public LispObject execute() {
            return Packages.listAllPackages();
        }
    };
    private static final Primitive _DEFPACKAGE = new Primitive("%defpackage", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject[] args) {
            Symbol sym;
            String symbolName;
            LispObject symbolNames;
            Package otherPkg;
            LispObject si;
            String symbolName2;
            if (args.length != 10) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            String packageName = args[0].getStringValue();
            LispObject nicknames = Lisp.checkList(args[1]);
            LispObject shadows = Lisp.checkList(args[3]);
            LispObject shadowingImports = Lisp.checkList(args[4]);
            LispObject use = Lisp.checkList(args[5]);
            LispObject imports = Lisp.checkList(args[6]);
            LispObject interns = Lisp.checkList(args[7]);
            LispObject exports = Lisp.checkList(args[8]);
            Package pkg = Packages.findPackage(packageName);
            if (pkg != null) {
                return pkg;
            }
            if (nicknames != Lisp.NIL) {
                for (LispObject list = nicknames; list != Lisp.NIL; list = list.cdr()) {
                    String nick = Lisp.javaString(list.car());
                    if (Packages.findPackage(nick) == null) continue;
                    return Lisp.error(new PackageError("A package named " + nick + " already exists."));
                }
            }
            pkg = Packages.createPackage(packageName);
            while (nicknames != Lisp.NIL) {
                LispObject string = nicknames.car().STRING();
                pkg.addNickname(string.getStringValue());
                nicknames = nicknames.cdr();
            }
            while (shadows != Lisp.NIL) {
                symbolName2 = shadows.car().getStringValue();
                pkg.shadow(symbolName2);
                shadows = shadows.cdr();
            }
            while (shadowingImports != Lisp.NIL) {
                si = shadowingImports.car();
                otherPkg = Lisp.coerceToPackage(si.car());
                for (symbolNames = si.cdr(); symbolNames != Lisp.NIL; symbolNames = symbolNames.cdr()) {
                    symbolName = symbolNames.car().getStringValue();
                    sym = otherPkg.findAccessibleSymbol(symbolName);
                    if (sym == null) {
                        return Lisp.error(new LispError(symbolName + " not found in package " + otherPkg.getName() + "."));
                    }
                    pkg.shadowingImport(sym);
                }
                shadowingImports = shadowingImports.cdr();
            }
            while (use != Lisp.NIL) {
                LispObject obj = use.car();
                if (obj instanceof Package) {
                    pkg.usePackage((Package)obj);
                } else {
                    LispObject string = obj.STRING();
                    Package p = Packages.findPackage(string.getStringValue());
                    if (p == null) {
                        return Lisp.error(new LispError(obj.writeToString() + " is not the name of a package."));
                    }
                    pkg.usePackage(p);
                }
                use = use.cdr();
            }
            while (imports != Lisp.NIL) {
                si = imports.car();
                otherPkg = Lisp.coerceToPackage(si.car());
                for (symbolNames = si.cdr(); symbolNames != Lisp.NIL; symbolNames = symbolNames.cdr()) {
                    symbolName = symbolNames.car().getStringValue();
                    sym = otherPkg.findAccessibleSymbol(symbolName);
                    if (sym == null) {
                        return Lisp.error(new LispError(symbolName + " not found in package " + otherPkg.getName() + "."));
                    }
                    pkg.importSymbol(sym);
                }
                imports = imports.cdr();
            }
            while (interns != Lisp.NIL) {
                symbolName2 = interns.car().getStringValue();
                pkg.intern(symbolName2);
                interns = interns.cdr();
            }
            while (exports != Lisp.NIL) {
                symbolName2 = exports.car().getStringValue();
                pkg.export(pkg.intern(symbolName2));
                exports = exports.cdr();
            }
            return pkg;
        }
    };
}

