/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.EqualHashTable;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class Pathname
extends LispObject {
    protected LispObject host = Lisp.NIL;
    protected LispObject device = Lisp.NIL;
    protected LispObject directory = Lisp.NIL;
    protected LispObject name = Lisp.NIL;
    protected LispObject type = Lisp.NIL;
    protected LispObject version = Lisp.NIL;
    private String namestring;
    public static EqualHashTable LOGICAL_PATHNAME_TRANSLATIONS = new EqualHashTable(64, Lisp.NIL, Lisp.NIL);
    private static final Symbol _LOGICAL_PATHNAME_TRANSLATIONS_ = Lisp.exportSpecial("*LOGICAL-PATHNAME-TRANSLATIONS*", Lisp.PACKAGE_SYS, LOGICAL_PATHNAME_TRANSLATIONS);
    private static final Primitive _PATHNAME_HOST = new Primitive("%pathname-host", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).host;
        }
    };
    private static final Primitive _PATHNAME_DEVICE = new Primitive("%pathname-device", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).device;
        }
    };
    private static final Primitive _PATHNAME_DIRECTORY = new Primitive("%pathname-directory", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).directory;
        }
    };
    private static final Primitive _PATHNAME_NAME = new Primitive("%pathname-name", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).name;
        }
    };
    private static final Primitive _PATHNAME_TYPE = new Primitive("%pathname-type", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).type;
        }
    };
    private static final Primitive PATHNAME_VERSION = new Primitive("pathname-version", "pathname"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname((LispObject)arg).version;
        }
    };
    private static final Primitive NAMESTRING = new Primitive("namestring", "pathname"){

        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            String namestring = pathname.getNamestring();
            if (namestring == null) {
                Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.writeToString()));
            }
            return new SimpleString(namestring);
        }
    };
    private static final Primitive DIRECTORY_NAMESTRING = new Primitive("directory-namestring", "pathname"){

        public LispObject execute(LispObject arg) {
            return new SimpleString(Lisp.coerceToPathname(arg).getDirectoryNamestring());
        }
    };
    private static final Primitive PATHNAME = new Primitive("pathname", "pathspec"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname(arg);
        }
    };
    private static final Primitive _PARSE_NAMESTRING = new Primitive("%parse-namestring", Lisp.PACKAGE_SYS, false, "namestring host default-pathname"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispThread thread = LispThread.currentThread();
            AbstractString namestring = Lisp.checkString(first);
            if (second == Lisp.NIL) {
                if ((third = Lisp.coerceToPathname(third)) instanceof LogicalPathname) {
                    second = ((LogicalPathname)third).host;
                } else {
                    return thread.setValues(Pathname.parseNamestring(namestring), namestring.LENGTH());
                }
            }
            Debug.assertTrue(second != Lisp.NIL);
            AbstractString host = Lisp.checkString(second);
            return thread.setValues(Pathname.parseNamestring(namestring, host), namestring.LENGTH());
        }
    };
    private static final Primitive MAKE_PATHNAME = new Primitive("make-pathname", "&key host device directory name type version defaults case"){

        public LispObject execute(LispObject[] args) {
            return Pathname._makePathname(args);
        }
    };
    private static final Primitive PATHNAMEP = new Primitive("pathnamep", "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Pathname ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive LOGICAL_PATHNAME_P = new Primitive("logical-pathname-p", Lisp.PACKAGE_SYS, true, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof LogicalPathname ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive USER_HOMEDIR_PATHNAME = new Primitive("user-homedir-pathname", "&optional host"){

        public LispObject execute(LispObject[] args) {
            switch (args.length) {
                case 0: {
                    String s = System.getProperty("user.home");
                    if (!s.endsWith(File.separator)) {
                        s = s.concat(File.separator);
                    }
                    return new Pathname(s);
                }
                case 1: {
                    return Lisp.NIL;
                }
            }
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }
    };
    private static final Primitive LIST_DIRECTORY = new Primitive("list-directory", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            File f;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname instanceof LogicalPathname) {
                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
            }
            LispObject result = Lisp.NIL;
            String s = pathname.getNamestring();
            if (s != null && (f = new File(s)).isDirectory()) {
                try {
                    File[] files = f.listFiles();
                    int i = files.length;
                    while (i-- > 0) {
                        File file = files[i];
                        Pathname p = file.isDirectory() ? Utilities.getDirectoryPathname(file) : new Pathname(file.getCanonicalPath());
                        result = new Cons(p, result);
                    }
                }
                catch (IOException e) {
                    return Lisp.error(new FileError("Unable to list directory " + pathname.writeToString() + ".", pathname));
                }
                catch (SecurityException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            return result;
        }
    };
    private static final Primitive _WILD_PATHNAME_P = new Primitive("%wild-pathname-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            LispObject value;
            Pathname pathname = Lisp.coerceToPathname(first);
            if (second == Lisp.NIL) {
                return pathname.isWild() ? Lisp.T : Lisp.NIL;
            }
            if (second == Keyword.DIRECTORY) {
                if (pathname.directory instanceof Cons) {
                    if (Lisp.memq(Keyword.WILD, pathname.directory)) {
                        return Lisp.T;
                    }
                    if (Lisp.memq(Keyword.WILD_INFERIORS, pathname.directory)) {
                        return Lisp.T;
                    }
                }
                return Lisp.NIL;
            }
            if (second == Keyword.HOST) {
                value = pathname.host;
            } else if (second == Keyword.DEVICE) {
                value = pathname.device;
            } else if (second == Keyword.NAME) {
                value = pathname.name;
            } else if (second == Keyword.TYPE) {
                value = pathname.type;
            } else if (second == Keyword.VERSION) {
                value = pathname.version;
            } else {
                return Lisp.error(new ProgramError("Unrecognized keyword " + second.writeToString() + "."));
            }
            if (value == Keyword.WILD || value == Keyword.WILD_INFERIORS) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive MERGE_PATHNAMES = new Primitive("merge-pathnames", "pathname &optional default-pathname default-version"){

        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            Pathname defaultPathname = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            LispObject defaultVersion = third;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }
    };
    private static final Primitive MKDIR = new Primitive("mkdir", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            Pathname defaultedPathname;
            File file;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return (file = Utilities.getFile(defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL))).mkdir() ? Lisp.T : Lisp.NIL;
        }
    };
    public static final Primitive RENAME_FILE = new Primitive("rename-file", "filespec new-name"){

        public LispObject execute(LispObject first, LispObject second) {
            Pathname original = (Pathname)Pathname.truename(first, true);
            String originalNamestring = original.getNamestring();
            Pathname newName = Lisp.coerceToPathname(second);
            if (newName.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", newName));
            }
            String newNamestring = (newName = Pathname.mergePathnames(newName, original, Lisp.NIL)) instanceof LogicalPathname ? LogicalPathname.translateLogicalPathname((LogicalPathname)newName).getNamestring() : newName.getNamestring();
            if (originalNamestring != null && newNamestring != null) {
                File source = new File(originalNamestring);
                File destination = new File(newNamestring);
                if (Utilities.isPlatformWindows && destination.isFile()) {
                    destination.delete();
                }
                if (source.renameTo(destination)) {
                    return LispThread.currentThread().setValues(newName, original, Pathname.truename(newName, true));
                }
            }
            return Lisp.error(new FileError("Unable to rename " + original.writeToString() + " to " + newName.writeToString() + "."));
        }
    };
    private static final Primitive FILE_NAMESTRING = new Primitive("file-namestring", "pathname"){

        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            FastStringBuffer sb = new FastStringBuffer();
            if (p.name instanceof AbstractString) {
                sb.append(p.name.getStringValue());
            } else if (p.name == Keyword.WILD) {
                sb.append('*');
            } else {
                return Lisp.NIL;
            }
            if (p.type instanceof AbstractString) {
                sb.append('.');
                sb.append(p.type.getStringValue());
            } else if (p.type == Keyword.WILD) {
                sb.append(".*");
            }
            return new SimpleString(sb);
        }
    };
    private static final Primitive HOST_NAMESTRING = new Primitive("host-namestring", "pathname"){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname((LispObject)arg).host;
        }
    };

    protected Pathname() {
    }

    public Pathname(String s) {
        this.init(s);
    }

    public Pathname(URL url) {
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            String s;
            try {
                s = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                s = null;
            }
            if (s.startsWith("file:")) {
                int index = s.indexOf("!/");
                String container = s.substring(5, index);
                if (Utilities.isPlatformWindows && container.length() > 0 && container.charAt(0) == '/') {
                    container = container.substring(1);
                }
                this.device = new Pathname(container);
                s = s.substring(index + 1);
                Pathname p = new Pathname(s);
                this.directory = p.directory;
                this.name = p.name;
                this.type = p.type;
                return;
            }
        } else if ("file".equals(protocol)) {
            String s;
            try {
                s = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                s = null;
            }
            if (s != null && s.startsWith("file:")) {
                this.init(s.substring(5));
                return;
            }
        }
        Lisp.error(new LispError("Unsupported URL: \"" + url.toString() + '\"'));
    }

    private final void init(String s) {
        int i;
        int bang;
        if (s == null) {
            return;
        }
        if (s.equals(".") || s.equals("./") || Utilities.isPlatformWindows && s.equals(".\\")) {
            this.directory = new Cons(Keyword.RELATIVE);
            return;
        }
        if (s.equals("..") || s.equals("../")) {
            this.directory = Lisp.list(Keyword.RELATIVE, Keyword.UP);
            return;
        }
        if (Utilities.isPlatformWindows) {
            if (s.startsWith("\\\\")) {
                int shareIndex = s.indexOf(92, 2);
                int dirIndex = s.indexOf(92, shareIndex + 1);
                if (shareIndex == -1 || dirIndex == -1) {
                    Lisp.error(new LispError("Unsupported UNC path format: \"" + s + '\"'));
                }
                this.host = new SimpleString(s.substring(2, shareIndex));
                this.device = new SimpleString(s.substring(shareIndex + 1, dirIndex));
                Pathname p = new Pathname(s.substring(dirIndex));
                this.directory = p.directory;
                this.name = p.name;
                this.type = p.type;
                this.version = p.version;
                return;
            }
            s = s.replace('/', '\\');
        }
        if ((bang = s.indexOf("!/")) >= 0) {
            Pathname container = new Pathname(s.substring(0, bang));
            LispObject containerType = container.type;
            if (containerType instanceof AbstractString && containerType.getStringValue().equalsIgnoreCase("jar")) {
                this.device = container;
                s = s.substring(bang + 1);
                Pathname p = new Pathname(s);
                this.directory = p.directory;
                this.name = p.name;
                this.type = p.type;
                return;
            }
        }
        if (Utilities.isPlatformUnix) {
            if (s.equals("~")) {
                s = System.getProperty("user.home").concat("/");
            } else if (s.startsWith("~/")) {
                s = System.getProperty("user.home").concat(s.substring(1));
            }
        }
        this.namestring = s;
        if (Utilities.isPlatformWindows && s.length() >= 2 && s.charAt(1) == ':') {
            this.device = new SimpleString(s.charAt(0));
            s = s.substring(2);
        }
        String d = null;
        if (Utilities.isPlatformWindows) {
            i = s.length();
            while (i-- > 0) {
                char c = s.charAt(i);
                if (c != '/' && c != '\\') continue;
                d = s.substring(0, i + 1);
                s = s.substring(i + 1);
                break;
            }
        } else {
            i = s.length();
            while (i-- > 0) {
                if (s.charAt(i) != '/') continue;
                d = s.substring(0, i + 1);
                s = s.substring(i + 1);
                break;
            }
        }
        if (d != null) {
            if (s.equals("..")) {
                d = d.concat(s);
                s = "";
            }
            this.directory = Pathname.parseDirectory(d);
        }
        if (s.startsWith(".")) {
            this.name = new SimpleString(s);
            return;
        }
        int index = s.lastIndexOf(46);
        String n = null;
        String t = null;
        if (index > 0) {
            n = s.substring(0, index);
            t = s.substring(index + 1);
        } else if (s.length() > 0) {
            n = s;
        }
        if (n != null) {
            this.name = n.equals("*") ? Keyword.WILD : new SimpleString(n);
        }
        if (t != null) {
            this.type = t.equals("*") ? Keyword.WILD : new SimpleString(t);
        }
    }

    private static final LispObject parseDirectory(String d) {
        if (d.equals("/") || Utilities.isPlatformWindows && d.equals("\\")) {
            return new Cons(Keyword.ABSOLUTE);
        }
        LispObject result = d.startsWith("/") || Utilities.isPlatformWindows && d.startsWith("\\") ? new Cons(Keyword.ABSOLUTE) : new Cons(Keyword.RELATIVE);
        StringTokenizer st = new StringTokenizer(d, "/\\");
        while (st.hasMoreTokens()) {
            LispObject obj;
            String token = st.nextToken();
            if (token.equals("*")) {
                obj = Keyword.WILD;
            } else if (token.equals("**")) {
                obj = Keyword.WILD_INFERIORS;
            } else if (token.equals("..")) {
                if (result.car() instanceof AbstractString) {
                    result = result.cdr();
                    continue;
                }
                obj = Keyword.UP;
            } else {
                obj = new SimpleString(token);
            }
            result = new Cons(obj, result);
        }
        return ((LispObject)result).nreverse();
    }

    public LispObject getParts() {
        LispObject parts = Lisp.NIL;
        parts = parts.push(new Cons("HOST", this.host));
        parts = parts.push(new Cons("DEVICE", this.device));
        parts = parts.push(new Cons("DIRECTORY", this.directory));
        parts = parts.push(new Cons("NAME", this.name));
        parts = parts.push(new Cons("TYPE", this.type));
        parts = parts.push(new Cons("VERSION", this.version));
        return parts.nreverse();
    }

    public LispObject typeOf() {
        return Symbol.PATHNAME;
    }

    public LispObject classOf() {
        return BuiltInClass.PATHNAME;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.PATHNAME) {
            return Lisp.T;
        }
        if (type == BuiltInClass.PATHNAME) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final LispObject getDevice() {
        return this.device;
    }

    public String getNamestring() {
        if (this.namestring != null) {
            return this.namestring;
        }
        if (this.name == Lisp.NIL && this.type != Lisp.NIL) {
            Debug.assertTrue(this.namestring == null);
            return null;
        }
        if (this.directory instanceof AbstractString) {
            Debug.assertTrue(false);
        }
        FastStringBuffer sb = new FastStringBuffer();
        if (this.host != Lisp.NIL) {
            Debug.assertTrue(this.host instanceof AbstractString);
            if (!(this instanceof LogicalPathname)) {
                sb.append("\\\\");
            }
            sb.append(this.host.getStringValue());
            if (this instanceof LogicalPathname) {
                sb.append(':');
            } else {
                sb.append(File.separatorChar);
            }
        }
        if (this.device != Lisp.NIL && this.device != Keyword.UNSPECIFIC) {
            if (this.device instanceof AbstractString) {
                sb.append(this.device.getStringValue());
                if (this instanceof LogicalPathname || this.host == Lisp.NIL) {
                    sb.append(':');
                }
            } else if (this.device instanceof Pathname) {
                sb.append(((Pathname)this.device).getNamestring());
                sb.append("!");
            } else {
                Debug.assertTrue(false);
            }
        }
        sb.append(this.getDirectoryNamestring());
        if (this.name instanceof AbstractString) {
            String n = this.name.getStringValue();
            if (n.indexOf(File.separatorChar) >= 0) {
                Debug.assertTrue(this.namestring == null);
                return null;
            }
            sb.append(n);
        } else if (this.name == Keyword.WILD) {
            sb.append('*');
        }
        if (this.type != Lisp.NIL) {
            sb.append('.');
            if (this.type instanceof AbstractString) {
                String t = this.type.getStringValue();
                if (t.indexOf(46) >= 0) {
                    Debug.assertTrue(this.namestring == null);
                    return null;
                }
                sb.append(t);
            } else if (this.type == Keyword.WILD) {
                sb.append('*');
            } else {
                Debug.assertTrue(false);
            }
        }
        if (this instanceof LogicalPathname) {
            if (this.version.integerp()) {
                sb.append('.');
                int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue());
                if (this.version instanceof Fixnum) {
                    sb.append(Integer.toString(((Fixnum)this.version).value, base).toUpperCase());
                } else if (this.version instanceof Bignum) {
                    sb.append(((Bignum)this.version).value.toString(base).toUpperCase());
                }
            } else if (this.version == Keyword.WILD) {
                sb.append(".*");
            } else if (this.version == Keyword.NEWEST) {
                sb.append(".NEWEST");
            }
        }
        this.namestring = sb.toString();
        return this.namestring;
    }

    protected String getDirectoryNamestring() {
        this.validateDirectory(true);
        FastStringBuffer sb = new FastStringBuffer();
        if (this.directory != Lisp.NIL) {
            char separatorChar = this.device instanceof Pathname ? (char)'/' : (char)File.separatorChar;
            LispObject temp = this.directory;
            LispObject part = temp.car();
            temp = temp.cdr();
            if (part == Keyword.ABSOLUTE) {
                sb.append(separatorChar);
            } else if (part == Keyword.RELATIVE) {
                if (temp == Lisp.NIL) {
                    sb.append('.');
                    sb.append(separatorChar);
                }
            } else {
                Lisp.error(new FileError("Unsupported directory component " + part.writeToString() + ".", this));
            }
            while (temp != Lisp.NIL) {
                part = temp.car();
                if (part instanceof AbstractString) {
                    sb.append(part.getStringValue());
                } else if (part == Keyword.WILD) {
                    sb.append('*');
                } else if (part == Keyword.WILD_INFERIORS) {
                    sb.append("**");
                } else if (part == Keyword.UP) {
                    sb.append("..");
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.writeToString() + ".", this));
                }
                sb.append(separatorChar);
                temp = temp.cdr();
            }
        }
        return sb.toString();
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pathname) {
            Pathname p = (Pathname)obj;
            if (Utilities.isPlatformWindows) {
                if (!this.host.equalp(p.host)) {
                    return false;
                }
                if (!this.device.equalp(p.device)) {
                    return false;
                }
                if (!this.directory.equalp(p.directory)) {
                    return false;
                }
                if (!this.name.equalp(p.name)) {
                    return false;
                }
                if (!this.type.equalp(p.type)) {
                    return false;
                }
            } else {
                if (!this.host.equal(p.host)) {
                    return false;
                }
                if (!this.device.equal(p.device)) {
                    return false;
                }
                if (!this.directory.equal(p.directory)) {
                    return false;
                }
                if (!this.name.equal(p.name)) {
                    return false;
                }
                if (!this.type.equal(p.type)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean equalp(LispObject obj) {
        return this.equal(obj);
    }

    public int sxhash() {
        return (this.host.sxhash() ^ this.device.sxhash() ^ this.directory.sxhash() ^ this.name.sxhash() ^ this.type.sxhash()) & Integer.MAX_VALUE;
    }

    public String writeToString() {
        boolean useNamestring;
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        String s = null;
        s = this.getNamestring();
        if (s != null) {
            useNamestring = true;
            if (printReadably) {
                if (this.host != Lisp.NIL || this.version != Lisp.NIL) {
                    useNamestring = false;
                } else if (this.name instanceof AbstractString) {
                    String n = this.name.getStringValue();
                    if (n.equals(".") || n.equals("..")) {
                        useNamestring = false;
                    } else if (n.indexOf(File.separatorChar) >= 0) {
                        useNamestring = false;
                    }
                }
            }
        } else {
            useNamestring = false;
        }
        FastStringBuffer sb = new FastStringBuffer();
        if (useNamestring) {
            if (printReadably || printEscape) {
                sb.append("#P\"");
            }
            int limit = s.length();
            for (int i = 0; i < limit; ++i) {
                char c = s.charAt(i);
                if ((printReadably || printEscape) && (c == '\"' || c == '\\')) {
                    sb.append('\\');
                }
                sb.append(c);
            }
            if (printReadably || printEscape) {
                sb.append('\"');
            }
        } else {
            sb.append("#P(");
            if (this.host != Lisp.NIL) {
                sb.append(":HOST ");
                sb.append(this.host.writeToString());
                sb.append(' ');
            }
            if (this.device != Lisp.NIL) {
                sb.append(":DEVICE ");
                sb.append(this.device.writeToString());
                sb.append(' ');
            }
            if (this.directory != Lisp.NIL) {
                sb.append(":DIRECTORY ");
                sb.append(this.directory.writeToString());
                sb.append(" ");
            }
            if (this.name != Lisp.NIL) {
                sb.append(":NAME ");
                sb.append(this.name.writeToString());
                sb.append(' ');
            }
            if (this.type != Lisp.NIL) {
                sb.append(":TYPE ");
                sb.append(this.type.writeToString());
                sb.append(' ');
            }
            if (this.version != Lisp.NIL) {
                sb.append(":VERSION ");
                sb.append(this.version.writeToString());
                sb.append(' ');
            }
            if (sb.charAt(sb.length() - 1) == ' ') {
                sb.setLength(sb.length() - 1);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static Pathname parseNamestring(String s) {
        return new Pathname(s);
    }

    public static Pathname parseNamestring(AbstractString namestring) {
        String s = namestring.getStringValue();
        String h = Pathname.getHostString(s);
        if (h != null && LOGICAL_PATHNAME_TRANSLATIONS.get(new SimpleString(h)) != null) {
            return new LogicalPathname(h, s.substring(s.indexOf(58) + 1));
        }
        return new Pathname(s);
    }

    public static Pathname parseNamestring(AbstractString namestring, AbstractString host) {
        String s = namestring.getStringValue();
        String h = Pathname.getHostString(s);
        if (h != null) {
            if (!h.equals(host.getStringValue())) {
                Lisp.error(new LispError("Host in " + s + " does not match requested host " + host.getStringValue()));
                return null;
            }
            s = s.substring(s.indexOf(58) + 1);
        }
        if (LOGICAL_PATHNAME_TRANSLATIONS.get(host) != null) {
            return new LogicalPathname(host.getStringValue(), s);
        }
        Lisp.error(new LispError(host.writeToString() + " is not defined as a logical pathname host."));
        return null;
    }

    protected static String getHostString(String s) {
        int colon = s.indexOf(58);
        if (colon >= 0) {
            return s.substring(0, colon).toUpperCase();
        }
        return null;
    }

    private static final void checkCaseArgument(LispObject arg) {
        if (arg != Keyword.COMMON && arg != Keyword.LOCAL) {
            Lisp.type_error(arg, Lisp.list(Symbol.MEMBER, Keyword.COMMON, Keyword.LOCAL));
        }
    }

    public static final Pathname makePathname(LispObject args) {
        return Pathname._makePathname(args.copyToArray());
    }

    private static final Pathname _makePathname(LispObject[] args) {
        boolean logical;
        Pathname p;
        if (args.length % 2 != 0) {
            Lisp.error(new ProgramError("Odd number of keyword arguments."));
        }
        LispObject host = Lisp.NIL;
        LispObject device = Lisp.NIL;
        LispObject directory = Lisp.NIL;
        LispObject name = Lisp.NIL;
        LispObject type = Lisp.NIL;
        LispObject version = Lisp.NIL;
        Pathname defaults = null;
        boolean deviceSupplied = false;
        boolean nameSupplied = false;
        boolean typeSupplied = false;
        for (int i = 0; i < args.length; i += 2) {
            LispObject key = args[i];
            LispObject value = args[i + 1];
            if (key == Keyword.HOST) {
                host = value;
                continue;
            }
            if (key == Keyword.DEVICE) {
                device = value;
                deviceSupplied = true;
                continue;
            }
            if (key == Keyword.DIRECTORY) {
                if (value instanceof AbstractString) {
                    directory = Lisp.list(Keyword.ABSOLUTE, value);
                    continue;
                }
                if (value == Keyword.WILD) {
                    directory = Lisp.list(Keyword.ABSOLUTE, Keyword.WILD);
                    continue;
                }
                directory = value;
                continue;
            }
            if (key == Keyword.NAME) {
                name = value;
                nameSupplied = true;
                continue;
            }
            if (key == Keyword.TYPE) {
                type = value;
                typeSupplied = true;
                continue;
            }
            if (key == Keyword.VERSION) {
                version = value;
                continue;
            }
            if (key == Keyword.DEFAULTS) {
                defaults = Lisp.coerceToPathname(value);
                continue;
            }
            if (key != Keyword.CASE) continue;
        }
        if (defaults != null) {
            if (host == Lisp.NIL) {
                host = defaults.host;
            }
            directory = Pathname.mergeDirectories(directory, defaults.directory);
            if (!deviceSupplied) {
                device = defaults.device;
            }
            if (!nameSupplied) {
                name = defaults.name;
            }
            if (!typeSupplied) {
                type = defaults.type;
            }
        }
        if (host != Lisp.NIL) {
            if (host instanceof AbstractString) {
                host = LogicalPathname.canonicalizeStringComponent((AbstractString)host);
            }
            if (LOGICAL_PATHNAME_TRANSLATIONS.get(host) == null) {
                Lisp.error(new LispError(host.writeToString() + " is not defined as a logical pathname host."));
            }
            p = new LogicalPathname();
            logical = true;
            p.host = host;
            p.device = Keyword.UNSPECIFIC;
        } else {
            p = new Pathname();
            logical = false;
        }
        if (device != Lisp.NIL) {
            if (logical) {
                if (device != Keyword.UNSPECIFIC) {
                    Lisp.error(new LispError("The device component of a logical pathname must be :UNSPECIFIC."));
                }
            } else {
                p.device = device;
            }
        }
        if (directory != Lisp.NIL) {
            if (logical) {
                if (directory.listp()) {
                    LispObject d = Lisp.NIL;
                    while (directory != Lisp.NIL) {
                        LispObject component = directory.car();
                        d = component instanceof AbstractString ? d.push(LogicalPathname.canonicalizeStringComponent((AbstractString)component)) : d.push(component);
                        directory = directory.cdr();
                    }
                    p.directory = d.nreverse();
                } else if (directory == Keyword.WILD || directory == Keyword.WILD_INFERIORS) {
                    p.directory = directory;
                } else {
                    Lisp.error(new LispError("Invalid directory component for logical pathname: " + directory.writeToString()));
                }
            } else {
                p.directory = directory;
            }
        }
        if (name != Lisp.NIL) {
            p.name = logical && name instanceof AbstractString ? LogicalPathname.canonicalizeStringComponent((AbstractString)name) : (name instanceof AbstractString ? Pathname.validateStringComponent((AbstractString)name) : name);
        }
        if (type != Lisp.NIL) {
            p.type = logical && type instanceof AbstractString ? LogicalPathname.canonicalizeStringComponent((AbstractString)type) : type;
        }
        p.version = version;
        return p;
    }

    private static final AbstractString validateStringComponent(AbstractString s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (c != '/' && (c != '\\' || !Utilities.isPlatformWindows)) continue;
            Lisp.error(new LispError("Invalid character #\\" + c + " in pathname component \"" + s + '\"'));
            return null;
        }
        return s;
    }

    private final boolean validateDirectory(boolean signalError) {
        for (LispObject temp = this.directory; temp != Lisp.NIL; temp = temp.cdr()) {
            LispObject second;
            LispObject first = temp.car();
            if (first != Keyword.ABSOLUTE && first != Keyword.WILD_INFERIORS || (second = temp.car()) != Keyword.UP && second != Keyword.BACK) continue;
            if (signalError) {
                FastStringBuffer sb = new FastStringBuffer();
                sb.append(first.writeToString());
                sb.append(" may not be followed immediately by ");
                sb.append(second.writeToString());
                sb.append('.');
                Lisp.error(new FileError(sb.toString(), this));
            }
            return false;
        }
        return true;
    }

    public boolean isWild() {
        if (this.host == Keyword.WILD || this.host == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.device == Keyword.WILD || this.device == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.directory instanceof Cons) {
            if (Lisp.memq(Keyword.WILD, this.directory)) {
                return true;
            }
            if (Lisp.memq(Keyword.WILD_INFERIORS, this.directory)) {
                return true;
            }
        }
        if (this.name == Keyword.WILD || this.name == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.type == Keyword.WILD || this.type == Keyword.WILD_INFERIORS) {
            return true;
        }
        return this.version == Keyword.WILD || this.version == Keyword.WILD_INFERIORS;
    }

    public static final Pathname mergePathnames(Pathname pathname, Pathname defaultPathname, LispObject defaultVersion) {
        Pathname p;
        if (pathname instanceof LogicalPathname) {
            p = new LogicalPathname();
        } else {
            p = new Pathname();
            if (defaultPathname instanceof LogicalPathname) {
                defaultPathname = LogicalPathname.translateLogicalPathname((LogicalPathname)defaultPathname);
            }
        }
        p.host = pathname.host != Lisp.NIL ? pathname.host : defaultPathname.host;
        p.device = pathname.device != Lisp.NIL ? pathname.device : defaultPathname.device;
        p.directory = Pathname.mergeDirectories(pathname.directory, defaultPathname.directory);
        p.name = pathname.name != Lisp.NIL ? pathname.name : defaultPathname.name;
        p.type = pathname.type != Lisp.NIL ? pathname.type : defaultPathname.type;
        p.version = pathname.version != Lisp.NIL ? pathname.version : (pathname.name instanceof AbstractString ? defaultVersion : (defaultPathname.version != Lisp.NIL ? defaultPathname.version : defaultVersion));
        if (p instanceof LogicalPathname) {
            p.device = Keyword.UNSPECIFIC;
            if (p.directory.listp()) {
                LispObject canonical = Lisp.NIL;
                for (LispObject original = p.directory; original != Lisp.NIL; original = original.cdr()) {
                    LispObject component = original.car();
                    if (component instanceof AbstractString) {
                        component = LogicalPathname.canonicalizeStringComponent((AbstractString)component);
                    }
                    canonical = canonical.push(component);
                }
                p.directory = canonical.nreverse();
            }
            if (p.name instanceof AbstractString) {
                p.name = LogicalPathname.canonicalizeStringComponent((AbstractString)p.name);
            }
            if (p.type instanceof AbstractString) {
                p.type = LogicalPathname.canonicalizeStringComponent((AbstractString)p.type);
            }
        }
        return p;
    }

    private static final LispObject mergeDirectories(LispObject dir, LispObject defaultDir) {
        if (dir == Lisp.NIL) {
            return defaultDir;
        }
        if (dir.car() == Keyword.RELATIVE && defaultDir != Lisp.NIL) {
            int i;
            LispObject result = Lisp.NIL;
            while (defaultDir != Lisp.NIL) {
                result = new Cons(defaultDir.car(), result);
                defaultDir = defaultDir.cdr();
            }
            for (dir = dir.cdr(); dir != Lisp.NIL; dir = dir.cdr()) {
                result = new Cons(dir.car(), result);
            }
            LispObject[] array = result.copyToArray();
            for (i = 0; i < array.length - 1; ++i) {
                if (array[i] != Keyword.BACK || !(array[i + 1] instanceof AbstractString) && array[i + 1] != Keyword.WILD) continue;
                array[i] = null;
                array[i + 1] = null;
            }
            result = Lisp.NIL;
            for (i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                result = new Cons(array[i], result);
            }
            return result;
        }
        return dir;
    }

    public static final LispObject truename(LispObject arg, boolean errorIfDoesNotExist) {
        Pathname pathname = Lisp.coerceToPathname(arg);
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        if (pathname.isWild()) {
            return Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
        }
        Pathname defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL);
        String namestring = defaultedPathname.getNamestring();
        if (namestring == null) {
            return Lisp.error(new FileError("Pathname has no namestring: " + defaultedPathname.writeToString(), defaultedPathname));
        }
        File file = new File(namestring);
        if (file.isDirectory()) {
            return Utilities.getDirectoryPathname(file);
        }
        if (file.exists()) {
            try {
                return new Pathname(file.getCanonicalPath());
            }
            catch (IOException e) {
                return Lisp.error(new LispError(e.getMessage()));
            }
        }
        if (errorIfDoesNotExist) {
            FastStringBuffer sb = new FastStringBuffer("The file ");
            sb.append(defaultedPathname.writeToString());
            sb.append(" does not exist.");
            return Lisp.error(new FileError(sb.toString(), defaultedPathname));
        }
        return Lisp.NIL;
    }

    static {
        LispObject obj = Symbol.DEFAULT_PATHNAME_DEFAULTS.getSymbolValue();
        Symbol.DEFAULT_PATHNAME_DEFAULTS.setSymbolValue(Lisp.coerceToPathname(obj));
    }
}

