/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractBitVector;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.AutoloadMacro;
import org.armedbear.lisp.AutoloadedFunctionProxy;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Binding;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.CompiledClosure;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Condition;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlError;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Extensions;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.MacroObject;
import org.armedbear.lisp.Main;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.Return;
import org.armedbear.lisp.SimpleCondition;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.StandardGenericFunction;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.SymbolMacro;
import org.armedbear.lisp.Throw;
import org.armedbear.lisp.TwoWayStream;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.UndefinedFunction;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZeroRankArray;

public final class Primitives {
    public static final Primitive MULTIPLY = new Primitive(Symbol.STAR, "&rest numbers"){

        public LispObject execute() {
            return Fixnum.ONE;
        }

        public LispObject execute(LispObject arg) {
            if (arg.numberp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.NUMBER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.multiplyBy(second);
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = Fixnum.ONE;
            for (int i = 0; i < args.length; ++i) {
                result = ((LispObject)result).multiplyBy(args[i]);
            }
            return result;
        }
    };
    public static final Primitive DIVIDE = new Primitive(Symbol.SLASH, "numerator &rest denominators"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Fixnum.ONE.divideBy(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.divideBy(second);
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = args[0];
            for (int i = 1; i < args.length; ++i) {
                result = result.divideBy(args[i]);
            }
            return result;
        }
    };
    public static final Primitive MIN = new Primitive(Symbol.MIN, "&rest reals"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg.realp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.REAL);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isLessThan(second) ? first : second;
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = args[0];
            if (!result.realp()) {
                Lisp.type_error(result, Symbol.REAL);
            }
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].isLessThan(result)) continue;
                result = args[i];
            }
            return result;
        }
    };
    public static final Primitive MAX = new Primitive(Symbol.MAX, "&rest reals"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            if (arg.realp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.REAL);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isGreaterThan(second) ? first : second;
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = args[0];
            if (!result.realp()) {
                Lisp.type_error(result, Symbol.REAL);
            }
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].isGreaterThan(result)) continue;
                result = args[i];
            }
            return result;
        }
    };
    private static final Primitive IDENTITY = new Primitive(Symbol.IDENTITY, "object"){

        public LispObject execute(LispObject arg) {
            return arg;
        }
    };
    private static final Primitive COMPILED_FUNCTION_P = new Primitive(Symbol.COMPILED_FUNCTION_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg.typep(Symbol.COMPILED_FUNCTION);
        }
    };
    private static final Primitive CONSP = new Primitive(Symbol.CONSP, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Cons ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive LISTP = new Primitive(Symbol.LISTP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.LISTP();
        }
    };
    private static final Primitive ABS = new Primitive(Symbol.ABS, "number"){

        public LispObject execute(LispObject arg) {
            return arg.ABS();
        }
    };
    private static final Primitive ARRAYP = new Primitive(Symbol.ARRAYP, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof AbstractArray ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive ARRAY_HAS_FILL_POINTER_P = new Primitive(Symbol.ARRAY_HAS_FILL_POINTER_P, "array"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkArray(arg).hasFillPointer() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive VECTORP = new Primitive(Symbol.VECTORP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.VECTORP();
        }
    };
    private static final Primitive SIMPLE_VECTOR_P = new Primitive(Symbol.SIMPLE_VECTOR_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof SimpleVector ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive BIT_VECTOR_P = new Primitive(Symbol.BIT_VECTOR_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof AbstractBitVector ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive SIMPLE_BIT_VECTOR_P = new Primitive(Symbol.SIMPLE_BIT_VECTOR_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg.typep(Symbol.SIMPLE_BIT_VECTOR);
        }
    };
    private static final Primitive _EVAL = new Primitive("%eval", Lisp.PACKAGE_SYS, false, "form"){

        public LispObject execute(LispObject arg) {
            return Lisp.eval(arg, new Environment(), LispThread.currentThread());
        }
    };
    private static final Primitive EQ = new Primitive(Symbol.EQ, "x y"){

        public LispObject execute(LispObject first, LispObject second) {
            return first == second ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive EQL = new Primitive(Symbol.EQL, "x y"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.eql(second) ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive EQUAL = new Primitive(Symbol.EQUAL, "x y"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.equal(second) ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive EQUALP = new Primitive(Symbol.EQUALP, "x y"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.equalp(second) ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive VALUES = new Primitive(Symbol.VALUES, "&rest object"){

        public LispObject execute() {
            return LispThread.currentThread().setValues();
        }

        public LispObject execute(LispObject arg) {
            return LispThread.currentThread().setValues(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispThread.currentThread().setValues(first, second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return LispThread.currentThread().setValues(first, second, third);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return LispThread.currentThread().setValues(first, second, third, fourth);
        }

        public LispObject execute(LispObject[] args) {
            return LispThread.currentThread().setValues(args);
        }
    };
    private static final Primitive VALUES_LIST = new Primitive(Symbol.VALUES_LIST, "list"){

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.NIL) {
                return LispThread.currentThread().setValues();
            }
            if (arg.cdr() == Lisp.NIL) {
                return arg.car();
            }
            return LispThread.currentThread().setValues(arg.copyToArray());
        }
    };
    private static final Primitive CONS = new Primitive(Symbol.CONS, "object-1 object-2"){

        public LispObject execute(LispObject first, LispObject second) {
            return new Cons(first, second);
        }
    };
    private static final Primitive LENGTH = new Primitive(Symbol.LENGTH, "sequence"){

        public LispObject execute(LispObject arg) {
            return arg.LENGTH();
        }
    };
    private static final Primitive ELT = new Primitive(Symbol.ELT, "sequence index"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.elt(Fixnum.getValue(second));
        }
    };
    private static final Primitive ATOM = new Primitive(Symbol.ATOM, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Cons ? Lisp.NIL : Lisp.T;
        }
    };
    private static final Primitive CONSTANTP = new Primitive(Symbol.CONSTANTP, "form &optional environment"){

        public LispObject execute(LispObject arg) {
            return arg.constantp() ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.constantp() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive FUNCTIONP = new Primitive(Symbol.FUNCTIONP, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Function || arg instanceof StandardGenericFunction ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive SPECIAL_OPERATOR_P = new Primitive(Symbol.SPECIAL_OPERATOR_P, "symbol"){

        public LispObject execute(LispObject arg) {
            return arg.isSpecialOperator() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive SYMBOLP = new Primitive(Symbol.SYMBOLP, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Symbol ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive ENDP = new Primitive(Symbol.ENDP, "list"){

        public LispObject execute(LispObject arg) {
            return arg.endp() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive NULL = new Primitive(Symbol.NULL, "object"){

        public LispObject execute(LispObject arg) {
            return arg == Lisp.NIL ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive NOT = new Primitive(Symbol.NOT, "x"){

        public LispObject execute(LispObject arg) {
            return arg == Lisp.NIL ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive PLUSP = new Primitive(Symbol.PLUSP, "real"){

        public LispObject execute(LispObject arg) {
            return arg.PLUSP();
        }
    };
    private static final Primitive MINUSP = new Primitive(Symbol.MINUSP, "real"){

        public LispObject execute(LispObject arg) {
            return arg.MINUSP();
        }
    };
    private static final Primitive ZEROP = new Primitive(Symbol.ZEROP, "number"){

        public LispObject execute(LispObject arg) {
            return arg.ZEROP();
        }
    };
    private static final Primitive FIXNUMP = new Primitive("fixnump", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            return arg instanceof Fixnum ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive SYMBOL_VALUE = new Primitive(Symbol.SYMBOL_VALUE, "symbol"){

        public LispObject execute(LispObject arg) {
            LispObject value = Lisp.checkSymbol(arg).symbolValue();
            if (value instanceof SymbolMacro) {
                return Lisp.error(new LispError(arg.writeToString() + " has no dynamic value."));
            }
            return value;
        }
    };
    private static final Primitive SET = new Primitive(Symbol.SET, "symbol value"){

        public LispObject execute(LispObject first, LispObject second) {
            return LispThread.currentThread().setSpecialVariable(Lisp.checkSymbol(first), second);
        }
    };
    private static final Primitive RPLACA = new Primitive(Symbol.RPLACA, "cons object"){

        public LispObject execute(LispObject first, LispObject second) {
            first.setCar(second);
            return first;
        }
    };
    private static final Primitive RPLACD = new Primitive(Symbol.RPLACD, "cons object"){

        public LispObject execute(LispObject first, LispObject second) {
            first.setCdr(second);
            return first;
        }
    };
    private static final Primitive ADD = new Primitive(Symbol.PLUS, "&rest numbers"){

        public LispObject execute() {
            return Fixnum.ZERO;
        }

        public LispObject execute(LispObject arg) {
            if (arg.numberp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.NUMBER);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.add(second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return first.add(second).add(third);
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = Fixnum.ZERO;
            int length = args.length;
            for (int i = 0; i < length; ++i) {
                result = ((LispObject)result).add(args[i]);
            }
            return result;
        }
    };
    private static final Primitive ONE_PLUS = new Primitive(Symbol.ONE_PLUS, "number"){

        public LispObject execute(LispObject arg) {
            return arg.incr();
        }
    };
    private static final Primitive SUBTRACT = new Primitive(Symbol.MINUS, "minuend &rest subtrahends"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return arg.negate();
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.subtract(second);
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = args[0];
            for (int i = 1; i < args.length; ++i) {
                result = result.subtract(args[i]);
            }
            return result;
        }
    };
    private static final Primitive ONE_MINUS = new Primitive(Symbol.ONE_MINUS, "number"){

        public LispObject execute(LispObject arg) {
            return arg.decr();
        }
    };
    private static final SpecialOperator WHEN = new SpecialOperator(Symbol.WHEN){

        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            if (Lisp.eval(args.car(), env, thread) != Lisp.NIL) {
                args = args.cdr();
                thread.clearValues();
                return Lisp.progn(args, env, thread);
            }
            return thread.setValues(Lisp.NIL);
        }
    };
    private static final SpecialOperator UNLESS = new SpecialOperator(Symbol.UNLESS){

        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            if (Lisp.eval(args.car(), env, thread) == Lisp.NIL) {
                args = args.cdr();
                thread.clearValues();
                return Lisp.progn(args, env, thread);
            }
            return thread.setValues(Lisp.NIL);
        }
    };
    private static final Primitive _STREAM_OUTPUT_OBJECT = new Primitive("%stream-output-object", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkStream(second)._writeString(first.writeToString());
            return first;
        }
    };
    private static final Primitive _OUTPUT_OBJECT = new Primitive("%output-object", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            LispObject out = second == Lisp.T ? Symbol.TERMINAL_IO.symbolValue() : (second == Lisp.NIL ? Symbol.STANDARD_OUTPUT.symbolValue() : second);
            Lisp.checkStream(out)._writeString(first.writeToString());
            return first;
        }
    };
    private static final Primitive _WRITE_TO_STRING = new Primitive("%write-to-string", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            return new SimpleString(arg.writeToString());
        }
    };
    private static final Primitive _STREAM_TERPRI = new Primitive("%stream-terpri", Lisp.PACKAGE_SYS, true, "output-stream"){

        public LispObject execute(LispObject arg) {
            Lisp.checkStream(arg)._writeChar('\n');
            return Lisp.NIL;
        }
    };
    private static final Primitive _TERPRI = new Primitive("%terpri", Lisp.PACKAGE_SYS, false, "output-stream"){

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue();
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_OUTPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.terpri();
        }
    };
    private static final Primitive _FRESH_LINE = new Primitive("%fresh-line", Lisp.PACKAGE_SYS, false, "output-stream"){

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue();
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_OUTPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.freshLine();
        }
    };
    private static final Primitive BOUNDP = new Primitive(Symbol.BOUNDP, "symbol"){

        public LispObject execute(LispObject arg) {
            Symbol symbol = Lisp.checkSymbol(arg);
            SpecialBinding binding = LispThread.currentThread().getSpecialBinding(symbol);
            if (binding != null) {
                return binding.value != null ? Lisp.T : Lisp.NIL;
            }
            return symbol.getSymbolValue() != null ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive FBOUNDP = new Primitive(Symbol.FBOUNDP, "name"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol) {
                return arg.getSymbolFunction() != null ? Lisp.T : Lisp.NIL;
            }
            if (Lisp.isValidSetfFunctionName(arg)) {
                LispObject f = Lisp.get(arg.cadr(), Symbol.SETF_FUNCTION, null);
                return f != null ? Lisp.T : Lisp.NIL;
            }
            return Lisp.type_error(arg, Lisp.FUNCTION_NAME);
        }
    };
    private static final Primitive FMAKUNBOUND = new Primitive(Symbol.FMAKUNBOUND, "name"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol) {
                Lisp.checkSymbol(arg).setSymbolFunction(null);
                return arg;
            }
            if (Lisp.isValidSetfFunctionName(arg)) {
                Lisp.remprop((Symbol)arg.cadr(), Symbol.SETF_FUNCTION);
                return arg;
            }
            return Lisp.type_error(arg, Lisp.FUNCTION_NAME);
        }
    };
    private static final Primitive SETF_FUNCTION_NAME_P = new Primitive("setf-function-name-p", Lisp.PACKAGE_SYS, true, "thing"){

        public LispObject execute(LispObject arg) {
            return Lisp.isValidSetfFunctionName(arg) ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive REMPROP = new Primitive(Symbol.REMPROP, "symbol indicator"){

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.remprop(Lisp.checkSymbol(first), second);
        }
    };
    public static final Primitive APPEND = new Primitive(Symbol.APPEND, "&rest lists"){

        public LispObject execute() {
            return Lisp.NIL;
        }

        public LispObject execute(LispObject arg) {
            return arg;
        }

        public LispObject execute(LispObject first, LispObject second) {
            Cons result;
            if (first == Lisp.NIL) {
                return second;
            }
            Cons splice = result = new Cons(first.car());
            for (first = first.cdr(); first != Lisp.NIL; first = first.cdr()) {
                Cons temp = new Cons(first.car());
                splice.cdr = temp;
                splice = temp;
            }
            splice.cdr = second;
            return result;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Cons temp;
            Cons result;
            if (first == Lisp.NIL) {
                return this.execute(second, third);
            }
            Cons splice = result = new Cons(first.car());
            for (first = first.cdr(); first != Lisp.NIL; first = first.cdr()) {
                temp = new Cons(first.car());
                splice.cdr = temp;
                splice = temp;
            }
            while (second != Lisp.NIL) {
                temp = new Cons(second.car());
                splice.cdr = temp;
                splice = temp;
                second = second.cdr();
            }
            splice.cdr = third;
            return result;
        }

        public LispObject execute(LispObject[] args) {
            Cons temp;
            LispObject top;
            int i;
            Cons result = null;
            Cons splice = null;
            int limit = args.length - 1;
            for (i = 0; i < limit; ++i) {
                top = args[i];
                if (top == Lisp.NIL) continue;
                splice = result = new Cons(top.car());
                for (top = top.cdr(); top != Lisp.NIL; top = top.cdr()) {
                    temp = new Cons(top.car());
                    splice.cdr = temp;
                    splice = temp;
                }
                break;
            }
            if (result == null) {
                return args[i];
            }
            ++i;
            while (i < limit) {
                for (top = args[i]; top != Lisp.NIL; top = top.cdr()) {
                    temp = new Cons(top.car());
                    splice.cdr = temp;
                    splice = temp;
                }
                ++i;
            }
            splice.cdr = args[i];
            return result;
        }
    };
    private static final Primitive NCONC = new Primitive(Symbol.NCONC, "&rest lists"){

        public LispObject execute() {
            return Lisp.NIL;
        }

        public LispObject execute(LispObject arg) {
            return arg;
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (first == Lisp.NIL) {
                return second;
            }
            if (first instanceof Cons) {
                LispObject result = first;
                Cons splice = null;
                while (first instanceof Cons) {
                    splice = (Cons)first;
                    first = splice.cdr;
                }
                splice.cdr = second;
                return result;
            }
            return Lisp.type_error(first, Symbol.LIST);
        }

        public LispObject execute(LispObject[] array) {
            int i;
            LispObject result = null;
            Cons splice = null;
            int limit = array.length - 1;
            for (i = 0; i < limit; ++i) {
                LispObject list = array[i];
                if (list == Lisp.NIL) continue;
                if (list instanceof Cons) {
                    if (splice != null) {
                        splice.cdr = list;
                        splice = (Cons)list;
                    }
                    while (list instanceof Cons) {
                        if (result == null) {
                            result = list;
                            splice = (Cons)result;
                        } else {
                            splice = (Cons)list;
                        }
                        list = splice.cdr;
                    }
                    continue;
                }
                Lisp.type_error(list, Symbol.LIST);
            }
            if (result == null) {
                return array[i];
            }
            splice.cdr = array[i];
            return result;
        }
    };
    private static final Primitive EQUALS = new Primitive(Symbol.EQUALS, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isEqualTo(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isEqualTo(second) && second.isEqualTo(third)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            LispObject obj = array[0];
            for (int i = 1; i < length; ++i) {
                if (!array[i].isNotEqualTo(obj)) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive NOT_EQUALS = new Primitive(Symbol.NOT_EQUALS, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isNotEqualTo(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isEqualTo(second)) {
                return Lisp.NIL;
            }
            if (first.isEqualTo(third)) {
                return Lisp.NIL;
            }
            if (second.isEqualTo(third)) {
                return Lisp.NIL;
            }
            return Lisp.T;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                LispObject obj = array[i];
                for (int j = i + 1; j < length; ++j) {
                    if (!array[j].isEqualTo(obj)) continue;
                    return Lisp.NIL;
                }
            }
            return Lisp.T;
        }
    };
    private static final Primitive LT = new Primitive(Symbol.LT, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isLessThan(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isLessThan(second) && second.isLessThan(third)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                if (!array[i].isLessThanOrEqualTo(array[i - 1])) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive LE = new Primitive(Symbol.LE, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isLessThanOrEqualTo(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isLessThanOrEqualTo(second) && second.isLessThanOrEqualTo(third)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                if (!array[i].isLessThan(array[i - 1])) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive GT = new Primitive(Symbol.GT, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isGreaterThan(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isGreaterThan(second) && second.isGreaterThan(third)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                if (!array[i].isGreaterThanOrEqualTo(array[i - 1])) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive GE = new Primitive(Symbol.GE, "&rest numbers"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.isGreaterThanOrEqualTo(second) ? Lisp.T : Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first.isGreaterThanOrEqualTo(second) && second.isGreaterThanOrEqualTo(third)) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject[] array) {
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                if (!array[i].isGreaterThan(array[i - 1])) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive NTH = new Primitive(Symbol.NTH, "n list"){

        public LispObject execute(LispObject first, LispObject second) {
            return second.NTH(first);
        }
    };
    private static final Primitive _SET_NTH = new Primitive("%set-nth", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int index = Fixnum.getValue(first);
            if (index < 0) {
                Lisp.error(new TypeError("(SETF NTH): invalid index " + index + "."));
            }
            int i = 0;
            while (true) {
                if (i == index) {
                    second.setCar(third);
                    return third;
                }
                if ((second = second.cdr()) == Lisp.NIL) {
                    return Lisp.error(new LispError("(SETF NTH): the index " + index + "is too large."));
                }
                ++i;
            }
        }
    };
    private static final Primitive NTHCDR = new Primitive(Symbol.NTHCDR, "n list"){

        public LispObject execute(LispObject first, LispObject second) {
            int index = Fixnum.getValue(first);
            if (index < 0) {
                return Lisp.type_error(first, Lisp.list(Symbol.INTEGER, Fixnum.ZERO));
            }
            for (int i = 0; i < index; ++i) {
                if ((second = second.cdr()) != Lisp.NIL) continue;
                return Lisp.NIL;
            }
            return second;
        }
    };
    private static final Primitive ERROR = new Primitive(Symbol.ERROR, "datum &rest arguments"){

        public LispObject execute(LispObject[] args) {
            Error e = new Error();
            e.printStackTrace();
            System.out.println("ERROR placeholder called with arguments:");
            if (args.length == 1 && args[0] instanceof Condition) {
                System.out.println(args[0].writeToString());
                System.out.println(((Condition)args[0]).getConditionReport());
            } else {
                for (LispObject a : args) {
                    System.out.println(a.writeToString());
                }
            }
            System.exit(1);
            return Lisp.NIL;
        }
    };
    private static final Primitive AUTOCOMPILE = new Primitive(Symbol.AUTOCOMPILE, "function"){

        public LispObject execute(LispObject function) {
            return Lisp.NIL;
        }
    };
    private static final Primitive SIGNAL = new Primitive(Symbol.SIGNAL, "datum &rest arguments"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            if (args[0] instanceof Condition) {
                return Lisp.error((Condition)args[0]);
            }
            return Lisp.error(new SimpleCondition());
        }
    };
    private static final Primitive UNDEFINED_FUNCTION_CALLED = new Primitive(Symbol.UNDEFINED_FUNCTION_CALLED, "name arguments"){

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.error(new UndefinedFunction(first));
        }
    };
    private static final Primitive _FORMAT = new Primitive("%format", Lisp.PACKAGE_SYS, false, "destination control-string &rest args"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispObject destination = first;
            LispObject[] _args = new LispObject[]{second, third};
            String s = this._format(_args);
            return this.outputFormattedString(s, destination);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            LispObject destination = first;
            LispObject[] _args = new LispObject[]{second, third, fourth};
            String s = this._format(_args);
            return this.outputFormattedString(s, destination);
        }

        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject destination = args[0];
            LispObject[] _args = new LispObject[args.length - 1];
            for (int i = 0; i < _args.length; ++i) {
                _args[i] = args[i + 1];
            }
            String s = this._format(_args);
            return this.outputFormattedString(s, destination);
        }

        private final String _format(LispObject[] args) {
            LispObject formatControl = args[0];
            LispObject formatArguments = Lisp.NIL;
            for (int i = 1; i < args.length; ++i) {
                formatArguments = new Cons(args[i], formatArguments);
            }
            formatArguments = formatArguments.nreverse();
            return Lisp.format(formatControl, formatArguments);
        }

        private final LispObject outputFormattedString(String s, LispObject destination) {
            if (destination == Lisp.T) {
                Lisp.checkCharacterOutputStream(Symbol.STANDARD_OUTPUT.symbolValue())._writeString(s);
                return Lisp.NIL;
            }
            if (destination == Lisp.NIL) {
                return new SimpleString(s);
            }
            if (destination instanceof TwoWayStream) {
                Stream out = ((TwoWayStream)destination).getOutputStream();
                if (out instanceof Stream) {
                    out._writeString(s);
                    return Lisp.NIL;
                }
                Lisp.error(new TypeError("The value " + destination.writeToString() + " is not a character output stream."));
            }
            if (destination instanceof Stream) {
                ((Stream)destination)._writeString(s);
                return Lisp.NIL;
            }
            return Lisp.NIL;
        }
    };
    private static final Symbol _SIMPLE_FORMAT_FUNCTION_ = Lisp.internSpecial("*SIMPLE-FORMAT-FUNCTION*", Lisp.PACKAGE_SYS, _FORMAT);
    private static final Primitive _DEFUN = new Primitive("%defun", Lisp.PACKAGE_SYS, true, "name definition"){

        public LispObject execute(LispObject name, LispObject definition) {
            if (name instanceof Symbol) {
                Symbol symbol = (Symbol)name;
                if (symbol.getSymbolFunction() instanceof SpecialOperator) {
                    String message = symbol.getName() + " is a special operator and may not be redefined.";
                    return Lisp.error(new ProgramError(message));
                }
            } else if (!Lisp.isValidSetfFunctionName(name)) {
                return Lisp.type_error(name, Lisp.FUNCTION_NAME);
            }
            if (definition instanceof Function) {
                Symbol.FSET.execute(name, definition, Lisp.NIL, ((Function)definition).getLambdaList());
                return name;
            }
            return Lisp.type_error(definition, Symbol.FUNCTION);
        }
    };
    private static final Primitive FDEFINITION_BLOCK_NAME = new Primitive("fdefinition-block-name", Lisp.PACKAGE_SYS, true, "function-name"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol) {
                return arg;
            }
            if (Lisp.isValidSetfFunctionName(arg)) {
                return arg.cadr();
            }
            return Lisp.type_error(arg, Lisp.FUNCTION_NAME);
        }
    };
    private static final Primitive MACRO_FUNCTION = new Primitive(Symbol.MACRO_FUNCTION, "symbol &optional environment"){

        public LispObject execute(LispObject arg) {
            LispObject obj = arg.getSymbolFunction();
            if (obj instanceof AutoloadMacro) {
                ((AutoloadMacro)obj).load();
                obj = arg.getSymbolFunction();
            }
            if (obj instanceof MacroObject) {
                return ((MacroObject)obj).expander;
            }
            if (obj instanceof SpecialOperator) {
                obj = Lisp.get(arg, Symbol.MACROEXPAND_MACRO, Lisp.NIL);
                if (obj instanceof AutoloadMacro) {
                    ((AutoloadMacro)obj).load();
                    obj = Lisp.get(arg, Symbol.MACROEXPAND_MACRO, Lisp.NIL);
                }
                if (obj instanceof MacroObject) {
                    return ((MacroObject)obj).expander;
                }
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject first, LispObject second) {
            LispObject obj;
            if (second != Lisp.NIL) {
                Environment env = Lisp.checkEnvironment(second);
                obj = env.lookupFunction(first);
            } else {
                obj = first.getSymbolFunction();
            }
            if (obj instanceof AutoloadMacro) {
                ((AutoloadMacro)obj).load();
                obj = first.getSymbolFunction();
            }
            if (obj instanceof MacroObject) {
                return ((MacroObject)obj).expander;
            }
            if (obj instanceof SpecialOperator) {
                obj = Lisp.get(first, Symbol.MACROEXPAND_MACRO, Lisp.NIL);
                if (obj instanceof AutoloadMacro) {
                    ((AutoloadMacro)obj).load();
                    obj = Lisp.get(first, Symbol.MACROEXPAND_MACRO, Lisp.NIL);
                }
                if (obj instanceof MacroObject) {
                    return ((MacroObject)obj).expander;
                }
            }
            return Lisp.NIL;
        }
    };
    private static final SpecialOperator DEFMACRO = new SpecialOperator(Symbol.DEFMACRO){

        public LispObject execute(LispObject args, Environment env) {
            Symbol symbol = Lisp.checkSymbol(args.car());
            LispObject lambdaList = Lisp.checkList(args.cadr());
            LispObject body = args.cddr();
            Cons block = new Cons(Symbol.BLOCK, (LispObject)new Cons(symbol, body));
            Cons toBeApplied = Lisp.list(Symbol.FUNCTION, Lisp.list(Symbol.LAMBDA, lambdaList, block));
            LispThread thread = LispThread.currentThread();
            Symbol formArg = Lisp.gensym("FORM-", thread);
            Symbol envArg = Lisp.gensym("ENV-", thread);
            Cons expander = Lisp.list(Symbol.LAMBDA, Lisp.list(formArg, envArg), Lisp.list(Symbol.APPLY, toBeApplied, Lisp.list(Symbol.CDR, formArg)));
            Closure expansionFunction = new Closure((LispObject)expander, env);
            MacroObject macroObject = new MacroObject((LispObject)symbol, expansionFunction);
            if (symbol.getSymbolFunction() instanceof SpecialOperator) {
                Lisp.put(symbol, Symbol.MACROEXPAND_MACRO, macroObject);
            } else {
                symbol.setSymbolFunction(macroObject);
            }
            macroObject.setLambdaList(lambdaList);
            thread._values = null;
            return symbol;
        }
    };
    private static final Primitive MAKE_MACRO = new Primitive("make-macro", Lisp.PACKAGE_SYS, true, "name expansion-function"){

        public LispObject execute(LispObject first, LispObject second) {
            return new MacroObject(first, second);
        }
    };
    private static final Primitive MACRO_FUNCTION_P = new Primitive("macro-function-p", Lisp.PACKAGE_SYS, true, "value"){

        public LispObject execute(LispObject arg) {
            return arg instanceof MacroObject ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive MAKE_SYMBOL_MACRO = new Primitive("make-symbol-macro", Lisp.PACKAGE_SYS, true, "expansion"){

        public LispObject execute(LispObject arg) {
            return new SymbolMacro(arg);
        }
    };
    private static final Primitive SYMBOL_MACRO_P = new Primitive("symbol-macro-p", Lisp.PACKAGE_SYS, true, "value"){

        public LispObject execute(LispObject arg) {
            return arg instanceof SymbolMacro ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive _DEFPARAMETER = new Primitive("%defparameter", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Symbol symbol = Lisp.checkSymbol(first);
            if (third instanceof AbstractString) {
                symbol.setDocumentation(Symbol.VARIABLE, third);
            } else if (third != Lisp.NIL) {
                Lisp.type_error(third, Symbol.STRING);
            }
            symbol.initializeSpecial(second);
            return symbol;
        }
    };
    private static final Primitive _DEFVAR = new Primitive("%defvar", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            Symbol symbol = Lisp.checkSymbol(arg);
            symbol.setSpecial(true);
            return symbol;
        }

        public LispObject execute(LispObject first, LispObject second) {
            Symbol symbol = Lisp.checkSymbol(first);
            symbol.initializeSpecial(second);
            return symbol;
        }
    };
    private static final Primitive _DEFCONSTANT = new Primitive("%defconstant", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Symbol symbol = Lisp.checkSymbol(first);
            if (third != Lisp.NIL) {
                if (third instanceof AbstractString) {
                    symbol.setDocumentation(Symbol.VARIABLE, third);
                } else {
                    return Lisp.type_error(third, Symbol.STRING);
                }
            }
            symbol.initializeConstant(second);
            return symbol;
        }
    };
    private static final SpecialOperator COND = new SpecialOperator(Symbol.COND, "&rest clauses"){

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            while (args != Lisp.NIL) {
                LispObject clause = args.car();
                result = Lisp.eval(clause.car(), env, thread);
                thread._values = null;
                if (result != Lisp.NIL) {
                    LispObject body = clause.cdr();
                    while (body != Lisp.NIL) {
                        result = Lisp.eval(body.car(), env, thread);
                        body = ((Cons)body).cdr;
                    }
                    return result;
                }
                args = ((Cons)args).cdr;
            }
            return result;
        }
    };
    private static final SpecialOperator CASE = new SpecialOperator(Symbol.CASE, "keyform &body cases"){

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            LispObject key = Lisp.eval(args.car(), env, thread);
            for (args = args.cdr(); args != Lisp.NIL; args = args.cdr()) {
                LispObject candidate;
                LispObject keys;
                LispObject clause = args.car();
                boolean match = false;
                if (keys.listp()) {
                    for (keys = clause.car(); keys != Lisp.NIL; keys = keys.cdr()) {
                        candidate = keys.car();
                        if (!key.eql(candidate)) continue;
                        match = true;
                        break;
                    }
                } else {
                    candidate = keys;
                    if (candidate == Lisp.T || candidate == Symbol.OTHERWISE) {
                        match = true;
                    } else if (key.eql(candidate)) {
                        match = true;
                    }
                }
                if (!match) continue;
                return Lisp.progn(clause.cdr(), env, thread);
            }
            return Lisp.NIL;
        }
    };
    private static final SpecialOperator ECASE = new SpecialOperator(Symbol.ECASE, "keyform &body cases"){

        public LispObject execute(LispObject args, Environment env) {
            LispObject clauses;
            LispThread thread = LispThread.currentThread();
            LispObject key = Lisp.eval(args.car(), env, thread);
            for (clauses = args.cdr(); clauses != Lisp.NIL; clauses = clauses.cdr()) {
                LispObject candidate;
                LispObject keys;
                LispObject clause = clauses.car();
                boolean match = false;
                if (keys.listp()) {
                    for (keys = clause.car(); keys != Lisp.NIL; keys = keys.cdr()) {
                        candidate = keys.car();
                        if (!key.eql(candidate)) continue;
                        match = true;
                        break;
                    }
                } else {
                    candidate = keys;
                    if (key.eql(candidate)) {
                        match = true;
                    }
                }
                if (!match) continue;
                return Lisp.progn(clause.cdr(), env, thread);
            }
            LispObject expectedType = Lisp.NIL;
            for (clauses = args.cdr(); clauses != Lisp.NIL; clauses = clauses.cdr()) {
                LispObject clause = clauses.car();
                LispObject keys = clause.car();
                if (keys.listp()) {
                    while (keys != Lisp.NIL) {
                        expectedType = expectedType.push(keys.car());
                        keys = keys.cdr();
                    }
                    continue;
                }
                expectedType = expectedType.push(keys);
            }
            expectedType = expectedType.nreverse();
            expectedType = expectedType.push(Symbol.MEMBER);
            return Lisp.type_error(key, expectedType);
        }
    };
    private static final Primitive UPGRADED_ARRAY_ELEMENT_TYPE = new Primitive(Symbol.UPGRADED_ARRAY_ELEMENT_TYPE, "typespec &optional environment"){

        public LispObject execute(LispObject arg) {
            return Lisp.getUpgradedArrayElementType(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.getUpgradedArrayElementType(first);
        }
    };
    private static final Primitive ARRAY_RANK = new Primitive(Symbol.ARRAY_RANK, "array"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(Lisp.checkArray(arg).getRank());
        }
    };
    private static final Primitive ARRAY_DIMENSIONS = new Primitive(Symbol.ARRAY_DIMENSIONS, "array"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkArray(arg).getDimensions();
        }
    };
    private static final Primitive ARRAY_DIMENSION = new Primitive(Symbol.ARRAY_DIMENSION, "array axis-number"){

        public LispObject execute(LispObject first, LispObject second) {
            AbstractArray array = Lisp.checkArray(first);
            return Fixnum.getInstance(array.getDimension(Fixnum.getValue(second)));
        }
    };
    private static final Primitive ARRAY_TOTAL_SIZE = new Primitive(Symbol.ARRAY_TOTAL_SIZE, "array"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(Lisp.checkArray(arg).getTotalSize());
        }
    };
    private static final Primitive ARRAY_ELEMENT_TYPE = new Primitive(Symbol.ARRAY_ELEMENT_TYPE, "array"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkArray(arg).getElementType();
        }
    };
    private static final Primitive ADJUSTABLE_ARRAY_P = new Primitive(Symbol.ADJUSTABLE_ARRAY_P, "array"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkArray(arg).isAdjustable() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive ARRAY_DISPLACEMENT = new Primitive(Symbol.ARRAY_DISPLACEMENT, "array"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkArray(arg).arrayDisplacement();
        }
    };
    private static final Primitive ARRAY_IN_BOUNDS_P = new Primitive(Symbol.ARRAY_IN_BOUNDS_P, "array &rest subscripts"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispObject r = args[0];
            AbstractArray array = Lisp.checkArray(r);
            int rank = array.getRank();
            if (rank != args.length - 1) {
                FastStringBuffer sb = new FastStringBuffer("ARRAY-IN-BOUNDS-P: ");
                sb.append("wrong number of subscripts (");
                sb.append(args.length - 1);
                sb.append(") for array of rank ");
                sb.append(rank);
                Lisp.error(new ProgramError(sb.toString()));
            }
            for (int i = 0; i < rank; ++i) {
                LispObject arg = args[i + 1];
                if (arg instanceof Fixnum) {
                    int subscript = ((Fixnum)arg).value;
                    if (subscript >= 0 && subscript < array.getDimension(i)) continue;
                    return Lisp.NIL;
                }
                if (arg instanceof Bignum) {
                    return Lisp.NIL;
                }
                Lisp.type_error(arg, Symbol.INTEGER);
            }
            return Lisp.T;
        }
    };
    private static final Primitive _ARRAY_ROW_MAJOR_INDEX = new Primitive("%array-row-major-index", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            AbstractArray array = Lisp.checkArray(first);
            LispObject[] subscripts = second.copyToArray();
            return Lisp.number(array.getRowMajorIndex(subscripts));
        }
    };
    private static final Primitive AREF = new Primitive(Symbol.AREF, "array &rest subscripts"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            AbstractArray array = Lisp.checkArray(arg);
            if (array.getRank() == 0) {
                return array.AREF(0);
            }
            FastStringBuffer sb = new FastStringBuffer("Wrong number of subscripts (0) for array of rank ");
            sb.append(array.getRank());
            sb.append('.');
            return Lisp.error(new ProgramError(sb.toString()));
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.AREF(second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return Lisp.checkArray(first).get(new int[]{Fixnum.getValue(second), Fixnum.getValue(third)});
        }

        public LispObject execute(LispObject[] args) {
            AbstractArray array = Lisp.checkArray(args[0]);
            int[] subs = new int[args.length - 1];
            int i = subs.length;
            while (i-- > 0) {
                subs[i] = Fixnum.getValue(args[i + 1]);
            }
            return array.get(subs);
        }
    };
    private static final Primitive ASET = new Primitive("aset", Lisp.PACKAGE_SYS, true, "array subscripts new-element"){

        public LispObject execute(LispObject first, LispObject second) {
            if (!(first instanceof ZeroRankArray)) {
                return Lisp.error(new TypeError("The value " + first.writeToString() + " is not an array of rank 0."));
            }
            ZeroRankArray array = (ZeroRankArray)first;
            array.aset(0, second);
            return second;
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            first.aset(second, third);
            return third;
        }

        public LispObject execute(LispObject[] args) {
            AbstractArray array = Lisp.checkArray(args[0]);
            int nsubs = args.length - 2;
            int[] subs = new int[nsubs];
            int i = nsubs;
            while (i-- > 0) {
                subs[i] = Fixnum.getValue(args[i + 1]);
            }
            LispObject newValue = args[args.length - 1];
            array.set(subs, newValue);
            return newValue;
        }
    };
    private static final Primitive ROW_MAJOR_AREF = new Primitive(Symbol.ROW_MAJOR_AREF, "array index"){

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.checkArray(first).AREF(Fixnum.getValue(second));
        }
    };
    private static final Primitive VECTOR = new Primitive(Symbol.VECTOR, "&rest objects"){

        public LispObject execute(LispObject[] args) {
            return new SimpleVector(args);
        }
    };
    private static final Primitive FILL_POINTER = new Primitive(Symbol.FILL_POINTER, "vector"){

        public LispObject execute(LispObject arg) {
            AbstractArray aa;
            if (arg instanceof AbstractArray && (aa = (AbstractArray)arg).hasFillPointer()) {
                return Fixnum.getInstance(aa.getFillPointer());
            }
            return Lisp.type_error(arg, Lisp.list(Symbol.AND, Symbol.VECTOR, Lisp.list(Symbol.SATISFIES, Symbol.ARRAY_HAS_FILL_POINTER_P)));
        }
    };
    private static final Primitive _SET_FILL_POINTER = new Primitive("%set-fill-pointer", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof AbstractVector) {
                AbstractVector v = (AbstractVector)first;
                if (v.hasFillPointer()) {
                    v.setFillPointer(second);
                } else {
                    v.noFillPointer();
                }
                return second;
            }
            return Lisp.type_error(first, Lisp.list(Symbol.AND, Symbol.VECTOR, Lisp.list(Symbol.SATISFIES, Symbol.ARRAY_HAS_FILL_POINTER_P)));
        }
    };
    private static final Primitive VECTOR_PUSH = new Primitive(Symbol.VECTOR_PUSH, "new-element vector"){

        public LispObject execute(LispObject first, LispObject second) {
            AbstractVector v = Lisp.checkVector(second);
            int fillPointer = v.getFillPointer();
            if (fillPointer < 0) {
                v.noFillPointer();
            }
            if (fillPointer >= v.capacity()) {
                return Lisp.NIL;
            }
            v.aset(fillPointer, first);
            v.setFillPointer(fillPointer + 1);
            return Fixnum.getInstance(fillPointer);
        }
    };
    private static final Primitive VECTOR_PUSH_EXTEND = new Primitive(Symbol.VECTOR_PUSH_EXTEND, "new-element vector &optional extension"){

        public LispObject execute(LispObject first, LispObject second) {
            return second.VECTOR_PUSH_EXTEND(first);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return second.VECTOR_PUSH_EXTEND(first, third);
        }
    };
    private static final Primitive VECTOR_POP = new Primitive(Symbol.VECTOR_POP, "vector"){

        public LispObject execute(LispObject arg) {
            AbstractVector v = Lisp.checkVector(arg);
            int fillPointer = v.getFillPointer();
            if (fillPointer < 0) {
                v.noFillPointer();
            }
            if (fillPointer == 0) {
                Lisp.error(new LispError("nothing left to pop"));
            }
            int newFillPointer = v.checkIndex(fillPointer - 1);
            LispObject element = v.AREF(newFillPointer);
            v.setFillPointer(newFillPointer);
            return element;
        }
    };
    private static final Primitive TYPE_OF = new Primitive(Symbol.TYPE_OF, "object"){

        public LispObject execute(LispObject arg) {
            return arg.typeOf();
        }
    };
    private static final Primitive CLASS_OF = new Primitive(Symbol.CLASS_OF, "object"){

        public LispObject execute(LispObject arg) {
            return arg.classOf();
        }
    };
    private static final Primitive SIMPLE_TYPEP = new Primitive("simple-typep", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            return first.typep(second);
        }
    };
    private static final Primitive FUNCTION_LAMBDA_EXPRESSION = new Primitive(Symbol.FUNCTION_LAMBDA_EXPRESSION, "function"){

        public LispObject execute(LispObject arg) {
            LispObject value3;
            LispObject value2;
            LispObject value1;
            if (arg instanceof CompiledClosure) {
                value1 = Lisp.NIL;
                value2 = Lisp.T;
                LispObject name = ((CompiledClosure)arg).getLambdaName();
                value3 = name != null ? name : Lisp.NIL;
            } else if (arg instanceof Closure) {
                Closure closure = (Closure)arg;
                LispObject expr = closure.getBody();
                expr = new Cons(closure.getLambdaList(), expr);
                value1 = expr = new Cons(Symbol.LAMBDA, expr);
                Environment env = closure.getEnvironment();
                value2 = env == null || env.isEmpty() ? Lisp.NIL : env;
                LispObject name = ((Closure)arg).getLambdaName();
                value3 = name != null ? name : Lisp.NIL;
            } else if (arg instanceof Function) {
                value1 = Lisp.NIL;
                value2 = Lisp.T;
                value3 = ((Function)arg).getLambdaName();
            } else if (arg instanceof StandardGenericFunction) {
                value1 = Lisp.NIL;
                value2 = Lisp.T;
                value3 = ((StandardGenericFunction)arg).getGenericFunctionName();
            } else {
                return Lisp.type_error(arg, Symbol.FUNCTION);
            }
            return LispThread.currentThread().setValues(value1, value2, value3);
        }
    };
    public static final Primitive FUNCALL = new Primitive(Symbol.FUNCALL, "function &rest args"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return LispThread.currentThread().execute(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return LispThread.currentThread().execute(first, second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return LispThread.currentThread().execute(first, second, third);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return LispThread.currentThread().execute(first, second, third, fourth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
            return LispThread.currentThread().execute(first, second, third, fourth, fifth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            return LispThread.currentThread().execute(first, second, third, fourth, fifth, sixth);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
            return LispThread.currentThread().execute(first, second, third, fourth, fifth, sixth, seventh);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eigth) {
            return LispThread.currentThread().execute(first, second, third, fourth, fifth, sixth, seventh, eigth);
        }

        public LispObject execute(LispObject[] args) {
            int length = args.length - 1;
            if (length == 8) {
                return LispThread.currentThread().execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            }
            LispObject[] newArgs = new LispObject[length];
            System.arraycopy(args, 1, newArgs, 0, length);
            return LispThread.currentThread().execute(args[0], newArgs);
        }
    };
    public static final Primitive APPLY = new Primitive(Symbol.APPLY, "function &rest args"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject fun, LispObject args) {
            LispThread thread = LispThread.currentThread();
            int length = args.length();
            switch (length) {
                case 0: {
                    return thread.execute(fun);
                }
                case 1: {
                    return thread.execute(fun, ((Cons)args).car);
                }
                case 2: {
                    Cons cons = (Cons)args;
                    return thread.execute(fun, cons.car, ((Cons)cons.cdr).car);
                }
                case 3: {
                    return thread.execute(fun, args.car(), args.cadr(), args.cdr().cdr().car());
                }
            }
            LispObject[] funArgs = new LispObject[length];
            int j = 0;
            while (args != Lisp.NIL) {
                funArgs[j++] = args.car();
                args = args.cdr();
            }
            return Lisp.funcall(fun, funArgs, thread);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (third.listp()) {
                int numFunArgs = 1 + third.length();
                LispObject[] funArgs = new LispObject[numFunArgs];
                funArgs[0] = second;
                int j = 1;
                while (third != Lisp.NIL) {
                    funArgs[j++] = third.car();
                    third = third.cdr();
                }
                return Lisp.funcall(first, funArgs, LispThread.currentThread());
            }
            return Lisp.type_error(third, Symbol.LIST);
        }

        public LispObject execute(LispObject[] args) {
            int numArgs = args.length;
            LispObject spread = args[numArgs - 1];
            if (spread.listp()) {
                int numFunArgs = numArgs - 2 + spread.length();
                LispObject[] funArgs = new LispObject[numFunArgs];
                int j = 0;
                for (int i = 1; i < numArgs - 1; ++i) {
                    funArgs[j++] = args[i];
                }
                while (spread != Lisp.NIL) {
                    funArgs[j++] = spread.car();
                    spread = spread.cdr();
                }
                return Lisp.funcall(args[0], funArgs, LispThread.currentThread());
            }
            return Lisp.type_error(spread, Symbol.LIST);
        }
    };
    private static final Primitive MAPCAR = new Primitive(Symbol.MAPCAR, "function &rest lists"){

        public LispObject execute(LispObject fun, LispObject list) {
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            Cons splice = null;
            while (list != Lisp.NIL) {
                if (!(list instanceof Cons)) {
                    return Lisp.type_error(list, Symbol.LIST);
                }
                Cons cons = (Cons)list;
                LispObject obj = thread.execute(fun, cons.car);
                if (splice == null) {
                    splice = new Cons(obj, result);
                    result = splice;
                } else {
                    Cons c = new Cons(obj);
                    splice.cdr = c;
                    splice = c;
                }
                list = cons.cdr;
            }
            thread._values = null;
            return result;
        }

        public LispObject execute(LispObject fun, LispObject list1, LispObject list2) {
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            Cons splice = null;
            while (list1 != Lisp.NIL && list2 != Lisp.NIL) {
                LispObject obj = thread.execute(fun, list1.car(), list2.car());
                if (splice == null) {
                    splice = new Cons(obj, result);
                    result = splice;
                } else {
                    Cons cons = new Cons(obj);
                    splice.cdr = cons;
                    splice = cons;
                }
                list1 = list1.cdr();
                list2 = list2.cdr();
            }
            thread._values = null;
            return result;
        }

        public LispObject execute(LispObject[] args) {
            int numArgs = args.length;
            if (numArgs < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            int commonLength = -1;
            for (int i = 1; i < numArgs; ++i) {
                if (!args[i].listp()) {
                    Lisp.type_error(args[i], Symbol.LIST);
                }
                int len = args[i].length();
                if (commonLength < 0) {
                    commonLength = len;
                    continue;
                }
                if (commonLength <= len) continue;
                commonLength = len;
            }
            LispThread thread = LispThread.currentThread();
            LispObject[] results = new LispObject[commonLength];
            int numFunArgs = numArgs - 1;
            LispObject[] funArgs = new LispObject[numFunArgs];
            for (int i = 0; i < commonLength; ++i) {
                int j;
                for (j = 0; j < numFunArgs; ++j) {
                    funArgs[j] = args[j + 1].car();
                }
                results[i] = Lisp.funcall(args[0], funArgs, thread);
                for (j = 1; j < numArgs; ++j) {
                    args[j] = args[j].cdr();
                }
            }
            thread._values = null;
            LispObject result = Lisp.NIL;
            int i = commonLength;
            while (i-- > 0) {
                result = new Cons(results[i], result);
            }
            return result;
        }
    };
    private static final Primitive MAPC = new Primitive(Symbol.MAPC, "function &rest lists"){

        public LispObject execute(LispObject fun, LispObject list) {
            LispThread thread = LispThread.currentThread();
            LispObject result = list;
            while (list != Lisp.NIL) {
                if (!(list instanceof Cons)) {
                    return Lisp.type_error(list, Symbol.LIST);
                }
                Cons cons = (Cons)list;
                thread.execute(fun, cons.car);
                list = cons.cdr;
            }
            thread._values = null;
            return result;
        }

        public LispObject execute(LispObject fun, LispObject list1, LispObject list2) {
            LispThread thread = LispThread.currentThread();
            LispObject result = list1;
            while (list1 != Lisp.NIL && list2 != Lisp.NIL) {
                thread.execute(fun, list1.car(), list2.car());
                list1 = ((Cons)list1).cdr;
                list2 = ((Cons)list2).cdr;
            }
            thread._values = null;
            return result;
        }

        public LispObject execute(LispObject[] args) {
            int numArgs = args.length;
            if (numArgs < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            int commonLength = -1;
            for (int i = 1; i < numArgs; ++i) {
                if (!args[i].listp()) {
                    Lisp.type_error(args[i], Symbol.LIST);
                }
                int len = args[i].length();
                if (commonLength < 0) {
                    commonLength = len;
                    continue;
                }
                if (commonLength <= len) continue;
                commonLength = len;
            }
            LispThread thread = LispThread.currentThread();
            LispObject result = args[1];
            int numFunArgs = numArgs - 1;
            LispObject[] funArgs = new LispObject[numFunArgs];
            for (int i = 0; i < commonLength; ++i) {
                int j;
                for (j = 0; j < numFunArgs; ++j) {
                    funArgs[j] = args[j + 1].car();
                }
                Lisp.funcall(args[0], funArgs, thread);
                for (j = 1; j < numArgs; ++j) {
                    args[j] = args[j].cdr();
                }
            }
            thread._values = null;
            return result;
        }
    };
    private static final Primitive MACROEXPAND = new Primitive(Symbol.MACROEXPAND, "form &optional env"){

        public LispObject execute(LispObject form) {
            return Lisp.macroexpand(form, new Environment(), LispThread.currentThread());
        }

        public LispObject execute(LispObject form, LispObject env) {
            return Lisp.macroexpand(form, env != Lisp.NIL ? Lisp.checkEnvironment(env) : new Environment(), LispThread.currentThread());
        }
    };
    private static final Primitive MACROEXPAND_1 = new Primitive(Symbol.MACROEXPAND_1, "form &optional env"){

        public LispObject execute(LispObject form) {
            return Lisp.macroexpand_1(form, new Environment(), LispThread.currentThread());
        }

        public LispObject execute(LispObject form, LispObject env) {
            return Lisp.macroexpand_1(form, env != Lisp.NIL ? Lisp.checkEnvironment(env) : new Environment(), LispThread.currentThread());
        }
    };
    private static final Primitive GENSYM = new Primitive(Symbol.GENSYM, "&optional x"){

        public LispObject execute() {
            return Lisp.gensym("G", LispThread.currentThread());
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof Fixnum) {
                int n = ((Fixnum)arg).value;
                if (n >= 0) {
                    FastStringBuffer sb = new FastStringBuffer('G');
                    sb.append(n);
                    return new Symbol(new SimpleString(sb));
                }
            } else if (arg instanceof Bignum) {
                BigInteger n = ((Bignum)arg).value;
                if (n.signum() >= 0) {
                    FastStringBuffer sb = new FastStringBuffer('G');
                    sb.append(n.toString());
                    return new Symbol(new SimpleString(sb));
                }
            } else if (arg instanceof AbstractString) {
                return Lisp.gensym(arg.getStringValue(), LispThread.currentThread());
            }
            return Lisp.type_error(arg, Lisp.list(Symbol.OR, Symbol.STRING, Symbol.UNSIGNED_BYTE));
        }
    };
    private static final Primitive STRING = new Primitive(Symbol.STRING, "x"){

        public LispObject execute(LispObject arg) {
            return arg.STRING();
        }
    };
    private static final Primitive INTERN = new Primitive(Symbol.INTERN, "string &optional package"){

        public LispObject execute(LispObject arg) {
            SimpleString s = arg instanceof SimpleString ? (SimpleString)arg : new SimpleString(arg.getStringValue());
            LispThread thread = LispThread.currentThread();
            Package pkg = (Package)Symbol._PACKAGE_.symbolValue(thread);
            return pkg.intern(s, thread);
        }

        public LispObject execute(LispObject first, LispObject second) {
            SimpleString s = first instanceof SimpleString ? (SimpleString)first : new SimpleString(first.getStringValue());
            Package pkg = Lisp.coerceToPackage(second);
            return pkg.intern(s, LispThread.currentThread());
        }
    };
    private static final Primitive UNINTERN = new Primitive(Symbol.UNINTERN, "symbol &optional package"){

        public LispObject execute(LispObject[] args) {
            if (args.length == 0 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Symbol symbol = Lisp.checkSymbol(args[0]);
            Package pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            return pkg.unintern(symbol);
        }
    };
    private static final Primitive FIND_PACKAGE = new Primitive(Symbol.FIND_PACKAGE, "name"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Package) {
                return arg;
            }
            if (arg instanceof AbstractString) {
                Package pkg = Packages.findPackage(arg.getStringValue());
                return pkg != null ? pkg : Lisp.NIL;
            }
            if (arg instanceof Symbol) {
                Package pkg = Packages.findPackage(Lisp.checkSymbol(arg).getName());
                return pkg != null ? pkg : Lisp.NIL;
            }
            if (arg instanceof LispCharacter) {
                String packageName = String.valueOf(new char[]{((LispCharacter)arg).getValue()});
                Package pkg = Packages.findPackage(packageName);
                return pkg != null ? pkg : Lisp.NIL;
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive _MAKE_PACKAGE = new Primitive("%make-package", Lisp.PACKAGE_SYS, false){

        public LispObject execute() {
            return new Package();
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispObject use;
            String nick;
            LispObject nicknames;
            String packageName = Lisp.javaString(first);
            Package pkg = Packages.findPackage(packageName);
            if (pkg != null) {
                Lisp.error(new LispError("Package " + packageName + " already exists."));
            }
            if ((nicknames = Lisp.checkList(second)) != Lisp.NIL) {
                for (LispObject list = nicknames; list != Lisp.NIL; list = list.cdr()) {
                    nick = Lisp.javaString(list.car());
                    if (Packages.findPackage(nick) == null) continue;
                    Lisp.error(new PackageError("A package named " + nick + " already exists."));
                }
            }
            if ((use = Lisp.checkList(third)) != Lisp.NIL) {
                for (LispObject list = use; list != Lisp.NIL; list = list.cdr()) {
                    String s;
                    Package p;
                    LispObject obj = list.car();
                    if (obj instanceof Package || (p = Packages.findPackage(s = Lisp.javaString(obj))) != null) continue;
                    Lisp.error(new LispError(obj.writeToString() + " is not the name of a package."));
                    return Lisp.NIL;
                }
            }
            pkg = Packages.createPackage(packageName);
            while (nicknames != Lisp.NIL) {
                nick = Lisp.javaString(nicknames.car());
                pkg.addNickname(nick);
                nicknames = nicknames.cdr();
            }
            while (use != Lisp.NIL) {
                LispObject obj = use.car();
                if (obj instanceof Package) {
                    pkg.usePackage((Package)obj);
                } else {
                    String s = Lisp.javaString(obj);
                    Package p = Packages.findPackage(s);
                    if (p == null) {
                        Lisp.error(new LispError(obj.writeToString() + " is not the name of a package."));
                        return Lisp.NIL;
                    }
                    pkg.usePackage(p);
                }
                use = use.cdr();
            }
            return pkg;
        }
    };
    private static final Primitive _IN_PACKAGE = new Primitive("%in-package", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            String packageName = Lisp.javaString(arg);
            Package pkg = Packages.findPackage(packageName);
            if (pkg == null) {
                return Lisp.error(new PackageError("The name " + packageName + " does not designate any package."));
            }
            SpecialBinding binding = LispThread.currentThread().getSpecialBinding(Symbol._PACKAGE_);
            if (binding != null) {
                binding.value = pkg;
            } else {
                Symbol._PACKAGE_.setSymbolValue(pkg);
            }
            return pkg;
        }
    };
    private static final Primitive USE_PACKAGE = new Primitive(Symbol.USE_PACKAGE, "packages-to-use &optional package"){

        public LispObject execute(LispObject[] args) {
            if (args.length < 1 || args.length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Package pkg = args.length == 2 ? Lisp.coerceToPackage(args[1]) : Lisp.getCurrentPackage();
            if (args[0].listp()) {
                for (LispObject list = args[0]; list != Lisp.NIL; list = list.cdr()) {
                    pkg.usePackage(Lisp.coerceToPackage(list.car()));
                }
            } else {
                pkg.usePackage(Lisp.coerceToPackage(args[0]));
            }
            return Lisp.T;
        }
    };
    private static final Primitive PACKAGE_SYMBOLS = new Primitive("package-symbols", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).getSymbols();
        }
    };
    private static final Primitive PACKAGE_INTERNAL_SYMBOLS = new Primitive("package-internal-symbols", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).PACKAGE_INTERNAL_SYMBOLS();
        }
    };
    private static final Primitive PACKAGE_EXTERNAL_SYMBOLS = new Primitive("package-external-symbols", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).PACKAGE_EXTERNAL_SYMBOLS();
        }
    };
    private static final Primitive PACKAGE_INHERITED_SYMBOLS = new Primitive("package-inherited-symbols", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPackage(arg).PACKAGE_INHERITED_SYMBOLS();
        }
    };
    private static final Primitive EXPORT = new Primitive(Symbol.EXPORT, "symbols &optional package"){

        public LispObject execute(LispObject arg) {
            Package pkg = (Package)Symbol._PACKAGE_.symbolValue();
            if (arg instanceof Cons) {
                for (LispObject list = arg; list != Lisp.NIL; list = list.cdr()) {
                    pkg.export(Lisp.checkSymbol(list.car()));
                }
            } else {
                pkg.export(Lisp.checkSymbol(arg));
            }
            return Lisp.T;
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof Cons) {
                Package pkg = Lisp.coerceToPackage(second);
                for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                    pkg.export(Lisp.checkSymbol(list.car()));
                }
            } else {
                Lisp.coerceToPackage(second).export(Lisp.checkSymbol(first));
            }
            return Lisp.T;
        }
    };
    private static final Primitive FIND_SYMBOL = new Primitive(Symbol.FIND_SYMBOL, "string &optional package"){

        public LispObject execute(LispObject arg) {
            return Lisp.getCurrentPackage().findSymbol(arg.getStringValue());
        }

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.coerceToPackage(second).findSymbol(first.getStringValue());
        }
    };
    private static final Primitive FSET = new Primitive("fset", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            return this.execute(first, second, Lisp.NIL, Lisp.NIL, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return this.execute(first, second, third, Lisp.NIL, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return this.execute(first, second, third, fourth, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
            Symbol symbol;
            if (first instanceof Symbol) {
                Primitives.checkRedefinition(first);
                symbol = Lisp.checkSymbol(first);
                symbol.setSymbolFunction(second);
                LispThread thread = LispThread.currentThread();
                LispObject sourcePathname = Lisp._SOURCE_.symbolValue(thread);
                LispObject sourcePosition = third;
                if (sourcePathname != Lisp.NIL) {
                    sourcePosition = Lisp._SOURCE_POSITION_.symbolValue(thread);
                }
                if (sourcePathname == Lisp.NIL) {
                    sourcePathname = Keyword.TOP_LEVEL;
                }
                if (sourcePathname != Keyword.TOP_LEVEL) {
                    Lisp.put(symbol, Symbol._SOURCE, new Cons(sourcePathname, third));
                } else {
                    Lisp.put(symbol, Symbol._SOURCE, sourcePathname);
                }
            } else if (Lisp.isValidSetfFunctionName(first)) {
                Primitives.checkRedefinition(first);
                symbol = Lisp.checkSymbol(first.cadr());
                Lisp.put(symbol, Symbol.SETF_FUNCTION, second);
            } else {
                return Lisp.type_error(first, Lisp.FUNCTION_NAME);
            }
            if (second instanceof Operator) {
                Operator op = (Operator)second;
                op.setLambdaName(first);
                if (fourth != Lisp.NIL) {
                    op.setLambdaList(fourth);
                }
                if (fifth != Lisp.NIL) {
                    op.setDocumentation(Symbol.FUNCTION, fifth);
                }
            }
            return second;
        }
    };
    private static final Primitive _SET_SYMBOL_PLIST = new Primitive("%set-symbol-plist", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkSymbol(first).setPropertyList(Lisp.checkList(second));
            return second;
        }
    };
    private static final Primitive GETF = new Primitive(Symbol.GETF, "plist indicator &optional default"){

        public LispObject execute(LispObject plist, LispObject indicator) {
            return Lisp.getf(plist, indicator, Lisp.NIL);
        }

        public LispObject execute(LispObject plist, LispObject indicator, LispObject defaultValue) {
            return Lisp.getf(plist, indicator, defaultValue);
        }
    };
    private static final Primitive GET = new Primitive(Symbol.GET, "symbol indicator &optional default"){

        public LispObject execute(LispObject symbol, LispObject indicator) {
            return Lisp.get(symbol, indicator, Lisp.NIL);
        }

        public LispObject execute(LispObject symbol, LispObject indicator, LispObject defaultValue) {
            return Lisp.get(symbol, indicator, defaultValue);
        }
    };
    private static final Primitive PUT = new Primitive("put", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject symbol, LispObject indicator, LispObject value) {
            return Lisp.put(Lisp.checkSymbol(symbol), indicator, value);
        }

        public LispObject execute(LispObject symbol, LispObject indicator, LispObject defaultValue, LispObject value) {
            return Lisp.put(Lisp.checkSymbol(symbol), indicator, value);
        }
    };
    private static final SpecialOperator MACROLET = new SpecialOperator(Symbol.MACROLET, "definitions &rest body"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            try {
                Environment ext = new Environment(env);
                for (LispObject defs = Lisp.checkList(args.car()); defs != Lisp.NIL; defs = defs.cdr()) {
                    LispObject def = Lisp.checkList(defs.car());
                    Symbol symbol = Lisp.checkSymbol(def.car());
                    Symbol make_expander_for_macrolet = Lisp.PACKAGE_SYS.intern("MAKE-EXPANDER-FOR-MACROLET");
                    LispObject expander = make_expander_for_macrolet.execute(def);
                    Closure expansionFunction = new Closure(expander, env);
                    MacroObject macroObject = new MacroObject((LispObject)symbol, expansionFunction);
                    ext.addFunctionBinding(symbol, macroObject);
                }
                LispObject lispObject = Lisp.progn(ext.processDeclarations(args.cdr()), ext, thread);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
    };
    private static final Primitive MAKE_EXPANDER_FOR_MACROLET = new Primitive("make-expander-for-macrolet", Lisp.PACKAGE_SYS, true, "definition"){

        public LispObject execute(LispObject definition) {
            Symbol symbol = Lisp.checkSymbol(definition.car());
            LispObject lambdaList = definition.cadr();
            LispObject body = definition.cddr();
            Cons block = new Cons(Symbol.BLOCK, (LispObject)new Cons(symbol, body));
            Cons toBeApplied = Lisp.list(Symbol.LAMBDA, lambdaList, block);
            LispThread thread = LispThread.currentThread();
            Symbol formArg = Lisp.gensym("WHOLE-", thread);
            Symbol envArg = Lisp.gensym("ENVIRONMENT-", thread);
            Cons expander = Lisp.list(Symbol.LAMBDA, Lisp.list(formArg, envArg), Lisp.list(Symbol.APPLY, toBeApplied, Lisp.list(Symbol.CDR, formArg)));
            return expander;
        }
    };
    private static final SpecialOperator TAGBODY = new SpecialOperator(Symbol.TAGBODY, "&rest statements"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            Environment ext = new Environment(env);
            try {
                LispObject lispObject = Lisp.processTagBody(args, Lisp.preprocessTagBody(args, ext), ext);
                return lispObject;
            }
            finally {
                ext.inactive = true;
            }
        }
    };
    private static final SpecialOperator GO = new SpecialOperator(Symbol.GO, "tag"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Binding binding = env.getTagBinding(args.car());
            if (binding == null) {
                return Lisp.error(new ControlError("No tag named " + args.car().writeToString() + " is currently visible."));
            }
            return Lisp.nonLocalGo(binding, args.car());
        }
    };
    private static final SpecialOperator BLOCK = new SpecialOperator(Symbol.BLOCK, "name &rest forms"){

        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Symbol tag = Lisp.checkSymbol(args.car());
            LispObject body = ((Cons)args).cdr();
            Environment ext = new Environment(env);
            LispObject block = new LispObject();
            ext.addBlock(tag, block);
            LispObject result = Lisp.NIL;
            LispThread thread = LispThread.currentThread();
            try {
                LispObject lispObject = Lisp.progn(body, ext, thread);
                return lispObject;
            }
            catch (Return ret) {
                if (ret.getBlock() == block) {
                    LispObject lispObject = ret.getResult();
                    return lispObject;
                }
                throw ret;
            }
            finally {
                ext.inactive = true;
            }
        }
    };
    private static final SpecialOperator RETURN_FROM = new SpecialOperator(Symbol.RETURN_FROM, "name &optional value"){

        public LispObject execute(LispObject args, Environment env) {
            int length = args.length();
            if (length < 1 || length > 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Symbol symbol = Lisp.checkSymbol(args.car());
            return Lisp.nonLocalReturn(env.getBlockBinding(symbol), symbol, length == 2 ? Lisp.eval(args.cadr(), env, LispThread.currentThread()) : Lisp.NIL);
        }
    };
    private static final SpecialOperator CATCH = new SpecialOperator(Symbol.CATCH, "tag &body body"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() < 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            LispObject tag = Lisp.eval(args.car(), env, thread);
            thread.pushCatchTag(tag);
            LispObject body = args.cdr();
            LispObject result = Lisp.NIL;
            try {
                LispObject lispObject = Lisp.progn(body, env, thread);
                return lispObject;
            }
            catch (Throw t) {
                if (t.tag == tag) {
                    LispObject lispObject = t.getResult(thread);
                    return lispObject;
                }
                throw t;
            }
            catch (Return ret) {
                throw ret;
            }
            finally {
                thread.popCatchTag();
            }
        }
    };
    private static final SpecialOperator THROW = new SpecialOperator(Symbol.THROW, "tag result"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            thread.throwToTag(Lisp.eval(args.car(), env, thread), Lisp.eval(args.cadr(), env, thread));
            return Lisp.NIL;
        }
    };
    private static final SpecialOperator UNWIND_PROTECT = new SpecialOperator(Symbol.UNWIND_PROTECT, "protected &body cleanup"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            LispObject body;
            LispObject[] values2;
            LispObject result;
            LispThread thread = LispThread.currentThread();
            try {
                result = Lisp.eval(args.car(), env, thread);
                values2 = thread._values;
                body = args.cdr();
            }
            catch (Throwable throwable) {
                LispObject[] values2 = thread._values;
                LispObject body2 = args.cdr();
                while (body2 != Lisp.NIL) {
                    Lisp.eval(body2.car(), env, thread);
                    body2 = ((Cons)body2).cdr;
                }
                thread._values = values2;
                throw throwable;
            }
            while (body != Lisp.NIL) {
                Lisp.eval(body.car(), env, thread);
                body = ((Cons)body).cdr;
            }
            thread._values = values2;
            if (values2 != null) {
                thread.setValues(values2);
            } else {
                thread._values = null;
            }
            return result;
        }
    };
    private static final SpecialOperator EVAL_WHEN = new SpecialOperator(Symbol.EVAL_WHEN, "situations &rest forms"){

        public LispObject execute(LispObject args, Environment env) {
            LispObject situations = args.car();
            if (situations != Lisp.NIL && (Lisp.memq(Keyword.EXECUTE, situations) || Lisp.memq(Symbol.EVAL, situations))) {
                return Lisp.progn(args.cdr(), env, LispThread.currentThread());
            }
            return Lisp.NIL;
        }
    };
    private static final SpecialOperator MULTIPLE_VALUE_BIND = new SpecialOperator(Symbol.MULTIPLE_VALUE_BIND, "vars value-form &body body"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            LispObject vars = args.car();
            args = args.cdr();
            LispObject valuesForm = args.car();
            LispObject body = args.cdr();
            LispThread thread = LispThread.currentThread();
            LispObject value = Lisp.eval(valuesForm, env, thread);
            LispObject[] values = thread._values;
            if (values == null) {
                values = new LispObject[]{value};
            }
            LispObject bodyAndDecls = Lisp.parseBody(body, false);
            LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
            body = bodyAndDecls.car();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            Environment ext = new Environment(env);
            int i = 0;
            LispObject var = vars.car();
            while (var != Lisp.NIL) {
                LispObject val;
                Symbol sym = Lisp.checkSymbol(var);
                LispObject lispObject = val = i < values.length ? values[i] : Lisp.NIL;
                if (specials != Lisp.NIL && Lisp.memq(sym, specials)) {
                    thread.bindSpecial(sym, val);
                    ext.declareSpecial(sym);
                } else if (sym.isSpecialVariable()) {
                    thread.bindSpecial(sym, val);
                } else {
                    ext.bind(sym, val);
                }
                vars = vars.cdr();
                var = vars.car();
                ++i;
            }
            while (specials != Lisp.NIL) {
                Symbol symbol = (Symbol)specials.car();
                ext.declareSpecial(symbol);
                specials = ((Cons)specials).cdr;
            }
            thread._values = null;
            LispObject result = Lisp.NIL;
            try {
                result = Lisp.progn(body, ext, thread);
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
            return result;
        }
    };
    private static final SpecialOperator MULTIPLE_VALUE_PROG1 = new SpecialOperator(Symbol.MULTIPLE_VALUE_PROG1, "values-form &rest forms"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() == 0) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.eval(args.car(), env, thread);
            LispObject[] values = thread._values;
            while ((args = args.cdr()) != Lisp.NIL) {
                Lisp.eval(args.car(), env, thread);
            }
            if (values != null) {
                thread.setValues(values);
            } else {
                thread._values = null;
            }
            return result;
        }
    };
    private static final SpecialOperator MULTIPLE_VALUE_CALL = new SpecialOperator(Symbol.MULTIPLE_VALUE_CALL, "fun &rest args"){

        public LispObject execute(LispObject args, Environment env) {
            LispObject function;
            if (args.length() == 0) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            LispObject obj = Lisp.eval(args.car(), env, thread);
            args = args.cdr();
            if (obj instanceof Symbol) {
                function = obj.getSymbolFunction();
                if (function == null) {
                    Lisp.error(new UndefinedFunction(obj));
                }
            } else if (obj instanceof Function) {
                function = obj;
            } else {
                Lisp.error(new LispError(obj.writeToString() + " is not a function name."));
                return Lisp.NIL;
            }
            ArrayList<LispObject> arrayList = new ArrayList<LispObject>();
            while (args != Lisp.NIL) {
                LispObject form = args.car();
                LispObject result = Lisp.eval(form, env, thread);
                LispObject[] values = thread._values;
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        arrayList.add(values[i]);
                    }
                } else {
                    arrayList.add(result);
                }
                args = ((Cons)args).cdr;
            }
            LispObject[] argv = new LispObject[arrayList.size()];
            arrayList.toArray(argv);
            return Lisp.funcall(function, argv, thread);
        }
    };
    private static final SpecialOperator AND = new SpecialOperator(Symbol.AND, "&rest forms"){

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.T;
            while (args != Lisp.NIL) {
                result = Lisp.eval(args.car(), env, thread);
                if (result == Lisp.NIL) {
                    if (((Cons)args).cdr == Lisp.NIL) break;
                    thread._values = null;
                    break;
                }
                args = ((Cons)args).cdr;
            }
            return result;
        }
    };
    private static final SpecialOperator OR = new SpecialOperator(Symbol.OR, "&rest forms"){

        public LispObject execute(LispObject args, Environment env) {
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            while (args != Lisp.NIL) {
                result = Lisp.eval(args.car(), env, thread);
                if (result != Lisp.NIL) {
                    if (((Cons)args).cdr == Lisp.NIL) break;
                    thread._values = null;
                    break;
                }
                args = ((Cons)args).cdr;
            }
            return result;
        }
    };
    private static final SpecialOperator MULTIPLE_VALUE_LIST = new SpecialOperator(Symbol.MULTIPLE_VALUE_LIST, "value-form"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.eval(((Cons)args).car, env, thread);
            LispObject[] values = thread._values;
            if (values == null) {
                return new Cons(result);
            }
            thread._values = null;
            LispObject list = Lisp.NIL;
            int i = values.length;
            while (i-- > 0) {
                list = new Cons(values[i], list);
            }
            return list;
        }
    };
    private static final SpecialOperator NTH_VALUE = new SpecialOperator(Symbol.NTH_VALUE, "n form"){

        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            LispThread thread = LispThread.currentThread();
            int n = Fixnum.getValue(Lisp.eval(args.car(), env, thread));
            if (n < 0) {
                n = 0;
            }
            LispObject result = Lisp.eval(args.cadr(), env, thread);
            LispObject[] values = thread._values;
            thread._values = null;
            if (values == null) {
                return n == 0 ? result : Lisp.NIL;
            }
            if (n < values.length) {
                return values[n];
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive CALL_COUNT = new Primitive("call-count", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.getCallCount());
        }
    };
    private static final Primitive SET_CALL_COUNT = new Primitive("set-call-count", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            first.setCallCount(Fixnum.getValue(second));
            return second;
        }
    };
    private static final Primitive HOT_COUNT = new Primitive("hot-count", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.getHotCount());
        }
    };
    private static final Primitive SET_HOT_COUNT = new Primitive("set-hot-count", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            first.setHotCount(Fixnum.getValue(second));
            return second;
        }
    };
    private static final Primitive LAMBDA_NAME = new Primitive("lambda-name", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Operator) {
                return ((Operator)arg).getLambdaName();
            }
            if (arg instanceof StandardGenericFunction) {
                return ((StandardGenericFunction)arg).getGenericFunctionName();
            }
            return Lisp.type_error(arg, Symbol.FUNCTION);
        }
    };
    private static final Primitive _SET_LAMBDA_NAME = new Primitive("%set-lambda-name", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof Operator) {
                ((Operator)first).setLambdaName(second);
                return second;
            }
            if (first instanceof StandardGenericFunction) {
                ((StandardGenericFunction)first).setGenericFunctionName(second);
                return second;
            }
            return Lisp.type_error(first, Symbol.FUNCTION);
        }
    };
    private static final Primitive SHRINK_VECTOR = new Primitive("shrink-vector", Lisp.PACKAGE_SYS, true, "vector new-size"){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkVector(first).shrink(Fixnum.getValue(second));
            return first;
        }
    };
    private static final Primitive SUBSEQ = new Primitive(Symbol.SUBSEQ, "sequence start &optional end"){

        public LispObject execute(LispObject first, LispObject second) {
            int start = Fixnum.getValue(second);
            if (start < 0) {
                FastStringBuffer sb = new FastStringBuffer("Bad start index (");
                sb.append(start);
                sb.append(") for SUBSEQ.");
                Lisp.error(new TypeError(sb.toString()));
            }
            if (first.listp()) {
                return Primitives.list_subseq(first, start, -1);
            }
            if (first instanceof AbstractVector) {
                AbstractVector v = (AbstractVector)first;
                return v.subseq(start, v.length());
            }
            return Lisp.type_error(first, Symbol.SEQUENCE);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int end;
            int start = Fixnum.getValue(second);
            if (start < 0) {
                FastStringBuffer sb = new FastStringBuffer("Bad start index (");
                sb.append(start);
                sb.append(").");
                Lisp.error(new TypeError(sb.toString()));
            }
            if (third != Lisp.NIL) {
                end = Fixnum.getValue(third);
                if (start > end) {
                    FastStringBuffer sb = new FastStringBuffer("Start index (");
                    sb.append(start);
                    sb.append(") is greater than end index (");
                    sb.append(end);
                    sb.append(") for SUBSEQ.");
                    Lisp.error(new TypeError(sb.toString()));
                }
            } else {
                end = -1;
            }
            if (first.listp()) {
                return Primitives.list_subseq(first, start, end);
            }
            if (first instanceof AbstractVector) {
                AbstractVector v = (AbstractVector)first;
                if (end < 0) {
                    end = v.length();
                }
                return v.subseq(start, end);
            }
            return Lisp.type_error(first, Symbol.SEQUENCE);
        }
    };
    private static final Primitive LIST = new Primitive(Symbol.LIST, "&rest objects"){

        public LispObject execute() {
            return Lisp.NIL;
        }

        public LispObject execute(LispObject arg) {
            return new Cons(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return new Cons(first, (LispObject)new Cons(second));
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return new Cons(first, (LispObject)new Cons(second, (LispObject)new Cons(third)));
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return new Cons(first, (LispObject)new Cons(second, (LispObject)new Cons(third, (LispObject)new Cons(fourth))));
        }

        public LispObject execute(LispObject[] args) {
            LispObject result = Lisp.NIL;
            int i = args.length;
            while (i-- > 0) {
                result = new Cons(args[i], result);
            }
            return result;
        }
    };
    private static final Primitive LIST_STAR = new Primitive(Symbol.LIST_STAR, "&rest objects"){

        public LispObject execute() {
            return Lisp.error(new WrongNumberOfArgumentsException(this));
        }

        public LispObject execute(LispObject arg) {
            return arg;
        }

        public LispObject execute(LispObject first, LispObject second) {
            return new Cons(first, second);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return new Cons(first, (LispObject)new Cons(second, third));
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return new Cons(first, (LispObject)new Cons(second, (LispObject)new Cons(third, fourth)));
        }

        public LispObject execute(LispObject[] args) {
            int i = args.length - 1;
            LispObject result = args[i];
            while (i-- > 0) {
                result = new Cons(args[i], result);
            }
            return result;
        }
    };
    public static final Primitive NREVERSE = new Primitive(Symbol.NREVERSE, "sequence"){

        public LispObject execute(LispObject arg) {
            return arg.nreverse();
        }
    };
    private static final Primitive NRECONC = new Primitive(Symbol.NRECONC, "list tail"){

        public LispObject execute(LispObject list, LispObject obj) {
            if (list instanceof Cons) {
                LispObject list3 = list.cdr();
                if (list3 instanceof Cons) {
                    if (list3.cdr() instanceof Cons) {
                        LispObject h;
                        LispObject list1 = list3;
                        LispObject list2 = Lisp.NIL;
                        do {
                            h = list3.cdr();
                            list3.setCdr(list2);
                            list2 = list3;
                        } while ((list3 = h).cdr() instanceof Cons);
                        list.setCdr(list2);
                        list1.setCdr(list3);
                    }
                    LispObject h = list.car();
                    list.setCar(list3.car());
                    list3.setCar(h);
                    list3.setCdr(obj);
                } else if (list3 == Lisp.NIL) {
                    list.setCdr(obj);
                } else {
                    Lisp.type_error(list3, Symbol.LIST);
                }
                return list;
            }
            if (list == Lisp.NIL) {
                return obj;
            }
            return Lisp.type_error(list, Symbol.LIST);
        }
    };
    private static final Primitive REVERSE = new Primitive(Symbol.REVERSE, "sequence"){

        public LispObject execute(LispObject arg) {
            return arg.reverse();
        }
    };
    private static final Primitive DELETE_EQ = new Primitive("delete-eq", Lisp.PACKAGE_SYS, true, "item sequence"){

        public LispObject execute(LispObject item, LispObject sequence) {
            if (sequence instanceof AbstractVector) {
                return ((AbstractVector)sequence).deleteEq(item);
            }
            return LIST_DELETE_EQ.execute(item, sequence);
        }
    };
    private static final Primitive DELETE_EQL = new Primitive("delete-eql", Lisp.PACKAGE_SYS, true, "item sequence"){

        public LispObject execute(LispObject item, LispObject sequence) {
            if (sequence instanceof AbstractVector) {
                return ((AbstractVector)sequence).deleteEql(item);
            }
            return LIST_DELETE_EQL.execute(item, sequence);
        }
    };
    private static final Primitive LIST_DELETE_EQ = new Primitive("list-delete-eq", Lisp.PACKAGE_SYS, true, "item list"){

        public LispObject execute(LispObject item, LispObject list) {
            if (list instanceof Cons) {
                LispObject tail = list;
                LispObject splice = list;
                while (tail instanceof Cons) {
                    LispObject car = tail.car();
                    if (car == item) {
                        if (tail.cdr() != Lisp.NIL) {
                            LispObject temp = tail;
                            tail.setCar(temp.cadr());
                            tail.setCdr(temp.cddr());
                            continue;
                        }
                        if (tail == list) {
                            return Lisp.NIL;
                        }
                        splice.setCdr(Lisp.NIL);
                        return list;
                    }
                    splice = tail;
                    tail = tail.cdr();
                }
                if (tail == Lisp.NIL) {
                    return list;
                }
                return Lisp.type_error(tail, Symbol.LIST);
            }
            if (list == Lisp.NIL) {
                return list;
            }
            return Lisp.type_error(list, Symbol.LIST);
        }
    };
    private static final Primitive LIST_DELETE_EQL = new Primitive("list-delete-eql", Lisp.PACKAGE_SYS, true, "item list"){

        public LispObject execute(LispObject item, LispObject list) {
            if (list instanceof Cons) {
                LispObject tail = list;
                LispObject splice = list;
                while (tail instanceof Cons) {
                    LispObject car = tail.car();
                    if (car.eql(item)) {
                        if (tail.cdr() != Lisp.NIL) {
                            LispObject temp = tail;
                            tail.setCar(temp.cadr());
                            tail.setCdr(temp.cddr());
                            continue;
                        }
                        if (tail == list) {
                            return Lisp.NIL;
                        }
                        splice.setCdr(Lisp.NIL);
                        return list;
                    }
                    splice = tail;
                    tail = tail.cdr();
                }
                if (tail == Lisp.NIL) {
                    return list;
                }
                return Lisp.type_error(tail, Symbol.LIST);
            }
            if (list == Lisp.NIL) {
                return list;
            }
            return Lisp.type_error(list, Symbol.LIST);
        }
    };
    private static final Primitive VECTOR_DELETE_EQ = new Primitive("vector-delete-eq", Lisp.PACKAGE_SYS, true, "item vector"){

        public LispObject execute(LispObject item, LispObject vector) {
            Lisp.checkVector(vector).deleteEq(item);
            return vector;
        }
    };
    private static final Primitive VECTOR_DELETE_EQL = new Primitive("vector-delete-eql", Lisp.PACKAGE_SYS, true, "item vector"){

        public LispObject execute(LispObject item, LispObject vector) {
            Lisp.checkVector(vector).deleteEql(item);
            return vector;
        }
    };
    private static final Primitive _SET_ELT = new Primitive("%set-elt", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof AbstractVector) {
                ((AbstractVector)first).aset(Fixnum.getValue(second), third);
                return third;
            }
            if (first instanceof Cons) {
                int index = Fixnum.getValue(second);
                if (index < 0) {
                    Lisp.error(new TypeError());
                }
                LispObject list = first;
                int i = 0;
                while (true) {
                    if (i == index) {
                        list.setCar(third);
                        return third;
                    }
                    if ((list = list.cdr()) == Lisp.NIL) {
                        Lisp.error(new TypeError());
                    }
                    ++i;
                }
            }
            return Lisp.type_error(first, Symbol.SEQUENCE);
        }
    };
    private static final Primitive _MAKE_LIST = new Primitive("%make-list", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            int size = Fixnum.getValue(first);
            if (size < 0) {
                return Lisp.type_error(first, Lisp.list(Symbol.INTEGER, Fixnum.ZERO, Symbol.MOST_POSITIVE_FIXNUM.getSymbolValue()));
            }
            LispObject result = Lisp.NIL;
            int i = size;
            while (i-- > 0) {
                result = new Cons(second, result);
            }
            return result;
        }
    };
    private static final Primitive _MEMBER = new Primitive("%member", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject item, LispObject list, LispObject key, LispObject test, LispObject testNot) {
            LispObject tail = Lisp.checkList(list);
            if (test != Lisp.NIL && testNot != Lisp.NIL) {
                Lisp.error(new LispError("MEMBER: test and test-not both supplied"));
            }
            if (testNot == Lisp.NIL && (test == Lisp.NIL || test == Symbol.EQL)) {
                test = EQL;
            }
            if (key == Lisp.NIL) {
                if (test == EQL) {
                    while (tail instanceof Cons) {
                        if (item.eql(((Cons)tail).car)) {
                            return tail;
                        }
                        tail = ((Cons)tail).cdr;
                    }
                } else if (test != Lisp.NIL) {
                    while (tail instanceof Cons) {
                        LispObject candidate = ((Cons)tail).car;
                        if (test.execute(item, candidate) != Lisp.NIL) {
                            return tail;
                        }
                        tail = ((Cons)tail).cdr;
                    }
                } else {
                    while (tail instanceof Cons) {
                        LispObject candidate = ((Cons)tail).car;
                        if (testNot.execute(item, candidate) == Lisp.NIL) {
                            return tail;
                        }
                        tail = ((Cons)tail).cdr;
                    }
                }
            } else {
                while (tail instanceof Cons) {
                    LispObject candidate = key.execute(((Cons)tail).car);
                    if (test != Lisp.NIL ? test.execute(item, candidate) != Lisp.NIL : testNot.execute(item, candidate) == Lisp.NIL) {
                        return tail;
                    }
                    tail = ((Cons)tail).cdr;
                }
            }
            if (tail != Lisp.NIL) {
                Lisp.type_error(tail, Symbol.LIST);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive FUNCALL_KEY = new Primitive("funcall-key", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            if (first != Lisp.NIL) {
                return LispThread.currentThread().execute(first, second);
            }
            return second;
        }
    };
    private static final Primitive COERCE_TO_FUNCTION = new Primitive("coerce-to-function", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToFunction(arg);
        }
    };
    private static final Primitive MAKE_CLOSURE = new Primitive("make-closure", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof Cons && ((Cons)first).car == Symbol.LAMBDA) {
                Environment env = second == Lisp.NIL ? new Environment() : Lisp.checkEnvironment(second);
                return new Closure(first, env);
            }
            return Lisp.error(new TypeError("The argument to MAKE-CLOSURE is not a lambda form."));
        }
    };
    private static final Primitive STREAMP = new Primitive(Symbol.STREAMP, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof Stream ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive INTEGERP = new Primitive(Symbol.INTEGERP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.INTEGERP();
        }
    };
    private static final Primitive EVENP = new Primitive(Symbol.EVENP, "integer"){

        public LispObject execute(LispObject arg) {
            return arg.EVENP();
        }
    };
    private static final Primitive ODDP = new Primitive(Symbol.ODDP, "integer"){

        public LispObject execute(LispObject arg) {
            return arg.ODDP();
        }
    };
    private static final Primitive NUMBERP = new Primitive(Symbol.NUMBERP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.NUMBERP();
        }
    };
    private static final Primitive REALP = new Primitive(Symbol.REALP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.REALP();
        }
    };
    private static final Primitive RATIONALP = new Primitive(Symbol.RATIONALP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.RATIONALP();
        }
    };
    private static final Primitive COMPLEX = new Primitive(Symbol.COMPLEX, "realpart &optional imagpart"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return Complex.getInstance(arg, SingleFloat.ZERO);
            }
            if (arg instanceof DoubleFloat) {
                return Complex.getInstance(arg, DoubleFloat.ZERO);
            }
            if (arg.realp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.REAL);
        }

        public LispObject execute(LispObject first, LispObject second) {
            return Complex.getInstance(first, second);
        }
    };
    private static final Primitive COMPLEXP = new Primitive(Symbol.COMPLEXP, "object"){

        public LispObject execute(LispObject arg) {
            return arg.COMPLEXP();
        }
    };
    private static final Primitive NUMERATOR = new Primitive(Symbol.NUMERATOR, "rational"){

        public LispObject execute(LispObject arg) {
            return arg.NUMERATOR();
        }
    };
    private static final Primitive DENOMINATOR = new Primitive(Symbol.DENOMINATOR, "rational"){

        public LispObject execute(LispObject arg) {
            return arg.DENOMINATOR();
        }
    };
    private static final Primitive REALPART = new Primitive(Symbol.REALPART, "number"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Complex) {
                return ((Complex)arg).getRealPart();
            }
            if (arg.numberp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.NUMBER);
        }
    };
    private static final Primitive IMAGPART = new Primitive(Symbol.IMAGPART, "number"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Complex) {
                return ((Complex)arg).getImaginaryPart();
            }
            return arg.multiplyBy(Fixnum.ZERO);
        }
    };
    private static final Primitive INTEGER_LENGTH = new Primitive(Symbol.INTEGER_LENGTH, "integer"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Fixnum) {
                int n = ((Fixnum)arg).value;
                if (n < 0) {
                    n ^= 0xFFFFFFFF;
                }
                int count = 0;
                while (n > 0) {
                    n >>>= 1;
                    ++count;
                }
                return Fixnum.getInstance(count);
            }
            if (arg instanceof Bignum) {
                return Fixnum.getInstance(((Bignum)arg).value.bitLength());
            }
            return Lisp.type_error(arg, Symbol.INTEGER);
        }
    };
    private static final Primitive GCD_2 = new Primitive("gcd-2", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            BigInteger n2;
            BigInteger n1;
            if (first instanceof Fixnum) {
                n1 = BigInteger.valueOf(((Fixnum)first).value);
            } else if (first instanceof Bignum) {
                n1 = ((Bignum)first).value;
            } else {
                return Lisp.type_error(first, Symbol.INTEGER);
            }
            if (second instanceof Fixnum) {
                n2 = BigInteger.valueOf(((Fixnum)second).value);
            } else if (second instanceof Bignum) {
                n2 = ((Bignum)second).value;
            } else {
                return Lisp.type_error(second, Symbol.INTEGER);
            }
            return Lisp.number(n1.gcd(n2));
        }
    };
    private static final Primitive IDENTITY_HASH_CODE = new Primitive("identity-hash-code", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(System.identityHashCode(arg));
        }
    };
    private static final Primitive SIMPLE_VECTOR_SEARCH = new Primitive("simple-vector-search", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            AbstractVector v = Lisp.checkVector(second);
            if (first.length() == 0) {
                return Fixnum.ZERO;
            }
            int patternLength = first.length();
            int limit = v.length() - patternLength;
            if (first instanceof AbstractVector) {
                AbstractVector pattern = (AbstractVector)first;
                LispObject element = pattern.AREF(0);
                for (int i = 0; i <= limit; ++i) {
                    if (!v.AREF(i).eql(element)) continue;
                    boolean match = true;
                    int j = i + 1;
                    for (int k = 1; k < patternLength; ++k) {
                        if (v.AREF(j).eql(pattern.AREF(k))) {
                            ++j;
                            continue;
                        }
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    return Fixnum.getInstance(i);
                }
            } else {
                LispObject element = first.car();
                for (int i = 0; i <= limit; ++i) {
                    if (!v.AREF(i).eql(element)) continue;
                    boolean match = true;
                    int j = i + 1;
                    for (LispObject rest = first.cdr(); rest != Lisp.NIL; rest = rest.cdr()) {
                        if (v.AREF(j).eql(rest.car())) {
                            ++j;
                            continue;
                        }
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    return Fixnum.getInstance(i);
                }
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive UPTIME = new Primitive("uptime", Lisp.PACKAGE_EXT, true){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis() - Main.startTimeMillis);
        }
    };
    private static final Primitive BUILT_IN_FUNCTION_P = new Primitive("built-in-function-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkSymbol(arg).isBuiltInFunction() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive INSPECTED_PARTS = new Primitive("inspected-parts", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return arg.getParts();
        }
    };
    private static final Primitive INSPECTED_DESCRIPTION = new Primitive("inspected-description", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            return arg.getDescription();
        }
    };
    public static final Primitive SYMBOL_NAME = new Primitive(Symbol.SYMBOL_NAME, "symbol"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkSymbol((LispObject)arg).name;
        }
    };
    public static final Primitive SYMBOL_PACKAGE = new Primitive(Symbol.SYMBOL_PACKAGE, "symbol"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkSymbol(arg).getPackage();
        }
    };
    public static final Primitive SYMBOL_FUNCTION = new Primitive(Symbol.SYMBOL_FUNCTION, "symbol"){

        public LispObject execute(LispObject arg) {
            LispObject function = Lisp.checkSymbol(arg).getSymbolFunction();
            if (function != null) {
                return function;
            }
            return Lisp.error(new UndefinedFunction(arg));
        }
    };
    public static final Primitive _SET_SYMBOL_FUNCTION = new Primitive("%set-symbol-function", Lisp.PACKAGE_SYS, false, "symbol function"){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkSymbol(first).setSymbolFunction(second);
            return second;
        }
    };
    public static final Primitive SYMBOL_PLIST = new Primitive(Symbol.SYMBOL_PLIST, "symbol"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkSymbol(arg).getPropertyList();
        }
    };
    public static final Primitive KEYWORDP = new Primitive(Symbol.KEYWORDP, "object"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol && Lisp.checkSymbol(arg).getPackage() == Lisp.PACKAGE_KEYWORD) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    };
    public static final Primitive MAKE_SYMBOL = new Primitive(Symbol.MAKE_SYMBOL, "name"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SimpleString) {
                return new Symbol((SimpleString)arg);
            }
            if (arg instanceof AbstractString) {
                return new Symbol(arg.getStringValue());
            }
            return Lisp.type_error(arg, Symbol.STRING);
        }
    };
    public static final Primitive MAKUNBOUND = new Primitive(Symbol.MAKUNBOUND, "symbol"){

        public LispObject execute(LispObject arg) {
            Lisp.checkSymbol(arg).setSymbolValue(null);
            return arg;
        }
    };
    private static final Primitive _CLASS_NAME = new Primitive("%class-name", Lisp.PACKAGE_SYS, true, "class"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass((LispObject)arg).symbol;
        }
    };
    private static final Primitive _SET_CLASS_NAME = new Primitive("%set-class-name", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass((LispObject)first).symbol = Lisp.checkSymbol(second);
            return second;
        }
    };
    private static final Primitive CLASS_LAYOUT = new Primitive("class-layout", Lisp.PACKAGE_SYS, true, "class"){

        public LispObject execute(LispObject arg) {
            Layout layout = Lisp.checkClass(arg).getClassLayout();
            return layout != null ? layout : Lisp.NIL;
        }
    };
    private static final Primitive _SET_CLASS_LAYOUT = new Primitive("%set-class-layout", Lisp.PACKAGE_SYS, true, "class layout"){

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof Layout) {
                Lisp.checkClass(first).setClassLayout((Layout)second);
                return second;
            }
            return Lisp.type_error(second, Symbol.LAYOUT);
        }
    };
    private static final Primitive CLASS_DIRECT_SUPERCLASSES = new Primitive("class-direct-superclasses", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass(arg).getDirectSuperclasses();
        }
    };
    private static final Primitive _SET_CLASS_DIRECT_SUPERCLASSES = new Primitive("%set-class-direct-superclasses", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass(first).setDirectSuperclasses(second);
            return second;
        }
    };
    private static final Primitive CLASS_DIRECT_SUBCLASSES = new Primitive("class-direct-subclasses", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass(arg).getDirectSubclasses();
        }
    };
    private static final Primitive _SET_CLASS_DIRECT_SUBCLASSES = new Primitive("%set-class-direct-subclasses", Lisp.PACKAGE_SYS, true, "class direct-subclasses"){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass(first).setDirectSubclasses(second);
            return second;
        }
    };
    private static final Primitive _CLASS_PRECEDENCE_LIST = new Primitive("%class-precedence-list", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass(arg).getCPL();
        }
    };
    private static final Primitive SET_CLASS_PRECEDENCE_LIST = new Primitive("set-class-precedence-list", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass((LispObject)first).classPrecedenceList = second;
            return second;
        }
    };
    private static final Primitive CLASS_DIRECT_METHODS = new Primitive("class-direct-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass((LispObject)arg).directMethods;
        }
    };
    private static final Primitive _SET_CLASS_DIRECT_METHODS = new Primitive("%set-class-direct-methods", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass((LispObject)first).directMethods = second;
            return second;
        }
    };
    private static final Primitive CLASS_DOCUMENTATION = new Primitive("class-documentation", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass((LispObject)arg).documentation;
        }
    };
    private static final Primitive _SET_CLASS_DOCUMENTATION = new Primitive("%set-class-documentation", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass((LispObject)first).documentation = second;
            return second;
        }
    };
    private static final Primitive CLASS_FINALIZED_P = new Primitive("class-finalized-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            return Lisp.checkClass(arg).isFinalized() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive _SET_CLASS_FINALIZED_P = new Primitive("%set-class-finalized-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkClass(first).setFinalized(second != Lisp.NIL);
            return second;
        }
    };
    private static final Primitive CLASSP = new Primitive("classp", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            return arg instanceof LispClass ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive CHAR_TO_UTF8 = new Primitive("char-to-utf8", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject arg) {
            byte[] bytes;
            LispCharacter c = Lisp.checkCharacter(arg);
            char[] chars = new char[]{c.value};
            String s = new String(chars);
            try {
                bytes = s.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return Lisp.error(new LispError("UTF8 is not a supported encoding."));
            }
            LispObject[] objects = new LispObject[bytes.length];
            int i = bytes.length;
            while (i-- > 0) {
                int n = bytes[i];
                if (n < 0) {
                    n += 256;
                }
                objects[i] = Fixnum.getInstance(n);
            }
            return new SimpleVector(objects);
        }
    };
    private static final Primitive _DOCUMENTATION = new Primitive("%documentation", Lisp.PACKAGE_SYS, true, "object doc-type"){

        public LispObject execute(LispObject object, LispObject docType) {
            LispObject function;
            LispObject doc = object.getDocumentation(docType);
            if (doc == Lisp.NIL && docType == Symbol.FUNCTION && object instanceof Symbol && (function = object.getSymbolFunction()) != null) {
                doc = function.getDocumentation(docType);
            }
            return doc;
        }
    };
    private static final Primitive _SET_DOCUMENTATION = new Primitive("%set-documentation", Lisp.PACKAGE_SYS, true, "object doc-type documentation"){

        public LispObject execute(LispObject object, LispObject docType, LispObject documentation) {
            object.setDocumentation(docType, documentation);
            return documentation;
        }
    };
    private static final Primitive _PUTF = new Primitive("%putf", Lisp.PACKAGE_SYS, true, "plist indicator new-value"){

        public LispObject execute(LispObject plist, LispObject indicator, LispObject newValue) {
            return Lisp.putf(plist, indicator, newValue);
        }
    };
    private static final Primitive FUNCTION_PLIST = new Primitive("function-plist", Lisp.PACKAGE_SYS, true, "function"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkFunction(arg).getPropertyList();
        }
    };
    private static final Primitive MAKE_KEYWORD = new Primitive("make-keyword", Lisp.PACKAGE_SYS, true, "symbol"){

        public LispObject execute(LispObject arg) {
            return Lisp.PACKAGE_KEYWORD.intern(Lisp.checkSymbol((LispObject)arg).name);
        }
    };
    private static final Primitive STANDARD_OBJECT_P = new Primitive("standard-object-p", Lisp.PACKAGE_SYS, true, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof StandardObject ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive COPY_TREE = new Primitive(Symbol.COPY_TREE, "object"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Cons) {
                Cons cons = (Cons)arg;
                return new Cons(this.execute(cons.car), this.execute(cons.cdr));
            }
            return arg;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkRedefinition(LispObject arg) {
        LispObject oldDefinition;
        LispThread thread = LispThread.currentThread();
        if (Lisp._WARN_ON_REDEFINITION_.symbolValue(thread) != Lisp.NIL && arg instanceof Symbol && (oldDefinition = arg.getSymbolFunction()) != null && !(oldDefinition instanceof Autoload) && !(oldDefinition instanceof AutoloadedFunctionProxy)) {
            LispObject oldSource = Extensions.SOURCE_PATHNAME.execute(arg);
            LispObject currentSource = Lisp._SOURCE_.symbolValue(thread);
            if (currentSource == Lisp.NIL) {
                currentSource = Keyword.TOP_LEVEL;
            }
            if (oldSource != Lisp.NIL && currentSource.equal(oldSource)) {
                return;
            }
            if (currentSource == Keyword.TOP_LEVEL) {
                Symbol.STYLE_WARN.execute((LispObject)new SimpleString("redefining ~S at top level"), arg);
            } else {
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Symbol._PACKAGE_, Lisp.PACKAGE_CL);
                try {
                    Symbol.STYLE_WARN.execute(new SimpleString("redefining ~S in ~S"), arg, currentSource);
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
            }
        }
    }

    private static final LispObject list_subseq(LispObject list, int start, int end) {
        int index = 0;
        LispObject result = Lisp.NIL;
        while (list != Lisp.NIL) {
            if (end >= 0 && index == end) {
                return result.nreverse();
            }
            if (index++ >= start) {
                result = new Cons(list.car(), result);
            }
            list = list.cdr();
        }
        return result.nreverse();
    }
}

