/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SimpleVector
extends AbstractVector {
    private int capacity;
    private LispObject[] data;
    private static final Primitive SVREF = new Primitive("svref", "simple-vector index"){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SimpleVector) {
                SimpleVector sv = (SimpleVector)first;
                int index = Fixnum.getValue(second);
                try {
                    return sv.data[index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int capacity = sv.capacity;
                    sv.badIndex(index, capacity);
                    return Lisp.NIL;
                }
            }
            return Lisp.type_error(first, Symbol.SIMPLE_VECTOR);
        }
    };
    private static final Primitive SVSET = new Primitive("svset", Lisp.PACKAGE_SYS, true, "simple-vector index new-value"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof SimpleVector) {
                SimpleVector sv = (SimpleVector)first;
                int index = Fixnum.getValue(second);
                try {
                    ((SimpleVector)sv).data[index] = third;
                    return third;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int capacity = sv.capacity;
                    sv.badIndex(index, capacity);
                    return Lisp.NIL;
                }
            }
            return Lisp.type_error(first, Symbol.SIMPLE_VECTOR);
        }
    };

    public SimpleVector(int capacity) {
        this.data = new LispObject[capacity];
        int i = capacity;
        while (i-- > 0) {
            this.data[i] = Fixnum.ZERO;
        }
        this.capacity = capacity;
    }

    public SimpleVector(LispObject obj) {
        if (obj.listp()) {
            this.data = obj.copyToArray();
            this.capacity = this.data.length;
        } else if (obj instanceof AbstractVector) {
            this.capacity = obj.length();
            this.data = new LispObject[this.capacity];
            for (int i = 0; i < this.capacity; ++i) {
                this.data[i] = obj.elt(i);
            }
        } else {
            Debug.assertTrue(false);
        }
    }

    public SimpleVector(LispObject[] array) {
        this.data = array;
        this.capacity = array.length;
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_VECTOR, Fixnum.getInstance(this.capacity));
    }

    public LispObject classOf() {
        return BuiltInClass.SIMPLE_VECTOR;
    }

    public LispObject getDescription() {
        StringBuffer sb = new StringBuffer("A simple vector with ");
        sb.append(this.capacity);
        sb.append(" elements");
        return new SimpleString(sb);
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject getElementType() {
        return Lisp.T;
    }

    public boolean isSimpleVector() {
        return true;
    }

    public boolean hasFillPointer() {
        return false;
    }

    public boolean isAdjustable() {
        return false;
    }

    public int capacity() {
        return this.capacity;
    }

    public int length() {
        return this.capacity;
    }

    public LispObject elt(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    public LispObject AREF(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.data.length);
            return Lisp.NIL;
        }
    }

    public LispObject AREF(LispObject index) {
        int idx = Fixnum.getValue(index);
        try {
            return this.data[idx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(idx, this.data.length);
            return Lisp.NIL;
        }
    }

    public void aset(int index, LispObject newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    public LispObject SVREF(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.data.length);
            return Lisp.NIL;
        }
    }

    public void svset(int index, LispObject newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    public LispObject subseq(int start, int end) {
        SimpleVector v = new SimpleVector(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.data[j++] = this.data[i++];
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    public void fill(LispObject obj) {
        int i = this.capacity;
        while (i-- > 0) {
            this.data[i] = obj;
        }
    }

    public LispObject deleteEq(LispObject item) {
        int limit = this.capacity;
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.data[i++]) == item) continue;
            this.data[j++] = obj;
        }
        if (j < limit) {
            this.shrink(j);
        }
        return this;
    }

    public LispObject deleteEql(LispObject item) {
        int limit = this.capacity;
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.data[i++]).eql(item)) continue;
            this.data[j++] = obj;
        }
        if (j < limit) {
            this.shrink(j);
        }
        return this;
    }

    public void shrink(int n) {
        if (n < this.capacity) {
            LispObject[] newData = new LispObject[n];
            System.arraycopy(this.data, 0, newData, 0, n);
            this.data = newData;
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    public LispObject reverse() {
        SimpleVector result = new SimpleVector(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.data[i] = this.data[j];
            ++i;
            --j;
        }
        return result;
    }

    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            LispObject temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newData = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newData[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newData[i] = initialContents.elt(i);
                }
            } else {
                Lisp.error(new TypeError(initialContents, Symbol.SEQUENCE));
            }
            return new SimpleVector(newData);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newData = new LispObject[newCapacity];
            System.arraycopy(this.data, 0, newData, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newData[i] = initialElement;
                }
            }
            return new SimpleVector(newData);
        }
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }
}

