/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;

public final class Site {
    private static final String LISP_HOME;
    private static final Symbol _LISP_HOME_;

    public static final String getLispHome() {
        return LISP_HOME;
    }

    static {
        String protocol;
        URL url;
        String lispHome = System.getProperty("abcl.home");
        if (lispHome == null && (url = Lisp.class.getResource("boot.lisp")) != null && (protocol = url.getProtocol()) != null && protocol.equals("file")) {
            String path = url.getPath();
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            int index = path.lastIndexOf(47);
            if (index >= 0) {
                lispHome = path.substring(0, index + 1);
                if (Utilities.isPlatformWindows && lispHome.length() > 0 && lispHome.charAt(0) == '/') {
                    lispHome = lispHome.substring(1);
                }
            }
        }
        LISP_HOME = lispHome;
        _LISP_HOME_ = Lisp.exportSpecial("*LISP-HOME*", Lisp.PACKAGE_EXT, Lisp.NIL);
        String s = Site.getLispHome();
        if (s != null) {
            _LISP_HOME_.setSymbolValue(new Pathname(s));
        }
    }
}

