/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class SlimeInputStream
extends Stream {
    String s;
    int length;
    final Function f;
    final Stream ostream;
    private static final Primitive MAKE_SLIME_INPUT_STREAM = new Primitive("make-slime-input-stream", Lisp.PACKAGE_EXT, true, "function output-stream"){

        public LispObject execute(LispObject first, LispObject second) {
            Function fun = first instanceof Symbol ? (Function)first.getSymbolFunction() : (Function)first;
            Stream os = Lisp.checkCharacterOutputStream(second);
            return new SlimeInputStream(fun, os);
        }
    };

    public SlimeInputStream(Function f, Stream ostream) {
        this.elementType = Symbol.CHARACTER;
        this.isInputStream = true;
        this.isOutputStream = false;
        this.isCharacterStream = true;
        this.isBinaryStream = false;
        this.f = f;
        this.ostream = ostream;
    }

    public LispObject typeOf() {
        return Symbol.SLIME_INPUT_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.SLIME_INPUT_STREAM;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.SLIME_INPUT_STREAM) {
            return Lisp.T;
        }
        if (type == Symbol.STRING_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SLIME_INPUT_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    public LispObject listen() {
        return this.offset < this.length ? Lisp.T : Lisp.NIL;
    }

    protected int _readChar() {
        if (this.offset >= this.length) {
            this.ostream.finishOutput();
            this.s = LispThread.currentThread().execute(this.f).getStringValue();
            if (this.s.length() == 0) {
                return -1;
            }
            this.offset = 0;
            this.length = this.s.length();
        }
        char n = this.s.charAt(this.offset);
        ++this.offset;
        if (n == '\n') {
            ++this.lineNumber;
        }
        return n;
    }

    protected void _unreadChar(int n) {
        if (this.offset > 0) {
            --this.offset;
            if (n == 10) {
                --this.lineNumber;
            }
        }
    }

    protected boolean _charReady() {
        return this.offset < this.length;
    }

    public void _clearInput() {
        super._clearInput();
        this.s = "";
        this.offset = 0;
        this.length = 0;
        this.lineNumber = 0;
    }

    public String toString() {
        return this.unreadableString("SLIME-INPUT-STREAM");
    }
}

