/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SlotDefinition;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public class SlotClass
extends LispClass {
    private LispObject directSlotDefinitions = Lisp.NIL;
    private LispObject slotDefinitions = Lisp.NIL;
    private LispObject directDefaultInitargs = Lisp.NIL;
    private LispObject defaultInitargs = Lisp.NIL;
    private static final Primitive CLASS_DIRECT_SLOTS = new Primitive("class-direct-slots", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).directSlotDefinitions;
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive _SET_CLASS_DIRECT_SLOTS = new Primitive("%set-class-direct-slots", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SlotClass) {
                ((SlotClass)first).directSlotDefinitions = second;
                return second;
            }
            return Lisp.type_error(first, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive _CLASS_SLOTS = new Primitive(Symbol._CLASS_SLOTS, "class"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).slotDefinitions;
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive SET_CLASS_SLOTS = new Primitive(Symbol.SET_CLASS_SLOTS, "class slot-definitions"){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SlotClass) {
                ((SlotClass)first).slotDefinitions = second;
                return second;
            }
            return Lisp.type_error(first, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive CLASS_DIRECT_DEFAULT_INITARGS = new Primitive("class-direct-default-initargs", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).directDefaultInitargs;
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive _SET_CLASS_DIRECT_DEFAULT_INITARGS = new Primitive("%set-class-direct-default-initargs", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SlotClass) {
                ((SlotClass)first).directDefaultInitargs = second;
                return second;
            }
            return Lisp.type_error(first, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive CLASS_DEFAULT_INITARGS = new Primitive("class-default-initargs", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).defaultInitargs;
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive _SET_CLASS_DEFAULT_INITARGS = new Primitive("%set-class-default-initargs", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SlotClass) {
                ((SlotClass)first).defaultInitargs = second;
                return second;
            }
            return Lisp.type_error(first, Symbol.STANDARD_CLASS);
        }
    };
    private static final Primitive COMPUTE_CLASS_DEFAULT_INITARGS = new Primitive("compute-class-default-initargs", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof SlotClass)) {
                return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
            }
            SlotClass c = (SlotClass)arg;
            return c.computeDefaultInitargs();
        }
    };

    public SlotClass() {
    }

    public SlotClass(Symbol symbol, LispObject directSuperclasses) {
        super(symbol, directSuperclasses);
    }

    public LispObject getParts() {
        LispObject result = super.getParts().nreverse();
        result = result.push(new Cons("DIRECT-SLOTS", this.directSlotDefinitions));
        result = result.push(new Cons("SLOTS", this.slotDefinitions));
        result = result.push(new Cons("DIRECT-DEFAULT-INITARGS", this.directDefaultInitargs));
        result = result.push(new Cons("DEFAULT-INITARGS", this.defaultInitargs));
        return result.nreverse();
    }

    public LispObject typep(LispObject type) {
        return super.typep(type);
    }

    public LispObject getDirectSlotDefinitions() {
        return this.directSlotDefinitions;
    }

    public void setDirectSlotDefinitions(LispObject directSlotDefinitions) {
        this.directSlotDefinitions = directSlotDefinitions;
    }

    public final LispObject getSlotDefinitions() {
        return this.slotDefinitions;
    }

    public void setSlotDefinitions(LispObject slotDefinitions) {
        this.slotDefinitions = slotDefinitions;
    }

    public LispObject getDirectDefaultInitargs() {
        return this.directDefaultInitargs;
    }

    public void setDirectDefaultInitargs(LispObject directDefaultInitargs) {
        this.directDefaultInitargs = directDefaultInitargs;
    }

    public void setDefaultInitargs(LispObject defaultInitargs) {
        this.defaultInitargs = defaultInitargs;
    }

    private LispObject computeDefaultInitargs() {
        LispObject result = Lisp.NIL;
        for (LispObject cpl = this.getCPL(); cpl != Lisp.NIL; cpl = cpl.cdr()) {
            LispObject obj;
            LispClass c = (LispClass)cpl.car();
            if (!(c instanceof StandardClass) || (obj = ((StandardClass)c).getDirectDefaultInitargs()) == Lisp.NIL) continue;
            result = Symbol.APPEND.execute(result, obj);
        }
        return result;
    }

    public void finalizeClass() {
        if (this.isFinalized()) {
            return;
        }
        Debug.assertTrue(this.slotDefinitions == Lisp.NIL);
        LispObject cpl = this.getCPL();
        Debug.assertTrue(cpl != null);
        Debug.assertTrue(cpl.listp());
        for (cpl = cpl.reverse(); cpl != Lisp.NIL; cpl = cpl.cdr()) {
            LispObject car = cpl.car();
            if (!(car instanceof StandardClass)) continue;
            StandardClass cls = (StandardClass)car;
            LispObject defs = cls.getDirectSlotDefinitions();
            Debug.assertTrue(defs != null);
            Debug.assertTrue(defs.listp());
            while (defs != Lisp.NIL) {
                this.slotDefinitions = this.slotDefinitions.push(defs.car());
                defs = defs.cdr();
            }
        }
        this.slotDefinitions = this.slotDefinitions.nreverse();
        LispObject[] instanceSlotNames = new LispObject[this.slotDefinitions.length()];
        int i = 0;
        for (LispObject tail = this.slotDefinitions; tail != Lisp.NIL; tail = tail.cdr()) {
            SlotDefinition slotDefinition = (SlotDefinition)tail.car();
            slotDefinition.setLocation(i);
            instanceSlotNames[i++] = slotDefinition.getName();
        }
        this.setClassLayout(new Layout((LispClass)this, instanceSlotNames, Lisp.NIL));
        this.setDefaultInitargs(this.computeDefaultInitargs());
        this.setFinalized(true);
    }
}

