/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SlotClass;
import org.armedbear.lisp.SlotDefinition;
import org.armedbear.lisp.SlotDefinitionClass;
import org.armedbear.lisp.StandardGenericFunctionClass;
import org.armedbear.lisp.StandardMethodClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.StandardReaderMethodClass;
import org.armedbear.lisp.Symbol;

public class StandardClass
extends SlotClass {
    public static final StandardClass STANDARD_CLASS = StandardClass.addStandardClass(Symbol.STANDARD_CLASS, Lisp.list(BuiltInClass.CLASS_T, new LispObject[0]));
    public static final StandardClass STANDARD_OBJECT = StandardClass.addStandardClass(Symbol.STANDARD_OBJECT, Lisp.list(BuiltInClass.CLASS_T, new LispObject[0]));
    public static final StandardClass GENERIC_FUNCTION = StandardClass.addStandardClass(Symbol.GENERIC_FUNCTION, Lisp.list(BuiltInClass.FUNCTION, STANDARD_OBJECT));
    public static final StandardClass CLASS = StandardClass.addStandardClass(Symbol.CLASS, Lisp.list(STANDARD_OBJECT, new LispObject[0]));
    public static final StandardClass BUILT_IN_CLASS = StandardClass.addStandardClass(Symbol.BUILT_IN_CLASS, Lisp.list(CLASS, new LispObject[0]));
    public static final StandardClass JAVA_CLASS = StandardClass.addStandardClass(Symbol.JAVA_CLASS, Lisp.list(CLASS, new LispObject[0]));
    public static final StandardClass FORWARD_REFERENCED_CLASS = StandardClass.addStandardClass(Symbol.FORWARD_REFERENCED_CLASS, Lisp.list(CLASS, new LispObject[0]));
    public static final StandardClass STRUCTURE_CLASS = StandardClass.addStandardClass(Symbol.STRUCTURE_CLASS, Lisp.list(CLASS, new LispObject[0]));
    public static final StandardClass CONDITION = StandardClass.addStandardClass(Symbol.CONDITION, Lisp.list(STANDARD_OBJECT, new LispObject[0]));
    public static final StandardClass SIMPLE_CONDITION = StandardClass.addStandardClass(Symbol.SIMPLE_CONDITION, Lisp.list(CONDITION, new LispObject[0]));
    public static final StandardClass WARNING = StandardClass.addStandardClass(Symbol.WARNING, Lisp.list(CONDITION, new LispObject[0]));
    public static final StandardClass SIMPLE_WARNING = StandardClass.addStandardClass(Symbol.SIMPLE_WARNING, Lisp.list(SIMPLE_CONDITION, WARNING));
    public static final StandardClass STYLE_WARNING = StandardClass.addStandardClass(Symbol.STYLE_WARNING, Lisp.list(WARNING, new LispObject[0]));
    public static final StandardClass SERIOUS_CONDITION = StandardClass.addStandardClass(Symbol.SERIOUS_CONDITION, Lisp.list(CONDITION, new LispObject[0]));
    public static final StandardClass STORAGE_CONDITION = StandardClass.addStandardClass(Symbol.STORAGE_CONDITION, Lisp.list(SERIOUS_CONDITION, new LispObject[0]));
    public static final StandardClass ERROR = StandardClass.addStandardClass(Symbol.ERROR, Lisp.list(SERIOUS_CONDITION, new LispObject[0]));
    public static final StandardClass ARITHMETIC_ERROR = StandardClass.addStandardClass(Symbol.ARITHMETIC_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass CELL_ERROR = StandardClass.addStandardClass(Symbol.CELL_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass CONTROL_ERROR = StandardClass.addStandardClass(Symbol.CONTROL_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass FILE_ERROR = StandardClass.addStandardClass(Symbol.FILE_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass DIVISION_BY_ZERO = StandardClass.addStandardClass(Symbol.DIVISION_BY_ZERO, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
    public static final StandardClass FLOATING_POINT_INEXACT = StandardClass.addStandardClass(Symbol.FLOATING_POINT_INEXACT, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
    public static final StandardClass FLOATING_POINT_INVALID_OPERATION = StandardClass.addStandardClass(Symbol.FLOATING_POINT_INVALID_OPERATION, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
    public static final StandardClass FLOATING_POINT_OVERFLOW = StandardClass.addStandardClass(Symbol.FLOATING_POINT_OVERFLOW, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
    public static final StandardClass FLOATING_POINT_UNDERFLOW = StandardClass.addStandardClass(Symbol.FLOATING_POINT_UNDERFLOW, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
    public static final StandardClass PROGRAM_ERROR = StandardClass.addStandardClass(Symbol.PROGRAM_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass PACKAGE_ERROR = StandardClass.addStandardClass(Symbol.PACKAGE_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass STREAM_ERROR = StandardClass.addStandardClass(Symbol.STREAM_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass PARSE_ERROR = StandardClass.addStandardClass(Symbol.PARSE_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass PRINT_NOT_READABLE = StandardClass.addStandardClass(Symbol.PRINT_NOT_READABLE, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass READER_ERROR = StandardClass.addStandardClass(Symbol.READER_ERROR, Lisp.list(PARSE_ERROR, STREAM_ERROR));
    public static final StandardClass END_OF_FILE = StandardClass.addStandardClass(Symbol.END_OF_FILE, Lisp.list(STREAM_ERROR, new LispObject[0]));
    public static final StandardClass SIMPLE_ERROR = StandardClass.addStandardClass(Symbol.SIMPLE_ERROR, Lisp.list(SIMPLE_CONDITION, ERROR));
    public static final StandardClass TYPE_ERROR = StandardClass.addStandardClass(Symbol.TYPE_ERROR, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass SIMPLE_TYPE_ERROR = StandardClass.addStandardClass(Symbol.SIMPLE_TYPE_ERROR, Lisp.list(SIMPLE_CONDITION, TYPE_ERROR));
    public static final StandardClass UNBOUND_SLOT = StandardClass.addStandardClass(Symbol.UNBOUND_SLOT, Lisp.list(CELL_ERROR, new LispObject[0]));
    public static final StandardClass UNBOUND_VARIABLE = StandardClass.addStandardClass(Symbol.UNBOUND_VARIABLE, Lisp.list(CELL_ERROR, new LispObject[0]));
    public static final StandardClass UNDEFINED_FUNCTION = StandardClass.addStandardClass(Symbol.UNDEFINED_FUNCTION, Lisp.list(CELL_ERROR, new LispObject[0]));
    public static final StandardClass COMPILER_ERROR = StandardClass.addStandardClass(Symbol.COMPILER_ERROR, Lisp.list(CONDITION, new LispObject[0]));
    public static final StandardClass COMPILER_UNSUPPORTED_FEATURE_ERROR = StandardClass.addStandardClass(Symbol.COMPILER_UNSUPPORTED_FEATURE_ERROR, Lisp.list(CONDITION, new LispObject[0]));
    public static final StandardClass JAVA_EXCEPTION = StandardClass.addStandardClass(Symbol.JAVA_EXCEPTION, Lisp.list(ERROR, new LispObject[0]));
    public static final StandardClass METHOD = StandardClass.addStandardClass(Symbol.METHOD, Lisp.list(STANDARD_OBJECT, new LispObject[0]));
    public static final StandardClass STANDARD_METHOD = new StandardMethodClass();
    public static final StandardClass STANDARD_READER_METHOD;
    public static final StandardClass STANDARD_GENERIC_FUNCTION;
    public static final StandardClass SLOT_DEFINITION;

    public StandardClass() {
        this.setClassLayout(new Layout((LispClass)this, Lisp.NIL, Lisp.NIL));
    }

    public StandardClass(Symbol symbol, LispObject directSuperclasses) {
        super(symbol, directSuperclasses);
        this.setClassLayout(new Layout((LispClass)this, Lisp.NIL, Lisp.NIL));
    }

    public LispObject typeOf() {
        return Symbol.STANDARD_CLASS;
    }

    public LispObject classOf() {
        return STANDARD_CLASS;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.STANDARD_CLASS) {
            return Lisp.T;
        }
        if (type == STANDARD_CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject allocateInstance() {
        Layout layout = this.getClassLayout();
        if (layout == null) {
            Symbol.ERROR.execute(Symbol.SIMPLE_ERROR, Keyword.FORMAT_CONTROL, new SimpleString("No layout for class ~S."), Keyword.FORMAT_ARGUMENTS, Lisp.list(this, new LispObject[0]));
        }
        return new StandardObject(this, layout.getLength());
    }

    public String writeToString() {
        FastStringBuffer sb = new FastStringBuffer(Symbol.STANDARD_CLASS.writeToString());
        if (this.symbol != null) {
            sb.append(' ');
            sb.append(this.symbol.writeToString());
        }
        return this.unreadableString(sb.toString());
    }

    private static final StandardClass addStandardClass(Symbol name, LispObject directSuperclasses) {
        StandardClass c = new StandardClass(name, directSuperclasses);
        StandardClass.addClass(name, c);
        return c;
    }

    public static void initializeStandardClasses() {
        STANDARD_CLASS.setDirectSuperclass(CLASS);
        STANDARD_OBJECT.setDirectSuperclass(BuiltInClass.CLASS_T);
        GENERIC_FUNCTION.setDirectSuperclasses(Lisp.list(BuiltInClass.FUNCTION, STANDARD_OBJECT));
        ARITHMETIC_ERROR.setCPL(ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        ARITHMETIC_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.OPERATION, Lisp.list(Lisp.PACKAGE_CL.intern("ARITHMETIC-ERROR-OPERATION"), new LispObject[0])), new SlotDefinition(Symbol.OPERANDS, Lisp.list(Lisp.PACKAGE_CL.intern("ARITHMETIC-ERROR-OPERANDS"), new LispObject[0]))));
        BUILT_IN_CLASS.setCPL(BUILT_IN_CLASS, CLASS, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        JAVA_CLASS.setCPL(JAVA_CLASS, CLASS, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CELL_ERROR.setCPL(CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CELL_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.NAME, Lisp.list(Symbol.CELL_ERROR_NAME, new LispObject[0])), new LispObject[0]));
        CLASS.setCPL(CLASS, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        COMPILER_ERROR.setCPL(COMPILER_ERROR, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        COMPILER_UNSUPPORTED_FEATURE_ERROR.setCPL(COMPILER_UNSUPPORTED_FEATURE_ERROR, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CONDITION.setCPL(CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CONDITION.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.FORMAT_CONTROL, Lisp.list(Symbol.SIMPLE_CONDITION_FORMAT_CONTROL, new LispObject[0])), new SlotDefinition(Symbol.FORMAT_ARGUMENTS, Lisp.list(Symbol.SIMPLE_CONDITION_FORMAT_ARGUMENTS, new LispObject[0]), Lisp.NIL)));
        CONDITION.setDirectDefaultInitargs(Lisp.list(Keyword.FORMAT_ARGUMENTS, new Closure((LispObject)Lisp.list(Symbol.LAMBDA, Lisp.NIL, Lisp.NIL), new Environment())));
        CONTROL_ERROR.setCPL(CONTROL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        DIVISION_BY_ZERO.setCPL(DIVISION_BY_ZERO, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        END_OF_FILE.setCPL(END_OF_FILE, STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        ERROR.setCPL(ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FILE_ERROR.setCPL(FILE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FILE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.PATHNAME, Lisp.list(Lisp.PACKAGE_CL.intern("FILE-ERROR-PATHNAME"), new LispObject[0])), new LispObject[0]));
        FLOATING_POINT_INEXACT.setCPL(FLOATING_POINT_INEXACT, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_INVALID_OPERATION.setCPL(FLOATING_POINT_INVALID_OPERATION, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_OVERFLOW.setCPL(FLOATING_POINT_OVERFLOW, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_UNDERFLOW.setCPL(FLOATING_POINT_UNDERFLOW, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FORWARD_REFERENCED_CLASS.setCPL(FORWARD_REFERENCED_CLASS, CLASS, BuiltInClass.CLASS_T);
        GENERIC_FUNCTION.setCPL(GENERIC_FUNCTION, STANDARD_OBJECT, BuiltInClass.FUNCTION, BuiltInClass.CLASS_T);
        JAVA_EXCEPTION.setCPL(JAVA_EXCEPTION, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        JAVA_EXCEPTION.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.CAUSE, Lisp.list(Symbol.JAVA_EXCEPTION_CAUSE, new LispObject[0])), new LispObject[0]));
        METHOD.setCPL(METHOD, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PACKAGE_ERROR.setCPL(PACKAGE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PACKAGE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.PACKAGE, Lisp.list(Lisp.PACKAGE_CL.intern("PACKAGE-ERROR-PACKAGE"), new LispObject[0])), new LispObject[0]));
        PARSE_ERROR.setCPL(PARSE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PRINT_NOT_READABLE.setCPL(PRINT_NOT_READABLE, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PRINT_NOT_READABLE.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.OBJECT, Lisp.list(Lisp.PACKAGE_CL.intern("PRINT-NOT-READABLE-OBJECT"), new LispObject[0])), new LispObject[0]));
        PROGRAM_ERROR.setCPL(PROGRAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        READER_ERROR.setCPL(READER_ERROR, PARSE_ERROR, STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SERIOUS_CONDITION.setCPL(SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_CONDITION.setCPL(SIMPLE_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_ERROR.setCPL(SIMPLE_ERROR, SIMPLE_CONDITION, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_TYPE_ERROR.setDirectSuperclasses(Lisp.list(SIMPLE_CONDITION, TYPE_ERROR));
        SIMPLE_TYPE_ERROR.setCPL(SIMPLE_TYPE_ERROR, SIMPLE_CONDITION, TYPE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_WARNING.setDirectSuperclasses(Lisp.list(SIMPLE_CONDITION, WARNING));
        SIMPLE_WARNING.setCPL(SIMPLE_WARNING, SIMPLE_CONDITION, WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_CLASS.setCPL(STANDARD_CLASS, CLASS, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_OBJECT.setCPL(STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STORAGE_CONDITION.setCPL(STORAGE_CONDITION, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STREAM_ERROR.setCPL(STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STREAM_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.STREAM, Lisp.list(Lisp.PACKAGE_CL.intern("STREAM-ERROR-STREAM"), new LispObject[0])), new LispObject[0]));
        STRUCTURE_CLASS.setCPL(STRUCTURE_CLASS, CLASS, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STYLE_WARNING.setCPL(STYLE_WARNING, WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        TYPE_ERROR.setCPL(TYPE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        TYPE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.DATUM, Lisp.list(Lisp.PACKAGE_CL.intern("TYPE-ERROR-DATUM"), new LispObject[0])), new SlotDefinition(Symbol.EXPECTED_TYPE, Lisp.list(Lisp.PACKAGE_CL.intern("TYPE-ERROR-EXPECTED-TYPE"), new LispObject[0]))));
        UNBOUND_SLOT.setCPL(UNBOUND_SLOT, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        UNBOUND_SLOT.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.INSTANCE, Lisp.list(Lisp.PACKAGE_CL.intern("UNBOUND-SLOT-INSTANCE"), new LispObject[0])), new LispObject[0]));
        UNBOUND_VARIABLE.setCPL(UNBOUND_VARIABLE, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        UNDEFINED_FUNCTION.setCPL(UNDEFINED_FUNCTION, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        WARNING.setCPL(WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        ARITHMETIC_ERROR.finalizeClass();
        CELL_ERROR.finalizeClass();
        COMPILER_ERROR.finalizeClass();
        COMPILER_UNSUPPORTED_FEATURE_ERROR.finalizeClass();
        CONDITION.finalizeClass();
        CONTROL_ERROR.finalizeClass();
        DIVISION_BY_ZERO.finalizeClass();
        END_OF_FILE.finalizeClass();
        ERROR.finalizeClass();
        FILE_ERROR.finalizeClass();
        FLOATING_POINT_INEXACT.finalizeClass();
        FLOATING_POINT_INVALID_OPERATION.finalizeClass();
        FLOATING_POINT_OVERFLOW.finalizeClass();
        FLOATING_POINT_UNDERFLOW.finalizeClass();
        JAVA_EXCEPTION.finalizeClass();
        PACKAGE_ERROR.finalizeClass();
        PARSE_ERROR.finalizeClass();
        PRINT_NOT_READABLE.finalizeClass();
        PROGRAM_ERROR.finalizeClass();
        READER_ERROR.finalizeClass();
        SERIOUS_CONDITION.finalizeClass();
        SIMPLE_CONDITION.finalizeClass();
        SIMPLE_ERROR.finalizeClass();
        SIMPLE_TYPE_ERROR.finalizeClass();
        SIMPLE_WARNING.finalizeClass();
        STORAGE_CONDITION.finalizeClass();
        STREAM_ERROR.finalizeClass();
        STYLE_WARNING.finalizeClass();
        TYPE_ERROR.finalizeClass();
        UNBOUND_SLOT.finalizeClass();
        UNBOUND_VARIABLE.finalizeClass();
        UNDEFINED_FUNCTION.finalizeClass();
        WARNING.finalizeClass();
        Debug.assertTrue(SLOT_DEFINITION.isFinalized());
        SLOT_DEFINITION.setCPL(SLOT_DEFINITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SLOT_DEFINITION.setDirectSlotDefinitions(SLOT_DEFINITION.getClassLayout().generateSlotDefinitions());
        SLOT_DEFINITION.setSlotDefinitions(SLOT_DEFINITION.getDirectSlotDefinitions());
        Debug.assertTrue(STANDARD_METHOD.isFinalized());
        STANDARD_METHOD.setCPL(STANDARD_METHOD, METHOD, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_METHOD.setDirectSlotDefinitions(STANDARD_METHOD.getClassLayout().generateSlotDefinitions());
        STANDARD_METHOD.setSlotDefinitions(STANDARD_METHOD.getDirectSlotDefinitions());
        Debug.assertTrue(STANDARD_READER_METHOD.isFinalized());
        STANDARD_READER_METHOD.setCPL(STANDARD_READER_METHOD, STANDARD_METHOD, METHOD, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_READER_METHOD.setSlotDefinitions(STANDARD_READER_METHOD.getClassLayout().generateSlotDefinitions());
        STANDARD_READER_METHOD.setDirectSlotDefinitions(Lisp.list(STANDARD_READER_METHOD.getSlotDefinitions().reverse().car(), new LispObject[0]));
        Debug.assertTrue(STANDARD_GENERIC_FUNCTION.isFinalized());
        STANDARD_GENERIC_FUNCTION.setCPL(STANDARD_GENERIC_FUNCTION, GENERIC_FUNCTION, STANDARD_OBJECT, BuiltInClass.FUNCTION, BuiltInClass.CLASS_T);
        STANDARD_GENERIC_FUNCTION.setDirectSlotDefinitions(STANDARD_GENERIC_FUNCTION.getClassLayout().generateSlotDefinitions());
        STANDARD_GENERIC_FUNCTION.setSlotDefinitions(STANDARD_GENERIC_FUNCTION.getDirectSlotDefinitions());
    }

    static {
        StandardClass.addClass(Symbol.STANDARD_METHOD, STANDARD_METHOD);
        STANDARD_READER_METHOD = new StandardReaderMethodClass();
        StandardClass.addClass(Symbol.STANDARD_READER_METHOD, STANDARD_READER_METHOD);
        STANDARD_GENERIC_FUNCTION = new StandardGenericFunctionClass();
        StandardClass.addClass(Symbol.STANDARD_GENERIC_FUNCTION, STANDARD_GENERIC_FUNCTION);
        SLOT_DEFINITION = new SlotDefinitionClass();
        StandardClass.addClass(Symbol.SLOT_DEFINITION, SLOT_DEFINITION);
    }
}

