/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DispatchMacroFunction;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.FaslReadtable;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.ReaderMacroFunction;
import org.armedbear.lisp.Readtable;
import org.armedbear.lisp.SimpleArray_T;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.StringInputStream;
import org.armedbear.lisp.StructureClass;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZeroRankArray;
import org.armedbear.lisp.util.DecodingReader;

public class Stream
extends LispObject {
    protected LispObject elementType;
    protected boolean isInputStream;
    protected boolean isOutputStream;
    protected boolean isCharacterStream;
    protected boolean isBinaryStream;
    private boolean pastEnd = false;
    private boolean interactive;
    private boolean open = true;
    protected PushbackReader reader;
    protected int offset;
    protected int lineNumber;
    private Writer writer;
    protected int charPos;
    protected static final Symbol keywordDefault = Lisp.internKeyword("DEFAULT");
    private static final Symbol keywordCodePage = Lisp.internKeyword("CODE-PAGE");
    private static final Symbol keywordID = Lisp.internKeyword("ID");
    private static final Symbol keywordEolStyle = Lisp.internKeyword("EOL-STYLE");
    private static final Symbol keywordCR = Lisp.internKeyword("CR");
    private static final Symbol keywordLF = Lisp.internKeyword("LF");
    private static final Symbol keywordCRLF = Lisp.internKeyword("CRLF");
    private static final Symbol keywordRAW = Lisp.internKeyword("RAW");
    public static final EolStyle platformEolStyle = Utilities.isPlatformWindows ? EolStyle.CRLF : EolStyle.LF;
    protected EolStyle eolStyle = platformEolStyle;
    protected char eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
    protected LispObject externalFormat = Lisp.NIL;
    protected String encoding = null;
    protected char lastChar = '\u0000';
    private InputStream in;
    private OutputStream out;
    private static final Symbol _SHARP_EQUAL_ALIST_ = Lisp.internSpecial("*SHARP-EQUAL-ALIST*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Primitive _WRITE_CHAR = new Primitive("%stream-write-char", Lisp.PACKAGE_SYS, true, "character output-stream"){

        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkStream(second)._writeChar(LispCharacter.getValue(first));
            return first;
        }
    };
    private static final Primitive _STREAM_WRITE_CHAR = new Primitive("%write-char", Lisp.PACKAGE_SYS, false, "character output-stream"){

        public LispObject execute(LispObject first, LispObject second) {
            char c = LispCharacter.getValue(first);
            if (second == Lisp.T) {
                second = Symbol.TERMINAL_IO.symbolValue();
            } else if (second == Lisp.NIL) {
                second = Symbol.STANDARD_OUTPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(second);
            stream._writeChar(c);
            return first;
        }
    };
    private static final Primitive _WRITE_STRING = new Primitive("%write-string", Lisp.PACKAGE_SYS, false, "string output-stream start end"){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractString s = Lisp.checkString(first);
            char[] chars = s.chars();
            Stream out = Lisp.outSynonymOf(second);
            int start = Fixnum.getValue(third);
            int end = fourth == Lisp.NIL ? chars.length : Fixnum.getValue(fourth);
            Lisp.checkBounds(start, end, chars.length);
            out._writeChars(chars, start, end);
            return first;
        }
    };
    private static final Primitive _FINISH_OUTPUT = new Primitive("%finish-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        public LispObject execute(LispObject arg) {
            return Stream.finishOutput(arg);
        }
    };
    private static final Primitive _FORCE_OUTPUT = new Primitive("%force-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        public LispObject execute(LispObject arg) {
            return Stream.finishOutput(arg);
        }
    };
    private static final Primitive CLEAR_INPUT = new Primitive(Symbol.CLEAR_INPUT, "&optional input-stream"){

        public LispObject execute(LispObject[] args) {
            if (args.length > 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Stream in = args.length == 0 ? Lisp.checkCharacterInputStream(Symbol.STANDARD_INPUT.symbolValue()) : Lisp.inSynonymOf(args[0]);
            in.clearInput();
            return Lisp.NIL;
        }
    };
    private static final Primitive _CLEAR_OUTPUT = new Primitive("%clear-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                return Lisp.NIL;
            }
            if (arg == Lisp.NIL) {
                return Lisp.NIL;
            }
            if (arg instanceof Stream) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STREAM);
        }
    };
    private static final Primitive CLOSE = new Primitive(Symbol.CLOSE, "stream &key abort"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkStream(arg).close(Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Stream stream = Lisp.checkStream(first);
            if (second == Keyword.ABORT) {
                return stream.close(third);
            }
            return Lisp.error(new ProgramError("Unrecognized keyword argument " + second.writeToString() + "."));
        }
    };
    private static final Primitive OUT_SYNONYM_OF = new Primitive("out-synonym-of", Lisp.PACKAGE_SYS, true, "stream-designator"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Stream) {
                return arg;
            }
            if (arg == Lisp.T) {
                return Symbol.TERMINAL_IO.symbolValue();
            }
            if (arg == Lisp.NIL) {
                return Symbol.STANDARD_OUTPUT.symbolValue();
            }
            return arg;
        }
    };
    private static final Primitive WRITE_8_BITS = new Primitive("write-8-bits", Lisp.PACKAGE_SYS, true, "byte stream"){

        public LispObject execute(LispObject first, LispObject second) {
            int n = Fixnum.getValue(first);
            if (n < 0 || n > 255) {
                return Lisp.type_error(first, Lisp.UNSIGNED_BYTE_8);
            }
            Lisp.checkStream(second)._writeByte(n);
            return Lisp.NIL;
        }
    };
    private static final Primitive READ_8_BITS = new Primitive("read-8-bits", Lisp.PACKAGE_SYS, true, "stream &optional eof-error-p eof-value"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return Lisp.checkBinaryInputStream(first).readByte(second != Lisp.NIL, third);
        }

        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 1 || length > 3) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Stream in = Lisp.checkBinaryInputStream(args[0]);
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            LispObject eofValue = length > 2 ? args[2] : Lisp.NIL;
            return in.readByte(eofError, eofValue);
        }
    };
    private static final Primitive READ_LINE = new Primitive(Symbol.READ_LINE, "&optional input-stream eof-error-p eof-value recursive-p"){

        public LispObject execute() {
            LispObject obj = Symbol.STANDARD_INPUT.symbolValue();
            Stream stream = Lisp.checkStream(obj);
            return stream.readLine(true, Lisp.NIL);
        }

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue();
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.readLine(true, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, third);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, third);
        }
    };
    private static final Primitive _READ_FROM_STRING = new Primitive("%read-from-string", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            String s = first.getStringValue();
            boolean eofError = second != Lisp.NIL;
            boolean preserveWhitespace = sixth != Lisp.NIL;
            int startIndex = fourth != Lisp.NIL ? Fixnum.getValue(fourth) : 0;
            int endIndex = fifth != Lisp.NIL ? Fixnum.getValue(fifth) : s.length();
            StringInputStream in = new StringInputStream(s, startIndex, endIndex);
            LispThread thread = LispThread.currentThread();
            LispObject result = preserveWhitespace ? in.readPreservingWhitespace(eofError, third, false, thread) : in.read(eofError, third, false, thread);
            return thread.setValues(result, Fixnum.getInstance(in.getOffset()));
        }
    };
    private static final Primitive READ = new Primitive(Symbol.READ, "&optional input-stream eof-error-p eof-value recursive-p"){

        public LispObject execute() {
            LispThread thread = LispThread.currentThread();
            LispObject obj = Symbol.STANDARD_INPUT.symbolValue(thread);
            Stream stream = Lisp.checkStream(obj);
            return stream.read(true, Lisp.NIL, false, thread);
        }

        public LispObject execute(LispObject arg) {
            LispThread thread = LispThread.currentThread();
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.read(true, Lisp.NIL, false, thread);
        }

        public LispObject execute(LispObject first, LispObject second) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, Lisp.NIL, false, thread);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, third, false, thread);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, third, fourth != Lisp.NIL, thread);
        }
    };
    private static final Primitive READ_PRESERVING_WHITESPACE = new Primitive(Symbol.READ_PRESERVING_WHITESPACE, "&optional input-stream eof-error-p eof-value recursive-p"){

        public LispObject execute(LispObject[] args) {
            LispObject eofValue;
            Stream stream;
            int length = args.length;
            if (length > 4) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Stream stream2 = stream = length > 0 ? Lisp.inSynonymOf(args[0]) : Lisp.getStandardInput();
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            LispObject lispObject = eofValue = length > 2 ? args[2] : Lisp.NIL;
            boolean recursive = length > 3 ? args[3] != Lisp.NIL : false;
            return stream.readPreservingWhitespace(eofError, eofValue, recursive, LispThread.currentThread());
        }
    };
    private static final Primitive READ_CHAR = new Primitive(Symbol.READ_CHAR, "&optional input-stream eof-error-p eof-value recursive-p"){

        public LispObject execute() {
            return Lisp.checkCharacterInputStream(Symbol.STANDARD_INPUT.symbolValue()).readChar();
        }

        public LispObject execute(LispObject arg) {
            return Lisp.inSynonymOf(arg).readChar();
        }

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, Lisp.NIL);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, third);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, third);
        }
    };
    private static final Primitive READ_CHAR_NO_HANG = new Primitive("read-char-no-hang", "&optional input-stream eof-error-p eof-value recursive-p"){

        public LispObject execute(LispObject[] args) {
            Stream stream;
            int length = args.length;
            if (length > 4) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            Stream stream2 = stream = length > 0 ? Lisp.inSynonymOf(args[0]) : Lisp.getStandardInput();
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            LispObject eofValue = length > 2 ? args[2] : Lisp.NIL;
            return stream.readCharNoHang(eofError, eofValue);
        }
    };
    private static final Primitive READ_DELIMITED_LIST = new Primitive("read-delimited-list", "char &optional input-stream recursive-p"){

        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 1 || length > 3) {
                Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char c = LispCharacter.getValue(args[0]);
            Stream stream = length > 1 ? Lisp.inSynonymOf(args[1]) : Lisp.getStandardInput();
            return stream.readDelimitedList(c);
        }
    };
    private static final Primitive UNREAD_CHAR = new Primitive(Symbol.UNREAD_CHAR, "character &optional input-stream"){

        public LispObject execute(LispObject arg) {
            return Lisp.getStandardInput().unreadChar(Lisp.checkCharacter(arg));
        }

        public LispObject execute(LispObject first, LispObject second) {
            Stream stream = Lisp.inSynonymOf(second);
            return stream.unreadChar(Lisp.checkCharacter(first));
        }
    };
    private static final Primitive WRITE_VECTOR_UNSIGNED_BYTE_8 = new Primitive("write-vector-unsigned-byte-8", Lisp.PACKAGE_SYS, true, "vector stream start end"){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractVector v = Lisp.checkVector(first);
            Stream stream = Lisp.checkStream(second);
            int start = Fixnum.getValue(third);
            int end = Fixnum.getValue(fourth);
            for (int i = start; i < end; ++i) {
                stream._writeByte(v.aref(i));
            }
            return v;
        }
    };
    private static final Primitive READ_VECTOR_UNSIGNED_BYTE_8 = new Primitive("read-vector-unsigned-byte-8", Lisp.PACKAGE_SYS, true, "vector stream start end"){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractVector v = Lisp.checkVector(first);
            Stream stream = Lisp.checkBinaryInputStream(second);
            int start = Fixnum.getValue(third);
            int end = Fixnum.getValue(fourth);
            if (!v.getElementType().equal(Lisp.UNSIGNED_BYTE_8)) {
                return Lisp.type_error(first, Lisp.list(Symbol.VECTOR, Lisp.UNSIGNED_BYTE_8));
            }
            for (int i = start; i < end; ++i) {
                int n = stream._readByte();
                if (n < 0) {
                    return Fixnum.getInstance(i);
                }
                v.aset(i, n);
            }
            return fourth;
        }
    };
    private static final Primitive FILE_POSITION = new Primitive("file-position", "stream &optional position-spec"){

        public LispObject execute(LispObject arg) {
            return Lisp.checkStream(arg).getFilePosition();
        }

        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.checkStream(first).setFilePosition(second);
        }
    };
    private static final Primitive STREAM_LINE_NUMBER = new Primitive("stream-line-number", Lisp.PACKAGE_SYS, false, "stream"){

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(Lisp.checkStream(arg).getLineNumber() + 1);
        }
    };
    private static final Primitive STREAM_OFFSET = new Primitive("stream-offset", Lisp.PACKAGE_SYS, false, "stream"){

        public LispObject execute(LispObject arg) {
            return Lisp.number(Lisp.checkStream(arg).getOffset());
        }
    };
    private static final Primitive STREAM_CHARPOS = new Primitive("stream-charpos", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            Stream stream = Lisp.checkCharacterOutputStream(arg);
            return Fixnum.getInstance(stream.getCharPos());
        }
    };
    private static final Primitive STREAM_SET_CHARPOS = new Primitive("stream-%set-charpos", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            Stream stream = Lisp.checkCharacterOutputStream(first);
            stream.setCharPos(Fixnum.getValue(second));
            return second;
        }
    };

    protected Stream() {
    }

    public Stream(InputStream stream) {
        this.initAsBinaryInputStream(stream);
    }

    public Stream(Reader r) {
        this.initAsCharacterInputStream(r);
    }

    public Stream(OutputStream stream) {
        this.initAsBinaryOutputStream(stream);
    }

    public Stream(Writer w) {
        this.initAsCharacterOutputStream(w);
    }

    public Stream(InputStream inputStream, LispObject elementType) {
        this(inputStream, elementType, (LispObject)keywordDefault);
    }

    public Stream(InputStream inputStream, LispObject elementType, LispObject format) {
        this.elementType = elementType;
        this.setExternalFormat(format);
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            DecodingReader reader = new DecodingReader(inputStream, 4096, this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding));
            this.initAsCharacterInputStream(reader);
        } else {
            this.isBinaryStream = true;
            BufferedInputStream stream = new BufferedInputStream(inputStream);
            this.initAsBinaryInputStream(stream);
        }
    }

    public Stream(InputStream inputStream, LispObject elementType, boolean interactive) {
        this(inputStream, elementType);
        this.setInteractive(interactive);
    }

    public Stream(OutputStream outputStream, LispObject elementType) {
        this(outputStream, elementType, (LispObject)keywordDefault);
    }

    public Stream(OutputStream outputStream, LispObject elementType, LispObject format) {
        this.elementType = elementType;
        this.setExternalFormat(format);
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            OutputStreamWriter w = this.encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, Charset.forName(this.encoding).newEncoder());
            this.initAsCharacterOutputStream(w);
        } else {
            BufferedOutputStream stream = new BufferedOutputStream(outputStream);
            this.initAsBinaryOutputStream(stream);
        }
    }

    public Stream(OutputStream outputStream, LispObject elementType, boolean interactive) {
        this(outputStream, elementType);
        this.setInteractive(interactive);
    }

    protected void initAsCharacterInputStream(Reader reader) {
        this.reader = !(reader instanceof PushbackReader) ? new PushbackReader(reader, 5) : (PushbackReader)reader;
        this.isInputStream = true;
        this.isCharacterStream = true;
    }

    protected void initAsBinaryInputStream(InputStream in) {
        this.in = in;
        this.isInputStream = true;
        this.isBinaryStream = true;
    }

    protected void initAsCharacterOutputStream(Writer writer) {
        this.writer = writer;
        this.isOutputStream = true;
        this.isCharacterStream = true;
    }

    protected void initAsBinaryOutputStream(OutputStream out) {
        this.out = out;
        this.isOutputStream = true;
        this.isBinaryStream = true;
    }

    public boolean isInputStream() {
        return this.isInputStream;
    }

    public boolean isOutputStream() {
        return this.isOutputStream;
    }

    public boolean isCharacterInputStream() {
        return this.isCharacterStream && this.isInputStream;
    }

    public boolean isBinaryInputStream() {
        return this.isBinaryStream && this.isInputStream;
    }

    public boolean isCharacterOutputStream() {
        return this.isCharacterStream && this.isOutputStream;
    }

    public boolean isBinaryOutputStream() {
        return this.isBinaryStream && this.isOutputStream;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean b) {
        this.interactive = b;
    }

    public LispObject getExternalFormat() {
        return this.externalFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExternalFormat(LispObject format) {
        LispObject enc;
        boolean encIsCp;
        block16: {
            block17: {
                LispObject eol;
                block18: {
                    this.finishOutput();
                    if (format == keywordDefault) {
                        this.encoding = null;
                        this.eolStyle = platformEolStyle;
                        this.eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
                        this.externalFormat = format;
                        return;
                    }
                    encIsCp = false;
                    if (!(format instanceof Cons)) break block17;
                    enc = format.car();
                    if (enc == keywordCodePage) {
                        encIsCp = true;
                        enc = Lisp.getf(format.cdr(), keywordID, null);
                    }
                    if ((eol = Lisp.getf(format.cdr(), keywordEolStyle, keywordRAW)) != keywordCR) break block18;
                    this.eolStyle = EolStyle.CR;
                    break block16;
                }
                if (eol == keywordLF) {
                    this.eolStyle = EolStyle.LF;
                    break block16;
                } else if (eol == keywordCRLF) {
                    this.eolStyle = EolStyle.CRLF;
                    break block16;
                } else if (eol == keywordRAW) {
                    // empty if block
                }
                break block16;
            }
            enc = format;
        }
        if (enc.numberp()) {
            this.encoding = enc.toString();
        } else if (enc instanceof AbstractString) {
            this.encoding = enc.getStringValue();
        } else if (enc == keywordDefault) {
            this.encoding = null;
        } else if (enc instanceof Symbol) {
            this.encoding = ((Symbol)enc).getName();
        }
        if (encIsCp) {
            this.encoding = "Cp" + this.encoding;
        }
        this.eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
        this.externalFormat = format;
        if (this.reader != null && this.reader instanceof DecodingReader) {
            ((DecodingReader)this.reader).setCharset(Charset.forName(this.encoding));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    public LispObject typeOf() {
        return Symbol.STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.STREAM;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject getElementType() {
        return this.elementType;
    }

    public int getOffset() {
        return this.offset;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    public int getCharPos() {
        return this.charPos;
    }

    public void setCharPos(int n) {
        this.charPos = n;
    }

    public LispObject read(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread) {
        LispObject result = this.readPreservingWhitespace(eofError, eofValue, recursive, thread);
        if (result != eofValue && !recursive) {
            try {
                int n;
                if (this._charReady() && (n = this._readChar()) >= 0) {
                    char c = (char)n;
                    Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
                    if (!rt.isWhitespace(c)) {
                        this._unreadChar(c);
                    }
                }
            }
            catch (IOException e) {
                return Lisp.error(new StreamError(this, e));
            }
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject readPreservingWhitespace(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread) {
        if (recursive) {
            LispObject result;
            int n;
            char c;
            Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
            do {
                n = -1;
                try {
                    n = this._readChar();
                }
                catch (IOException e) {
                    Lisp.error(new StreamError(this, e));
                }
                if (n >= 0) continue;
                if (eofError) {
                    return Lisp.error(new EndOfFile(this));
                }
                return eofValue;
            } while (rt.isWhitespace(c = (char)n) || (result = this.processChar(c, rt)) == null);
            return result;
        }
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(_SHARP_EQUAL_ALIST_, Lisp.NIL);
        try {
            LispObject lispObject = this.readPreservingWhitespace(eofError, eofValue, true, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public LispObject faslRead(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread) {
        try {
            int n;
            LispObject result = this.faslReadPreservingWhitespace(eofError, eofValue, recursive, thread);
            if (result != eofValue && !recursive && this._charReady() && (n = this._readChar()) >= 0) {
                char c = (char)n;
                FaslReadtable rt = FaslReadtable.getInstance();
                if (!rt.isWhitespace(c)) {
                    this._unreadChar(c);
                }
            }
            if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
                return Lisp.NIL;
            }
            return result;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LispObject faslReadPreservingWhitespace(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread) throws IOException {
        if (recursive) {
            LispObject result;
            int n;
            char c;
            FaslReadtable rt = FaslReadtable.getInstance();
            do {
                if ((n = this._readChar()) >= 0) continue;
                if (eofError) {
                    return Lisp.error(new EndOfFile(this));
                }
                return eofValue;
            } while (rt.isWhitespace(c = (char)n) || (result = this.processChar(c, rt)) == null);
            return result;
        }
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(_SHARP_EQUAL_ALIST_, Lisp.NIL);
        try {
            LispObject lispObject = this.faslReadPreservingWhitespace(eofError, eofValue, true, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    private final LispObject processChar(char c, Readtable rt) {
        LispObject handler = rt.getReaderMacroFunction(c);
        if (handler instanceof ReaderMacroFunction) {
            return ((ReaderMacroFunction)handler).execute(this, c);
        }
        if (handler != null && handler != Lisp.NIL) {
            return handler.execute((LispObject)this, LispCharacter.getInstance(c));
        }
        return this.readToken(c, rt);
    }

    public LispObject readPathname() {
        LispObject obj = this.read(true, Lisp.NIL, false, LispThread.currentThread());
        if (obj instanceof AbstractString) {
            return Pathname.parseNamestring((AbstractString)obj);
        }
        if (obj.listp()) {
            return Pathname.makePathname(obj);
        }
        return Lisp.error(new TypeError("#p requires a string or list argument."));
    }

    public LispObject faslReadPathname() {
        LispObject obj = this.faslRead(true, Lisp.NIL, false, LispThread.currentThread());
        if (obj instanceof AbstractString) {
            return Pathname.parseNamestring((AbstractString)obj);
        }
        if (obj.listp()) {
            return Pathname.makePathname(obj);
        }
        return Lisp.error(new TypeError("#p requires a string or list argument."));
    }

    public LispObject readSymbol() {
        Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(LispThread.currentThread());
        FastStringBuffer sb = new FastStringBuffer();
        this._readToken(sb, rt);
        return new Symbol(sb.toString());
    }

    public LispObject readSymbol(Readtable rt) {
        FastStringBuffer sb = new FastStringBuffer();
        this._readToken(sb, rt);
        return new Symbol(sb.toString());
    }

    public LispObject readStructure() {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj.listp()) {
            Symbol structure = Lisp.checkSymbol(obj.car());
            LispClass c = LispClass.findClass(structure);
            if (!(c instanceof StructureClass)) {
                return Lisp.error(new ReaderError(structure.getName() + " is not a defined structure type.", this));
            }
            LispObject args = obj.cdr();
            Symbol DEFSTRUCT_DEFAULT_CONSTRUCTOR = Lisp.PACKAGE_SYS.intern("DEFSTRUCT-DEFAULT-CONSTRUCTOR");
            LispObject constructor = DEFSTRUCT_DEFAULT_CONSTRUCTOR.getSymbolFunctionOrDie().execute(structure);
            int length = args.length();
            if (length % 2 != 0) {
                return Lisp.error(new ReaderError("Odd number of keyword arguments following #S: " + obj.writeToString(), this));
            }
            LispObject[] array = new LispObject[length];
            LispObject rest = args;
            for (int i = 0; i < length; i += 2) {
                LispObject key = rest.car();
                array[i] = key instanceof Symbol && ((Symbol)key).getPackage() == Lisp.PACKAGE_KEYWORD ? key : Lisp.PACKAGE_KEYWORD.intern(Lisp.javaString(key));
                array[i + 1] = rest.cadr();
                rest = rest.cddr();
            }
            return Lisp.funcall(constructor.getSymbolFunctionOrDie(), array, thread);
        }
        return Lisp.error(new ReaderError("Non-list following #S: " + obj.writeToString(), this));
    }

    public LispObject faslReadStructure() {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.faslRead(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj.listp()) {
            Symbol structure = Lisp.checkSymbol(obj.car());
            LispClass c = LispClass.findClass(structure);
            if (!(c instanceof StructureClass)) {
                return Lisp.error(new ReaderError(structure.getName() + " is not a defined structure type.", this));
            }
            LispObject args = obj.cdr();
            Symbol DEFSTRUCT_DEFAULT_CONSTRUCTOR = Lisp.PACKAGE_SYS.intern("DEFSTRUCT-DEFAULT-CONSTRUCTOR");
            LispObject constructor = DEFSTRUCT_DEFAULT_CONSTRUCTOR.getSymbolFunctionOrDie().execute(structure);
            int length = args.length();
            if (length % 2 != 0) {
                return Lisp.error(new ReaderError("Odd number of keyword arguments following #S: " + obj.writeToString(), this));
            }
            LispObject[] array = new LispObject[length];
            LispObject rest = args;
            for (int i = 0; i < length; i += 2) {
                LispObject key = rest.car();
                array[i] = key instanceof Symbol && ((Symbol)key).getPackage() == Lisp.PACKAGE_KEYWORD ? key : Lisp.PACKAGE_KEYWORD.intern(Lisp.javaString(key));
                array[i + 1] = rest.cadr();
                rest = rest.cddr();
            }
            return Lisp.funcall(constructor.getSymbolFunctionOrDie(), array, thread);
        }
        return Lisp.error(new ReaderError("Non-list following #S: " + obj.writeToString(), this));
    }

    public LispObject readList(boolean requireProperList, boolean useFaslReadtable) {
        LispThread thread = LispThread.currentThread();
        Cons first = null;
        Cons last2 = null;
        Readtable rt = null;
        if (useFaslReadtable) {
            rt = FaslReadtable.getInstance();
        }
        try {
            while (true) {
                LispObject obj;
                char c;
                if (!useFaslReadtable) {
                    rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
                }
                if ((c = this.flushWhitespace(rt)) == ')') {
                    return first == null ? Lisp.NIL : first;
                }
                if (c == '.') {
                    int n = this._readChar();
                    if (n < 0) {
                        return Lisp.error(new EndOfFile(this));
                    }
                    char nextChar = (char)n;
                    if (Stream.isTokenDelimiter(nextChar, rt)) {
                        if (last2 == null) {
                            if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
                                return Lisp.NIL;
                            }
                            return Lisp.error(new ReaderError("Nothing appears before . in list.", this));
                        }
                        this._unreadChar(nextChar);
                        LispObject obj2 = this.read(true, Lisp.NIL, true, thread);
                        if (requireProperList && !obj2.listp()) {
                            Lisp.error(new ReaderError("The value " + obj2.writeToString() + " is not of type " + Symbol.LIST.writeToString() + ".", this));
                        }
                        last2.cdr = obj2;
                        continue;
                    }
                    this._unreadChar(nextChar);
                }
                if ((obj = this.processChar(c, rt)) == null) continue;
                if (first == null) {
                    last2 = first = new Cons(obj);
                    continue;
                }
                Cons newCons = new Cons(obj);
                last2.cdr = newCons;
                last2 = newCons;
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return null;
        }
    }

    private static final boolean isTokenDelimiter(char c, Readtable rt) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '`': {
                return true;
            }
        }
        return rt.isWhitespace(c);
    }

    public LispObject readDispatchChar(char dispChar, boolean useFaslReadtable) {
        int numArg = -1;
        char c = '\u0000';
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return Lisp.error(new EndOfFile(this));
                }
                c = (char)n;
                if (c >= '0' && c <= '9') {
                    if (numArg < 0) {
                        numArg = 0;
                    }
                    numArg = numArg * 10 + c - 48;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
        LispThread thread = LispThread.currentThread();
        Readtable rt = useFaslReadtable ? FaslReadtable.getInstance() : (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
        LispObject fun = rt.getDispatchMacroCharacter(dispChar, c);
        if (fun instanceof DispatchMacroFunction) {
            return ((DispatchMacroFunction)fun).execute(this, c, numArg);
        }
        if (fun != Lisp.NIL) {
            LispObject result = thread.execute(fun, this, LispCharacter.getInstance(c), numArg < 0 ? Lisp.NIL : Fixnum.getInstance(numArg));
            LispObject[] values = thread._values;
            if (values != null && values.length == 0) {
                result = null;
            }
            thread._values = null;
            return result;
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return null;
        }
        return Lisp.error(new ReaderError("No dispatch function defined for #\\" + c, this));
    }

    public LispObject readCharacterLiteral(Readtable rt, LispThread thread) {
        try {
            int n = this._readChar();
            if (n < 0) {
                return Lisp.error(new EndOfFile(this));
            }
            char c = (char)n;
            FastStringBuffer sb = new FastStringBuffer(c);
            while ((n = this._readChar()) >= 0 && !rt.isWhitespace(c = (char)n)) {
                if (c == '(' || c == ')') {
                    this._unreadChar(c);
                    break;
                }
                sb.append(c);
            }
            if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
                return Lisp.NIL;
            }
            if (sb.length() == 1) {
                return LispCharacter.getInstance(sb.charAt(0));
            }
            String token = sb.toString();
            n = LispCharacter.nameToChar(token);
            if (n >= 0) {
                return LispCharacter.getInstance((char)n);
            }
            return Lisp.error(new LispError("Unrecognized character name: \"" + token + '\"'));
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public void skipBalancedComment() {
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return;
                }
                if (n == 124) {
                    n = this._readChar();
                    if (n == 35) {
                        return;
                    }
                    this._unreadChar(n);
                    continue;
                }
                if (n != 35) continue;
                n = this._readChar();
                if (n == 124) {
                    this.skipBalancedComment();
                    continue;
                }
                this._unreadChar(n);
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return;
        }
    }

    public LispObject readArray(int rank) {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        switch (rank) {
            case -1: {
                return Lisp.error(new ReaderError("No dimensions argument to #A.", this));
            }
            case 0: {
                return new ZeroRankArray(Lisp.T, obj, false);
            }
            case 1: {
                if (obj.listp() || obj instanceof AbstractVector) {
                    return new SimpleVector(obj);
                }
                return Lisp.error(new ReaderError(obj.writeToString() + " is not a sequence.", this));
            }
        }
        return new SimpleArray_T(rank, obj);
    }

    public LispObject faslReadArray(int rank) {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.faslRead(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        switch (rank) {
            case -1: {
                return Lisp.error(new ReaderError("No dimensions argument to #A.", this));
            }
            case 0: {
                return new ZeroRankArray(Lisp.T, obj, false);
            }
            case 1: {
                if (obj.listp() || obj instanceof AbstractVector) {
                    return new SimpleVector(obj);
                }
                return Lisp.error(new ReaderError(obj.writeToString() + " is not a sequence.", this));
            }
        }
        return new SimpleArray_T(rank, obj);
    }

    public LispObject readComplex() {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj instanceof Cons && obj.length() == 2) {
            return Complex.getInstance(obj.car(), obj.cadr());
        }
        FastStringBuffer sb = new FastStringBuffer("Invalid complex number format");
        if (this instanceof FileStream) {
            String namestring;
            Pathname p = ((FileStream)this).getPathname();
            if (p != null && (namestring = p.getNamestring()) != null) {
                sb.append(" in #P\"");
                sb.append(namestring);
                sb.append('\"');
            }
            sb.append(" at offset ");
            sb.append(this._getFilePosition());
        }
        sb.append(": #C");
        sb.append(obj.writeToString());
        return Lisp.error(new ReaderError(sb.toString(), this));
    }

    public LispObject faslReadComplex() {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.faslRead(true, Lisp.NIL, true, thread);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj instanceof Cons && obj.length() == 2) {
            return Complex.getInstance(obj.car(), obj.cadr());
        }
        FastStringBuffer sb = new FastStringBuffer("Invalid complex number format");
        if (this instanceof FileStream) {
            String namestring;
            Pathname p = ((FileStream)this).getPathname();
            if (p != null && (namestring = p.getNamestring()) != null) {
                sb.append(" in #P\"");
                sb.append(namestring);
                sb.append('\"');
            }
            sb.append(" at offset ");
            sb.append(this._getFilePosition());
        }
        sb.append(": #C");
        sb.append(obj.writeToString());
        return Lisp.error(new ReaderError(sb.toString(), this));
    }

    private String readMultipleEscape(Readtable rt) {
        FastStringBuffer sb = new FastStringBuffer();
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    Lisp.error(new EndOfFile(this));
                    return null;
                }
                char c = (char)n;
                byte syntaxType = rt.getSyntaxType(c);
                if (syntaxType == 4) {
                    n = this._readChar();
                    if (n < 0) {
                        Lisp.error(new EndOfFile(this));
                        return null;
                    }
                    sb.append((char)n);
                    continue;
                }
                if (syntaxType != 5) {
                    sb.append(c);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
        return sb.toString();
    }

    private static final int findUnescapedSingleColon(String s, BitSet flags) {
        if (flags == null) {
            return s.indexOf(58);
        }
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            if (s.charAt(i) != ':' || flags.get(i)) continue;
            return i;
        }
        return -1;
    }

    private static final int findUnescapedDoubleColon(String s, BitSet flags) {
        if (flags == null) {
            return s.indexOf("::");
        }
        int limit = s.length() - 1;
        for (int i = 0; i < limit; ++i) {
            if (s.charAt(i) != ':' || flags.get(i) || s.charAt(i + 1) != ':' || flags.get(i + 1)) continue;
            return i;
        }
        return -1;
    }

    private final LispObject readToken(char c, Readtable rt) {
        FastStringBuffer sb = new FastStringBuffer(c);
        LispThread thread = LispThread.currentThread();
        BitSet flags = this._readToken(sb, rt);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        LispObject readtableCase = rt.getReadtableCase();
        String token = readtableCase == Keyword.INVERT ? Stream.invert(sb.toString(), flags) : sb.toString();
        int length = token.length();
        if (length > 0) {
            char firstChar = token.charAt(0);
            if (flags == null) {
                LispObject number;
                if (firstChar == '.') {
                    boolean ok = false;
                    int i = length;
                    while (i-- > 1) {
                        if (token.charAt(i) == '.') continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        String message = length > 1 ? "Too many dots." : "Dot context error.";
                        return Lisp.error(new ReaderError(message, this));
                    }
                }
                int radix = Stream.getReadBase(thread);
                if ("+-.0123456789".indexOf(firstChar) >= 0) {
                    LispObject number2 = this.makeNumber(token, length, radix);
                    if (number2 != null) {
                        return number2;
                    }
                } else if (Character.digit(firstChar, radix) >= 0 && (number = this.makeNumber(token, length, radix)) != null) {
                    return number;
                }
            }
            if (!(firstChar != ':' || flags != null && flags.get(0))) {
                return Lisp.PACKAGE_KEYWORD.intern(token.substring(1));
            }
            int index = Stream.findUnescapedDoubleColon(token, flags);
            if (index > 0) {
                String packageName = token.substring(0, index);
                String symbolName = token.substring(index + 2);
                Package pkg = Packages.findPackage(packageName);
                if (pkg == null) {
                    return Lisp.error(new LispError("Package \"" + packageName + "\" not found."));
                }
                return pkg.intern(symbolName);
            }
            index = Stream.findUnescapedSingleColon(token, flags);
            if (index > 0) {
                String packageName = token.substring(0, index);
                Package pkg = Packages.findPackage(packageName);
                if (pkg == null) {
                    return Lisp.error(new PackageError("Package \"" + packageName + "\" not found."));
                }
                String symbolName = token.substring(index + 1);
                SimpleString s = new SimpleString(symbolName);
                Symbol symbol = pkg.findExternalSymbol(s);
                if (symbol != null) {
                    return symbol;
                }
                if (pkg.findInternalSymbol(s) != null) {
                    return Lisp.error(new ReaderError("The symbol \"" + symbolName + "\" is not external in package " + packageName + '.', this));
                }
                return Lisp.error(new ReaderError("The symbol \"" + symbolName + "\" was not found in package " + packageName + '.', this));
            }
        }
        return ((Package)Symbol._PACKAGE_.symbolValue(thread)).intern(new SimpleString(token));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BitSet _readToken(FastStringBuffer sb, Readtable rt) {
        BitSet flags = null;
        LispObject readtableCase = rt.getReadtableCase();
        if (sb.length() > 0) {
            Debug.assertTrue(sb.length() == 1);
            char c = sb.charAt(0);
            byte syntaxType = rt.getSyntaxType(c);
            if (syntaxType == 4) {
                int n = -1;
                try {
                    n = this._readChar();
                }
                catch (IOException e) {
                    Lisp.error(new StreamError(this, e));
                    return flags;
                }
                if (n < 0) {
                    Lisp.error(new EndOfFile(this));
                    return flags;
                }
                sb.setCharAt(0, (char)n);
                flags = new BitSet(1);
                flags.set(0);
            } else if (syntaxType == 5) {
                sb.setLength(0);
                sb.append(this.readMultipleEscape(rt));
                flags = new BitSet(sb.length());
                int i = sb.length();
                while (i-- > 0) {
                    flags.set(i);
                }
            } else if (rt.isInvalid(c)) {
                rt.checkInvalid(c, this);
            } else if (readtableCase == Keyword.UPCASE) {
                sb.setCharAt(0, LispCharacter.toUpperCase(c));
            } else if (readtableCase == Keyword.DOWNCASE) {
                sb.setCharAt(0, LispCharacter.toLowerCase(c));
            }
        }
        try {
            block5: while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return flags;
                }
                char c = (char)n;
                if (rt.isWhitespace(c)) {
                    this._unreadChar(n);
                    return flags;
                }
                byte syntaxType = rt.getSyntaxType(c);
                if (syntaxType == 2) {
                    this._unreadChar(c);
                    return flags;
                }
                rt.checkInvalid(c, this);
                if (syntaxType == 4) {
                    n = this._readChar();
                    if (n < 0) {
                        return flags;
                    }
                    sb.append((char)n);
                    if (flags == null) {
                        flags = new BitSet(sb.length());
                    }
                    flags.set(sb.length() - 1);
                    continue;
                }
                if (syntaxType == 5) {
                    int begin = sb.length();
                    sb.append(this.readMultipleEscape(rt));
                    int end = sb.length();
                    if (flags == null) {
                        flags = new BitSet(sb.length());
                    }
                    int i = begin;
                    while (true) {
                        if (i >= end) continue block5;
                        flags.set(i);
                        ++i;
                    }
                }
                if (readtableCase == Keyword.UPCASE) {
                    c = LispCharacter.toUpperCase(c);
                } else if (readtableCase == Keyword.DOWNCASE) {
                    c = LispCharacter.toLowerCase(c);
                }
                sb.append(c);
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return flags;
        }
    }

    public static final String invert(String s, BitSet flags) {
        int limit = s.length();
        boolean LOWER = true;
        int UPPER = 2;
        int state = 0;
        for (int i = 0; i < limit; ++i) {
            if (flags != null && flags.get(i)) continue;
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (state == 1) {
                    return s;
                }
                state = 2;
            }
            if (!Character.isLowerCase(c)) continue;
            if (state == 2) {
                return s;
            }
            state = 1;
        }
        FastStringBuffer sb = new FastStringBuffer(limit);
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (flags != null && flags.get(i)) {
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final int getReadBase(LispThread thread) {
        LispObject readBaseObject = Symbol.READ_BASE.symbolValue(thread);
        if (!(readBaseObject instanceof Fixnum)) {
            Lisp.error(new LispError("The value of *READ-BASE* is not of type '(INTEGER 2 36)."));
            return 10;
        }
        int readBase = ((Fixnum)readBaseObject).value;
        if (readBase < 2 || readBase > 36) {
            Lisp.error(new LispError("The value of *READ-BASE* is not of type '(INTEGER 2 36)."));
            return 10;
        }
        return readBase;
    }

    private final LispObject makeNumber(String token, int length, int radix) {
        int i;
        if (length == 0) {
            return null;
        }
        if (token.indexOf(47) >= 0) {
            return this.makeRatio(token, radix);
        }
        if (token.charAt(length - 1) == '.') {
            radix = 10;
            token = token.substring(0, --length);
        }
        boolean numeric = true;
        if (radix == 10) {
            i = length;
            while (i-- > 0) {
                char c = token.charAt(i);
                if (c >= '0' && c <= '9' || i <= 0 && (c == '-' || c == '+')) continue;
                numeric = false;
                break;
            }
        } else {
            i = length;
            while (i-- > 0) {
                char c = token.charAt(i);
                if (Character.digit(c, radix) >= 0 || i <= 0 && (c == '-' || c == '+')) continue;
                numeric = false;
                break;
            }
        }
        if (!numeric) {
            return Stream.makeFloat(token, length);
        }
        if (token.charAt(0) == '+') {
            token = token.substring(1);
        }
        try {
            int n = Integer.parseInt(token, radix);
            return n >= 0 && n <= 255 ? Fixnum.constants[n] : Fixnum.getInstance(n);
        }
        catch (NumberFormatException e) {
            try {
                return Bignum.getInstance(token, radix);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    private final LispObject makeRatio(String token, int radix) {
        int index = token.indexOf(47);
        if (index < 0) {
            return null;
        }
        try {
            BigInteger numerator = new BigInteger(token.substring(0, index), radix);
            BigInteger denominator = new BigInteger(token.substring(index + 1), radix);
            if (denominator.signum() == 0) {
                Lisp.error(new ReaderError("Division by zero.", this));
            }
            return Lisp.number(numerator, denominator);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final LispObject makeFloat(String token, int length) {
        LispObject format;
        if (length == 0) {
            return null;
        }
        FastStringBuffer sb = new FastStringBuffer();
        int i = 0;
        boolean maybe = false;
        int marker = 0;
        char c = token.charAt(i);
        if (c == '-' || c == '+') {
            sb.append(c);
            ++i;
        }
        while (i < length && ((c = token.charAt(i)) == '.' || c >= '0' && c <= '9')) {
            if (c == '.') {
                maybe = true;
            }
            sb.append(c);
            ++i;
        }
        if (i < length && "esfdlESFDL".indexOf(c = token.charAt(i)) >= 0) {
            maybe = true;
            marker = LispCharacter.toUpperCase(c);
            if (marker == 83) {
                marker = 70;
            } else if (marker == 76) {
                marker = 68;
            } else if (marker == 69) {
                format = Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue();
                marker = format == Symbol.SINGLE_FLOAT || format == Symbol.SHORT_FLOAT ? 70 : 68;
            }
            sb.append('E');
            ++i;
        }
        if (!maybe) {
            return null;
        }
        sb.append(token.substring(i));
        try {
            if (marker == 0) {
                format = Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue();
                marker = format == Symbol.SINGLE_FLOAT || format == Symbol.SHORT_FLOAT ? 70 : 68;
            }
            if (marker == 68) {
                return new DoubleFloat(Double.parseDouble(sb.toString()));
            }
            return new SingleFloat(Float.parseFloat(sb.toString()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public LispObject readRadix(int radix) {
        boolean escaped;
        FastStringBuffer sb = new FastStringBuffer();
        LispThread thread = LispThread.currentThread();
        Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
        boolean bl = escaped = this._readToken(sb, rt) != null;
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (escaped) {
            return Lisp.error(new ReaderError("Illegal syntax for number.", this));
        }
        String s = sb.toString();
        if (s.indexOf(47) >= 0) {
            return this.makeRatio(s, radix);
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        try {
            int n = Integer.parseInt(s, radix);
            return n >= 0 && n <= 255 ? Fixnum.constants[n] : Fixnum.getInstance(n);
        }
        catch (NumberFormatException e) {
            try {
                return Bignum.getInstance(s, radix);
            }
            catch (NumberFormatException e2) {
                return Lisp.error(new LispError());
            }
        }
    }

    public LispObject faslReadRadix(int radix) {
        boolean escaped;
        FastStringBuffer sb = new FastStringBuffer();
        LispThread thread = LispThread.currentThread();
        FaslReadtable rt = FaslReadtable.getInstance();
        boolean bl = escaped = this._readToken(sb, rt) != null;
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (escaped) {
            return Lisp.error(new ReaderError("Illegal syntax for number.", this));
        }
        String s = sb.toString();
        if (s.indexOf(47) >= 0) {
            return this.makeRatio(s, radix);
        }
        try {
            int n = Integer.parseInt(s, radix);
            return n >= 0 && n <= 255 ? Fixnum.constants[n] : Fixnum.getInstance(n);
        }
        catch (NumberFormatException e) {
            try {
                return Bignum.getInstance(s, radix);
            }
            catch (NumberFormatException e2) {
                return Lisp.error(new LispError());
            }
        }
    }

    private char flushWhitespace(Readtable rt) {
        try {
            int n;
            char c;
            do {
                if ((n = this._readChar()) >= 0) continue;
                Lisp.error(new EndOfFile(this));
                return '\u0000';
            } while (rt.isWhitespace(c = (char)n));
            return c;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return '\u0000';
        }
    }

    public LispObject readDelimitedList(char delimiter) {
        Readtable rt;
        char c;
        LispThread thread = LispThread.currentThread();
        LispObject result = Lisp.NIL;
        while ((c = this.flushWhitespace(rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread))) != delimiter) {
            LispObject obj = this.processChar(c, rt);
            if (obj == null) continue;
            result = new Cons(obj, result);
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        return result.nreverse();
    }

    public LispObject readLine(boolean eofError, LispObject eofValue) {
        LispThread thread = LispThread.currentThread();
        FastStringBuffer sb = new FastStringBuffer();
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    if (sb.length() == 0) {
                        if (eofError) {
                            return Lisp.error(new EndOfFile(this));
                        }
                        return thread.setValues(eofValue, Lisp.T);
                    }
                    return thread.setValues(new SimpleString(sb), Lisp.T);
                }
                if (n == 10) {
                    return thread.setValues(new SimpleString(sb), Lisp.NIL);
                }
                sb.append((char)n);
            }
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readChar() {
        try {
            int n = this._readChar();
            if (n < 0) {
                return Lisp.error(new EndOfFile(this));
            }
            return LispCharacter.getInstance((char)n);
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readChar(boolean eofError, LispObject eofValue) {
        try {
            int n = this._readChar();
            if (n < 0) {
                if (eofError) {
                    return Lisp.error(new EndOfFile(this));
                }
                return eofValue;
            }
            return LispCharacter.getInstance((char)n);
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readCharNoHang(boolean eofError, LispObject eofValue) {
        try {
            return this._charReady() ? this.readChar(eofError, eofValue) : Lisp.NIL;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject unreadChar(LispCharacter c) {
        try {
            this._unreadChar(c.value);
            return Lisp.NIL;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject finishOutput() {
        this._finishOutput();
        return Lisp.NIL;
    }

    public LispObject clearInput() {
        this._clearInput();
        return Lisp.NIL;
    }

    public LispObject getFilePosition() {
        long pos = this._getFilePosition();
        return pos >= 0L ? Lisp.number(pos) : Lisp.NIL;
    }

    public LispObject setFilePosition(LispObject arg) {
        return this._setFilePosition(arg) ? Lisp.T : Lisp.NIL;
    }

    public LispObject close(LispObject abort) {
        this._close();
        return Lisp.T;
    }

    public String toString() {
        return this.unreadableString("STREAM");
    }

    public LispObject readByte(boolean eofError, LispObject eofValue) {
        int n = this._readByte();
        if (n < 0) {
            if (eofError) {
                return Lisp.error(new EndOfFile(this));
            }
            return eofValue;
        }
        return Fixnum.constants[n];
    }

    public LispObject terpri() {
        this._writeChar('\n');
        return Lisp.NIL;
    }

    public LispObject freshLine() {
        if (this.charPos == 0) {
            return Lisp.NIL;
        }
        this._writeChar('\n');
        return Lisp.T;
    }

    public void print(char c) {
        this._writeChar(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prin1(LispObject obj) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        try {
            this._writeString(obj.writeToString());
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public LispObject listen() {
        if (this.pastEnd) {
            return Lisp.NIL;
        }
        try {
            if (!this._charReady()) {
                return Lisp.NIL;
            }
            int n = this._readChar();
            if (n < 0) {
                return Lisp.NIL;
            }
            this._unreadChar(n);
            return Lisp.T;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject fileLength() {
        return Lisp.type_error(this, Symbol.FILE_STREAM);
    }

    public LispObject fileStringLength(LispObject arg) {
        if (arg instanceof LispCharacter) {
            if (Utilities.isPlatformWindows && ((LispCharacter)arg).value == '\n') {
                return Fixnum.TWO;
            }
            return Fixnum.ONE;
        }
        if (arg instanceof AbstractString) {
            if (Utilities.isPlatformWindows) {
                int fileStringLength = 0;
                char[] chars = ((AbstractString)arg).getStringChars();
                int i = chars.length;
                while (i-- > 0) {
                    if (chars[i] == '\n') {
                        fileStringLength += 2;
                        continue;
                    }
                    ++fileStringLength;
                }
                return Lisp.number(fileStringLength);
            }
            return Lisp.number(arg.length());
        }
        return Lisp.error(new TypeError(arg.writeToString() + " is neither a string nor a character."));
    }

    protected int _readChar() throws IOException {
        int n;
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        if ((n = this.reader.read()) < 0) {
            this.pastEnd = true;
            return -1;
        }
        ++this.offset;
        if (n == 13 && this.eolStyle == EolStyle.CRLF) {
            n = this._readChar();
            if (n != 10) {
                this._unreadChar(n);
                return 13;
            }
            return 10;
        }
        if (n == this.eolChar) {
            ++this.lineNumber;
            return 10;
        }
        return n;
    }

    protected void _unreadChar(int n) throws IOException {
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        --this.offset;
        if (n == 10) {
            n = this.eolChar;
            --this.lineNumber;
        }
        this.reader.unread(n);
        this.pastEnd = false;
    }

    protected boolean _charReady() throws IOException {
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        return this.reader.ready();
    }

    public void _writeChar(char c) {
        try {
            if (c == '\n') {
                if (this.eolStyle == EolStyle.CRLF && this.lastChar != '\r') {
                    this.writer.write(13);
                }
                this.writer.write(this.eolChar);
                this.lastChar = this.eolChar;
                this.writer.flush();
                this.charPos = 0;
            } else {
                this.writer.write(c);
                this.lastChar = c;
                ++this.charPos;
            }
        }
        catch (NullPointerException e) {
            this.streamNotCharacterOutputStream();
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _writeChars(char[] chars, int start, int end) {
        try {
            if (this.eolStyle != EolStyle.RAW) {
                for (int i = start; i < end; ++i) {
                    this._writeChar(chars[i]);
                }
                return;
            }
            this.writer.write(chars, start, end - start);
            if (start < end) {
                this.lastChar = chars[end - 1];
            }
            int index = -1;
            int i = end;
            while (i-- > start) {
                if (chars[i] != '\n') continue;
                index = i;
                break;
            }
            if (index < 0) {
                this.charPos += end - start;
            } else {
                this.charPos = end - (index + 1);
                this.writer.flush();
            }
        }
        catch (NullPointerException e) {
            if (this.writer == null) {
                this.streamNotCharacterOutputStream();
            }
            throw e;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _writeString(String s) {
        try {
            this._writeChars(s.toCharArray(), 0, s.length());
        }
        catch (NullPointerException e) {
            if (this.writer == null) {
                this.streamNotCharacterOutputStream();
            }
            throw e;
        }
    }

    public void _writeLine(String s) {
        try {
            this._writeString(s);
            this._writeChar('\n');
        }
        catch (NullPointerException e) {
            this.streamNotCharacterOutputStream();
        }
    }

    public int _readByte() {
        try {
            int n = this.in.read();
            if (n < 0) {
                this.pastEnd = true;
            }
            return n;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return -1;
        }
    }

    public void _writeByte(int n) {
        try {
            this.out.write(n);
        }
        catch (NullPointerException e) {
            this.streamNotBinaryOutputStream();
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _finishOutput() {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _clearInput() {
        if (this.reader != null) {
            int c = 0;
            try {
                while (this._charReady() && c >= 0) {
                    c = this._readChar();
                }
            }
            catch (IOException e) {
                Lisp.error(new StreamError(this, e));
            }
        } else if (this.in != null) {
            try {
                int n = 0;
                while (this.in.available() > 0) {
                    n = this.in.read();
                }
                if (n < 0) {
                    this.pastEnd = true;
                }
            }
            catch (IOException e) {
                Lisp.error(new StreamError(this, e));
            }
        }
    }

    protected long _getFilePosition() {
        return -1L;
    }

    protected boolean _setFilePosition(LispObject arg) {
        return false;
    }

    public void _close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            this.setOpen(false);
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        try {
            this.writer.write(sw.toString());
            this.writer.write(10);
            this.lastChar = (char)10;
            this.writer.flush();
            this.charPos = 0;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    protected LispObject streamNotInputStream() {
        return Lisp.error(new StreamError(this, this.writeToString() + " is not an input stream."));
    }

    protected LispObject streamNotCharacterInputStream() {
        return Lisp.error(new StreamError(this, this.writeToString() + " is not a character input stream."));
    }

    protected LispObject streamNotOutputStream() {
        return Lisp.error(new StreamError(this, this.writeToString() + " is not an output stream."));
    }

    protected LispObject streamNotBinaryOutputStream() {
        return Lisp.error(new StreamError(this, this.writeToString() + " is not a binary output stream."));
    }

    protected LispObject streamNotCharacterOutputStream() {
        return Lisp.error(new StreamError(this, this.writeToString() + " is not a character output stream."));
    }

    private static final LispObject finishOutput(LispObject arg) {
        LispObject out = arg == Lisp.T ? Symbol.TERMINAL_IO.symbolValue() : (arg == Lisp.NIL ? Symbol.STANDARD_OUTPUT.symbolValue() : arg);
        return Lisp.checkStream(out).finishOutput();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EolStyle {
        RAW,
        CR,
        CRLF,
        LF;

    }
}

