/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class StringFunctions {
    private static final Primitive _STRING_EQUAL = new Primitive("%string=", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            int start2;
            int end2;
            int start1;
            char[] array1 = first.STRING().getStringChars();
            char[] array2 = second.STRING().getStringChars();
            int end1 = fourth == Lisp.NIL ? array1.length : Fixnum.getValue(fourth);
            if (end1 - (start1 = Fixnum.getValue(third)) != (end2 = sixth == Lisp.NIL ? array2.length : Fixnum.getValue(sixth)) - (start2 = Fixnum.getValue(fifth))) {
                return Lisp.NIL;
            }
            try {
                int i = start1;
                int j = start2;
                while (i < end1) {
                    if (array1[i] != array2[j]) {
                        return Lisp.NIL;
                    }
                    ++i;
                    ++j;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Debug.trace(e);
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive __STRING_EQUAL = new Primitive("%%string=", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject first, LispObject second) {
            char[] array2;
            char[] array1 = first.STRING().getStringChars();
            if (array1.length != (array2 = second.STRING().getStringChars()).length) {
                return Lisp.NIL;
            }
            int i = array1.length;
            while (i-- > 0) {
                if (array1[i] == array2[i]) continue;
                return Lisp.NIL;
            }
            return Lisp.T;
        }
    };
    private static final Primitive _STRING_NOT_EQUAL = new Primitive("%string/=", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Lisp.NIL;
                    }
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                if (array1[i] != array2[j]) {
                    return Fixnum.getInstance(i);
                }
                ++i;
                ++j;
            }
        }
    };
    private static final Primitive _STRING_EQUAL_IGNORE_CASE = new Primitive("%string-equal", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            char[] array1 = first.STRING().getStringChars();
            char[] array2 = second.STRING().getStringChars();
            int start1 = Fixnum.getValue(third);
            int end1 = Fixnum.getValue(fourth);
            int start2 = Fixnum.getValue(fifth);
            int end2 = Fixnum.getValue(sixth);
            if (end1 - start1 != end2 - start2) {
                return Lisp.NIL;
            }
            int i = start1;
            int j = start2;
            while (i < end1) {
                char c1 = array1[i];
                char c2 = array2[j];
                if (c1 != c2 && LispCharacter.toUpperCase(c1) != LispCharacter.toUpperCase(c2) && LispCharacter.toLowerCase(c1) != LispCharacter.toLowerCase(c2)) {
                    return Lisp.NIL;
                }
                ++i;
                ++j;
            }
            return Lisp.T;
        }
    };
    private static final Primitive _STRING_NOT_EQUAL_IGNORE_CASE = new Primitive("%string-not-equal", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Lisp.NIL;
                    }
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                char c1 = array1[i];
                char c2 = array2[j];
                if (c1 != c2 && LispCharacter.toUpperCase(c1) != LispCharacter.toUpperCase(c2) && LispCharacter.toLowerCase(c1) != LispCharacter.toLowerCase(c2)) break;
                ++i;
                ++j;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_LESS_THAN = new Primitive("%string<", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Lisp.NIL;
                    }
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Lisp.NIL;
                }
                c1 = array1[i];
                c2 = array2[j];
                if (c1 != c2) break;
                ++i;
                ++j;
            }
            if (c1 < c2) {
                return Fixnum.getInstance(i);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive _STRING_GREATER_THAN = new Primitive("%string>", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    return Lisp.NIL;
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                c1 = array1[i];
                c2 = array2[j];
                if (c1 != c2) break;
                ++i;
                ++j;
            }
            if (c1 < c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_LE = new Primitive("%string<=", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Lisp.NIL;
                }
                c1 = array1[i];
                c2 = array2[j];
                if (c1 != c2) break;
                ++i;
                ++j;
            }
            if (c1 > c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_GE = new Primitive("%string>=", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Fixnum.getInstance(i);
                    }
                    return Lisp.NIL;
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                c1 = array1[i];
                c2 = array2[j];
                if (c1 != c2) break;
                ++i;
                ++j;
            }
            if (c1 < c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_LESSP = new Primitive("%string-lessp", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Lisp.NIL;
                    }
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Lisp.NIL;
                }
                c1 = LispCharacter.toUpperCase(array1[i]);
                if (c1 != (c2 = LispCharacter.toUpperCase(array2[j]))) break;
                ++i;
                ++j;
            }
            if (c1 > c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_GREATERP = new Primitive("%string-greaterp", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    return Lisp.NIL;
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                c1 = LispCharacter.toUpperCase(array1[i]);
                if (c1 != (c2 = LispCharacter.toUpperCase(array2[j]))) break;
                ++i;
                ++j;
            }
            if (c1 < c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_NOT_LESSP = new Primitive("%string-not-lessp", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    if (j == end2) {
                        return Fixnum.getInstance(i);
                    }
                    return Lisp.NIL;
                }
                if (j == end2) {
                    return Fixnum.getInstance(i);
                }
                c1 = LispCharacter.toUpperCase(array1[i]);
                if (c1 != (c2 = LispCharacter.toUpperCase(array2[j]))) break;
                ++i;
                ++j;
            }
            if (c1 > c2) {
                return Fixnum.getInstance(i);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive _STRING_NOT_GREATERP = new Primitive("%string-not-greaterp", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject[] args) {
            char c2;
            char c1;
            if (args.length != 6) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            char[] array1 = args[0].STRING().getStringChars();
            char[] array2 = args[1].STRING().getStringChars();
            int start1 = Fixnum.getValue(args[2]);
            int end1 = Fixnum.getValue(args[3]);
            int start2 = Fixnum.getValue(args[4]);
            int end2 = Fixnum.getValue(args[5]);
            int i = start1;
            int j = start2;
            while (true) {
                if (i == end1) {
                    return Fixnum.getInstance(i);
                }
                if (j == end2) {
                    return Lisp.NIL;
                }
                c1 = LispCharacter.toUpperCase(array1[i]);
                if (c1 != (c2 = LispCharacter.toUpperCase(array2[j]))) break;
                ++i;
                ++j;
            }
            if (c1 > c2) {
                return Lisp.NIL;
            }
            return Fixnum.getInstance(i);
        }
    };
    private static final Primitive _STRING_UPCASE = new Primitive("%string-upcase", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int i;
            LispObject s = first.STRING();
            int length = s.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            FastStringBuffer sb = new FastStringBuffer(length);
            char[] array = s.getStringChars();
            for (i = 0; i < start; ++i) {
                sb.append(array[i]);
            }
            for (i = start; i < end; ++i) {
                sb.append(LispCharacter.toUpperCase(array[i]));
            }
            for (i = end; i < length; ++i) {
                sb.append(array[i]);
            }
            return new SimpleString(sb);
        }
    };
    private static final Primitive _STRING_DOWNCASE = new Primitive("%string-downcase", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int i;
            LispObject s = first.STRING();
            int length = s.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            FastStringBuffer sb = new FastStringBuffer(length);
            char[] array = s.getStringChars();
            for (i = 0; i < start; ++i) {
                sb.append(array[i]);
            }
            for (i = start; i < end; ++i) {
                sb.append(LispCharacter.toLowerCase(array[i]));
            }
            for (i = end; i < length; ++i) {
                sb.append(array[i]);
            }
            return new SimpleString(sb);
        }
    };
    private static final Primitive _STRING_CAPITALIZE = new Primitive("%string-capitalize", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int i;
            LispObject s = first.STRING();
            int length = s.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            FastStringBuffer sb = new FastStringBuffer(length);
            char[] array = s.getStringChars();
            boolean lastCharWasAlphanumeric = false;
            for (i = 0; i < start; ++i) {
                sb.append(array[i]);
            }
            for (i = start; i < end; ++i) {
                char c = array[i];
                if (Character.isLowerCase(c)) {
                    sb.append(lastCharWasAlphanumeric ? c : LispCharacter.toUpperCase(c));
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    sb.append(lastCharWasAlphanumeric ? LispCharacter.toLowerCase(c) : c);
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                sb.append(c);
                lastCharWasAlphanumeric = Character.isDigit(c);
            }
            for (i = end; i < length; ++i) {
                sb.append(array[i]);
            }
            return new SimpleString(sb);
        }
    };
    private static final Primitive _NSTRING_UPCASE = new Primitive("%nstring-upcase", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            AbstractString string = Lisp.checkString(first);
            int length = string.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            for (int i = start; i < end; ++i) {
                string.setCharAt(i, LispCharacter.toUpperCase(string.charAt(i)));
            }
            return string;
        }
    };
    private static final Primitive _NSTRING_DOWNCASE = new Primitive("%nstring-downcase", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            AbstractString string = Lisp.checkString(first);
            int length = string.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            for (int i = start; i < end; ++i) {
                string.setCharAt(i, LispCharacter.toLowerCase(string.charAt(i)));
            }
            return string;
        }
    };
    private static final Primitive _NSTRING_CAPITALIZE = new Primitive("%nstring-capitalize", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            AbstractString string = Lisp.checkString(first);
            int length = string.length();
            int start = Fixnum.getValue(second);
            if (start < 0 || start > length) {
                return Lisp.error(new TypeError("Invalid start position " + start + "."));
            }
            int end = third == Lisp.NIL ? length : Fixnum.getValue(third);
            if (end < 0 || end > length) {
                return Lisp.error(new TypeError("Invalid end position " + start + "."));
            }
            if (start > end) {
                return Lisp.error(new TypeError("Start (" + start + ") is greater than end (" + end + ")."));
            }
            boolean lastCharWasAlphanumeric = false;
            for (int i = start; i < end; ++i) {
                char c = string.charAt(i);
                if (Character.isLowerCase(c)) {
                    if (!lastCharWasAlphanumeric) {
                        string.setCharAt(i, LispCharacter.toUpperCase(c));
                    }
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    if (lastCharWasAlphanumeric) {
                        string.setCharAt(i, LispCharacter.toLowerCase(c));
                    }
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                lastCharWasAlphanumeric = Character.isDigit(c);
            }
            return string;
        }
    };
    public static final Primitive STRINGP = new Primitive("stringp", "object"){

        public LispObject execute(LispObject arg) {
            return arg.STRINGP();
        }
    };
    public static final Primitive SIMPLE_STRING_P = new Primitive("simple-string-p", "object"){

        public LispObject execute(LispObject arg) {
            return arg.SIMPLE_STRING_P();
        }
    };
    private static final Primitive _MAKE_STRING = new Primitive("%make-string", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject size, LispObject initialElement, LispObject elementType) {
            int n = Fixnum.getValue(size);
            if (n < 0 || n >= Integer.MAX_VALUE) {
                FastStringBuffer sb = new FastStringBuffer();
                sb.append("The size specified for this string (");
                sb.append(n);
                sb.append(')');
                if (n >= Integer.MAX_VALUE) {
                    sb.append(" is >= ARRAY-DIMENSION-LIMIT (");
                    sb.append(Integer.MAX_VALUE);
                    sb.append(").");
                } else {
                    sb.append(" is negative.");
                }
                return Lisp.error(new LispError(sb.toString()));
            }
            SimpleString string = new SimpleString(n);
            if (initialElement != Lisp.NIL) {
                char c = Lisp.checkCharacter(initialElement).getValue();
                string.fill(c);
            }
            return string;
        }
    };
    private static final Primitive CHAR = new Primitive(Symbol.CHAR, "string index"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.CHAR(Fixnum.getValue(second));
        }
    };
    private static final Primitive SCHAR = new Primitive(Symbol.SCHAR, "string index"){

        public LispObject execute(LispObject first, LispObject second) {
            return first.SCHAR(Fixnum.getValue(second));
        }
    };
    private static final Primitive SET_CHAR = new Primitive(Symbol.SET_CHAR, "string index character"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Lisp.checkString(first).setCharAt(Fixnum.getValue(second), LispCharacter.getValue(third));
            return third;
        }
    };
    private static final Primitive SET_SCHAR = new Primitive(Symbol.SET_SCHAR, "string index character"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof SimpleString) {
                ((SimpleString)first).setCharAt(Fixnum.getValue(second), LispCharacter.getValue(third));
                return third;
            }
            return Lisp.type_error(first, Symbol.SIMPLE_STRING);
        }
    };
    private static final Primitive STRING_POSITION = new Primitive("string-position", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int start;
            char c = LispCharacter.getValue(first);
            AbstractString string = Lisp.checkString(second);
            int limit = string.length();
            for (int i = start = Fixnum.getValue(third); i < limit; ++i) {
                if (string.charAt(i) != c) continue;
                return Lisp.number(i);
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive STRING_FIND = new Primitive("string-find", Lisp.PACKAGE_EXT, true, "char string"){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof LispCharacter) {
                char c = ((LispCharacter)first).value;
                AbstractString string = Lisp.checkString(second);
                int limit = string.length();
                for (int i = 0; i < limit; ++i) {
                    if (string.charAt(i) != c) continue;
                    return first;
                }
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive SIMPLE_STRING_SEARCH = new Primitive("simple-string-search", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject first, LispObject second) {
            int index = second.getStringValue().indexOf(first.getStringValue());
            return index >= 0 ? Fixnum.getInstance(index) : Lisp.NIL;
        }
    };
    private static final Primitive STRING_FILL = new Primitive("simple-string-fill", Lisp.PACKAGE_EXT, true){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof AbstractString) {
                AbstractString s = (AbstractString)first;
                s.fill(LispCharacter.getValue(second));
                return first;
            }
            return Lisp.type_error(first, Symbol.SIMPLE_STRING);
        }
    };
}

