/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.ArrayList;
import java.util.List;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymbolHashTable {
    private static final float LOAD_FACTOR = 0.75f;
    private int threshold;
    private HashEntry[] buckets;
    private int count;
    private int mask;

    public SymbolHashTable(int size) {
        this.buckets = new HashEntry[SymbolHashTable.calculateInitialCapacity(size)];
        this.threshold = (int)((float)size * 0.75f);
        this.mask = this.buckets.length - 1;
    }

    private static int calculateInitialCapacity(int size) {
        int capacity;
        for (capacity = 1; capacity < size; capacity <<= 1) {
        }
        return capacity;
    }

    public Symbol get(SimpleString key) {
        HashEntry e = this.buckets[key.sxhash() & this.mask];
        while (e != null) {
            if (key.equal(e.symbol.name)) {
                return e.symbol;
            }
            e = e.next;
        }
        return null;
    }

    public Symbol get(SimpleString key, int hash) {
        HashEntry e = this.buckets[hash & this.mask];
        while (e != null) {
            if (key.equal(e.symbol.name)) {
                return e.symbol;
            }
            e = e.next;
        }
        return null;
    }

    public void put(SimpleString key, Symbol symbol) {
        int index = key.sxhash() & this.mask;
        HashEntry e = this.buckets[index];
        while (e != null) {
            if (key.equal(e.symbol.name)) {
                if (e.symbol != symbol) {
                    Debug.trace("replacing existing key for " + key.getStringValue() + " in package " + e.symbol.getPackage().writeToString());
                    Thread.dumpStack();
                    e.symbol = symbol;
                }
                return;
            }
            e = e.next;
        }
        if (++this.count > this.threshold) {
            this.rehash();
            index = key.sxhash() & this.mask;
        }
        e = new HashEntry(symbol);
        e.next = this.buckets[index];
        this.buckets[index] = e;
    }

    public void put(Symbol symbol) {
        int index = symbol.sxhash() & this.mask;
        HashEntry e = this.buckets[index];
        while (e != null) {
            if (symbol.name.equal(e.symbol.name)) {
                if (e.symbol != symbol) {
                    Debug.trace("replacing existing key for " + symbol.getName());
                    Thread.dumpStack();
                    e.symbol = symbol;
                }
                return;
            }
            e = e.next;
        }
        if (++this.count > this.threshold) {
            this.rehash();
            index = symbol.sxhash() & this.mask;
        }
        e = new HashEntry(symbol);
        e.next = this.buckets[index];
        this.buckets[index] = e;
    }

    public LispObject remove(LispObject key) {
        if (key instanceof Symbol) {
            key = ((Symbol)key).name;
        }
        int index = key.sxhash() & this.mask;
        HashEntry e = this.buckets[index];
        HashEntry last2 = null;
        while (e != null) {
            if (key.equal(e.symbol.name)) {
                if (last2 == null) {
                    this.buckets[index] = e.next;
                } else {
                    last2.next = e.next;
                }
                --this.count;
                return e.symbol;
            }
            last2 = e;
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newCapacity = this.buckets.length * 2;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.buckets = new HashEntry[newCapacity];
        this.mask = this.buckets.length - 1;
        int i = oldBuckets.length;
        while (i-- > 0) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                int index = e.symbol.sxhash() & this.mask;
                HashEntry dest = this.buckets[index];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[index] = e;
                }
                HashEntry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }

    public List<Symbol> getSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (int i = 0; i < this.buckets.length; ++i) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                list.add(e.symbol);
                e = e.next;
            }
        }
        return list;
    }

    private static class HashEntry {
        Symbol symbol;
        HashEntry next;

        HashEntry(Symbol symbol) {
            this.symbol = symbol;
        }
    }
}

