/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.FastStringBuffer;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public class TypeError
extends LispError {
    private static final Primitive TYPE_ERROR_DATUM = new Primitive(Symbol.TYPE_ERROR_DATUM, "condition"){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof StandardObject)) {
                return Lisp.type_error(arg, Symbol.STANDARD_OBJECT);
            }
            StandardObject obj = (StandardObject)arg;
            return obj.getInstanceSlotValue(Symbol.DATUM);
        }
    };
    private static final Primitive TYPE_ERROR_EXPECTED_TYPE = new Primitive(Symbol.TYPE_ERROR_EXPECTED_TYPE, "condition"){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof StandardObject)) {
                return Lisp.type_error(arg, Symbol.STANDARD_OBJECT);
            }
            StandardObject obj = (StandardObject)arg;
            return obj.getInstanceSlotValue(Symbol.EXPECTED_TYPE);
        }
    };

    public TypeError() {
        super(StandardClass.TYPE_ERROR);
    }

    protected TypeError(LispClass cls) {
        super(cls);
    }

    public TypeError(LispObject datum, LispObject expectedType) {
        super(StandardClass.TYPE_ERROR);
        this.setDatum(datum);
        this.setExpectedType(expectedType);
    }

    public TypeError(LispObject initArgs) {
        super(StandardClass.TYPE_ERROR);
        this.initialize(initArgs);
    }

    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        LispObject datum = null;
        LispObject expectedType = null;
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            LispObject second = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.DATUM) {
                if (datum != null) continue;
                datum = second;
                continue;
            }
            if (first != Keyword.EXPECTED_TYPE || expectedType != null) continue;
            expectedType = second;
        }
        if (datum != null) {
            this.setDatum(datum);
        }
        if (expectedType != null) {
            this.setExpectedType(expectedType);
        }
    }

    public TypeError(String message) {
        super(StandardClass.TYPE_ERROR);
        this.setFormatControl(message);
        this.setDatum(Lisp.NIL);
        this.setExpectedType(Lisp.NIL);
    }

    public TypeError(String message, LispObject datum, LispObject expectedType) {
        super(StandardClass.TYPE_ERROR);
        this.setFormatControl(message);
        this.setDatum(datum);
        this.setExpectedType(expectedType);
    }

    public LispObject typeOf() {
        return Symbol.TYPE_ERROR;
    }

    public LispObject classOf() {
        return StandardClass.TYPE_ERROR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.TYPE_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.TYPE_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        try {
            String s = super.getMessage();
            if (s != null) {
                String string = s;
                return string;
            }
            LispObject datum = this.getDatum();
            LispObject expectedType = this.getExpectedType();
            FastStringBuffer sb = new FastStringBuffer();
            String name = datum != null ? datum.writeToString() : null;
            String type = null;
            if (expectedType != null) {
                type = expectedType.writeToString();
            }
            if (type != null) {
                if (name != null) {
                    sb.append("The value ");
                    sb.append(name);
                } else {
                    sb.append("Value");
                }
                sb.append(" is not of type ");
                sb.append(type);
            } else if (name != null) {
                sb.append("Wrong type: ");
                sb.append(name);
            }
            sb.append('.');
            String string = sb.toString();
            return string;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public final LispObject getDatum() {
        return this.getInstanceSlotValue(Symbol.DATUM);
    }

    private final void setDatum(LispObject datum) {
        this.setInstanceSlotValue(Symbol.DATUM, datum);
    }

    public final LispObject getExpectedType() {
        return this.getInstanceSlotValue(Symbol.EXPECTED_TYPE);
    }

    private final void setExpectedType(LispObject expectedType) {
        this.setInstanceSlotValue(Symbol.EXPECTED_TYPE, expectedType);
    }
}

