/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Symbol;

public final class Utilities {
    public static final boolean isPlatformUnix;
    public static final boolean isPlatformWindows;

    public static boolean isFilenameAbsolute(String filename) {
        int length = filename.length();
        if (length > 0) {
            char c0 = filename.charAt(0);
            if (c0 == '\\' || c0 == '/') {
                return true;
            }
            if (length > 2) {
                if (isPlatformWindows) {
                    char c1 = filename.charAt(1);
                    if (c1 == ':') {
                        if (c0 >= 'a' && c0 <= 'z') {
                            return true;
                        }
                        if (c0 >= 'A' && c0 <= 'Z') {
                            return true;
                        }
                    }
                } else if (filename.equals("~") || filename.startsWith("~/")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static File getFile(Pathname pathname) {
        return Utilities.getFile(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()));
    }

    public static File getFile(Pathname pathname, Pathname defaultPathname) {
        Pathname merged = Pathname.mergePathnames(pathname, defaultPathname, Lisp.NIL);
        String namestring = merged.getNamestring();
        if (namestring != null) {
            return new File(namestring);
        }
        Lisp.error(new FileError("Pathname has no namestring: " + merged.writeToString(), merged));
        return null;
    }

    public static Pathname getDirectoryPathname(File file) {
        try {
            String namestring = file.getCanonicalPath();
            if (namestring != null && namestring.length() > 0 && namestring.charAt(namestring.length() - 1) != File.separatorChar) {
                namestring = namestring.concat(File.separator);
            }
            return new Pathname(namestring);
        }
        catch (IOException e) {
            Lisp.error(new LispError(e.getMessage()));
            return null;
        }
    }

    public static byte[] getZippedZipEntryAsByteArray(ZipFile zipfile, String entryName, String subEntryName) {
        ZipEntry entry = zipfile.getEntry(entryName);
        ZipInputStream stream = null;
        try {
            stream = new ZipInputStream(zipfile.getInputStream(entry));
        }
        catch (IOException e) {
            Lisp.error(new FileError("Failed to open '" + entryName + "' in zipfile '" + zipfile + "': " + e.getMessage()));
        }
        do {
            try {
                entry = stream.getNextEntry();
            }
            catch (IOException e) {
                Lisp.error(new FileError("Failed to seek for '" + subEntryName + "' in '" + zipfile.getName() + ":" + entryName + ".:" + e.getMessage()));
            }
        } while (!entry.getName().equals(subEntryName));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = stream.read(buf, 0, buf.length)) != -1) {
                buffer.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            Lisp.error(new FileError("Failed to read compressed '" + subEntryName + "' in '" + zipfile.getName() + ":" + entryName + ":" + e.getMessage()));
        }
        return buffer.toByteArray();
    }

    public static InputStream getZippedZipEntryAsInputStream(ZipFile zipfile, String entryName, String subEntryName) {
        return new ByteArrayInputStream(Utilities.getZippedZipEntryAsByteArray(zipfile, entryName, subEntryName));
    }

    static {
        String osName = System.getProperty("os.name");
        isPlatformUnix = osName.startsWith("Linux") || osName.startsWith("Mac OS X") || osName.startsWith("Darwin") || osName.startsWith("Solaris") || osName.startsWith("SunOS") || osName.startsWith("AIX") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("NetBSD");
        isPlatformWindows = osName.startsWith("Windows");
    }
}

