/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;

class ZipCache {
    static Map<String, Entry> zips = new HashMap<String, Entry>();

    ZipCache() {
    }

    static synchronized ZipFile getZip(String name) throws IOException {
        Entry zip2 = zips.get(name);
        if (zip2 == null) {
            zip2 = new Entry(new ZipFile(name));
            zips.put(name, zip2);
        }
        ++zip2.refcount;
        return zip2.value;
    }

    static synchronized void removeZip(String name) throws IOException {
        Entry zip2 = zips.get(name);
        if (zip2 == null) {
            return;
        }
        --zip2.refcount;
        if (zip2.refcount == 0) {
            zip2.value.close();
            zips.remove(name);
        }
    }

    static class Entry {
        ZipFile value;
        int refcount = 0;

        Entry(ZipFile v) {
            this.value = v;
        }
    }
}

