/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.armedbear.lisp.Stream;

public abstract class DialogPromptStream
extends Stream {
    private StringWriter writtenSoFar = new StringWriter();
    private Reader reader = new Reader(){
        private StringReader stringReader = null;
        private int inputSize = 0;

        public void close() throws IOException {
            DialogPromptStream.this.closeDialog();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int read;
            if (this.stringReader == null) {
                DialogPromptStream.this.writtenSoFar.flush();
                String promptText = DialogPromptStream.this.writtenSoFar.toString();
                DialogPromptStream.this.writtenSoFar.getBuffer().delete(0, Integer.MAX_VALUE);
                String inputStr = DialogPromptStream.this.readInputFromModalDialog(promptText) + System.getProperty("line.separator", "\n");
                this.stringReader = new StringReader(inputStr);
                this.inputSize = inputStr.length();
            }
            if ((read = this.stringReader.read(cbuf, off, len)) != -1) {
                this.inputSize -= read;
            }
            if (read == -1 || this.inputSize == 0) {
                this.inputSize = 0;
                this.stringReader = null;
            }
            return read;
        }
    };

    protected DialogPromptStream() {
        this.initAsCharacterOutputStream(this.writtenSoFar);
        this.initAsCharacterInputStream(this.reader);
    }

    protected abstract void closeDialog();

    protected abstract String readInputFromModalDialog(String var1);
}

