/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.ArithmeticError;
import org.armedbear.lisp.CellError;
import org.armedbear.lisp.CompilerError;
import org.armedbear.lisp.CompilerUnsupportedFeatureError;
import org.armedbear.lisp.Condition;
import org.armedbear.lisp.ControlError;
import org.armedbear.lisp.DivisionByZero;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.FloatingPointInexact;
import org.armedbear.lisp.FloatingPointInvalidOperation;
import org.armedbear.lisp.FloatingPointOverflow;
import org.armedbear.lisp.FloatingPointUnderflow;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.ParseError;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.SeriousCondition;
import org.armedbear.lisp.SimpleCondition;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleTypeError;
import org.armedbear.lisp.SimpleWarning;
import org.armedbear.lisp.StorageCondition;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.StyleWarning;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.UnboundSlot;
import org.armedbear.lisp.UnboundVariable;
import org.armedbear.lisp.UndefinedFunction;
import org.armedbear.lisp.Warning;

public final class make_condition
extends Primitive {
    private static final Primitive MAKE_CONDITION = new make_condition();

    private make_condition() {
        super("%make-condition", Lisp.PACKAGE_SYS, true);
    }

    public LispObject execute(LispObject type, LispObject initArgs) {
        Symbol symbol;
        if (type instanceof Symbol) {
            symbol = (Symbol)type;
        } else if (type instanceof LispClass) {
            symbol = ((LispClass)type).getSymbol();
        } else {
            return Lisp.NIL;
        }
        if (symbol == Symbol.ARITHMETIC_ERROR) {
            return new ArithmeticError(initArgs);
        }
        if (symbol == Symbol.CELL_ERROR) {
            return new CellError(initArgs);
        }
        if (symbol == Symbol.CONDITION) {
            return new Condition(initArgs);
        }
        if (symbol == Symbol.CONTROL_ERROR) {
            return new ControlError(initArgs);
        }
        if (symbol == Symbol.DIVISION_BY_ZERO) {
            return new DivisionByZero(initArgs);
        }
        if (symbol == Symbol.END_OF_FILE) {
            return new EndOfFile(initArgs);
        }
        if (symbol == Symbol.ERROR) {
            return new LispError(initArgs);
        }
        if (symbol == Symbol.FILE_ERROR) {
            return new FileError(initArgs);
        }
        if (symbol == Symbol.FLOATING_POINT_INEXACT) {
            return new FloatingPointInexact(initArgs);
        }
        if (symbol == Symbol.FLOATING_POINT_INVALID_OPERATION) {
            return new FloatingPointInvalidOperation(initArgs);
        }
        if (symbol == Symbol.FLOATING_POINT_OVERFLOW) {
            return new FloatingPointOverflow(initArgs);
        }
        if (symbol == Symbol.FLOATING_POINT_UNDERFLOW) {
            return new FloatingPointUnderflow(initArgs);
        }
        if (symbol == Symbol.PACKAGE_ERROR) {
            return new PackageError(initArgs);
        }
        if (symbol == Symbol.PARSE_ERROR) {
            return new ParseError(initArgs);
        }
        if (symbol == Symbol.PRINT_NOT_READABLE) {
            return new PrintNotReadable(initArgs);
        }
        if (symbol == Symbol.PROGRAM_ERROR) {
            return new ProgramError(initArgs);
        }
        if (symbol == Symbol.READER_ERROR) {
            return new ReaderError(initArgs);
        }
        if (symbol == Symbol.SERIOUS_CONDITION) {
            return new SeriousCondition(initArgs);
        }
        if (symbol == Symbol.SIMPLE_CONDITION) {
            return new SimpleCondition(initArgs);
        }
        if (symbol == Symbol.SIMPLE_ERROR) {
            return new SimpleError(initArgs);
        }
        if (symbol == Symbol.SIMPLE_TYPE_ERROR) {
            return new SimpleTypeError(initArgs);
        }
        if (symbol == Symbol.SIMPLE_WARNING) {
            return new SimpleWarning(initArgs);
        }
        if (symbol == Symbol.STORAGE_CONDITION) {
            return new StorageCondition(initArgs);
        }
        if (symbol == Symbol.STREAM_ERROR) {
            return new StreamError(initArgs);
        }
        if (symbol == Symbol.STYLE_WARNING) {
            return new StyleWarning(initArgs);
        }
        if (symbol == Symbol.TYPE_ERROR) {
            return new TypeError(initArgs);
        }
        if (symbol == Symbol.UNBOUND_SLOT) {
            return new UnboundSlot(initArgs);
        }
        if (symbol == Symbol.UNBOUND_VARIABLE) {
            return new UnboundVariable(initArgs);
        }
        if (symbol == Symbol.UNDEFINED_FUNCTION) {
            return new UndefinedFunction(initArgs);
        }
        if (symbol == Symbol.WARNING) {
            return new Warning(initArgs);
        }
        if (symbol == Symbol.COMPILER_ERROR) {
            return new CompilerError(initArgs);
        }
        if (symbol == Symbol.COMPILER_UNSUPPORTED_FEATURE_ERROR) {
            return new CompilerUnsupportedFeatureError(initArgs);
        }
        return Lisp.NIL;
    }
}

