/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;

public final class zip
extends Primitive {
    private static final Primitive zip = new zip();

    private zip() {
        super("zip", Lisp.PACKAGE_SYS, true, "pathname pathnames");
    }

    public LispObject execute(LispObject first, LispObject second) {
        Pathname zipfilePathname = Lisp.coerceToPathname(first);
        byte[] buffer = new byte[4096];
        try {
            String zipfileNamestring = zipfilePathname.getNamestring();
            if (zipfileNamestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.writeToString()));
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
            for (LispObject list = second; list != Lisp.NIL; list = list.cdr()) {
                int n;
                Pathname pathname = Lisp.coerceToPathname(list.car());
                String namestring = pathname.getNamestring();
                if (namestring == null) {
                    out.close();
                    File zipfile = new File(zipfileNamestring);
                    zipfile.delete();
                    return Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.writeToString()));
                }
                File file = new File(namestring);
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(file.getName());
                out.putNextEntry(entry);
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
        return zipfilePathname;
    }
}

