package org.sciencecommons.protege.lisp;

import org.armedbear.lisp.Interpreter;

/*
 * The singleton approach is used here because we are relying on
 * the bundle being a singleton bundle.
 */
public class LispContext {
    private static LispContext instance;
    private Interpreter interpreter;
    
    private LispContext() {
        Interpreter.createInstance();

    }
    
    public static LispContext getInstance() {
        if (instance == null) {
            instance = new LispContext();
        }
        return instance;
    }
    
    public void dispose() {
        interpreter.dispose();
        instance = null;
    }

}
