package abcl_ae;

import java.io.IOException;
import javax.servlet.http.*;

import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.ConditionThrowable;

public class HelloWorldServlet extends HttpServlet {
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws IOException {
			
		LispThread currentThread = LispThread.currentThread();
		
		SpecialBinding lastSpecialBinding = currentThread.lastSpecialBinding;
		currentThread.bindSpecial(
			Symbol.STANDARD_OUTPUT, 
			new org.armedbear.lisp.Stream(resp.getOutputStream(), Symbol.CHARACTER, false));
			
		try {
			currentThread.execute(AbclInit.doGet);
		} catch (ConditionThrowable condition) {
			resp.setContentType("text/plain");
			resp.getWriter().println(condition.toString());
		} finally {
			currentThread.lastSpecialBinding = lastSpecialBinding;
		}
	}
}