(in-package :date-iter)

(defmacro-driver (FOR (yy mm dd) FROM-DATE from-date-spec &optional TO to-date-spec BY (n 1)  SKIP-WEEKENDS (skipval t))
  "Driver for iterating over dates. All dates are in YMD format, ie (YYYY MM DD)"
  (let ((ty (gensym "TO-YEAR"))
		(tm (gensym "TO-MONTH"))
		(td (gensym "TO-DATE"))
		(fy (gensym "FROM-YEAR"))
		(fm (gensym "FROM-MONTH"))
		(fd (gensym "FROM-DATE"))
		(by (gensym "BY"))
		(kwd (if generate 'generate 'for)))

	`(progn
	   (with ,by = ,n)
	   ;;start from the previous value before starting iteration
	   (with (,fy ,fm ,fd)    = (destructuring-bind (xy xm xd)
								 ,from-date-spec
							   (multiple-value-list 
								(get-next-day xy xm xd (* -1 ,by) ,skipval))))
	   (with (,ty ,tm ,td) = (let ((xtspec ,to-date-spec))
							   (if xtspec
								   xtspec
								   (multiple-value-list 
									(date-calc:today)))))

	   (,kwd ,yy next (progn 
						(multiple-value-setq (,fy ,fm ,fd)
						  (get-next-day ,fy ,fm ,fd ,by ,skipval))
						(when (< (date-calc:delta-days ,fy ,fm ,fd ,ty ,tm ,td) 0) (terminate))
						(list ,fy ,fm ,fd))))))


(defun get-next-day (y m d by skipweekends)
  (let ((dir (signum by)))
	(iter (for i below (abs by))
		  (multiple-value-setq (y m d)
			(get-next-one-day y m d dir skipweekends))))
  (values y m d))

(defun get-next-one-day (y m d dir skipweekends)

  (assert (or (= dir 1) (= dir -1)))

  (when skipweekends
	(let ((dow (date-calc:day-of-week y m d)))
	  ;;when going forward, fri,sat,sun + 1  => mon
	  (when (and (= dir 1) (or (= dow 5) (= dow 6) (= dow 7)))
		(incf dir (- 7 dow)))
	  ;;when going backward mon,sat,sun - 1  => fri
	  (when (and (= dir -1) (or (= dow 1) (= dow 6) (= dow 7)))
		(decf dir (mod (1+ dow) 7)))))

  (date-calc:add-delta-days y m d dir))

