;;;

(defparameter *symbol-names*
  '("ZUT"
    "gnao"
    "Bar"
    "qWe"
    "#:a-Symbol"
    "#:another-symbol"
    "#:AND-ANOTHER"
    "|an-Escaped-symBOl|"
    "|a Funky SymBOl|"))

(defun case-test-1 (read-case print-case)
  (let ((*readtable* (copy-readtable))
	(*print-case* print-case)
	)
    (setf (readtable-case *readtable*) read-case)
    (format t ">>>> Testing with~@
               >>>> READTABLE-CASE ~S~@
               >>>> PRINT-CASE ~S~%"
	    read-case
	    print-case)
    (dolist (s *symbol-names*)
      (let ((sym (read-from-string s)))
	(format t "~&~S ~S~%"
		sym
		(symbol-name sym))))
    (terpri)
    (terpri)
    ))

(defun case-test-2 (read-case symbol-name-case print-case)
  (let ((*readtable* (copy-readtable))
	(*print-case* print-case)
	)
    (setf (readtable-case *readtable*) read-case)
    (format t ">>>> Testing with~@
               >>>> READTABLE-CASE ~S~@
               >>>> PRINT-CASE ~S~%"
	    read-case
	    print-case)
    (dolist (s *symbol-names*)
      (let ((sym (read-from-string s)))
	(format t "~&~S ~S~%"
		sym
		(symbol-name sym))))
    (terpri)
    (terpri)
    ))


(defun case-test ()
  (dolist (rc '(:upcase :downcase :preserve :invert))
    (dolist (pc '(:upcase :downcase :capitalize))
      (case-test-1 rc pc))))

(defun case-test-full ()
  (dolist (rc '(:upcase :downcase :preserve :invert))
    (dolist (snc '(:ignore :upcase :downcase :preserve :invert))
      (dolist (pc '(:upcase :downcase :capitalize))
	(case-test-2 rc snc pc))))