
(in-package :io-tests )
(defmacro f32-to-hex (hex flt)
  `(assert-equal ,hex  (format nil "~X" (float-32-to-ieee-754 ,flt))))
(defmacro  hex-to-f32 (hex flt)
  `(assert-equal (ieee-754-to-float-32 (parse-integer ,hex :radix 16)) ,flt))

(defmacro f64-to-hex (hex flt)
  `(assert-equal ,hex  (format nil "~X" (float-64-to-ieee-754 ,flt))))
(defmacro  hex-to-f64 (hex flt)
  `(assert-equal (ieee-754-to-float-64 (parse-integer ,hex :radix 16)) ,flt))



(eval-when (:compile-toplevel :load-toplevel)
  (defparameter *testf32* '("3F800000" 1.0
			    "BF800000" -1.0
			    "A4FB11E"  9.9999995e-33
			    "3FC00000" 1.5
			    "2C9"      1.0e-42
			    "749DC5AD" 9.999999e31
			    "43AC8000" 345.0
			    "47A39100" 83746.0
			    "47"       9.9492191e-44
			    "6CE3EE"   9.9999994e-39
			    "AE397" 9.9999881e-40
			    ))
  (defparameter *testf64*
    '("37D5C72FB1552D83" 1.0d-39
      "1A56E1FC2F8F359" 1.0d-300
      "7E8"             1.0d-320
      "7E37E43C8800759C" 1.0d300
      "6979CE4AE6ED0F27"  1.23456789d+200
      "4A551E3E787F1976" 1.23456789d+50
      )
  ))





(defmacro to-float-32 ( )
  `(define-test hex-to-f32-test
    ,@(loop for (hex flt) on *testf32* by #'cddr collect `(hex-to-f32 ,hex ,flt))))

(defmacro from-float-32 ( )
  `(define-test f32-to-hex-test
    ,@(loop for (hex flt) on *testf32* by #'cddr collect `(f32-to-hex ,hex ,flt))))



(defmacro to-float-64 ( )
  `(define-test hex-to-f64-test
    ,@(loop for (hex flt) on *testf64* by #'cddr collect `(hex-to-f64 ,hex ,flt))))

(defmacro from-float-64 ( )
  `(define-test f64-to-hex-test
    ,@(loop for (hex flt) on *testf64* by #'cddr collect `(f64-to-hex ,hex ,flt))))


; see examples here http://babbage.cs.qc.edu/IEEE-754/


(to-float-32)	
(from-float-32)  

(to-float-64)	
(from-float-64)  



