
(in-package :ltk)

(with-ltk (  )
  (setq *debug-tk* t)
  (let*
      (
       ( main (make-instance 'frame :master nil ))
       ( msg (make-instance 'label :master main :justify :left :text "Three checkbuttons are displayed below.  If you 
click on a button, it will toggle the button's 
selection state and set a Tcl variable to a value 
indicating the state of the checkbutton.  Click the 
\"See Variables\" button to see the current values 
of the variables."))
       ( frame_buttons (make-instance 'frame :master main ))
       (b1 (make-instance 'check-button :master frame_buttons :text "Wipers OK" :relief :flat))
       ( b2 (make-instance 'check-button :master frame_buttons :text "Brakes OK" :relief :flat))
       ( b3 (make-instance 'check-button :master frame_buttons :text "Driver Sober" :relief :flat))
       ( button2showVars ( make-instance 'button :master main :text "See variables" 
					 :command (lambda ()
						    (let*
							(
							 (value1 (value b1))
							 (value2 (value b2))
							 (value3 (value b3))
							 (topl (make-instance 'toplevel :title "Variable values" ))
							 ( label1 (make-instance 'label :master topl :text "Variables :" :width 15))
							 (label2 (make-instance 'label :master topl :text (format nil "Wipers: ~D" value1 ) :width 25 ))
							 (label3 (make-instance 'label :master topl :text (format nil "Brakes: ~D" value2 ) :width 25))
							 (label4 (make-instance 'label :master topl :text (format nil "Sober: ~D" value3 ) :width 25))
							 )
						      (pack label1 :side :top )
						      (mapcar (lambda ( label ) (pack label :side :top :anchor :w :fill :x )) (list label2 label3 label4 ))))))
      )
    (pack main)
    (pack msg :side :top)
    (pack button2showvars :side :bottom )
    (pack frame_buttons :side :bottom :pady 2 :fill :x)
    (mapcar (lambda ( button ) (pack button :side :top :pady 2 :anchor :w )) (list b1 b2 b3))
  
    ))


