#|Arxiu: coordenatedCanvas.lisp
  Contingut: Widget que mostra uns eixos coordenats on es pot dibuixar usant coordenades logiques.
  Ultima actualitzacio: 5/11/06
  Autor: Felip Alaez Nadal. |#

(defpackage coordenatedCanvas 
  (:use :cl :ltk)
  (:export #:coordenatedCanvas #:drawAxis #:drawLine )
  )

(in-package :coordenatedCanvas)


(defclass coordenatedCanvas (canvas) 
  (
   (x_min :accessor x_min :initarg :x_min :initform -10 :type integer :documentation "Minimal logic value of x in the canvas.")
   (x_max :accessor x_max :initarg :x_max :initform 10 :type integer :documentation "Max logic value of x in the canvas.")
   (y_min :accessor y_min :initarg :y_min :initform -10 :type integer :documentation "Minimal logic value of y in the canvas.")
   (y_max :accessor y_max :initarg :y_max :initform 10 :type integer :documentation "Max logic value of y in the canvas.")
   (width :accessor width :initarg :width :initform 300 :type integer :documentation "Width of the canvas object.")
   (height :accessor height :initarg :height :initform 300 :type integer :documentation "Height of the canvas object.")
   (x_div_width :accessor x_div_width :initarg :x_div_width :initform 1 :type integer :documentation "Logical value of the width of divisions at x axis.")
   (y_div_width :accessor y_div_width :initarg :y_div_width :initform 1 :type integer :documentation "Logical value of the width of divisions at y axis.")
   (func :writer set-function :reader get-function :initarg :function :initform (lambda (x y) (declare (ignore x y)) (format t "Please, set a function to call when the user clicks on the screen~%" )  :documentation "An x-y function to execute when the user clicks the left button on the canvas."))
   )
  (:documentation "This class provides a canvas with a x-y axis. You can draw there using the coordinates of points referred to the axis, other than using screen coordinates. These are called 'logic coordinates', opposed to 'screen coordinates'.")
  )


(defun xph2xsc ( x cc )
  "Transforms a logic point (x) coordinate to a screen point (x coordinate). Returns that coordinate."
  (let ((x_min (x_min cc))
	(x_max (x_max cc))
	(ample_canvas (width cc)))
    (truncate (* ample_canvas (/ (- x x_min) (- x_max x_min))))))

(defun yph2ysc ( y  cc)
  "Transforms a logic point (y coordinate) to a screen point (y coordinate). Returns that coordinate."
  (let ((y_min (y_min cc))
	(y_max (y_max cc))
	(alt_canvas (height cc)))
    (truncate (- alt_canvas (* alt_canvas (* ( / (- y y_min) (- y_max y_min) )))))))


(defun xsc2xph ( x cc )
  "Transforms a screen point (x coordinated) to a logic point (x coordinated). Returns that coordinate."
  (let
      ((x_min (x_min cc))
       (x_max (x_max cc))
       (ample_canvas (width cc)))
  (float (+ x_min (* (- x_max x_min) (/ x ample_canvas))))))

(defun ysc2yph ( y cc )
  "Transfors a screen point (y coordinate) to a logic point (y coordinate). Returns that coordinate."
  (let
      ((y_min (y_min cc))
       (y_max (y_max cc))
       (alt_canvas (height cc)))
    (float (+ y_min (* (- y_max y_min) (/ (-  alt_canvas y ) alt_canvas))))))


(defmethod drawAxis (  ( cc coordenatedCanvas ) )
  "Draws the axis of the coordenatedCanvas."
  (let*
      ((x_min (x_min cc))
       (x_max (x_max cc))
       (y_min (y_min cc))
       (y_max (y_max cc))
       (alt_canvas (height cc))
       (ample_canvas (width cc))
       (ample_divisions_x (x_div_width cc))
       (ample_divisions_y (y_div_width cc))
       (alt_eix_x  (float (- alt_canvas (*  (/ (abs y_min) (- y_max y_min) ) alt_canvas))))
       (ample_eix_y (float (* (/ (abs x_min) (- x_max x_min )) ample_canvas)))
       (ample_div_x_pix (float (* ample_canvas (/ ample_divisions_x (- x_max x_min ) ))))
       (ample_div_y_pix (float (* alt_canvas (/ ample_divisions_y (- y_max y_min ) ))))
  
       )
    ;Ara dibuixe l'eix x
    (if (and (>  0 y_min ) (< 0 y_max)) ;si el 0 de les y entra en l'interval
	(progn
	  (create-line cc (list 0 alt_eix_x ample_canvas alt_eix_x))
	  (do ((i 0 (incf i ample_div_x_pix)) ;Codi per a posar les etiquetes
	       (j 0 (incf j)))
	      ((>= i ample_canvas))
	    (create-line cc (list i (- alt_eix_x 5) i (+ alt_eix_x 5 )))
	    (create-text cc  i (+ alt_eix_x 5) (+ (* j ample_divisions_x) x_min))))
	    
	(progn ;En cas contrari, la posicio de l'eix x depen de les y
	  (cond 
	    ((>= y_min 0) ;-> eix de les x baix del tot
	     (create-line cc (list 0 alt_canvas ample_canvas alt_canvas))
	     (do ((i 0 (incf i ample_div_x_pix))
		  (j 0 (incf j)))
		 ((>= i ample_canvas))
	       (create-line cc (list i alt_canvas i (- alt_canvas 5) ))
	       (create-text cc i (- alt_canvas 20) (+ (* j ample_divisions_x) x_min))))
	    ((< y_min 0) ;-> eix de les x dalt del tot
	     (create-line cc (list 0 0 ample_canvas 0))
	     (do ((i 0 (incf i ample_div_x_pix))
		  (j 0 (incf j)))
		 ((>= i ample_canvas))
	       (create-line cc (list i 0 i  5 ))
	       (create-text cc i 5 (+ (* j ample_divisions_x) x_min)))))
	  ))

;Per ultim dibuixe l'eix de les y
    (if (and (> 0 x_min ) (< 0 x_max )) ;si el 0 de les x entra en l'interval
	(progn
	  (create-line cc (list ample_eix_y  0 ample_eix_y  alt_canvas))
	  (do ((i 0 (incf i ample_div_y_pix))
	       (j 0 (incf j)))
	      ((>= i alt_canvas))
	    (create-line cc (list (- ample_eix_y 5) i (+ ample_eix_y 5) i))
	    (create-text cc  (- ample_eix_y 20) (- alt_canvas  i) (+ (* j ample_divisions_y) y_min))))
	
	(progn ;En cas contrari, l'eix de les y està pegat a una de les dues bandes, a quina?
	  (cond
	    ((>= x_min 0) ;eix de les y a l'esquerra
	     (create-line cc (list 0 0 0 alt_canvas))
	     (do ((i 0 (incf i ample_div_y_pix))
		  (j 0 (incf j)))
		 ((>= i alt_canvas))
	       (create-line cc (list  0  i 10  i))
	       (create-text cc 0 (- alt_canvas i) (+ (* j ample_divisions_y) y_min))))
	    ((< x_min 0) ;eix de les y a la dreta
	     (do ((i 0 (incf i ample_div_y_pix))
		  (j 0 (incf j)))
		 ((>= i alt_canvas))
	       (create-line cc (list  0  i 10  i))
	       (create-text cc 10 i (+ (* j ample_divisions_y) y_min))))
	    )))))



(defmethod pack :after (   ( cc coordenatedCanvas ) &key (side :top) (fill :none) expand after before padx pady  ipadx ipady anchor  )
  "Method to be executed after the packing of the canvas. Just draws the x-y axis."
  (declare (ignore side fill expand after before padx pady ipadx ipady anchor))
  (itemconfigure  cc (create-rectangle cc 0 0 (width cc ) (height cc)) :fill "white")
  (bind cc "<Button-1>" (lambda (evt) (funcall (get-function cc) (xsc2xph (event-x evt) cc) (ysc2yph (event-y evt) cc))))
  (drawAxis cc)
)

(defun xBelongs2Canvas ( x  cc )
  "Returns t if x belongs to cc, nil othercase."
  (and (<= x (x_max cc)) (>= x (x_min cc))))

(defun yBelongs2Canvas ( y cc )
  "Returns t if y belongs to cc, nil othercase."
  (and (<= y (y_max cc)) (>= y (y_min cc))))

(defmethod drawLine ( (cc coordenatedCanvas ) x0 y0 x1 y1  )
  "Draws a line on the canvas. The coordinates are logical coordinates, not screen coordinates."
  (let
      ((x0c (xph2xsc x0 cc))
       (y0c (yph2ysc y0 cc))
       (x1c (xph2xsc x1 cc))
       (y1c (yph2ysc y1 cc)))
    ;(format t "Linia de  ( ~D , ~D  ) a ( ~D , ~D ) ~%" x0c y0c x1c y1c )
    (create-line  cc (list x0c y0c x1c y1c))
    ))


(defmethod clearScreen ( (cc coordenatedCanvas ))
  "Clears the screen and redraws the axis."
  
  (itemconfigure cc (create-rectangle cc 0 0 (width cc ) (height cc)) :fill "white")
  (drawAxis cc))

(defmethod xEpsilon ( (cc coordenatedCanvas ))
  "Torna el minim increment de x que pot aplicar-se a un punt per a que siga distingible d'un altre."
  (float (/  (- (x_max cc) (x_min cc)) (width cc))))

(defmethod yEpsilon ( ( cc coordenatedCanvas ))
  "Torna el minim increment de y que pot aplicar-se a un punt per a que siga distingible d'un altre."
  (float   (/  (- (y_max cc) (y_min cc)) (height cc))))

(defun cctest ( )
  "Tests the class."
  (with-ltk ()
    (let*
	(( cc (make-instance 'coordenatedcanvas :width 500 :height 500  )))
      (set-function (lambda (x y) (drawLine cc x y (+ x 1) (+ y 1)  ))  cc)
      (pack cc))))